/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.service;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.miniorange.sso.saml.constant.PluginConstants;
import com.miniorange.sso.saml.utils.EncryptionUtils;
import com.miniorange.sso.saml.utils.PluginUtils;
import com.miniorange.sso.saml.utils.SAMLUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSettingsService {
    private static final Logger log = LoggerFactory.getLogger(PluginSettingsService.class);
    public static Boolean UserPresent = Boolean.FALSE;
    private final ApplicationProperties applicationProperties;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final PluginSettings pluginSettings;
    private final PropertyManager propertyManager;
    private final DirectoryManager directoryManager;
    private final CrowdService crowdService;
    public static Boolean isMetadataFileUploaded = Boolean.FALSE;
    private ArrayList<String> existingDirectory;
    private ArrayList<String> existingGroups;

    public PluginSettingsService(ApplicationProperties applicationProperties, PluginSettingsFactory pluginSettingsFactory, PluginSettings pluginSettings, PropertyManager propertyManager, DirectoryManager directoryManager, CrowdService crowdService) {
        this.applicationProperties = applicationProperties;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.propertyManager = propertyManager;
        this.directoryManager = directoryManager;
        this.crowdService = crowdService;
    }

    public String getCrowdVersion() {
        return this.applicationProperties.getVersion();
    }

    public String getBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String getContextPath() {
        return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
    }

    public int getCurrentLicenseUsers() {
        return this.propertyManager.getCurrentLicenseResourceTotal();
    }

    public List<String> getDefaultGroupForInitialConfiguration() {
        ArrayList<String> defaultGroup = new ArrayList<String>();
        defaultGroup.add("crowd-administrators");
        return defaultGroup;
    }

    public String getSpACSUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/saml/auth");
    }

    public String getSpSLOUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/saml/logout");
    }

    public String getCustomerLoginActionUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login");
    }

    public String getCustomerRegistrationActionUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-register");
    }

    public String getValidateOtpActionUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-verify");
    }

    public String getLicenseActionUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/crowd-saml/config/license-config");
    }

    public String getCrowdAuthAppName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CROWD_AUTH_APPLICATION_NAME")), (CharSequence)"crowd");
    }

    public void setCrowdAuthAppName(String crowdAuthAppName) {
        this.pluginSettings.put("miniorange.saml.CROWD_AUTH_APPLICATION_NAME", (Object)crowdAuthAppName);
    }

    public String getCrowdAuthAppPassword() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CROWD_AUTH_APPLICATION_PASSWORD")), (CharSequence)"");
    }

    public void setCrowdAuthAppPassword(String crowdAuthAppPassword) {
        this.pluginSettings.put("miniorange.saml.CROWD_AUTH_APPLICATION_PASSWORD", (Object)StringUtils.trimToEmpty((String)crowdAuthAppPassword));
    }

    public String getCustomerID() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_ID")), (CharSequence)"");
    }

    public void setCustomerId(String customerId) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_ID", (Object)customerId);
    }

    public String getCustomerEmail() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_EMAIL")), (CharSequence)"");
    }

    public void setCustomerEmail(String email) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_EMAIL", (Object)StringUtils.trimToEmpty((String)email));
    }

    public String getCustomerAPIKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_API_KEY")), (CharSequence)"");
    }

    public void setCustomerAPIKey(String customerId) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_API_KEY", (Object)customerId);
    }

    public String getCustomerTokenKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_TOKEN_KEY")), (CharSequence)"");
    }

    public void setCustomerTokenKey(String customerId) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_TOKEN_KEY", (Object)customerId);
    }

    public Boolean getOldCustomer() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("confluence.sso.mo.ioc"))), (boolean)false);
    }

    public void setOldCustomer(Boolean isOldCustomer) {
        this.pluginSettings.put("confluence.sso.mo.ioc", (Object)BooleanUtils.toString((Boolean)isOldCustomer, (String)"true", (String)"false", (String)"false"));
    }

    public String getCustomerLicenseKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_LICENSE_KEY")), (CharSequence)"");
    }

    public void setCustomerLicenseKey(String licenseKey) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_LICENSE_KEY", (Object)StringUtils.trimToEmpty((String)licenseKey));
    }

    public String getLicenseType() {
        String encryptedValue = (String)this.pluginSettings.get("miniorange.saml.IS_TRIAL_LICENSE");
        if (StringUtils.isBlank((CharSequence)encryptedValue)) {
            log.info("License type is not set or is blank.");
            return "";
        }
        try {
            String customerTokenKey = this.getCustomerTokenKey();
            if (StringUtils.isBlank((CharSequence)customerTokenKey)) {
                log.warn("Customer token key is blank. Cannot decrypt license type.");
                return "";
            }
            return EncryptionUtils.decrypt(customerTokenKey, encryptedValue);
        }
        catch (Exception e) {
            log.error("Error retrieving license type: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public void setLicenseType(String licenseType) {
        String customerTokenKey = this.getCustomerTokenKey();
        if (StringUtils.isBlank((CharSequence)customerTokenKey)) {
            log.warn("Customer token key is blank. Cannot encrypt license type.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)licenseType)) {
            log.warn("License type is blank. No value will be set.");
            return;
        }
        try {
            String encryptedValue = EncryptionUtils.encrypt(customerTokenKey, licenseType);
            this.pluginSettings.put("miniorange.saml.IS_TRIAL_LICENSE", (Object)encryptedValue);
            log.info("License type set successfully.");
        }
        catch (Exception e) {
            log.error("Error setting license type: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public String getLicenseExpireDate() {
        String encryptedValue = (String)this.pluginSettings.get("miniorange.saml.LICENSE_EXPIRE_DATE");
        if (StringUtils.isBlank((CharSequence)encryptedValue)) {
            log.info("License expiration date is not set or is blank.");
            return "";
        }
        try {
            String customerTokenKey = this.getCustomerTokenKey();
            if (StringUtils.isBlank((CharSequence)customerTokenKey)) {
                log.warn("Customer token key is blank. Cannot decrypt license expiration date.");
                return "";
            }
            return EncryptionUtils.decrypt(customerTokenKey, encryptedValue);
        }
        catch (Exception e) {
            log.error("Error retrieving license expiration date: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        try {
            String customerTokenKey = this.getCustomerTokenKey();
            if (StringUtils.isBlank((CharSequence)customerTokenKey)) {
                log.warn("Customer token key is blank. Cannot encrypt license expiration date.");
                return;
            }
            String encryptedValue = EncryptionUtils.encrypt(customerTokenKey, licenseExpireDate);
            this.pluginSettings.put("miniorange.saml.LICENSE_EXPIRE_DATE", (Object)encryptedValue);
            log.info("License expiration date set successfully.");
        }
        catch (Exception e) {
            log.error("Error setting license expiration date: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public Integer getLicencedUsers() {
        try {
            String licencedUsers = (String)this.pluginSettings.get("confluence.sso.mo.lu");
            if (licencedUsers == null) {
                log.warn("Licensed users value is missing from plugin settings.");
                return -1;
            }
            log.debug("Number of licensed users in Crowd: {}", (Object)licencedUsers);
            return Integer.parseInt(licencedUsers);
        }
        catch (NumberFormatException e) {
            log.error("Invalid number format for licensed users", (Throwable)e);
            return -1;
        }
    }

    public void setLicencedUsers(Integer userCount) {
        if (userCount == null || userCount < 0) {
            log.warn("Invalid user count provided: {}. User count must be a non-negative integer.", (Object)userCount);
            return;
        }
        String licencedUsers = userCount.toString();
        this.pluginSettings.put("confluence.sso.mo.lu", (Object)licencedUsers);
        log.debug("Licensed users count set to: {}", (Object)licencedUsers);
    }

    public Boolean isNoOfUserExceed() {
        try {
            Integer licencedUsers = this.getLicencedUsers();
            Integer crowdUserTier = this.propertyManager.getCurrentLicenseResourceTotal();
            if (crowdUserTier > licencedUsers) {
                if (licencedUsers > 20000) {
                    return Boolean.FALSE;
                }
                log.debug("No of Crowd user exceeded");
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            log.error("An error occurred while licensed user check ", (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public Boolean getLicenseVerified() {
        String encryptedValue = (String)this.pluginSettings.get("miniorange.saml.LICENSE_VERIFIED");
        if (StringUtils.isBlank((CharSequence)encryptedValue)) {
            log.info("License verification status is not set or is blank.");
            return Boolean.FALSE;
        }
        try {
            String customerTokenKey = this.getCustomerTokenKey();
            if (StringUtils.isBlank((CharSequence)customerTokenKey)) {
                log.warn("Customer token key is blank. Cannot decrypt license verification status.");
                return Boolean.FALSE;
            }
            String decryptedValue = EncryptionUtils.decrypt(customerTokenKey, encryptedValue);
            return BooleanUtils.toBoolean((String)decryptedValue);
        }
        catch (Exception e) {
            log.error("Error retrieving license verification status: {}", (Object)e.getMessage(), (Object)e);
            return Boolean.FALSE;
        }
    }

    public void setLicenseVerified(Boolean licenseVerified) {
        String customerTokenKey = this.getCustomerTokenKey();
        if (StringUtils.isBlank((CharSequence)customerTokenKey)) {
            log.warn("Customer token key is blank. Cannot encrypt license verification status.");
            return;
        }
        try {
            String encryptedValue = EncryptionUtils.encrypt(customerTokenKey, BooleanUtils.toString((Boolean)licenseVerified, (String)"true", (String)"false", (String)"false"));
            this.pluginSettings.put("miniorange.saml.LICENSE_VERIFIED", (Object)encryptedValue);
            log.info("License verification status set successfully to: {}", (Object)licenseVerified);
        }
        catch (Exception e) {
            log.error("Error setting license verification status: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void removeCustomerAccount() {
        log.info("Removing customer account details and license information.");
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_ID");
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_EMAIL");
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_API_KEY");
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_TOKEN_KEY");
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_LICENSE_KEY");
        this.pluginSettings.remove("miniorange.saml.LICENSE_VERIFIED");
        this.pluginSettings.remove("confluence.sso.mo.active.users");
        this.pluginSettings.remove("confluence.sso.mo.lu");
        this.pluginSettings.remove("confluence.sso.mo.ioc");
        this.pluginSettings.remove("miniorange.saml.USER_EXCEEDED_ALERT_EMAILS_SENT");
        this.pluginSettings.remove("miniorange.saml.LICENSE_EXPIRE_DATE");
        this.pluginSettings.remove("miniorange.saml.IS_TRIAL_LICENSE");
    }

    public Boolean getMailSent() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.MAIL_SENT"))), (boolean)Boolean.FALSE);
    }

    public void setMailSent(Boolean mailSent) {
        this.pluginSettings.put("miniorange.saml.MAIL_SENT", (Object)BooleanUtils.toString((Boolean)mailSent, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getTrialActivated() {
        try {
            String encryptedValue = StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.TRIAL_ACTIVATED")));
            Boolean trialActivated = StringUtils.isNotBlank((CharSequence)encryptedValue) && BooleanUtils.toBoolean((String)EncryptionUtils.decrypt("u4JpSz2dti6u5kRB", encryptedValue));
            log.debug("Retrieved trial activated status: {}", (Object)trialActivated);
            return trialActivated;
        }
        catch (Exception e) {
            log.error("Failed to get trial activated status", (Throwable)e);
            return false;
        }
    }

    public void setTrialActivated(Boolean trialActivated) {
        try {
            String encryptedValue = EncryptionUtils.encrypt("u4JpSz2dti6u5kRB", BooleanUtils.toString((Boolean)trialActivated, (String)"true", (String)"false", (String)"false"));
            this.pluginSettings.put("miniorange.saml.TRIAL_ACTIVATED", (Object)encryptedValue);
            log.debug("Trial activated status set. Value: {}", (Object)trialActivated);
        }
        catch (Exception e) {
            log.error("Failed to set trial activated status. TrialActivated: {}", (Object)trialActivated, (Object)e);
        }
    }

    public String getSpBaseUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SP_BASE_URL")), (CharSequence)this.getBaseUrl());
    }

    public void setSpBaseUrl(String spBaseUrl) {
        this.pluginSettings.put("miniorange.saml.SP_BASE_URL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)spBaseUrl, (CharSequence)this.getBaseUrl()))));
    }

    public String getSpEntityId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SP_ENTITY_ID")), (CharSequence)this.getBaseUrl());
    }

    public void setSpEntityId(String spEntityId) {
        this.pluginSettings.put("miniorange.saml.SP_ENTITY_ID", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)spEntityId, (CharSequence)this.getBaseUrl()))));
    }

    public Boolean getSigning() {
        String signing = (String)this.pluginSettings.get("miniorange.saml.SIGNING");
        if (StringUtils.isBlank((CharSequence)signing)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)signing);
    }

    public void setSigning(Boolean signing) {
        this.pluginSettings.put("miniorange.saml.SIGNING", (Object)BooleanUtils.toString((Boolean)signing, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEncryption() {
        String encryption = (String)this.pluginSettings.get("miniorange.saml.ENCRYPTION");
        if (StringUtils.isBlank((CharSequence)encryption)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)encryption);
    }

    public void setEncryption(Boolean encryption) {
        this.pluginSettings.put("miniorange.saml.ENCRYPTION", (Object)BooleanUtils.toString((Boolean)encryption, (String)"true", (String)"false", (String)"false"));
    }

    public String getOrganizationName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniOrange")), (CharSequence)"miniOrange");
    }

    public void setOrganizationName(String organizationName) {
        this.pluginSettings.put("miniOrange", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)organizationName, (CharSequence)"miniOrange"))));
    }

    public String getOrganizationUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("https://www.miniorange.com")), (CharSequence)"https://www.miniorange.com");
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.pluginSettings.put("https://www.miniorange.com", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)organizationUrl, (CharSequence)"https://www.miniorange.com"))));
    }

    public String getTechnicalContactName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniOrange support")), (CharSequence)"miniOrange support");
    }

    public void setTechnicalContactName(String technicalContactName) {
        this.pluginSettings.put("miniOrange support", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)technicalContactName, (CharSequence)"miniOrange support"))));
    }

    public String getTechnicalContactEmail() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("info@xecurify.com")), (CharSequence)"info@xecurify.com");
    }

    public void setTechnicalContactEmail(String technicalContactEmail) {
        this.pluginSettings.put("info@xecurify.com", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)technicalContactEmail, (CharSequence)"info@xecurify.com"))));
    }

    public String getSupportContactName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniOrange support")), (CharSequence)"miniOrange support");
    }

    public void setSupportContactName(String supportContactName) {
        this.pluginSettings.put("miniOrange Support", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)supportContactName, (CharSequence)"miniOrange Support"))));
    }

    public String getSupportContactEmail() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("info@xecurify.com")), (CharSequence)"info@xecurify.com");
    }

    public void setSupportContactEmail(String supportContactEmail) {
        this.pluginSettings.put("info@xecurify.com", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)supportContactEmail, (CharSequence)"info@xecurify.com"))));
    }

    public HashMap<String, String> getIdpMap() {
        HashMap idpMap = (HashMap)this.pluginSettings.get("miniorange.saml.IDP_MAP");
        if (idpMap == null) {
            return new HashMap<String, String>();
        }
        return idpMap;
    }

    public void setIdpMap(HashMap<String, String> idpMap) {
        this.pluginSettings.put("miniorange.saml.IDP_MAP", idpMap);
    }

    public ArrayList<String> getIdPList() {
        ArrayList idpList = (ArrayList)this.pluginSettings.get("miniorange.saml.IDP_LIST");
        if (idpList == null) {
            return new ArrayList<String>();
        }
        return idpList;
    }

    public void setIdPList(ArrayList<String> idpList) {
        this.pluginSettings.put("miniorange.saml.IDP_LIST", idpList);
    }

    public void setIdpConfig(JSONObject idpConfigObj, String idpName) {
        this.pluginSettings.put("miniorange.saml.IDP_CONFIG" + idpName, (Object)idpConfigObj.toString());
    }

    public JSONObject getIdpConfig(String idpName) throws JSONException {
        String idpConfigString = (String)this.pluginSettings.get("miniorange.saml.IDP_CONFIG" + idpName);
        if (StringUtils.isNotBlank((CharSequence)idpConfigString)) {
            return new JSONObject(idpConfigString);
        }
        return null;
    }

    public void setIsCertificateExpired(Boolean certificateExpired) {
        this.pluginSettings.put("miniorange.saml.CERT_EXPIRED", (Object)BooleanUtils.toString((Boolean)certificateExpired, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean isCertificateExpired() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.CERT_EXPIRED"))), (boolean)false);
    }

    public void updateCertificateExpiredMessage(Date certificateExpiryDate) {
        Date now = new DateTime().toDate();
        if (now.after(certificateExpiryDate)) {
            this.setIsCertificateExpired(Boolean.TRUE);
        } else {
            this.setIsCertificateExpired(Boolean.FALSE);
        }
    }

    public String getPublicSPCertificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.PUBLIC_SP_CERTIFICATE")), (CharSequence)this.getNewPublicSPCertificate());
    }

    public void setPublicSPCertificate(String publicSPCertificate) {
        this.pluginSettings.put("miniorange.saml.PUBLIC_SP_CERTIFICATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)publicSPCertificate, (CharSequence)this.getNewPublicSPCertificate()))));
    }

    public String getPrivateSPCertificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.PRIVATE_SP_CERTIFICATE")), (CharSequence)this.getNewPrivateSPCertificate());
    }

    public void setPrivateSPCertificate(String publicSPCertificate) {
        this.pluginSettings.put("miniorange.saml.PRIVATE_SP_CERTIFICATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)publicSPCertificate, (CharSequence)this.getNewPrivateSPCertificate()))));
    }

    public String getNewPublicSPCertificate() {
        return PluginUtils.readFileFromResource("/certificates/new-sp-certificate.crt");
    }

    public String getNewPrivateSPCertificate() {
        return PluginUtils.readFileFromResource("/certificates/new-sp-key.key");
    }

    public String getOldConfiguredPublicSPCertificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.OLD_CONFIGURED_PUBLIC_SP_CERTIFICATE")), (CharSequence)PluginUtils.readFileFromResource("/certificates/sp-certificate.crt"));
    }

    public void setOldConfiguredPublicSPCertificate(String publicSPCertificate) {
        this.pluginSettings.put("miniorange.saml.OLD_CONFIGURED_PUBLIC_SP_CERTIFICATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)publicSPCertificate, (CharSequence)PluginUtils.readFileFromResource("/certificates/sp-certificate.crt")))));
    }

    public String getOldConfiguredPrivateSPCertificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.OLD_CONFIGURED_PRIVATE_SP_CERTIFICATE")), (CharSequence)PluginUtils.readFileFromResource("/certificates/sp-key.key"));
    }

    public void setOldConfiguredPrivateSPCertificate(String publicSPCertificate) {
        this.pluginSettings.put("miniorange.saml.OLD_CONFIGURED_PRIVATE_SP_CERTIFICATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)publicSPCertificate, (CharSequence)PluginUtils.readFileFromResource("/certificates/sp-key.key")))));
    }

    public Long getSPCertExpireOn() {
        String expireOn = (String)this.pluginSettings.get("miniorange.saml.SP_CERTIFICATE_EXPIRE_ON");
        return NumberUtils.createLong((String)expireOn);
    }

    public void setSPCertExpireOn(String validTo) {
        try {
            Date from = new Date();
            SimpleDateFormat myformat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
            from = myformat.parse(from.toString());
            Date to = myformat.parse(validTo);
            long difference = Math.abs((from.getTime() - to.getTime()) / 86400000L);
            this.pluginSettings.put("miniorange.saml.SP_CERTIFICATE_EXPIRE_ON", (Object)String.valueOf(difference));
        }
        catch (ParseException e) {
            log.error("Error parsing the date. Ensure the date format matches 'E MMM dd HH:mm:ss Z yyyy'", (Throwable)e);
        }
        catch (Exception e) {
            log.error("An unexpected error occurred while setting the certificate expiry date", (Throwable)e);
        }
    }

    public String getIdpEntityId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.IDP_ENTITY_ID")), (CharSequence)"");
    }

    public void setIdpEntityId(String idpEntityId) {
        this.pluginSettings.put("miniorange.saml.IDP_ENTITY_ID", (Object)StringUtils.trimToEmpty((String)idpEntityId));
    }

    public String getIdpName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.IDP_NAME")), (CharSequence)"IDP");
    }

    public void setIdpName(String idpName) {
        this.pluginSettings.put("miniorange.saml.IDP_NAME", (Object)StringUtils.defaultIfBlank((CharSequence)idpName, (CharSequence)""));
    }

    public String getSsoServiceUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SSO_URL")), (CharSequence)"");
    }

    public void setSsoServiceUrl(String ssoServiceUrl) {
        this.pluginSettings.put("miniorange.saml.SSO_URL", (Object)StringUtils.trimToEmpty((String)ssoServiceUrl));
    }

    public String getSloServiceUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SLO_URL")), (CharSequence)"");
    }

    public void setSloServiceUrl(String sloServiceUrl) {
        this.pluginSettings.put("miniorange.saml.SLO_URL", (Object)StringUtils.trimToEmpty((String)sloServiceUrl));
    }

    public String getSsoBindingType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SSO_BINDING_TYPE")), (CharSequence)"HttpRedirect");
    }

    public void setSsoBindingType(String ssoBindingType) {
        this.pluginSettings.put("miniorange.saml.SSO_BINDING_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)ssoBindingType, (CharSequence)"HttpRedirect"))));
    }

    public String getSloBindingType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SLO_BINDING_TYPE")), (CharSequence)"HttpRedirect");
    }

    public void setSloBindingType(String sloBindingType) {
        this.pluginSettings.put("miniorange.saml.SLO_BINDING_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)sloBindingType, (CharSequence)"HttpRedirect"))));
    }

    public String getX509Certificate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.X509_CERTIFICATE")), (CharSequence)"");
    }

    public void setX509Certificate(String x509Certificate) {
        this.pluginSettings.put("miniorange.saml.X509_CERTIFICATE", (Object)SAMLUtils.serializePublicCertificate(x509Certificate));
    }

    public Object getAllX509Certificates() {
        return this.pluginSettings.get("miniorange.saml.ALL_X509_CERTIFICATES");
    }

    public void setAllX509Certificates(List<String> x509certificates) {
        for (String certificate : x509certificates) {
            x509certificates.set(x509certificates.indexOf(certificate), SAMLUtils.serializePublicCertificate(certificate));
        }
        this.pluginSettings.put("miniorange.saml.ALL_X509_CERTIFICATES", x509certificates);
    }

    public Boolean getSignedRequest() {
        String signedRequestStr = (String)this.pluginSettings.get("miniorange.saml.SIGNED_REQUEST");
        if (StringUtils.isBlank((CharSequence)signedRequestStr)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)signedRequestStr);
    }

    public void setSignedRequest(Boolean signedRequest) {
        this.pluginSettings.put("miniorange.saml.SIGNED_REQUEST", (Object)BooleanUtils.toString((Boolean)signedRequest, (String)"true", (String)"false", (String)"false"));
    }

    public String getNameIdFormat() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.NAME_ID_FORMAT")), (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.pluginSettings.put("miniorange.saml.NAME_ID_FORMAT", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)nameIdFormat, (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"))));
    }

    public String getInputMetadataUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.INPUT_METADATA_URL")), (CharSequence)"");
    }

    public void setInputMetadataUrl(String url) {
        this.pluginSettings.put("miniorange.saml.INPUT_METADATA_URL", (Object)StringUtils.trimToEmpty((String)url));
    }

    public Boolean getRefreshMetadata() {
        if (BooleanUtils.isFalse((Boolean)((Boolean)this.pluginSettings.get("miniorange.saml.INPUT_METADATA_URL")))) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.REFRESH_METADATA"))), (boolean)false);
    }

    public void setRefreshMetadata(Boolean refreshMetadata) {
        this.pluginSettings.put("miniorange.saml.REFRESH_METADATA", (Object)BooleanUtils.toString((Boolean)refreshMetadata, (String)"true", (String)"false", (String)"false"));
    }

    public String getRefreshInterval() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.METADATA_REFRESH_INTERVAL")), (CharSequence)"hourly");
    }

    public void setRefreshInterval(String refreshInterval) {
        this.pluginSettings.put("miniorange.saml.METADATA_REFRESH_INTERVAL", (Object)StringUtils.trimToEmpty((String)refreshInterval));
    }

    public Integer getCustomRefreshInterval() {
        String interval = (String)this.pluginSettings.get("miniorange.saml.CUSTOM_REFRESH_INTERVAL");
        if (NumberUtils.isDigits((String)interval)) {
            return NumberUtils.createInteger((String)interval);
        }
        return SAMLUtils.getMetadataRefreshInterval(this.getRefreshInterval(), 60, "minutes");
    }

    public void setCustomRefreshInterval(Integer customRefreshInterval) {
        this.pluginSettings.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL", (Object)String.valueOf(customRefreshInterval));
    }

    public String getCustomRefreshIntervalUnit() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT")), (CharSequence)"minutes");
    }

    public void setCustomRefreshIntervalUnit(String customRefreshIntervalUnit) {
        this.pluginSettings.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", (Object)StringUtils.trimToEmpty((String)customRefreshIntervalUnit));
    }

    public String getLoginUserAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGIN_USER_ATTRIBUTE")), (CharSequence)"username");
    }

    public void setLoginUserAttribute(String loginUserAttribute) {
        this.pluginSettings.put("miniorange.saml.LOGIN_USER_ATTRIBUTE", (Object)StringUtils.defaultIfBlank((CharSequence)loginUserAttribute, (CharSequence)"username"));
    }

    public String getUsernameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.USERNAME_ATTRIBUTE")), (CharSequence)"NameID");
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.pluginSettings.put("miniorange.saml.USERNAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)usernameAttribute, (CharSequence)"NameID"))));
    }

    public String getEmailAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.EMAIL_ATTRIBUTE")), (CharSequence)"NameID");
    }

    public void setEmailAttribute(String emailAttribute) {
        this.pluginSettings.put("miniorange.saml.EMAIL_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailAttribute, (CharSequence)"NameID"))));
    }

    public String getFullNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.FULL_NAME_ATTRIBUTE")), (CharSequence)"");
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.pluginSettings.put("miniorange.saml.FULL_NAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""))));
    }

    public Boolean getUseSeparateNameAttributes() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE"))), (boolean)false);
    }

    public void setUseSeparateNameAttributes(Boolean defaultLoginDisabled) {
        this.pluginSettings.put("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE", (Object)BooleanUtils.toString((Boolean)defaultLoginDisabled, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getKeepExistingUserAttributes() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.KEEP_EXISTING_ATTRIBUTE"))), (boolean)false);
    }

    public void setKeepExistingUserAttributes(Boolean keepExistingUserAttributes) {
        this.pluginSettings.put("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", (Object)BooleanUtils.toString((Boolean)keepExistingUserAttributes, (String)"true", (String)"false", (String)"false"));
    }

    public String getFirstNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.FIRST_NAME_ATTRIBUTE")), (CharSequence)"");
    }

    public void setFirstNameAttribute(String fullNameAttribute) {
        this.pluginSettings.put("miniorange.saml.FIRST_NAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""))));
    }

    public String getLastNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LAST_NAME_ATTRIBUTE")), (CharSequence)"");
    }

    public void setLastNameAttribute(String fullNameAttribute) {
        this.pluginSettings.put("miniorange.saml.LAST_NAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""))));
    }

    public HashMap<String, String> getCustomAttributeMapping() {
        Object customAttributeMapping = this.pluginSettings.get("miniorange.saml.CUSTOM_ATTRIBUTE_MAPPING");
        if (customAttributeMapping != null) {
            return (HashMap)customAttributeMapping;
        }
        return new HashMap<String, String>();
    }

    public void setCustomAttributeMapping(HashMap<String, String> customAttributeMapping) {
        this.pluginSettings.put("miniorange.saml.CUSTOM_ATTRIBUTE_MAPPING", customAttributeMapping);
    }

    public Boolean getRestrictUserCreation() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.RESTRICT_USER_CREATION"))), (boolean)false);
    }

    public void setRestrictUserCreation(Boolean restrictUserCreation) {
        this.pluginSettings.put("miniorange.saml.RESTRICT_USER_CREATION", (Object)BooleanUtils.toString((Boolean)restrictUserCreation, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRegexPatternEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_REGEX_PATTERN"))), (boolean)Boolean.FALSE);
    }

    public void setRegexPatternEnabled(Boolean regexPatternEnabled) {
        this.pluginSettings.put("miniorange.saml.ENABLE_REGEX_PATTERN", (Object)BooleanUtils.toString((Boolean)regexPatternEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getRegexPattern() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.REGEX_PATTERN")), (CharSequence)"");
    }

    public void setRegexPattern(String regexPattern) {
        this.pluginSettings.put("miniorange.saml.REGEX_PATTERN", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPattern, (CharSequence)""))));
    }

    public String getRoleAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ROLE_ATTRIBUTE")), (CharSequence)"");
    }

    public void setRoleAttribute(String roleAttribute) {
        this.pluginSettings.put("miniorange.saml.ROLE_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)roleAttribute, (CharSequence)""))));
    }

    public String getEnableDefaultGroupsFor() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR")), (CharSequence)"newUsers");
    }

    public void setEnableDefaultGroupsFor(String enableDefaultGroupsFor) {
        this.pluginSettings.put("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR", (Object)StringUtils.defaultIfEmpty((CharSequence)enableDefaultGroupsFor, (CharSequence)"newUsers"));
    }

    public Boolean getUpdateUserOnlyIfRoleMapped() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.UPDATE_USER_ONLY_IF_ROLEMAPPED"))), (boolean)false);
    }

    public void setUpdateUserOnlyIfRoleMapped(Boolean updateUserOnlyIfRoleMapped) {
        this.pluginSettings.put("miniorange.saml.UPDATE_USER_ONLY_IF_ROLEMAPPED", (Object)BooleanUtils.toString((Boolean)updateUserOnlyIfRoleMapped, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getKeepExistingUserRoles() {
        String keepExistingUserRoles = (String)this.pluginSettings.get("miniorange.saml.KEEP_EXISTING_USER_ROLES");
        if (StringUtils.isBlank((CharSequence)keepExistingUserRoles)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)keepExistingUserRoles);
    }

    public void setKeepExistingUserRoles(Boolean keepExistingUserRoles) {
        this.pluginSettings.put("miniorange.saml.KEEP_EXISTING_USER_ROLES", (Object)BooleanUtils.toString((Boolean)keepExistingUserRoles, (String)"true", (String)"false", (String)"false"));
    }

    public HashMap<String, String> getRoleMapping() {
        Object roleMapping = this.pluginSettings.get("miniorange.saml.ROLE_MAPPING");
        if (roleMapping != null) {
            return (HashMap)roleMapping;
        }
        return new HashMap<String, String>();
    }

    public void setRoleMapping(HashMap<String, String> roleMapping) {
        this.pluginSettings.put("miniorange.saml.ROLE_MAPPING", roleMapping);
    }

    public Boolean getCreateUsersIfRoleMapped() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED"))), (boolean)false);
    }

    public void setCreateUsersIfRoleMapped(Boolean createUsersIfRoleMapped) {
        this.pluginSettings.put("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED", (Object)BooleanUtils.toString((Boolean)createUsersIfRoleMapped, (String)"true", (String)"false", (String)"false"));
    }

    public List<String> getOnTheFlyDoNotRemoveGroups() {
        if (this.pluginSettings.get("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS") != null) {
            return (List)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS");
        }
        return new ArrayList<String>();
    }

    public void setOnTheFlyDoNotRemoveGroups(List<String> groups) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS", groups);
    }

    public Boolean getCreateNewGroups() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS"))), (boolean)true);
    }

    public void setCreateNewGroups(Boolean createNewGroups) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS", (Object)BooleanUtils.toString((Boolean)createNewGroups, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getOnTheFlyGroupCreation() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_GROUP_MAPPING"))), (boolean)false);
    }

    public void setOnTheFlyGroupCreation(Boolean createUsersIfRoleMapped) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_GROUP_MAPPING", (Object)BooleanUtils.toString((Boolean)createUsersIfRoleMapped, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getOnTheFlyAssignNewGroupsOnly() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY"))), (boolean)true);
    }

    public void setOnTheFlyAssignNewGroupsOnly(Boolean onTheFlyAssignNewGroupsOnly) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY", (Object)BooleanUtils.toString((Boolean)onTheFlyAssignNewGroupsOnly, (String)"true", (String)"false", (String)"false"));
    }

    public List<String> getDefaultGroups() {
        String defaultGroups = (String)this.pluginSettings.get("miniorange.saml.DEFAULT_GROUP");
        return defaultGroups != null ? Collections.singletonList(defaultGroups) : Collections.singletonList("crowd-administrators");
    }

    public void setDefaultGroups(List<String> defaultGroups) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_GROUP", defaultGroups);
    }

    public List<String> getGroupFilterOptionsList() {
        ArrayList<String> filterOption = new ArrayList<String>();
        filterOption.add("None");
        filterOption.add("Starts with");
        filterOption.add("Contains");
        filterOption.add("Regex");
        return filterOption;
    }

    public String getDefaultDirectory() {
        String defaultDirectory = StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.DEFAULT_DIRECTORY")), (String)"");
        if (StringUtils.isBlank((CharSequence)defaultDirectory) || StringUtils.isEmpty((CharSequence)defaultDirectory)) {
            List directoryObjects = this.directoryManager.findAllDirectories();
            if (directoryObjects.get(0) != null) {
                defaultDirectory = ((Directory)directoryObjects.get(0)).getName();
            }
            this.setDefaultDirectory(defaultDirectory);
        }
        return defaultDirectory;
    }

    public ArrayList<String> getExistingDirectory() {
        List directoryObjects = this.directoryManager.findAllDirectories();
        this.existingDirectory = new ArrayList();
        for (Directory directory : directoryObjects) {
            this.existingDirectory.add(directory.getName());
        }
        return this.existingDirectory;
    }

    public ArrayList<String> getExistingGroups() {
        try {
            this.existingGroups = this.getAllGroups();
            return this.existingGroups;
        }
        catch (Exception e) {
            log.error("An exception occurs while getting list of groups from Crowd Server", (Throwable)e);
            return null;
        }
    }

    protected ArrayList<String> getAllGroups() {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(50);
        log.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        log.debug("groups =  " + groups);
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public void setDefaultDirectory(String defaultDirectory) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_DIRECTORY", (Object)StringUtils.trimToEmpty((String)defaultDirectory));
    }

    public Boolean getGroupRegexPatternEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.REGEX_FOR_GROUPS_ENABLED"))), (boolean)Boolean.FALSE);
    }

    public void setGroupRegexPatternEnabled(Boolean groupRegexPatternEnabled) {
        this.pluginSettings.put("miniorange.saml.REGEX_FOR_GROUPS_ENABLED", (Object)BooleanUtils.toString((Boolean)groupRegexPatternEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getOnTheFlyFilterIDPGroupsOption() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_OPTION")), (CharSequence)"None");
    }

    public void setOnTheFlyFilterIDPGroupsOption(String onTheFlyFilterIDPGroupsOption) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_OPTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)onTheFlyFilterIDPGroupsOption, (CharSequence)"NameID"))));
    }

    public String getOnTheFlyFilterIDPGroupsKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_KEY")), (CharSequence)"");
    }

    public void setOnTheFlyFilterIDPGroupsKey(String onTheFlyFilterIDPGroupsKey) {
        this.pluginSettings.put("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)onTheFlyFilterIDPGroupsKey, (CharSequence)""))));
    }

    public String getRegexPatternForGroup() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.REGEX_PATTERN_FOR_GROUPS")), (CharSequence)"");
    }

    public void setRegexPatternForGroup(String regexPatternForGroup) {
        this.pluginSettings.put("miniorange.saml.REGEX_PATTERN_FOR_GROUPS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPatternForGroup, (CharSequence)""))));
    }

    public String getTestRegex() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.TEXT_REGEX_FOR_GROUPS")), (CharSequence)"");
    }

    public void setTestRegex(String testRegex) {
        this.pluginSettings.put("miniorange.saml.TEXT_REGEX_FOR_GROUPS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)testRegex, (CharSequence)""))));
    }

    public String getRegexGroups() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.REGEX_GROUPS")), (CharSequence)"");
    }

    public void setRegexGroups(String regexGroups) {
        this.pluginSettings.put("miniorange.saml.REGEX_GROUPS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexGroups, (CharSequence)""))));
    }

    public List<String> getBackdoorGroups() {
        return Optional.ofNullable((List)this.pluginSettings.get("miniorange.saml.BACKDOOR_GROUPS")).orElse(Collections.singletonList("crowd-administrators"));
    }

    public void setBackdoorGroups(List<String> backdoorGroups) {
        this.pluginSettings.put("miniorange.saml.BACKDOOR_GROUPS", backdoorGroups);
    }

    public Boolean getRestrictBackdoor() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.RESTRICT_BACKDOOR"))), (boolean)false);
    }

    public void setRestrictBackdoor(Boolean restrictBackdoor) {
        this.pluginSettings.put("miniorange.saml.RESTRICT_BACKDOOR", (Object)BooleanUtils.toString((Boolean)restrictBackdoor, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getApplicationGroupEnrollment() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.APPLICATION_GROUP_ENROLLMENT"))), (boolean)false);
    }

    public void setApplicationGroupEnrollment(Boolean applicationGroupEnrollment) {
        this.pluginSettings.put("miniorange.saml.APPLICATION_GROUP_ENROLLMENT", (Object)BooleanUtils.toString((Boolean)applicationGroupEnrollment, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_DEBUG_LOGS"))), (boolean)false);
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put("miniorange.saml.ENABLE_DEBUG_LOGS", (Object)BooleanUtils.toString((Boolean)enableDebugLogs, (String)"true", (String)"false", (String)"false"));
    }

    public String getTimeDelay() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.TIME_DELAY")), (CharSequence)"01");
    }

    public void setTimeDelay(String timeDelay) {
        this.pluginSettings.put("miniorange.saml.TIME_DELAY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)timeDelay, (CharSequence)"01"))));
    }

    public Boolean getEnableSAMLSSO() {
        String enableSAMLSSO = (String)this.pluginSettings.get("miniorange.saml.ENABLE_SAML_SSO");
        if (StringUtils.isBlank((CharSequence)enableSAMLSSO)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)enableSAMLSSO);
    }

    public void setEnableSAMLSSO(Boolean enableSAMLSSO) {
        this.pluginSettings.put("miniorange.saml.ENABLE_SAML_SSO", (Object)BooleanUtils.toString((Boolean)enableSAMLSSO, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getDefaultLoginDisabled() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.DISABLE_DEFAULT_LOGIN")));
    }

    public void setDefaultLoginDisabled(Boolean defaultLoginDisabled) {
        this.pluginSettings.put("miniorange.saml.DISABLE_DEFAULT_LOGIN", (Object)BooleanUtils.toString((Boolean)defaultLoginDisabled, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAutoActivateUser() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.AUTO_ACTIVATE_USER")));
    }

    public void setAutoActivateUser(Boolean autoActivateUser) {
        this.pluginSettings.put("miniorange.saml.AUTO_ACTIVATE_USER", (Object)BooleanUtils.toString((Boolean)autoActivateUser, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getBackdoorEnabled() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_BACKDOOR")));
    }

    public void setBackdoorEnabled(Boolean backdoorEnabled) {
        this.pluginSettings.put("miniorange.saml.ENABLE_BACKDOOR", (Object)BooleanUtils.toString((Boolean)backdoorEnabled, (String)"true", (String)"false", (String)"true"));
    }

    public String getRelayState() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.RELAY_STATE")), (CharSequence)"");
    }

    public void setRelayState(String relayState) {
        this.pluginSettings.put("miniorange.saml.RELAY_STATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)relayState, (CharSequence)""))));
    }

    public String getLoginButtonText() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGIN_BUTTON_TEXT")), (CharSequence)"Use Corporate Login");
    }

    public void setLoginButtonText(String loginButtonText) {
        this.pluginSettings.put("miniorange.saml.LOGIN_BUTTON_TEXT", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)loginButtonText, (CharSequence)"Use Corporate Login"))));
    }

    public String getLoginTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SAML_LOGIN_TEMPLATE")), (CharSequence)PluginUtils.readFileFromResource("/templates/logintemplate.vm"));
    }

    public void setLoginTemplate(String loginTemplate) {
        this.pluginSettings.put("miniorange.saml.SAML_LOGIN_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)loginTemplate, (CharSequence)PluginUtils.readFileFromResource("/templates/logintemplate.vm")))));
    }

    public Boolean getEnableErrorMsgTemplate() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_ERROR_MSG_TEMPLATE")));
    }

    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.pluginSettings.put("miniorange.saml.ENABLE_ERROR_MSG_TEMPLATE", (Object)BooleanUtils.toString((Boolean)enableErrorMsgTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public String getErrorMsgTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ERROR_MSG_TEMPLATE")), (CharSequence)PluginUtils.readFileFromResource("/templates/errormsgTemplate.vm"));
    }

    public void setErrorMsgTemplate(String errorMsgTemplate) {
        this.pluginSettings.put("miniorange.saml.ERROR_MSG_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)errorMsgTemplate, (CharSequence)PluginUtils.readFileFromResource("/templates/errormsgTemplate.vm")))));
    }

    public String getSecretKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.TWO_FACTOR_SECRET_KEY")), (CharSequence)"");
    }

    public void setSecretKey(String secretKey) {
        this.pluginSettings.put("miniorange.saml.TWO_FACTOR_SECRET_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)secretKey, (CharSequence)""))));
    }

    public void setAttributeMappingConfig(JSONObject attributeMappingConfig, String idpID) {
        this.pluginSettings.put("miniorange.saml.ATTRIBUTE_MAPPING_CONFIG" + idpID, (Object)attributeMappingConfig.toString());
    }

    public JSONObject getAttributeMappingConfig(String idpID) throws JSONException {
        String attributeMappingConfig = (String)this.pluginSettings.get("miniorange.saml.ATTRIBUTE_MAPPING_CONFIG" + idpID);
        if (StringUtils.isNotBlank((CharSequence)attributeMappingConfig)) {
            return new JSONObject(attributeMappingConfig);
        }
        return null;
    }

    public void setGroupMappingConfig(JSONObject groupMappingConfig, String idpID) {
        this.pluginSettings.put("miniorange.saml.GROUP_MAPPING_CONFIG" + idpID, (Object)groupMappingConfig.toString());
    }

    public JSONObject getGroupMappingConfig(String idpID) throws JSONException {
        String groupMappingConfig = (String)this.pluginSettings.get("miniorange.saml.GROUP_MAPPING_CONFIG" + idpID);
        if (StringUtils.isNotBlank((CharSequence)groupMappingConfig)) {
            return new JSONObject(groupMappingConfig);
        }
        return null;
    }

    public JSONObject getImportMetadataConfig(String idpID) throws JSONException {
        String importMetadataConfig = (String)this.pluginSettings.get("miniorange.saml.DOMAIN_MAPPING" + idpID);
        if (StringUtils.isNotBlank((CharSequence)importMetadataConfig)) {
            return new JSONObject(importMetadataConfig);
        }
        return null;
    }

    public void setImportMetadataConfig(JSONObject importMetadataConfig, String idpID) {
        this.pluginSettings.put("miniorange.saml.DOMAIN_MAPPING" + idpID, (Object)importMetadataConfig.toString());
    }

    public List<String> getDomains() {
        List domains = (List)this.pluginSettings.get("miniorange.saml.DOMAINS");
        return domains != null ? domains : new ArrayList();
    }

    public void setDomains(String[] domains) {
        ArrayList<String> domainList = new ArrayList<String>(domains.length);
        for (int i = 0; i < domains.length; ++i) {
            domainList.add(i, domains[i]);
        }
        this.pluginSettings.put("miniorange.saml.DOMAINS", domainList);
    }

    public List<String> convertJasonArrayToList(JSONArray agentGroupsArray) throws JSONException {
        ArrayList<String> agentGroups = new ArrayList<String>();
        if (agentGroupsArray != null) {
            for (int i = 0; i < agentGroupsArray.length(); ++i) {
                agentGroups.add(agentGroupsArray.getString(i));
            }
        }
        return agentGroups;
    }

    public Boolean getUseDomainMapping() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_DOMAIN_MAPPING"))), (boolean)false);
    }

    public void setUseDomainMapping(Boolean useDomainMapping) {
        this.pluginSettings.put("miniorange.saml.USE_DOMAIN_MAPPING", (Object)BooleanUtils.toString((Boolean)useDomainMapping, (String)"true", (String)"false", (String)"false"));
    }

    public HashMap<String, String> getDomainMapping() {
        HashMap domainMapping = (HashMap)this.pluginSettings.get("miniorange.saml.DOMAIN_MAPPING");
        return domainMapping != null ? domainMapping : new HashMap();
    }

    public void setDomainMapping(HashMap<String, String> domainMapping) {
        this.pluginSettings.put("miniorange.saml.DOMAIN_MAPPING", domainMapping);
    }

    public String getSpConfigurationStatus() {
        return (String)this.pluginSettings.get("miniorange.saml.SP_CONFIGURATION_STATUS");
    }

    public void setSpConfigurationStatus(String status) {
        this.pluginSettings.put("miniorange.saml.SP_CONFIGURATION_STATUS", (Object)StringUtils.defaultIfBlank((CharSequence)status, (CharSequence)""));
    }

    public String getMetadataUploadStatus() {
        return (String)this.pluginSettings.get("miniorange.saml.METADATA_UPLOAD_STATUS");
    }

    public void setMetadataUploadStatus(String status) {
        this.pluginSettings.put("miniorange.saml.METADATA_UPLOAD_STATUS", (Object)StringUtils.defaultIfBlank((CharSequence)status, (CharSequence)""));
    }

    public String getSAMLPostRequest() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SAML_POST_REQUEST")), (CharSequence)PluginUtils.readFileFromResource("/templates/samlpostrequest.vm"));
    }

    public String getSAMLPostResponse() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SAML_POST_RESPONSE")), (CharSequence)PluginUtils.readFileFromResource("/templates/samlpostresponse.vm"));
    }

    public void clearPluginSettings() {
        this.pluginSettings.remove("miniorange.saml.IDP_ENTITY_ID");
        this.pluginSettings.remove("miniorange.saml.SSO_URL");
        this.pluginSettings.remove("miniorange.saml.SSO_BINDING_TYPE");
        this.pluginSettings.remove("miniorange.saml.SLO_URL");
        this.pluginSettings.remove("miniorange.saml.SLO_BINDING_TYPE");
        this.pluginSettings.remove("miniorange.saml.X509_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.ALL_X509_CERTIFICATES");
        this.pluginSettings.remove("miniorange.saml.SIGNED_REQUEST");
    }

    public void removeIdp(String idpID) {
        this.pluginSettings.remove("miniorange.saml.IDP_CONFIG" + idpID);
        log.debug("IDP Attribute remove : miniorange.saml.ATTRIBUTE_MAPPING_CONFIG" + idpID);
        this.pluginSettings.remove("miniorange.saml.ATTRIBUTE_MAPPING_CONFIG" + idpID);
        this.pluginSettings.remove("miniorange.saml.GROUP_MAPPING_CONFIG" + idpID);
        HashMap<String, String> domainMapping = this.getDomainMapping();
        List<String> domains = this.getDomains();
        ArrayList<String> idpList = this.getIdPList();
        HashMap<String, String> idpMap = this.getIdpMap();
        Iterator<Map.Entry<String, String>> domainMappingIterator = domainMapping.entrySet().iterator();
        while (domainMappingIterator.hasNext()) {
            Map.Entry<String, String> currentEntry = domainMappingIterator.next();
            if (!currentEntry.getValue().equals(idpID)) continue;
            domainMappingIterator.remove();
        }
        if (idpList != null && idpList.contains(idpID)) {
            int index = idpList.indexOf(idpID);
            if (domains.size() > index) {
                domains.remove(index);
            }
            idpList.remove(idpID);
            idpMap.remove(idpID);
        }
        this.setIdpMap(idpMap);
        this.setIdPList(idpList);
        this.setDomainMapping(domainMapping);
        this.setDomains(domains.toArray(new String[0]));
    }

    public void clearOldConfiguration() {
        this.pluginSettings.remove("miniorange.saml.SIGNING");
        this.pluginSettings.remove("miniorange.saml.ENCRYPTION");
        this.pluginSettings.remove("miniorange.saml.SP_BASE_URL");
        this.pluginSettings.remove("miniorange.saml.SP_ENTITY_ID");
        this.pluginSettings.remove("miniorange.saml.IDP_NAME");
        this.pluginSettings.remove("miniorange.saml.IDP_ENTITY_ID");
        this.pluginSettings.remove("miniorange.saml.SSO_URL");
        this.pluginSettings.remove("miniorange.saml.SSO_BINDING_TYPE");
        this.pluginSettings.remove("miniorange.saml.SLO_URL");
        this.pluginSettings.remove("miniorange.saml.SLO_BINDING_TYPE");
        this.pluginSettings.remove("miniorange.saml.X509_CERTIFICATE");
        this.pluginSettings.remove("miniorange.saml.ALL_X509_CERTIFICATES");
        this.pluginSettings.remove("miniorange.saml.SIGNED_REQUEST");
        this.pluginSettings.remove("miniorange.saml.NAME_ID_FORMAT");
        this.pluginSettings.remove("miniorange.saml.REFRESH_METADATA");
        this.pluginSettings.remove("miniorange.saml.METADATA_REFRESH_INTERVAL");
        this.pluginSettings.remove("miniorange.saml.CUSTOM_REFRESH_INTERVAL");
        this.pluginSettings.remove("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT");
        this.pluginSettings.remove("miniorange.saml.KEEP_EXISTING_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.LOGIN_USER_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.EMAIL_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.USERNAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.ENABLE_REGEX_PATTERN");
        this.pluginSettings.remove("miniorange.saml.REGEX_PATTERN");
        this.pluginSettings.remove("miniorange.saml.FULL_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.FIRST_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.LAST_NAME_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.ROLE_ATTRIBUTE");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_GROUP");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_GROUPS");
        this.pluginSettings.remove("miniorange.saml.DEFAULT_DIRECTORY");
        this.pluginSettings.remove("miniorange.saml.ROLE_MAPPING");
        this.pluginSettings.remove("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED");
        this.pluginSettings.remove("miniorange.saml.RESTRICT_USER_CREATION");
        this.pluginSettings.remove("miniorange.saml.KEEP_EXISTING_USER_ROLES");
        this.pluginSettings.remove("miniorange.saml.INPUT_METADATA_URL");
        this.pluginSettings.remove("miniorange.saml.APPLICATION_GROUP_ENROLLMENT");
        for (int i = 0; i < this.getIdPList().size(); ++i) {
            this.removeIdp(this.getIdPList().get(i));
        }
        for (String idp : this.getIdPList()) {
            this.removeIdp(idp);
        }
        this.pluginSettings.remove("miniorange.saml.DOMAINS");
        this.pluginSettings.remove("miniorange.saml.DOMAIN_MAPPING");
        this.pluginSettings.remove("miniorange.saml.USE_DOMAIN_MAPPING");
        this.pluginSettings.remove("miniorange.saml.IDP_LIST");
        this.pluginSettings.remove("miniorange.saml.IDP_MAP");
        this.pluginSettings.remove("miniorange.saml.DISABLE_DEFAULT_LOGIN");
        this.pluginSettings.remove("miniorange.saml.LOGIN_BUTTON_TEXT");
        this.pluginSettings.remove("miniorange.saml.RELAY_STATE");
        this.pluginSettings.remove("miniorange.saml.ENABLE_BACKDOOR");
        this.pluginSettings.remove("miniorange.saml.SAML_LOGIN_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.AUTO_ACTIVATE_USER");
        this.pluginSettings.remove("miniorange.saml.ENABLE_SAML_SSO");
    }

    public String getLoginServletUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/saml/auth");
    }

    public String getLogoutServletUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/saml/logout");
    }

    public Map<String, String> getCertificateInfo() {
        return SAMLUtils.getCertificateInfo(this.getPublicSPCertificate());
    }

    public Map<String, String> getIdpGuides() {
        TreeMap<String, String> idp = new TreeMap<String, String>();
        for (PluginConstants.idpGuides idpGuide : PluginConstants.idpGuides.values()) {
            idp.put(idpGuide.name(), idpGuide.getGuide());
        }
        return idp;
    }

    public String getAddIdpConfigurationPageUrl() {
        return this.getSpBaseUrl().concat("/plugins/servlet/crowd-saml/config/idp-config");
    }

    public Boolean getUserPresent() {
        return UserPresent;
    }

    public void setUserPresent(Boolean UserPresent) {
        PluginSettingsService.UserPresent = UserPresent;
    }

    public String getLoginPageUrl() {
        return this.getSpBaseUrl().concat("/console/login.action");
    }

    public String getSSODomain() {
        String ssoDomain = "";
        CookieConfiguration cookieConfiguration = this.propertyManager.getCookieConfiguration();
        ssoDomain = cookieConfiguration.getDomain();
        log.debug("Crowd SSO Domain : " + ssoDomain);
        return StringUtils.isNotBlank((CharSequence)ssoDomain) ? ssoDomain : "";
    }
}

