/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.miniorange.sso.saml.model.PluginAPIResponse;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.service.PluginUserService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.log4j.Level;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPluginConfigAPI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AdminPluginConfigAPI.class);
    private final PluginUserService pluginUserService;
    private final PluginLicenseService pluginLicenseService;
    private final PluginSettingsService pluginSettingsService;

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Admin Plugin Config API : GET");
        try {
            String action;
            if (this.pluginUserService.isSystemAdminAuthenticated(request)) {
                log.warn("User is not a system admin");
                response.sendError(401, "Unauthorized access");
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Invalid Crowd SAML plugin license");
                response.sendError(401, "Unauthorized access. Invalid License");
            }
            if ((action = request.getParameter("action")) == null) {
                response.sendError(400, "Action parameter is required");
                return;
            }
            String idpId = request.getParameter("idpId");
            log.debug("Admin Plugin Config GET API : Action: {}  and IDP ID : {}", (Object)action, (Object)idpId);
            switch (action) {
                case "enableSSO": {
                    this.handleEnableSSO(request, response);
                    break;
                }
                case "disableSSO": {
                    this.handleDisableSSO(request, response);
                    break;
                }
                case "deleteIdp": {
                    this.handleDeleteIdp(request, response);
                    break;
                }
                case "enableDebugLogs": {
                    this.handleEnableDebugLogs(request, response);
                    break;
                }
                case "downloadCrowdLogs": {
                    this.handleDownloadCrowdLogs(request, response);
                    break;
                }
                default: {
                    response.setContentType("application/json");
                    response.sendError(400, "Invalid Action. Please choose a valid action.");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Admin Plugin Config API Error : ", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, e.getMessage());
        }
    }

    private void handleEnableSSO(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Enabling SSO for IDP");
        this.pluginSettingsService.setEnableSAMLSSO(Boolean.TRUE);
        PluginAPIResponse pluginAPIResponse = new PluginAPIResponse(200, "SSO Enabled Successfully");
        this.sendResponse(response, pluginAPIResponse);
    }

    private void handleDisableSSO(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Disabling SSO for IDP");
        this.pluginSettingsService.setEnableSAMLSSO(Boolean.FALSE);
        PluginAPIResponse pluginAPIResponse = new PluginAPIResponse(200, "SSO Disabled Successfully");
        this.sendResponse(response, pluginAPIResponse);
    }

    private void handleDeleteIdp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Deleting SSO for IDP");
        String idpId = request.getParameter("idpId");
        PluginAPIResponse pluginAPIResponse = new PluginAPIResponse();
    }

    private void handleEnableDebugLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Enabling Debug logs for miniOrange Crowd SAML SSO Plugin");
        boolean enableDebugLogs = BooleanUtils.toBoolean((String)request.getParameter("enableDebugLogs"));
        if (enableDebugLogs) {
            org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("com.miniorange.sso.saml");
            logger.setLevel(Level.DEBUG);
        }
    }

    @Deprecated
    private void handleDownloadCrowdLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Deprecated method invoked: handleDownloadCrowdLogs. Log file download initiated from the current node.");
    }

    private void sendResponse(HttpServletResponse response, PluginAPIResponse pluginAPIResponse) throws IOException {
        response.setStatus(pluginAPIResponse.getStatusCode());
        response.setContentType("application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", pluginAPIResponse.getStatusCode());
        jsonObject.put("message", (Object)pluginAPIResponse.getMessage());
        response.getOutputStream().write(jsonObject.toString().getBytes(StandardCharsets.UTF_8));
        response.getOutputStream().close();
    }

    @Generated
    public AdminPluginConfigAPI(PluginUserService pluginUserService, PluginLicenseService pluginLicenseService, PluginSettingsService pluginSettingsService) {
        this.pluginUserService = pluginUserService;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginSettingsService = pluginSettingsService;
    }
}

