/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCertificatesAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(CustomCertificatesAction.class);
    private static final String CUSTOM_CERTIFICATE_VM_PATH = "/templates/customcert.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final ApplicationServices applicationServices;
    private final PluginLicenseService pluginLicenseService;
    private final LoginUriProvider loginUriProvider;
    private String successMessage = "";
    private String errorMessage = "";

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Custom Certificates : GET ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the Custom Certificate page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CUSTOM_CERTIFICATE_VM_PATH, this.initializeCustomCertificateConfig(request, response), (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    private HashMap<String, Object> initializeCustomCertificateConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        context.put("publicSPCertificate", this.pluginSettingsService.getPublicSPCertificate());
        context.put("privateSPCertificate", this.pluginSettingsService.getPrivateSPCertificate());
        context.put("emailAdsress", "");
        context.put("companyName", "");
        context.put("orgUnit", "");
        context.put("locationName", "");
        context.put("countryCode", "");
        context.put("validityDays", "");
        return context;
    }

    @Generated
    public CustomCertificatesAction(TemplateRenderer templateRenderer, PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, ApplicationServices applicationServices, PluginLicenseService pluginLicenseService, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.applicationServices = applicationServices;
        this.pluginLicenseService = pluginLicenseService;
        this.loginUriProvider = loginUriProvider;
    }
}

