/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.utils;

import com.miniorange.sso.saml.exception.PluginException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ProxySelector;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    public static final String CONTENT_TYPE_JSON = "application/json";
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String sendPostRequest(String url, String data, String contentType, HashMap headers) {
        try {
            log.debug("MoHttpUtils Sending POST request to {} with payload {}", (Object)url, (Object)data);
            CloseableHttpClient httpClient = HttpUtils.getHttpClient();
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            StringEntity input = new StringEntity(data);
            input.setContentType(contentType);
            postRequest.setEntity((HttpEntity)input);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            log.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                log.debug("Response Entity found. Reading Response payload.");
                String status = IOUtils.toString((Reader)new InputStreamReader(response.getEntity().getContent()));
                log.debug("Response payload: " + status);
                httpClient.close();
                return status;
            }
            log.error("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            log.error("An exception occured while sending post request :" + e.getMessage());
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, e.getMessage(), e);
        }
    }

    public static String sendPostRequestToGetToken(String url, JSONObject data, String contentType, HashMap headers) {
        try {
            CloseableHttpClient httpClient = HttpUtils.getHttpClient();
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            StringEntity entity = new StringEntity(data.toString());
            entity.setContentType(contentType);
            postRequest.setEntity((HttpEntity)entity);
            return HttpUtils.executePostRequest(httpClient, postRequest);
        }
        catch (Exception e) {
            return "Failed";
        }
    }

    public static String executePostRequest(CloseableHttpClient httpClient, HttpPost postRequest) {
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            log.debug("Response Code : " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                httpClient.close();
                return status;
            }
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            log.error("Exception occurs while posting request for token", (Throwable)e);
            return "Failed";
        }
    }

    public static String sendGetRequest(String url) {
        try {
            log.debug("MoHttpUtils sendGetRequest Sending GET request to {}", (Object)url);
            CloseableHttpClient httpClient = HttpUtils.getHttpClient();
            HttpGet getRequest = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            log.debug("Response for HTTP Request: {} and Status Code: {} ", (Object)response.toString(), (Object)response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 200 && response.getEntity() != null) {
                log.debug("Response Entity found. Reading Response payload.");
                String data = IOUtils.toString((Reader)new InputStreamReader(response.getEntity().getContent()));
                log.debug("Response payload: " + data);
                httpClient.close();
                return data;
            }
            log.debug("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            log.error("An exception occured while sending get request :{}", (Object)e.getMessage());
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, e.getMessage(), e);
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = SSLContext.getInstance("Default");
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)ccm).build();
        return httpclient;
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, String domain, boolean isSecure) {
        request.setAttribute(cookieName, (Object)cookieValue);
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath("/");
        if (isSecure) {
            cookie.setSecure(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)domain)) {
            log.debug("Setting up Cookie {} in Domain = {}", (Object)cookieName, (Object)domain);
            cookie.setDomain(domain);
        }
        response.addCookie(cookie);
    }

    public static Cookie deleteCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        log.debug("Deleting cookie {}", (Object)cookieName);
        Cookie cookie = HttpUtils.getCookie(request, response, cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        } else {
            log.warn("No cookie found with name {}", (Object)cookieName);
        }
        return null;
    }

    public static Cookie getCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        log.debug("Getting details for cookie {}", (Object)cookieName);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                log.debug("cookie {} found", (Object)cookieName);
                return cookie;
            }
        }
        log.warn("No cookie found with name {}", (Object)cookieName);
        return null;
    }

    public static URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        log.debug("Request URL: {}", (Object)builder.toString());
        if (request.getQueryString() != null) {
            log.debug("Query String: {}", (Object)request.getQueryString());
            builder.append("?");
            builder.append(request.getQueryString());
        }
        URI uri = URI.create(builder.toString());
        log.debug("Constructed URI: {}", (Object)uri);
        return uri;
    }
}

