/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.service;

import com.miniorange.sso.saml.model.IDPMetadata;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.SAMLUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.json.JSONException;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.ContactPerson;
import org.opensaml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml2.metadata.EmailAddress;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.GivenName;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.LocalizedString;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml2.metadata.OrganizationName;
import org.opensaml.saml2.metadata.OrganizationURL;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.opensaml.saml2.metadata.impl.ContactPersonBuilder;
import org.opensaml.saml2.metadata.impl.EmailAddressBuilder;
import org.opensaml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml2.metadata.impl.GivenNameBuilder;
import org.opensaml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.saml2.metadata.impl.NameIDFormatBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationDisplayNameBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationNameBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationURLBuilder;
import org.opensaml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.opensaml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.signature.impl.KeyInfoBuilder;
import org.opensaml.xml.signature.impl.X509CertificateBuilder;
import org.opensaml.xml.signature.impl.X509DataBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class PluginMetadataService {
    private static final Logger log = LoggerFactory.getLogger(PluginMetadataService.class);
    private final PluginSettingsService pluginSettingsService;

    public String generatePluginMetadata() {
        log.debug("Generating plugin metadata");
        try {
            SAMLUtils.doBootstrap();
            EntityDescriptorBuilder builder = new EntityDescriptorBuilder();
            SPSSODescriptorBuilder spssoDescriptorBuilder = new SPSSODescriptorBuilder();
            KeyDescriptorBuilder keyDescriptorBuilder = new KeyDescriptorBuilder();
            KeyInfoBuilder keyInfoBuilder = new KeyInfoBuilder();
            X509DataBuilder x509DataBuilder = new X509DataBuilder();
            X509CertificateBuilder x509CertificateBuilder = new X509CertificateBuilder();
            NameIDFormatBuilder nameIdFormatBuilder = new NameIDFormatBuilder();
            AssertionConsumerServiceBuilder assertionConsumerServiceBuilder = new AssertionConsumerServiceBuilder();
            SingleLogoutServiceBuilder singleLogOutServiceBuilder = new SingleLogoutServiceBuilder();
            OrganizationBuilder organizationBuilder = new OrganizationBuilder();
            OrganizationNameBuilder organizationNameBuilder = new OrganizationNameBuilder();
            OrganizationDisplayNameBuilder organizationDisplayNameBuilder = new OrganizationDisplayNameBuilder();
            OrganizationURLBuilder organizationUrlBuilder = new OrganizationURLBuilder();
            ContactPersonBuilder contactPersonBuilder = new ContactPersonBuilder();
            GivenNameBuilder givenNameBuilder = new GivenNameBuilder();
            EmailAddressBuilder emailAddressBuilder = new EmailAddressBuilder();
            EntityDescriptor entityDescriptor = builder.buildObject();
            SPSSODescriptor spssoDescriptor = spssoDescriptorBuilder.buildObject();
            AssertionConsumerService assertionConsumerService = assertionConsumerServiceBuilder.buildObject();
            Organization organization = organizationBuilder.buildObject();
            ContactPerson contactPersonTechnical = contactPersonBuilder.buildObject();
            ContactPerson contactPersonSupport = contactPersonBuilder.buildObject();
            entityDescriptor.setEntityID(this.pluginSettingsService.getSpEntityId());
            spssoDescriptor.setWantAssertionsSigned(true);
            spssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            String certificate = this.pluginSettingsService.getPublicSPCertificate();
            certificate = SAMLUtils.deserializePublicCertificate(certificate);
            if (BooleanUtils.toBoolean((Boolean)this.pluginSettingsService.getSigning())) {
                spssoDescriptor.setAuthnRequestsSigned(true);
                KeyDescriptor signingKeyDescriptor = keyDescriptorBuilder.buildObject();
                signingKeyDescriptor.setUse(UsageType.SIGNING);
                KeyInfo signingKeyInfo = (KeyInfo)keyInfoBuilder.buildObject(KeyInfo.DEFAULT_ELEMENT_NAME);
                X509Data signingX509Data = (X509Data)x509DataBuilder.buildObject(X509Data.DEFAULT_ELEMENT_NAME);
                X509Certificate signingX509Certificate = (X509Certificate)x509CertificateBuilder.buildObject(X509Certificate.DEFAULT_ELEMENT_NAME);
                signingX509Certificate.setValue(certificate);
                signingX509Data.getX509Certificates().add(signingX509Certificate);
                signingKeyInfo.getX509Datas().add(signingX509Data);
                signingKeyDescriptor.setKeyInfo(signingKeyInfo);
                spssoDescriptor.getKeyDescriptors().add(signingKeyDescriptor);
            }
            if (BooleanUtils.toBoolean((Boolean)this.pluginSettingsService.getEncryption())) {
                KeyDescriptor encKeyDescriptor = keyDescriptorBuilder.buildObject();
                encKeyDescriptor.setUse(UsageType.ENCRYPTION);
                KeyInfo encKeyInfo = (KeyInfo)keyInfoBuilder.buildObject(KeyInfo.DEFAULT_ELEMENT_NAME);
                X509Data encX509Data = (X509Data)x509DataBuilder.buildObject(X509Data.DEFAULT_ELEMENT_NAME);
                X509Certificate encX509Certificate = (X509Certificate)x509CertificateBuilder.buildObject(X509Certificate.DEFAULT_ELEMENT_NAME);
                encX509Certificate.setValue(certificate);
                encX509Data.getX509Certificates().add(encX509Certificate);
                encKeyInfo.getX509Datas().add(encX509Data);
                encKeyDescriptor.setKeyInfo(encKeyInfo);
                spssoDescriptor.getKeyDescriptors().add(encKeyDescriptor);
            }
            SingleLogoutService singleLogoutServiceRedir = singleLogOutServiceBuilder.buildObject();
            singleLogoutServiceRedir.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            singleLogoutServiceRedir.setLocation(this.pluginSettingsService.getSpSLOUrl());
            spssoDescriptor.getSingleLogoutServices().add(singleLogoutServiceRedir);
            SingleLogoutService singleLogoutServicePost = singleLogOutServiceBuilder.buildObject();
            singleLogoutServicePost.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            singleLogoutServicePost.setLocation(this.pluginSettingsService.getSpSLOUrl());
            spssoDescriptor.getSingleLogoutServices().add(singleLogoutServicePost);
            ArrayList<String> nameIds = new ArrayList<String>();
            nameIds.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            nameIds.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            nameIds.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            for (String nameId : nameIds) {
                NameIDFormat nameIDFormat = nameIdFormatBuilder.buildObject();
                nameIDFormat.setFormat(nameId);
                spssoDescriptor.getNameIDFormats().add(nameIDFormat);
            }
            assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            assertionConsumerService.setLocation(this.pluginSettingsService.getSpACSUrl());
            assertionConsumerService.setIndex(1);
            spssoDescriptor.getAssertionConsumerServices().add(assertionConsumerService);
            entityDescriptor.getRoleDescriptors().add(spssoDescriptor);
            OrganizationName organizationName = organizationNameBuilder.buildObject();
            organizationName.setName(new LocalizedString(this.pluginSettingsService.getOrganizationName(), Locale.getDefault().getLanguage()));
            organization.getOrganizationNames().add(organizationName);
            OrganizationDisplayName organizationDisplayName = organizationDisplayNameBuilder.buildObject();
            organizationDisplayName.setName(new LocalizedString(this.pluginSettingsService.getOrganizationName(), Locale.getDefault().getLanguage()));
            organization.getDisplayNames().add(organizationDisplayName);
            OrganizationURL organizationURL = organizationUrlBuilder.buildObject();
            organizationURL.setURL(new LocalizedString(this.pluginSettingsService.getOrganizationUrl(), Locale.getDefault().getLanguage()));
            organization.getURLs().add(organizationURL);
            entityDescriptor.setOrganization(organization);
            contactPersonTechnical.setType(ContactPersonTypeEnumeration.TECHNICAL);
            GivenName givenNameTechnical = givenNameBuilder.buildObject();
            givenNameTechnical.setName(this.pluginSettingsService.getTechnicalContactName());
            contactPersonTechnical.setGivenName(givenNameTechnical);
            EmailAddress emailAddressTechnical = emailAddressBuilder.buildObject();
            emailAddressTechnical.setAddress(this.pluginSettingsService.getTechnicalContactEmail());
            contactPersonTechnical.getEmailAddresses().add(emailAddressTechnical);
            contactPersonSupport.setType(ContactPersonTypeEnumeration.SUPPORT);
            GivenName givenNameSupport = givenNameBuilder.buildObject();
            givenNameSupport.setName(this.pluginSettingsService.getSupportContactName());
            contactPersonSupport.setGivenName(givenNameSupport);
            EmailAddress emailAddressSupport = emailAddressBuilder.buildObject();
            emailAddressSupport.setAddress(this.pluginSettingsService.getSupportContactEmail());
            contactPersonSupport.getEmailAddresses().add(emailAddressSupport);
            entityDescriptor.getContactPersons().add(contactPersonTechnical);
            entityDescriptor.getContactPersons().add(contactPersonSupport);
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(entityDescriptor);
            Element element = marshaller.marshall(entityDescriptor);
            return XMLHelper.nodeToString(element);
        }
        catch (Exception e) {
            log.error("An error occurred while generating plugin's SAML metadata {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public IDPMetadata parseIdpSAMLMetadata(String idpMedataString) throws JSONException {
        IDPMetadata idpMetadata = new IDPMetadata();
        try {
            SAMLUtils.doBootstrap();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(new InputSource(new StringReader(idpMedataString)));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            XMLObject xmlObj = unmarshaller.unmarshall(element);
            log.debug("IDP SAML Metadata XMLObject: {}", (Object)xmlObj);
            EntityDescriptor entityDescriptor = (EntityDescriptor)xmlObj;
            IDPSSODescriptor idpSsoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
            log.debug("EntityDescriptor: {}, IDPSSODescriptor: {}", (Object)entityDescriptor, (Object)idpSsoDescriptor);
            if (idpSsoDescriptor != null) {
                idpMetadata.setEntityId(entityDescriptor.getEntityID());
                idpMetadata.setSingleSignOnServices(this.extractServices(idpSsoDescriptor.getSingleSignOnServices()));
                idpMetadata.setSingleLogoutServices(this.extractServices(idpSsoDescriptor.getSingleLogoutServices()));
                idpMetadata.setCertificates(this.extractCertificates(idpSsoDescriptor.getKeyDescriptors()));
            }
        }
        catch (Exception e) {
            log.error("An error occurred while parsing the IDP metadata string: {}", (Object)e.getMessage());
        }
        return idpMetadata;
    }

    private Map<String, String> extractServices(List<? extends Endpoint> services) {
        HashMap<String, String> serviceUrls = new HashMap<String, String>();
        for (Endpoint endpoint : services) {
            String binding = endpoint.getBinding();
            String location = endpoint.getLocation();
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(binding) && !"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(binding)) continue;
            log.debug("Service Binding: {}, Location: {}", (Object)binding, (Object)location);
            serviceUrls.put(binding, location);
        }
        return serviceUrls;
    }

    private List<String> extractCertificates(List<KeyDescriptor> keyDescriptors) {
        ArrayList<String> signingCertificates = new ArrayList<String>();
        for (KeyDescriptor keyDescriptor : keyDescriptors) {
            String certificate;
            X509Certificate cert;
            KeyInfo keyInfo = keyDescriptor.getKeyInfo();
            if (keyInfo == null || keyInfo.getX509Datas().isEmpty() || (cert = keyInfo.getX509Datas().get(0).getX509Certificates().get(0)) == null || !SAMLUtils.isValidPublicCertificate(certificate = cert.getValue()).booleanValue() || !UsageType.UNSPECIFIED.equals((Object)keyDescriptor.getUse()) && !UsageType.SIGNING.equals((Object)keyDescriptor.getUse())) continue;
            signingCertificates.add(certificate);
        }
        return signingCertificates;
    }

    @Generated
    public PluginMetadataService(PluginSettingsService pluginSettingsService) {
        this.pluginSettingsService = pluginSettingsService;
    }
}

