/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.sso.saml.handler.MoPluginConfigurationsHandler;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.PluginSettingsService;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurePluginServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ConfigurePluginServlet.class);
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final MoPluginConfigurationsHandler moPluginConfigurationsHandler;
    private final UserManager userManager;

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Configure Plugin servlet called from doGet");
        try {
            if (this.pluginSettingsService.getLicenseVerified().booleanValue()) {
                String jsonConfigurations = this.moPluginConfigurationsHandler.generateConfigurationsJson();
                response.setHeader("Cache-Control", "max-age=0");
                response.setHeader("Pragma", "");
                response.setContentType("application/json");
                response.getOutputStream().write(jsonConfigurations.getBytes());
            } else {
                this.showErrorMessage(response, "Your License has expired", "Please renew the license to use the API Call.");
            }
        }
        catch (JSONException e) {
            log.error("An error occurred while fetching the json." + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Configure Plugin servlet called from doPost");
        StringBuffer sb = new StringBuffer();
        try (BufferedReader bufferedReader = null;){
            int bytesRead;
            bufferedReader = request.getReader();
            char[] charBuffer = new char[128];
            while ((bytesRead = bufferedReader.read(charBuffer)) != -1) {
                sb.append(charBuffer, 0, bytesRead);
            }
        }
        try {
            if (this.pluginSettingsService.getLicenseVerified().booleanValue()) {
                this.pluginConfigHandler.stopAllSchedulers();
                this.pluginSettingsService.clearPluginSettings();
                this.moPluginConfigurationsHandler.importPluginConfigurations(sb.toString());
                this.showSuccessMessage(response, "SAML settings updated", "SAML App Configured successfully.");
            } else {
                this.showErrorMessage(response, "Your License has expired", " Please renew the license to use the API Call.");
            }
        }
        catch (Exception e) {
            log.error("An error occurred while importing the configuration. ", (Throwable)e);
        }
    }

    private void showErrorMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "ERROR");
            json.put("Message", message);
            json.put("Description", description);
            response.setStatus(401);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            log.error("An error occurred. ", (Throwable)e);
        }
    }

    private void showSuccessMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "SUCCESS");
            json.put("Message", message);
            json.put("Description", description);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            log.error("An error occurred. ", (Throwable)e);
        }
    }

    @Generated
    public ConfigurePluginServlet(PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, MoPluginConfigurationsHandler moPluginConfigurationsHandler, UserManager userManager) {
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.moPluginConfigurationsHandler = moPluginConfigurationsHandler;
        this.userManager = userManager;
    }
}

