/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseConfigAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LicenseConfigAction.class);
    private final UserManager userManager;
    private final PluginLicenseService pluginLicenseService;
    private final TemplateRenderer templateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final PluginConfigService pluginConfigService;
    private final String CONFIG_FILE_PATH = "/templates/license-config.ftl";
    public String successMessage = "";
    public String errorMessage = "";

    public LicenseConfigAction(UserManager userManager, PluginLicenseService pluginLicenseService, TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider, PluginConfigService pluginConfigService) {
        this.userManager = userManager;
        this.pluginLicenseService = pluginLicenseService;
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigService = pluginConfigService;
    }

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. License verification action: GET");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isCustomerRegistered().booleanValue()) {
                log.info("Customer account not found, redirecting user: {} to customer login page", (Object)userProfile.getUsername());
                response.sendRedirect("/plugins/servlet/crowd-saml/config/customer-login");
                return;
            }
            if (this.pluginLicenseService.isCustomerRegistered().booleanValue() && this.pluginLicenseService.isValidLicense()) {
                log.info("Valid license found, redirecting user: {} to plugin configuration", (Object)userProfile.getUsername());
                response.sendRedirect("/plugins/servlet/crowd-saml/config/sp-config");
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the customer login page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/templates/license-config.ftl", this.initializeConfig(), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. License verification action: POST");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (userProfile != null && this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                String licenseKey = request.getParameter("licenseKey");
                Boolean isValidLicense = this.pluginLicenseService.verifyLicense(licenseKey);
                if (isValidLicense.booleanValue()) {
                    log.debug("License verified successfully, redirecting to plugin configuration page");
                    response.sendRedirect("/plugins/servlet/crowd-saml/config/sp-config");
                    return;
                }
                this.errorMessage = "Invalid License Key";
            } else {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
            }
        }
        catch (Exception e) {
            this.errorMessage = "Invalid License Key";
            log.error(this.errorMessage, (Throwable)e);
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/templates/license-config.ftl", this.initializeConfig(), (Writer)response.getWriter());
    }

    public HashMap<String, Object> initializeConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("successMessage", this.successMessage);
        config.put("errorMessage", this.errorMessage);
        config.put("pluginConfigService", this.pluginConfigService);
        config.put("pluginLicenseService", this.pluginLicenseService);
        return config;
    }
}

