/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.io.IOException;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoResetSettingsServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoResetSettingsServlet.class);
    private MoSAMLSettings settings;
    private MoPluginHandler pluginHandler;
    @ComponentImport
    private UserManager userManager;

    @Autowired
    public MoResetSettingsServlet(MoSAMLSettings settings, MoPluginHandler pluginHandler, UserManager userManager) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            UserProfile user = this.userManager.getRemoteUser();
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                this.pluginHandler.stopAllSchedulers();
                this.settings.clearOldConfiguration();
                LOGGER.debug("Plugin setting is clear. Redirecting to the configure action");
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while clearing old plugin configuration ", e);
        }
        response.sendRedirect(this.settings.getConfigureActionUrl());
    }
}

