/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.xml.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public class EnableSSOAPI
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(EnableSSOAPI.class);
    private MoSAMLSettings settings;
    @ComponentImport
    private UserManager userManager;

    @Autowired
    public EnableSSOAPI(MoSAMLSettings settings, UserManager userManager) {
        this.settings = settings;
        this.userManager = userManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("EnableSSOAPI servlet called from doGet");
        this.showErrorMessage(response, "GET method is not allowed", "The method received in the request-line is known by the origin server but not supported by the target resource. Use POST instead of GET");
        JSONObject responseJson = new JSONObject();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("EnableSSOAPI servlet called from doPost");
        Enumeration headerNames = request.getHeaderNames();
        String key = "";
        String value = "";
        String action = request.getParameter("action");
        Boolean isAdmin = Boolean.FALSE;
        String username = "";
        String pwd = "";
        while (headerNames.hasMoreElements()) {
            try {
                key = (String)headerNames.nextElement();
                if (!StringUtils.equalsIgnoreCase((CharSequence)"Authorization", (CharSequence)key)) continue;
                value = request.getHeader(key);
                value = value.split(" ")[1];
                byte[] valueDecoded = Base64.decode(value);
                value = new String(valueDecoded);
                String[] arr = value.split(":");
                username = arr[0];
                pwd = arr[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error("Something went wrong while fetching username and password." + e);
            }
        }
        UserProfile user = null;
        if (StringUtils.isNotBlank((CharSequence)username) || StringUtils.isNotEmpty((CharSequence)username)) {
            user = this.userManager.getUserProfile(username);
        }
        if (user != null) {
            LOGGER.debug("User exist with username : " + username);
            if (BooleanUtils.toBoolean((Boolean)this.userManager.authenticate(username, pwd))) {
                isAdmin = this.userManager.isAdmin(user.getUserKey()) || this.userManager.isSystemAdmin(user.getUserKey());
            } else {
                this.showErrorMessage(response, "Basic Authentication Failed", "Authentication with the provided credentials failed. It may indicate that the user does not exist or the user's account is inactive or the credentials are incorrect");
                isAdmin = Boolean.FALSE;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
            if (StringUtils.isBlank((CharSequence)action)) {
                this.showErrorMessage(response, "No Parameter Sent", "Request does not contain any parameter");
                return;
            }
            switch (action) {
                case "disable": {
                    this.disableSSO(request, response);
                    break;
                }
                case "enable": {
                    this.enableSSO(request, response);
                    break;
                }
                default: {
                    this.showErrorMessage(response, "Invalid Parameter", "Request contains invalid parameter");
                    break;
                }
            }
        } else {
            this.showErrorMessage(response, "Access Denied", "App Configurations can be accessed only by administrators.");
        }
    }

    private void disableSSO(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.info("Disabling SSO for Crowd");
        this.settings.setEnableSAMLSSO(false);
        this.showSuccessMessage(response, "SSO Disabled Successfully", "SAML App Configured successfully.");
    }

    private void enableSSO(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.info("Enabling SSO for Crowd");
        this.settings.setEnableSAMLSSO(true);
        this.showSuccessMessage(response, "SSO Enabled Successfully", "SAML App Configured successfully.");
    }

    private void showErrorMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "ERROR");
            json.put("Message", message);
            json.put("Description", description);
            response.setStatus(401);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred. ", e);
        }
    }

    private void showSuccessMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "SUCCESS");
            json.put("Message", message);
            json.put("Description", description);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred. ", e);
        }
    }
}

