/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.plugin.PluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoSignOutSettingsAction
extends BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoSignOutSettingsAction.class);
    private final MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private Boolean enableLogoutTemplate;
    private String logoutTemplate;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private Boolean signoutSettingsSubmitted;

    public MoSignOutSettingsAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
    }

    public void validate() {
        LOGGER.info("SignOutSettings Action validate called ");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.signoutSettingsSubmitted)) {
            return;
        }
        if (super.hasActionErrors()) {
            this.initializeSAMLLogoutConfig();
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.info("SignOutSettings Action execute called ");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            LOGGER.debug("Sign out Settings Action doExecute Submitted: " + this.signoutSettingsSubmitted);
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            if (BooleanUtils.toBoolean((Boolean)this.signoutSettingsSubmitted)) {
                this.validate();
                this.moPluginHandler.saveSignoutSettings(this.enableLogoutTemplate, this.logoutTemplate);
                this.addActionMessage(this.getText("SAML signout settings updated."));
            }
            this.initializeSAMLLogoutConfig();
            return "success";
        }
        catch (PluginException e) {
            LOGGER.error("plugin exception occurred while initializing sign out settings details ", (Throwable)e);
            this.addActionError(e.getMessage());
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An error occured while saving sing out settings details", (Throwable)e);
            this.addActionError("An error occured while saving signout setings. Please check logs for more info.");
            return "input";
        }
    }

    private void initializeSAMLLogoutConfig() {
        this.enableLogoutTemplate = this.settings.getEnableLogoutTemplate();
        this.logoutTemplate = this.settings.getLogoutTemplate();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
    }

    public Boolean getEnableLogoutTemplate() {
        return this.enableLogoutTemplate;
    }

    public void setEnableLogoutTemplate(Boolean enableLogoutTemplate) {
        this.enableLogoutTemplate = enableLogoutTemplate;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public String getLogoutTemplate() {
        return this.logoutTemplate;
    }

    public void setLogoutTemplate(String logoutTemplate) {
        this.logoutTemplate = logoutTemplate;
    }

    public Boolean getSignoutSettingsSubmitted() {
        return this.signoutSettingsSubmitted;
    }

    public void setSignoutSettingsSubmitted(Boolean signoutSettingsSubmitted) {
        this.signoutSettingsSubmitted = signoutSettingsSubmitted;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }
}

