/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.plugin.PluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.net.URI;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoContactUsAction
extends BaseAction {
    private static Log LOGGER = LogFactory.getLog(MoContactUsAction.class);
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private Boolean submitSupportQuery;
    private Boolean reregister;
    private Boolean checklicense;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private Boolean enableDebugLogs;

    @Autowired
    public MoContactUsAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
    }

    public void validate() {
        LOGGER.debug("ContactUs Action validate called");
        if (!BooleanUtils.toBoolean((Boolean)this.submitSupportQuery)) {
            return;
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.debug("ContactUs Action execute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            LOGGER.debug("ContactUs Action doExecute Submitted: " + this.submitSupportQuery);
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            this.initializeSAMLConfig();
            if (this.enableDebugLogs.booleanValue()) {
                Logger logger = Logger.getLogger("com.miniorange.sso.saml");
                logger.setLevel(Level.DEBUG);
            }
            return "success";
        }
        catch (PluginException e) {
            LOGGER.error("An plugin exception occurred while verifying account details ", e);
            this.initializeSAMLConfig();
            this.addActionError(e.getMessage());
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while verifying account details ", e);
            this.initializeSAMLConfig();
            this.addActionError("An error occured while saving your details. Please check logs for more info.");
            return "input";
        }
    }

    private void initializeSAMLConfig() {
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.enableDebugLogs = this.settings.getEnableDebugLogs();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getPluginHandler() {
        return this.moPluginHandler;
    }

    public void setPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public Boolean getSubmitSupportQuery() {
        return this.submitSupportQuery;
    }

    public void setSubmitSupportQuery(Boolean submitSupportQuery) {
        this.submitSupportQuery = submitSupportQuery;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getChecklicense() {
        return this.checklicense;
    }

    public void setChecklicense(Boolean checklicense) {
        this.checklicense = checklicense;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public Boolean getEnableDebugLogs() {
        return this.enableDebugLogs;
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.enableDebugLogs = enableDebugLogs;
    }
}

