/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoAddIDPConfigurationAction
extends BaseAction {
    private static Logger LOGGER = LoggerFactory.getLogger(MoAddIDPConfigurationAction.class);
    @ComponentImport
    private I18nHelper i18nHelper;
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private String idpEntityId;
    private String ssoUrl;
    private String ssoBindingType;
    private String sloUrl;
    private String sloBindingType;
    private String x509Certificate;
    private List<String> certificates;
    private String[] allX509certificates;
    private Boolean signedRequest;
    private String metadataUrl;
    private Boolean submitted;
    private Boolean reregister;
    private Boolean checklicense;
    private Boolean addIdpSubmitted;
    private Boolean metadataImported;
    private Boolean fileSubmitted;
    private Boolean urlSubmitted;
    private String inputUrl;
    private String acsUrl;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private String idpID;
    private String idpName;
    private List<String> idpList;
    private Boolean shouldContainsAddIdp;
    private Boolean shouldShowBackButton;
    private List<String> nameIdFormats;
    private String nameIdFormat;
    private Boolean refreshMetadata;
    private String refreshInterval;
    private Integer customRefreshInterval;
    private String customRefreshIntervalUnit;

    @Autowired
    public MoAddIDPConfigurationAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler, I18nHelper i18nHelper) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.i18nHelper = i18nHelper;
    }

    public Boolean doValidate() {
        LOGGER.info("Add IDP Action: validate() called");
        Boolean error = false;
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (BooleanUtils.toBoolean((Boolean)this.addIdpSubmitted)) {
            LOGGER.info("Validating IdP Configuration");
            if (StringUtils.isBlank((CharSequence)this.idpName)) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.config.idpname.empty"));
                error = true;
            }
            if (BooleanUtils.toBoolean((Boolean)this.refreshMetadata)) {
                LOGGER.info("Validating IDP input URL");
                try {
                    LOGGER.debug("validating inputurl " + this.inputUrl);
                    new URL(this.inputUrl);
                    LOGGER.debug("success validating inputurl " + this.inputUrl);
                }
                catch (MalformedURLException e) {
                    this.addActionError(this.i18nHelper.getText("samlsso.error.sso.metadataUrl.invalid"));
                    error = true;
                }
            }
            if (StringUtils.isBlank((CharSequence)this.ssoUrl)) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.config.ssourl.empty"));
                error = true;
            } else {
                try {
                    new URL(this.ssoUrl);
                }
                catch (MalformedURLException e) {
                    LOGGER.error(e.getMessage());
                    this.addActionError(this.i18nHelper.getText("samlsso.error.config.ssourl.malformed"));
                    error = true;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.sloUrl)) {
                try {
                    new URL(this.sloUrl);
                }
                catch (MalformedURLException e) {
                    LOGGER.error(e.getMessage());
                    this.addActionError(this.i18nHelper.getText("samlsso.error.config.slourl.malformed"));
                    error = true;
                }
            }
            if (StringUtils.isBlank((CharSequence)this.idpEntityId)) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.config.idpentityid.empty"));
                error = true;
            }
            if (this.allX509certificates != null) {
                this.certificates = new ArrayList<String>(Arrays.asList(this.allX509certificates));
                this.certificates.removeAll(Arrays.asList(""));
                this.allX509certificates = this.certificates.toArray(new String[0]);
            }
            if (this.allX509certificates != null && this.allX509certificates.length > 0) {
                if (this.allX509certificates.length == 1) {
                    if (StringUtils.isBlank((CharSequence)this.allX509certificates[0])) {
                        this.addActionError(this.i18nHelper.getText("samlsso.error.config.certificate.empty"));
                        error = true;
                    } else if (!MoSAMLUtils.isValidCertificate(this.allX509certificates[0]).booleanValue()) {
                        this.addActionError(this.i18nHelper.getText("samlsso.error.config.certificate.invalid"));
                        error = true;
                    }
                } else {
                    for (String certificate : this.allX509certificates) {
                        if (MoSAMLUtils.isValidCertificate(certificate).booleanValue() || StringUtils.isBlank((CharSequence)certificate)) continue;
                        this.addActionError(this.i18nHelper.getText(this.i18nHelper.getText("samlsso.error.config.certificate.invalid")) + " " + (Arrays.asList(this.allX509certificates).indexOf(certificate) + 1));
                        error = true;
                    }
                }
            } else if (StringUtils.isBlank((CharSequence)this.x509Certificate)) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.config.certificate.empty"));
                error = true;
            } else if (!MoSAMLUtils.isValidCertificate(this.x509Certificate).booleanValue()) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.config.certificate.invalid"));
                error = true;
            }
            if (!StringUtils.equals((CharSequence)this.ssoBindingType, (CharSequence)"HttpRedirect") && !StringUtils.equals((CharSequence)this.ssoBindingType, (CharSequence)"HttpPost")) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.config.ssobinding.invalid"));
                error = true;
            }
            if (!StringUtils.equals((CharSequence)this.sloBindingType, (CharSequence)"HttpRedirect") && !StringUtils.equals((CharSequence)this.sloBindingType, (CharSequence)"HttpPost")) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.config.slobinding.invalid"));
                error = true;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)error)) {
            this.initializeSAMLConfig();
        }
        return error;
    }

    public String execute() throws Exception {
        LOGGER.info(" Add IDP Configuration Action doExecute called ");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.shouldShowBackButton = false;
        try {
            LOGGER.info("Add IdP Action execute called");
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            this.idpList = this.getIdpList();
            if (StringUtils.isBlank((CharSequence)this.idpID)) {
                if (StringUtils.isNotBlank((CharSequence)request.getParameter("idpid"))) {
                    this.idpID = request.getParameter("idpid");
                } else {
                    this.idpID = UUID.randomUUID().toString();
                    if (StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                        LOGGER.debug("Storing old IDP config values and initializing idp: " + this.idpID);
                        this.idpName = "IDP";
                        this.moPluginHandler.replaceOldSettingsWithNew(this.idpID, this.idpName);
                    }
                }
            }
            if (BooleanUtils.toBoolean((Boolean)this.addIdpSubmitted)) {
                Boolean error;
                LOGGER.info("IdP configuration submitted");
                ArrayList<Object> x509CertificateList = new ArrayList<String>();
                if (this.x509Certificate != null) {
                    x509CertificateList.add(StringUtils.trim((String)this.x509Certificate));
                }
                if (this.allX509certificates != null) {
                    x509CertificateList = new ArrayList<String>(Arrays.asList(this.allX509certificates));
                    x509CertificateList.removeAll(Arrays.asList(null, ""));
                    if (StringUtils.isBlank((CharSequence)this.x509Certificate)) {
                        this.x509Certificate = (String)x509CertificateList.get(0);
                    }
                }
                if (!(error = this.doValidate()).booleanValue()) {
                    MoPluginHandler.saveIdPConfiguration(this.idpID, this.idpName, this.idpEntityId, this.ssoBindingType, this.ssoUrl, this.sloBindingType, this.sloUrl, x509CertificateList, StringUtils.trim((String)this.x509Certificate), this.signedRequest, this.nameIdFormat, this.inputUrl, this.refreshMetadata, this.refreshInterval, this.customRefreshInterval, this.customRefreshIntervalUnit);
                    this.addActionMessage(this.getText("SAML settings updated."));
                    if (this.settings.getIdPList().size() > 1) {
                        response.sendRedirect(this.settings.getSpBaseUrl() + "/console/secure/plugins/crowd-sso-listidpconfig/listidp.action?operation=add&status=success");
                    }
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"add", (CharSequence)request.getParameter("operation")) || this.idpList.size() > 1) {
                this.shouldShowBackButton = Boolean.TRUE;
            }
            if (MoSAMLSettings.isMetadataFileUploaded.booleanValue()) {
                MoSAMLSettings.isMetadataFileUploaded = Boolean.FALSE;
                if (StringUtils.isNotBlank((CharSequence)this.settings.getMetadataUploadStatus())) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getMetadataUploadStatus(), (CharSequence)"Success.")) {
                        LOGGER.debug("Metadata Uploaded Succesfully");
                        if (this.settings.getIdPList().size() > 1) {
                            response.sendRedirect(this.settings.getSpBaseUrl() + "/console/secure/plugins/crowd-sso-listidpconfig/listidp.action?operation=add&status=success");
                        }
                        this.addActionMessage(this.getText("SAML settings updated"));
                    } else {
                        this.addActionError(this.settings.getMetadataUploadStatus());
                    }
                }
            }
            this.initializeSAMLConfig();
            return "success";
        }
        catch (MoPluginException e) {
            LOGGER.error("mo Plugin exeption occurs.", (Throwable)e);
            this.addActionError(e);
            this.initializeSAMLConfig();
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An exeption occurs while saving the configuration", (Throwable)e);
            this.initializeSAMLConfig();
            this.addActionError("An error occurred while saving your details. Please check logs for more info.");
            return "input";
        }
    }

    private void initializeSAMLConfig() {
        LOGGER.debug("initializeSAMLConfig for IDP ID : " + this.idpID);
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        if (idpConfig == null) {
            this.initializeNewForm();
            return;
        }
        this.acsUrl = this.settings.getLoginServletUrl() + "?idp=" + this.idpID;
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.idpName = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getIdpName(), (CharSequence)"");
        this.idpEntityId = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getIdpEntityId(), (CharSequence)"");
        this.ssoUrl = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getSsoUrl(), (CharSequence)"");
        this.sloUrl = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getSloUrl(), (CharSequence)"");
        this.ssoBindingType = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"");
        this.sloBindingType = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"");
        this.x509Certificate = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getX509Certificate(), (CharSequence)"");
        this.certificates = idpConfig.getCertificates();
        this.signedRequest = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getSignedRequest(), (boolean)true);
        this.inputUrl = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getMetadataUrl(), (CharSequence)"");
        this.shouldContainsAddIdp = true;
        this.nameIdFormats = this.getNameIdFormats();
        this.nameIdFormat = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getNameIdFormat(), (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        this.refreshMetadata = BooleanUtils.toBooleanDefaultIfNull((Boolean)idpConfig.getRefreshMetadata(), (boolean)false);
        this.refreshInterval = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getRefreshInterval(), (CharSequence)"hourly");
        this.customRefreshInterval = idpConfig.getCustomRefreshInterval() != null ? idpConfig.getCustomRefreshInterval() : 60;
        this.customRefreshIntervalUnit = (String)StringUtils.defaultIfBlank((CharSequence)idpConfig.getCustomRefreshIntervalUnit(), (CharSequence)"minutes");
    }

    private void initializeNewForm() {
        this.acsUrl = this.settings.getLoginServletUrl() + "?idp=" + this.idpID;
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.idpName = "";
        this.idpEntityId = "";
        this.ssoUrl = "";
        this.sloUrl = "";
        this.ssoBindingType = "HttpRedirect";
        this.sloBindingType = "HttpRedirect";
        this.x509Certificate = "";
        this.signedRequest = Boolean.TRUE;
        this.inputUrl = "";
        this.shouldContainsAddIdp = false;
        this.nameIdFormats = this.getNameIdFormats();
        this.nameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        this.refreshMetadata = Boolean.FALSE;
        this.refreshInterval = "hourly";
        this.customRefreshInterval = 60;
        this.customRefreshIntervalUnit = "minutes";
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getPluginHandler() {
        return this.moPluginHandler;
    }

    public void setPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    public void setIdpEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }

    public String getSsoBindingType() {
        return this.ssoBindingType;
    }

    public void setSsoBindingType(String ssoBindingType) {
        this.ssoBindingType = ssoBindingType;
    }

    public String getSloUrl() {
        return this.sloUrl;
    }

    public void setSloUrl(String sloUrl) {
        this.sloUrl = sloUrl;
    }

    public String getSloBindingType() {
        return this.sloBindingType;
    }

    public void setSloBindingType(String sloBindingType) {
        this.sloBindingType = sloBindingType;
    }

    public String getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(String x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public List<String> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<String> certificates) {
        this.certificates = certificates;
    }

    public String[] getAllX509certificates() {
        return this.allX509certificates;
    }

    public void setAllX509certificates(String[] allX509certificates) {
        this.allX509certificates = allX509certificates;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getSignedRequest() {
        return this.signedRequest;
    }

    public void setSignedRequest(Boolean signedRequest) {
        this.signedRequest = signedRequest;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getChecklicense() {
        return this.checklicense;
    }

    public void setChecklicense(Boolean checklicense) {
        this.checklicense = checklicense;
    }

    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    public void setMetadataUrl(String metadataUrl) {
        this.metadataUrl = metadataUrl;
    }

    public Boolean getMetadataImported() {
        return this.metadataImported;
    }

    public void setMetadataImported(Boolean metadataImported) {
        this.metadataImported = metadataImported;
    }

    public Boolean getFileSubmitted() {
        return this.fileSubmitted;
    }

    public void setFileSubmitted(Boolean fileSubmitted) {
        this.fileSubmitted = fileSubmitted;
    }

    public Boolean getUrlSubmitted() {
        return this.urlSubmitted;
    }

    public void setUrlSubmitted(Boolean urlSubmitted) {
        this.urlSubmitted = urlSubmitted;
    }

    public Boolean getAddIdpSubmitted() {
        return this.addIdpSubmitted;
    }

    public void setAddIdpSubmitted(Boolean addIdpSubmitted) {
        this.addIdpSubmitted = addIdpSubmitted;
    }

    public String getAcsUrl() {
        return this.acsUrl;
    }

    public void setAcsUrl(String acsUrl) {
        this.acsUrl = acsUrl;
    }

    public String getInputUrl() {
        return this.inputUrl;
    }

    public void setInputUrl(String inputUrl) {
        this.inputUrl = inputUrl;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public String getIdpID() {
        return this.idpID;
    }

    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public List<String> getIdpList() {
        ArrayList<String> idpList = this.settings.getIdPList();
        this.idpList = idpList;
        return this.idpList;
    }

    public void setIdpList(List<String> idpList) {
        this.idpList = idpList;
    }

    public Boolean getRefreshMetadata() {
        return this.refreshMetadata;
    }

    public void setRefreshMetadata(Boolean refreshMetadata) {
        this.refreshMetadata = refreshMetadata;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public Integer getCustomRefreshInterval() {
        return this.customRefreshInterval;
    }

    public void setCustomRefreshInterval(Integer customRefreshInterval) {
        this.customRefreshInterval = customRefreshInterval;
    }

    public String getCustomRefreshIntervalUnit() {
        return this.customRefreshIntervalUnit;
    }

    public void setCustomRefreshIntervalUnit(String customRefreshIntervalUnit) {
        this.customRefreshIntervalUnit = customRefreshIntervalUnit;
    }

    public Boolean getShouldContainsAddIdp() {
        return this.shouldContainsAddIdp;
    }

    public void setShouldContainsAddIdp(Boolean shouldContainsAddIdp) {
        this.shouldContainsAddIdp = shouldContainsAddIdp;
    }

    public Boolean getShouldShowBackButton() {
        return this.shouldShowBackButton;
    }

    public void setShouldShowBackButton(Boolean shouldShowBackButton) {
        this.shouldShowBackButton = shouldShowBackButton;
    }

    public List<String> getNameIdFormats() {
        ArrayList<String> nameIDFormats = new ArrayList<String>();
        nameIDFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        nameIDFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        nameIDFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        nameIDFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        return nameIDFormats;
    }

    public void setNameIdFormats(List<String> nameIdFormats) {
        this.nameIdFormats = nameIdFormats;
    }

    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }
}

