/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.Applications;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.service.UserService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.MoSAMLResponse;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Named
public class MoCrowdUserManager {
    private static Log LOGGER = LogFactory.getLog(MoCrowdUserManager.class);
    private MoSAMLSettings settings;
    @ComponentImport
    private ApplicationManager applicationManager;
    @ComponentImport
    private UserService userService;
    @ComponentImport
    private CrowdService crowdService;
    @ComponentImport
    private DirectoryManager directoryManager;

    @Autowired
    public MoCrowdUserManager(MoSAMLSettings settings, UserService userService, CrowdService crowdService, DirectoryManager directoryManager, ApplicationManager applicationManager) {
        this.settings = settings;
        this.userService = userService;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        this.applicationManager = applicationManager;
    }

    public UserTemplate updateUser(User ssouser, String email, MoSAMLResponse samlResponse, MoIDPConfig idpConfig) {
        try {
            ArrayList<String> groups;
            LOGGER.debug("Executing user update process");
            String username = ssouser.getName();
            String[] roleValues = samlResponse.getAttributes().get(idpConfig.getRoleAttribute());
            HashMap<String, String> roleMapping = idpConfig.getRoleMapping();
            ArrayList<String> groupsToAssign = this.getListOfMappedGroupsToAssign(roleValues, ssouser.getName(), idpConfig);
            UserTemplate userTemplate = new UserTemplate(ssouser);
            long directoryId = userTemplate.getDirectoryId();
            Object groupName = null;
            Directory directoryObjects = this.directoryManager.findDirectoryById(directoryId);
            if (!idpConfig.getKeepExistingUserAttributes().booleanValue()) {
                LOGGER.debug("Updating profile of the user : " + ssouser.toString());
                String fullName = "";
                String firstName = "";
                String lastName = "";
                if (samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute()).length == 1) {
                    firstName = samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute())[0];
                }
                if (samlResponse.getAttributes().get(idpConfig.getLastNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getLastNameAttribute()).length == 1) {
                    lastName = samlResponse.getAttributes().get(idpConfig.getLastNameAttribute())[0];
                }
                fullName = samlResponse.getAttributes().get(idpConfig.getFullNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getFullNameAttribute()).length == 1 ? samlResponse.getAttributes().get(idpConfig.getFullNameAttribute())[0] : firstName + " " + lastName;
                LOGGER.debug("username : " + username + " email : " + email + "First Name : " + firstName + "Last Name : " + lastName + " Full Name : " + fullName);
                userTemplate.setFirstName(firstName);
                userTemplate.setLastName(lastName);
                userTemplate.setDisplayName(fullName);
                this.directoryManager.updateUser(directoryId, userTemplate);
                Map<String, Set<String>> custumAttributes = this.getCustomAttributes(samlResponse, idpConfig);
                if (custumAttributes != null) {
                    LOGGER.debug("Updating additinal user information :  " + custumAttributes.toString());
                    this.directoryManager.storeUserAttributes(directoryId, username, custumAttributes);
                }
            }
            if (idpConfig.getOnTheFlyGroupCreation().booleanValue()) {
                if (idpConfig.getKeepExistingUserRoles().booleanValue()) {
                    return userTemplate;
                }
                groups = this.getAllGroupsOfUser(username);
                this.onTheFlyGroupAssignment(roleValues, username, idpConfig, directoryId, groups);
            } else if (!idpConfig.getKeepExistingUserRoles().booleanValue() && StringUtils.isNotEmpty((CharSequence)idpConfig.getRoleAttribute()) && !roleMapping.isEmpty()) {
                if (this.userService.isAdmin(username)) {
                    LOGGER.debug("Member of administrator group");
                } else {
                    LOGGER.debug("Not a Member of administrator group");
                    groups = this.getAllGroupsOfUser(username);
                    for (String group : groups) {
                        try {
                            if (!this.userService.isUserInGroup(username, group) || !StringUtils.isNotEmpty((CharSequence)roleMapping.get(group)) || groupsToAssign.contains(group)) continue;
                            this.directoryManager.removeUserFromGroup(directoryId, username, group);
                        }
                        catch (Exception e) {}
                    }
                    if (!groupsToAssign.isEmpty()) {
                        for (String newGroups : groupsToAssign) {
                            if (this.userService.isUserInGroup(username, newGroups) || !this.isDirectoryGroup(newGroups, directoryId).booleanValue()) continue;
                            LOGGER.debug("Assigning group : " + newGroups + "to user :" + username);
                            this.directoryManager.addUserToGroup(directoryId, username, newGroups);
                        }
                    }
                }
            } else {
                LOGGER.debug("KeepExistingUserRoles checked.");
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"allUsers")) {
                try {
                    ArrayList<String> defaultgroupsToAssign = new ArrayList<String>(idpConfig.getDefaultGroups());
                    for (String group : defaultgroupsToAssign) {
                        if (!this.isDirectoryGroup(group, directoryObjects.getId()).booleanValue()) continue;
                        LOGGER.debug("Assigning default group:  " + group + " to user : " + username);
                        try {
                            this.directoryManager.addUserToGroup(directoryObjects.getId().longValue(), username, group);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error occurred. User already exist in group/user not found", e);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while adding user to group", e);
                }
            }
            return userTemplate;
        }
        catch (MoSAMLException e) {
            LOGGER.error(e.getMessage() + e);
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while updating the user infromation." + e);
            throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void reactivateUser(User crowdUser) {
        try {
            LOGGER.debug("reactivateUser : " + crowdUser.getName());
            UserTemplate user = new UserTemplate(this.crowdService.getUser(crowdUser.getName()));
            long directoryId = user.getDirectoryId();
            user.setActive(true);
            this.directoryManager.updateUser(directoryId, user);
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while updating the user infromation." + e);
            throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public ArrayList<String> getAllGroups() {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(Integer.MAX_VALUE);
        LOGGER.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        LOGGER.debug("groups =  " + groups);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public ArrayList<String> getAllGroupsOfUser(String username) {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(Integer.MAX_VALUE);
        LOGGER.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public Boolean isDirectoryGroup(String groupName, Long directoryId) {
        try {
            this.directoryManager.findGroupByName(directoryId.longValue(), groupName);
            return Boolean.TRUE;
        }
        catch (Exception groupNotFound) {
            LOGGER.error("Group: " + groupName + " is not a member of directory : " + directoryId);
            return Boolean.FALSE;
        }
    }

    public UserTemplate createNewUser(String userName, String email, MoSAMLResponse samlResponse, MoIDPConfig idpConfig) {
        try {
            LOGGER.info("Creating new user.");
            String fullName = "";
            String firstName = "";
            String lastName = "";
            if (samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute()).length == 1) {
                firstName = samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute())[0];
            }
            if (samlResponse.getAttributes().get(idpConfig.getLastNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getLastNameAttribute()).length == 1) {
                lastName = samlResponse.getAttributes().get(idpConfig.getLastNameAttribute())[0];
            }
            fullName = samlResponse.getAttributes().get(idpConfig.getFullNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getFullNameAttribute()).length == 1 ? samlResponse.getAttributes().get(idpConfig.getFullNameAttribute())[0] : firstName + " " + lastName;
            String[] roleValues = samlResponse.getAttributes().get(idpConfig.getRoleAttribute());
            Object newUser = null;
            Directory directoryObjects = this.getApplicationDirectory(idpConfig, samlResponse.getRelayStateURL());
            UserTemplate user = new UserTemplate(userName, directoryObjects.getId().longValue());
            user.setActive(true);
            user.setEmailAddress(email);
            user.setDirectoryId(directoryObjects.getId().longValue());
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setDisplayName(fullName);
            user.setName(userName);
            PasswordCredential passwordCredential = new PasswordCredential(this.getRandomPassword(), true);
            Object groupName = null;
            ArrayList<String> defaultGroupsToAssign = new ArrayList<String>();
            if (StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"newUsers") || StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"allUsers")) {
                defaultGroupsToAssign.addAll(idpConfig.getDefaultGroups());
            }
            if (idpConfig.getOnTheFlyGroupCreation().booleanValue()) {
                this.directoryManager.addUser(directoryObjects.getId().longValue(), user, passwordCredential);
                Map<String, Set<String>> custumAttributes = this.getCustomAttributes(samlResponse, idpConfig);
                this.directoryManager.storeUserAttributes(directoryObjects.getId().longValue(), userName, custumAttributes);
                ArrayList<String> existingUserGroups = this.getAllGroupsOfUser(userName);
                for (String group : defaultGroupsToAssign) {
                    if (!this.isDirectoryGroup(group, directoryObjects.getId()).booleanValue()) continue;
                    LOGGER.debug("Assigning default group:  " + group + " to user : " + userName);
                    try {
                        this.directoryManager.addUserToGroup(directoryObjects.getId().longValue(), userName, group);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while assigning group to user.");
                    }
                }
                this.onTheFlyGroupAssignment(roleValues, userName, idpConfig, directoryObjects.getId(), existingUserGroups);
            } else {
                ArrayList<String> groupsToAssign = this.getListOfMappedGroupsToAssign(roleValues, userName, idpConfig);
                if (idpConfig.getCreateUsersIfRoleMapped().booleanValue() && groupsToAssign.size() > 0 || !idpConfig.getCreateUsersIfRoleMapped().booleanValue()) {
                    this.directoryManager.addUser(directoryObjects.getId().longValue(), user, passwordCredential);
                    Map<String, Set<String>> custumAttributes = this.getCustomAttributes(samlResponse, idpConfig);
                    this.directoryManager.storeUserAttributes(directoryObjects.getId().longValue(), userName, custumAttributes);
                    LOGGER.debug("Roles found. Creating user with Username: " + userName + ", Email: " + email + ", Name:" + fullName);
                    try {
                        for (String group : defaultGroupsToAssign) {
                            if (!this.isDirectoryGroup(group, directoryObjects.getId()).booleanValue()) continue;
                            LOGGER.debug("Assigning default group:  " + group + " to user : " + userName);
                            try {
                                this.directoryManager.addUserToGroup(directoryObjects.getId().longValue(), userName, group);
                            }
                            catch (Exception e) {
                                LOGGER.debug("Exception while assigning group to user.");
                            }
                        }
                        LOGGER.debug("Mapped Group(s) is assigning to the created user ");
                        for (String group : groupsToAssign) {
                            if (!this.isDirectoryGroup(group, directoryObjects.getId()).booleanValue()) continue;
                            LOGGER.debug("Assigning mapped group :" + group + "to user = " + userName);
                            try {
                                this.directoryManager.addUserToGroup(directoryObjects.getId().longValue(), userName, group);
                            }
                            catch (Exception e) {
                                LOGGER.debug("Exception while assigning group to user.");
                            }
                        }
                        return user;
                    }
                    catch (Exception e) {
                        LOGGER.error("An exception occurs while creating new users", e);
                        return user;
                    }
                }
            }
            return user;
        }
        catch (MoSAMLException e) {
            LOGGER.error(e.getMessage() + e);
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while creating new user." + e);
            throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onTheFlyGroupAssignment(String[] roleValues, String username, MoIDPConfig idpConfig, long directoryId, ArrayList<String> existingUserGroups) {
        ArrayList<String> doNotRemoveFromGroups = new ArrayList<String>(idpConfig.getOnTheFlyDoNotRemoveGroups());
        if (!idpConfig.getOnTheFlyAssignNewGroupsOnly().booleanValue()) {
            try {
                for (String group : existingUserGroups) {
                    if (doNotRemoveFromGroups.contains(group) || StringUtils.equals((CharSequence)group, (CharSequence)"crowd-administrators")) continue;
                    this.directoryManager.removeUserFromGroup(directoryId, username, group);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Cannot remove groups:" + e);
            }
        }
        LOGGER.debug("role values is=" + roleValues);
        List<Object> onTheFlyGroupList = new ArrayList();
        if (!StringUtils.equals((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"None")) {
            onTheFlyGroupList = this.onTheFlyFilterIDPGroups(Arrays.asList(roleValues), idpConfig);
            LOGGER.debug("IDP group list after applying filter :" + onTheFlyGroupList.toString());
        } else {
            onTheFlyGroupList = Arrays.asList(roleValues);
            LOGGER.debug(" group list on the fly=" + onTheFlyGroupList);
        }
        if (idpConfig.getGroupRegexPatternEnabled().booleanValue()) {
            void var11_12;
            LOGGER.debug("Applying regex on incoming groups");
            String regexp = idpConfig.getRegexPatternForGroup();
            String regexg = StringEscapeUtils.escapeJavaScript(idpConfig.getRegexGroups());
            LOGGER.debug("Applying regex on idp groups " + regexg + " " + regexp);
            LOGGER.debug("ont the fly group list=" + onTheFlyGroupList.size());
            boolean bl = false;
            while (var11_12 < onTheFlyGroupList.size()) {
                onTheFlyGroupList.set((int)var11_12, MoCrowdUserManager.getGroupNameFromRegexMethod(regexp, regexg, (String)onTheFlyGroupList.get((int)var11_12)));
                ++var11_12;
            }
            LOGGER.debug("Group list value after applying OTF regex : " + onTheFlyGroupList);
        }
        if (idpConfig.getCreateNewGroups().booleanValue()) {
            ArrayList<GroupTemplate> newGroups = new ArrayList<GroupTemplate>();
            List<Object> newGroupsToAdd = onTheFlyGroupList;
            for (String string : newGroupsToAdd) {
                newGroups.add(new GroupTemplate(string, directoryId));
            }
            try {
                this.directoryManager.addAllGroups(directoryId, newGroups, false);
                LOGGER.debug("New Groups created:" + newGroups);
                for (String string : newGroupsToAdd) {
                    if (this.directoryManager.isUserDirectGroupMember(directoryId, username, string)) continue;
                    this.directoryManager.addUserToGroup(directoryId, username, string);
                }
            }
            catch (Exception exception) {
                LOGGER.debug("New Groups not created:" + exception);
            }
        } else {
            List<Object> groups = onTheFlyGroupList;
            for (String string : groups) {
                try {
                    if (this.directoryManager.isUserDirectGroupMember(directoryId, username, string)) continue;
                    this.directoryManager.addUserToGroup(directoryId, username, string);
                }
                catch (Exception exception) {
                    LOGGER.debug("Group not found exception:" + exception);
                }
            }
        }
    }

    private List<String> onTheFlyFilterIDPGroups(List<String> idpGroups, MoIDPConfig idpConfig) {
        ArrayList<String> filteredGroups;
        block6: {
            block7: {
                block5: {
                    LOGGER.debug("idp groups under onTheFlyFilterIDPGroups option : " + idpGroups);
                    filteredGroups = new ArrayList<String>();
                    LOGGER.debug("Filtering IDP groups using filter type :" + idpConfig.getOnTheFlyFilterIDPGroupsOption() + ", and filter key :" + idpConfig.getOnTheFlyFilterIDPGroupsKey());
                    if (!StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Starts with")) break block5;
                    LOGGER.debug("Starts with");
                    for (String group : idpGroups) {
                        if (!StringUtils.startsWith((CharSequence)group.replace("\"", "").trim(), (CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsKey())) continue;
                        filteredGroups.add(group.replace("\"", ""));
                    }
                    break block6;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Contains")) break block7;
                LOGGER.debug("Contains");
                for (String group : idpGroups) {
                    if (!StringUtils.contains((CharSequence)group.replace("\"", ""), (CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsKey())) continue;
                    filteredGroups.add(group.replace("\"", ""));
                }
                break block6;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Regex")) break block6;
            LOGGER.debug("Regex");
            Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)idpConfig.getOnTheFlyFilterIDPGroupsKey()));
            for (String groupName : idpGroups) {
                Matcher matcher = pattern.matcher(groupName.replace("\"", ""));
                try {
                    if (!matcher.find()) continue;
                    filteredGroups.add(groupName.replace("\"", ""));
                }
                catch (Exception e) {
                    LOGGER.error("error occurred...", e);
                }
            }
        }
        return filteredGroups;
    }

    public ArrayList<String> getListOfMappedGroupsToAssign(String[] roleValues, String username, MoIDPConfig idpConfig) {
        try {
            ArrayList<String> groupsToAssign = new ArrayList<String>();
            if (roleValues != null && roleValues.length > 0) {
                HashMap<String, String> roleMapping = idpConfig.getRoleMapping();
                for (String key : roleMapping.keySet()) {
                    String value = roleMapping.get(key);
                    String[] groupNamesConfigured = StringUtils.split((String)value, (String)";");
                    for (int i = 0; i < groupNamesConfigured.length; ++i) {
                        String groupValue = groupNamesConfigured[i];
                        if (!Arrays.asList(roleValues).contains(groupValue)) continue;
                        try {
                            groupsToAssign.add(key);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            return groupsToAssign;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting mapped groups ", e);
            return null;
        }
    }

    public String getRandomPassword() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    public Map<String, Set<String>> getCustomAttributes(MoSAMLResponse samlResponse, MoIDPConfig idpConfig) {
        Map<String, String> customAttributeMapping = idpConfig.getCustomAttributeMapping();
        HashMap<String, Set<String>> custumAttributes = new HashMap<String, Set<String>>();
        String userProperty = "";
        for (String userAttributes : customAttributeMapping.keySet()) {
            HashSet<String> custumAttrValues = new HashSet<String>();
            try {
                userProperty = samlResponse.getAttributes().get(customAttributeMapping.get(userAttributes))[0];
            }
            catch (Exception e) {
                userProperty = "";
            }
            if (!StringUtils.isNotEmpty((CharSequence)userProperty)) continue;
            custumAttrValues.add(userProperty);
            custumAttributes.put(userAttributes, custumAttrValues);
        }
        return custumAttributes;
    }

    public static String getGroupNameFromRegexMethod(String regexPatternForGroup, String regexGroups, String groupName) {
        LOGGER.debug("regex pattern for group=" + regexPatternForGroup + " regex groups" + regexGroups + " group name=" + groupName);
        Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)regexPatternForGroup));
        LOGGER.debug("pattern is =" + pattern);
        Matcher matcher = pattern.matcher(groupName);
        if (matcher.find()) {
            groupName = matcher.groupCount() > 0 ? MoCrowdUserManager.formStringAccordingToGroupname(matcher, StringUtils.trimToEmpty((String)regexGroups)) : matcher.group();
        }
        return groupName;
    }

    public static String formStringAccordingToGroupname(Matcher matcher, String replaceWith) {
        LOGGER.info("forming String According To Groupname and replaceWith");
        StringBuffer groupname = new StringBuffer("");
        try {
            String[] groupPositions;
            for (String position : groupPositions = StringUtils.split((String)replaceWith, (char)'$')) {
                LOGGER.info("position " + position);
                groupname.append(matcher.group(Integer.parseInt(position.trim())));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while applying regex on groupname. Kindly check Regex configuration.", e);
        }
        return groupname.toString();
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public Directory getApplicationDirectory(MoIDPConfig idpConfig, String relayState) throws DirectoryNotFoundException {
        List appList = this.applicationManager.findAll();
        for (Application app : appList) {
            String applicationUrl = (String)app.getAttributes().get("applicationURL");
            if (applicationUrl == null || !relayState.contains(applicationUrl) && !applicationUrl.contains(relayState) && !app.getRemoteAddresses().toString().contains(relayState)) continue;
            List dirList = Applications.getActiveDirectories((Application)app);
            for (Directory dir : dirList) {
                if (!dir.getAllowedOperations().contains(OperationType.CREATE_USER)) continue;
                return dir;
            }
        }
        return this.directoryManager.findDirectoryByName(idpConfig.getDefaultDirectory());
    }
}

