/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.miniorange.sso.saml.Customer;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.crowd.MoPluginConfigurationsHandler;
import com.miniorange.sso.saml.crowd.MoPluginConstants;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.crowd.scheduler.MoMetadataRefreshService;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.dto.MoIDPMetadata;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.inject.Named;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
@Scanned
public class MoPluginHandler {
    private static Log LOGGER = LogFactory.getLog(MoPluginHandler.class);
    private static MoSAMLSettings settings;
    private static MoMetadataRefreshService metadataRefreshService;

    @Autowired
    public MoPluginHandler(MoSAMLSettings settings, MoMetadataRefreshService metadataRefreshService) {
        MoPluginHandler.metadataRefreshService = metadataRefreshService;
        MoPluginHandler.settings = settings;
    }

    public void saveSPCertificates(Boolean signing, Boolean encryption) {
        LOGGER.debug("saveSPCertificates Saving SP Info, Signing: " + signing + ", Encryption: " + encryption);
        settings.setSigning(signing);
        settings.setEncryption(encryption);
    }

    public void saveSPConfiguration(String spBaseUrl, String spEntityId) {
        LOGGER.debug("saveSPConfiguration Saving SP Info, SPBaseUrl: " + spBaseUrl + ", SPEntityID: " + spEntityId);
        settings.setSpBaseUrl(spBaseUrl);
        settings.setSpEntityId(spEntityId);
    }

    public static void saveAttributeMapping(String idpID, String usernameAttr, String emailAttr, String fullNameAttr, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String loginUserAttribute, Boolean regexPatternEnabled, String regexPattern, HashMap<String, String> customAttributeMapping) {
        LOGGER.info("Saving Attribute Mapping Configuration");
        LOGGER.debug("saveAttributeMapping Saving Attribute Mapping: UsernameAttr: " + usernameAttr + ", EmailAttr: " + emailAttr + ", NameAttr: " + fullNameAttr + ", useSeparateName: , firstName: " + firstNameAttribute + ", lastName: " + lastNameAttribute + "keepExistingUserAttributes " + keepExistingUserAttributes + " loginUserAttribute : " + loginUserAttribute + " regexPatternEnabled : " + regexPatternEnabled + " regexPattern : " + regexPattern + " Custom attributes : " + customAttributeMapping);
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            settings.setUsernameAttribute(usernameAttr);
            settings.setEmailAttribute(emailAttr);
            settings.setFirstNameAttribute(firstNameAttribute);
            settings.setLastNameAttribute(lastNameAttribute);
            settings.setFullNameAttribute(fullNameAttr);
            settings.setKeepExistingUserAttributes(keepExistingUserAttributes);
            settings.setLoginUserAttribute(loginUserAttribute);
            settings.setRegexPatternEnabled(regexPatternEnabled);
            settings.setRegexPattern(regexPattern);
            settings.setCustomAttributeMapping(customAttributeMapping);
        } else {
            JSONObject attributeConfig = MoPluginHandler.constructAttributeConfig(usernameAttr, emailAttr, fullNameAttr, firstNameAttribute, lastNameAttribute, keepExistingUserAttributes, loginUserAttribute, regexPatternEnabled, regexPattern, customAttributeMapping);
            settings.setAttributeMappingConfig(attributeConfig, idpID);
        }
    }

    public static void saveImportMetadata(String idpID, String inputUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        LOGGER.info("Saving Configuration for Import Metadata");
        LOGGER.debug("inputUrl/metadata = " + inputUrl + " refreshMetadata = " + refreshMetadata + "refreshInterval = " + refreshInterval + " customRefreshInterval = " + customRefreshInterval + " customRefreshIntervalUnit = " + customRefreshIntervalUnit);
        JSONObject importMetadataObj = MoPluginHandler.constructImportMetadataObj(inputUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
        settings.setImportMetadataConfig(importMetadataObj, idpID);
    }

    public void saveSigninSettings(String timeDelay, Boolean disableDefaultLogin, Boolean enableBackdoor, String loginButtonText, String relayState, String loginTemplate, Boolean autoActivateUser, Boolean enableSAMLSSO, Boolean restrictBackdoor, List<String> backdoorGroupsList, Boolean enableErrorMsgTemplate, String errorMsgTemplate) {
        LOGGER.debug("saveAttributeMapping Saving Attribute Mapping: disableDefaultLogin: " + disableDefaultLogin + ", enableBackdoor: " + enableBackdoor + ", LoginButtonText: " + loginButtonText + "autoActivateUser: " + autoActivateUser + "timeDelay: " + timeDelay);
        settings.setDefaultLoginDisabled(BooleanUtils.toBoolean((Boolean)disableDefaultLogin));
        settings.setAutoActivateUser(BooleanUtils.toBoolean((Boolean)autoActivateUser));
        LOGGER.debug("setTimeDelay to:" + timeDelay);
        settings.setTimeDelay(timeDelay);
        settings.setenableErrorMsgTemplate(BooleanUtils.toBoolean((Boolean)enableErrorMsgTemplate));
        settings.setBackdoorEnabled(BooleanUtils.toBoolean((Boolean)enableBackdoor));
        settings.setLoginButtonText(loginButtonText);
        settings.setRelayState(relayState);
        settings.setLoginTemplate(loginTemplate);
        settings.setRestrictBackdoor(restrictBackdoor);
        settings.setBackdoorGroups(backdoorGroupsList);
        settings.setErrorMsgTemplate(errorMsgTemplate);
        settings.setEnableSAMLSSO(enableSAMLSSO);
    }

    public void saveSignoutSettings(Boolean enableLogoutTemplate, String logoutTemplate) {
        LOGGER.debug("saveSignoutSettings Saving Signout settings: enableLogoutTemplate: " + enableLogoutTemplate + ", logoutTemplate: " + logoutTemplate);
        settings.setEnableLogoutTemplate(BooleanUtils.toBoolean((Boolean)enableLogoutTemplate));
        settings.setLogoutTemplate(logoutTemplate);
    }

    public static void saveRoleMapping(String idpID, String roleAttribute, Boolean createUsersIfRoleMapped, Boolean keepExistingUserRoles, HashMap<String, String> roleMapping, List<String> defaultGroups, Boolean restrictUserCreation, Boolean updateUserOnlyIfRoleMapped, String defaultDirectory, String enableDefaultGroupsFor, Boolean onTheFlyGroupCreation, List<String> onTheFlyDoNotRemoveGroups, Boolean createNewGroups, Boolean onTheFlyAssignNewGroupsOnly, Boolean applicationGroupEnrollment, Boolean groupRegexPatternEnabled, String onTheFlyFilterIDPGroupsOption, String onTheFlyFilterIDPGroupsKey, String regexPatternForGroup, String regexGroups, String testRegex) {
        LOGGER.info("Saving Group Mapping Configuration ");
        LOGGER.debug("roleAttribute = " + roleAttribute + " createUsersIfRoleMapped = " + createUsersIfRoleMapped + " keepExistingUserRoles = " + keepExistingUserRoles + " roleMapping = " + roleMapping + " defaultGroups = " + defaultGroups + " restrictUserCreation = " + restrictUserCreation + " updateUserOnlyIfRoleMapped = " + updateUserOnlyIfRoleMapped + "defaultDirectory = " + defaultDirectory + " enableDefaultGroupsFor = " + enableDefaultGroupsFor + ",onTheFlyGroupCreation = " + onTheFlyGroupCreation + ", onTheFlyDoNotRemoveGroups = " + onTheFlyDoNotRemoveGroups + ", createNewGroups=" + createNewGroups + ", onTheFlyAssignNewGroupsOnly = " + onTheFlyAssignNewGroupsOnly + ", applicationGroupEnrollment = " + applicationGroupEnrollment + " groupRegexPatternEnabled " + groupRegexPatternEnabled + " onTheFlyFilterIDPGroupsOption =" + onTheFlyFilterIDPGroupsOption + " onTheFlyFilterIDPGroupsKey =" + onTheFlyFilterIDPGroupsKey + " regexPatternForGroup =" + regexPatternForGroup + " regexGroups =" + regexGroups + " testRegex =" + testRegex);
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            settings.setRoleAttribute(roleAttribute);
            settings.setCreateUsersIfRoleMapped(BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped));
            settings.setKeepExistingUserRoles(BooleanUtils.toBoolean((Boolean)keepExistingUserRoles));
            settings.setRoleMapping(roleMapping);
            settings.setRestrictUserCreation(restrictUserCreation);
            settings.setEnableDefaultGroupsFor(enableDefaultGroupsFor);
            settings.setUpdateUserOnlyIfRoleMapped(updateUserOnlyIfRoleMapped);
            settings.setOnTheFlyGroupCreation(onTheFlyGroupCreation);
            settings.setApplicationGroupEnrollment(applicationGroupEnrollment);
            if (BooleanUtils.toBoolean((Boolean)onTheFlyGroupCreation)) {
                settings.setCreateNewGroups(createNewGroups);
                settings.setOnTheFlyDoNotRemoveGroups(onTheFlyDoNotRemoveGroups);
                settings.setOnTheFlyAssignNewGroupsOnly(onTheFlyAssignNewGroupsOnly);
            }
            if (!BooleanUtils.toBoolean((Boolean)restrictUserCreation)) {
                settings.setCreateUsersIfRoleMapped(BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped));
                if (!BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped)) {
                    settings.setDefaultGroups(defaultGroups);
                }
            }
            settings.setDefaultDirectory(defaultDirectory);
            settings.setGroupRegexPatternEnabled(groupRegexPatternEnabled);
            settings.setOnTheFlyFilterIDPGroupsOption(onTheFlyFilterIDPGroupsOption);
            settings.setOnTheFlyFilterIDPGroupsKey(onTheFlyFilterIDPGroupsKey);
            settings.setRegexPatternForGroup(regexPatternForGroup);
            settings.setRegexGroups(regexGroups);
            settings.setTestRegex(testRegex);
        } else {
            JSONObject groupMappingObject = MoPluginHandler.constructGroupMappingConfigObj(roleAttribute, createUsersIfRoleMapped, keepExistingUserRoles, roleMapping, defaultGroups, restrictUserCreation, enableDefaultGroupsFor, defaultDirectory, updateUserOnlyIfRoleMapped, onTheFlyGroupCreation, onTheFlyDoNotRemoveGroups, createNewGroups, onTheFlyAssignNewGroupsOnly, applicationGroupEnrollment, groupRegexPatternEnabled, onTheFlyFilterIDPGroupsOption, onTheFlyFilterIDPGroupsKey, regexPatternForGroup, regexGroups, testRegex);
            LOGGER.debug("[saveRoleMapping] Group Mapping Config " + groupMappingObject.toString());
            settings.setGroupMappingConfig(groupMappingObject, idpID);
        }
    }

    public static HashMap<String, String> getAuthorizationHeaders(Long customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex(stringToHash);
        headers.put("Customer-Key", String.valueOf(customerId));
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    public static void saveIdPConfiguration(String idpID, String idpName, String idpEntityId, String ssoBinding, String ssoUrl, String sloBinding, String sloUrl, List<String> x509AllCertificates, String x509Certificate, Boolean signedRequest, String nameIdFormat, String inputUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        LOGGER.info("saving IdP Configuration, IdpName: " + idpName);
        LOGGER.debug("idpID :" + idpID + ", idpEntityId :" + idpEntityId + ", ssoBinding :" + ssoBinding + ", ssoUrl :" + ssoUrl + ", sloBinding" + sloBinding + ", sloUrl :" + sloUrl + ", x509AllCertificates :" + x509AllCertificates + ", x509Certificate :" + x509Certificate + ", signedRequest :" + signedRequest + ", nameIdFormat : " + nameIdFormat + ", Rollover url" + inputUrl + ", refreshMetadata : " + refreshMetadata + ", refreshInterval : " + refreshInterval + ", customRefreshInterval" + customRefreshInterval + ", customRefreshIntervalUnit" + customRefreshIntervalUnit);
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            LOGGER.debug("Saving configuration for default IDP");
            settings.setIdpName(idpName);
            settings.setIdpEntityId(idpEntityId);
            settings.setSsoServiceUrl(ssoUrl);
            settings.setSsoBindingType(ssoBinding);
            settings.setSloServiceUrl(sloUrl);
            settings.setSloBindingType(sloBinding);
            if (x509Certificate != null) {
                settings.setX509Certificate(x509Certificate);
            } else {
                settings.setX509Certificate(x509AllCertificates.get(0));
            }
            if (x509AllCertificates.size() != 0) {
                settings.setAllX509Certificates(x509AllCertificates);
            }
            settings.setSignedRequest(signedRequest);
            settings.setNameIdFormat(nameIdFormat);
            if (BooleanUtils.toBoolean((Boolean)refreshMetadata)) {
                MoPluginHandler.saveImportMetadata(idpID, StringUtils.trim((String)inputUrl), refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
            } else {
                MoPluginHandler.saveImportMetadata(idpID, inputUrl, false, "hourly", 60, "minutes");
            }
        } else {
            LOGGER.debug("Saving configuration for IDP ID " + idpID);
            JSONObject idpConfigObj = MoPluginHandler.constructIdpConfig(idpID, idpName, idpEntityId, ssoBinding, ssoUrl, sloBinding, sloUrl, x509AllCertificates, x509Certificate, signedRequest, nameIdFormat, inputUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
            MoPluginHandler.saveImportMetadata(idpID, StringUtils.trim((String)inputUrl), refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
            HashMap<String, String> idpMap = settings.getIdpMap();
            idpMap.put(idpID, idpName);
            ArrayList<String> idpList = settings.getIdPList();
            if (!idpList.contains(idpID)) {
                MoPluginHandler.saveDefaultAttributeAndGroupMapping(idpID);
                idpList.add(idpID);
            }
            settings.setIdpMap(idpMap);
            settings.setIdPList(idpList);
            LOGGER.debug("After Saving" + settings.getIdpMap().toString());
            settings.setIdpConfig(idpConfigObj, idpID);
        }
        MoPluginHandler.toggleSchedulerService(idpID);
    }

    public static void saveDefaultAttributeAndGroupMapping(String idpID) {
        MoPluginHandler.saveAttributeMapping(idpID, "NameID", "NameID", "", "", "", Boolean.TRUE, settings.getLoginUserAttribute(), Boolean.FALSE, "", new HashMap<String, String>());
        MoPluginHandler.saveRoleMapping(idpID, "", Boolean.FALSE, Boolean.TRUE, new HashMap<String, String>(), settings.getDefaultGroups(), Boolean.FALSE, Boolean.TRUE, settings.getDefaultDirectory(), "newUsers", Boolean.FALSE, new ArrayList<String>(), Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, "None", "", "", "", "");
    }

    public void replaceOldSettingsWithNew(String idpID, String idpName) {
        LOGGER.debug("replaceOldSettingsWithNew Called");
        if (settings.getIdPList().size() == 0) {
            MoPluginHandler.saveIdPConfiguration(idpID, idpName, settings.getIdpEntityId(), settings.getSsoBindingType(), settings.getSsoServiceUrl(), settings.getSloBindingType(), settings.getSloServiceUrl(), (List)settings.getAllX509Certificates(), settings.getX509Certificate(), settings.getSignedRequest(), settings.getNameIdFormat(), settings.getInputMetadataUrl(), settings.getRefreshMetadata(), settings.getRefreshInterval(), settings.getCustomRefreshInterval(), settings.getCustomRefreshIntervalUnit());
            MoPluginHandler.saveAttributeMapping(idpID, settings.getUsernameAttribute(), settings.getEmailAttribute(), settings.getFirstNameAttribute(), settings.getLastNameAttribute(), settings.getFullNameAttribute(), settings.getKeepExistingUserAttributes(), settings.getLoginUserAttribute(), settings.getRegexPatternEnabled(), settings.getRegexPattern(), settings.getCustomAttributeMapping());
            MoPluginHandler.saveRoleMapping(idpID, settings.getRoleAttribute(), settings.getCreateUsersIfRoleMapped(), settings.getKeepExistingUserRoles(), settings.getRoleMapping(), settings.getDefaultGroups(), settings.getRestrictUserCreation(), settings.getUpdateUserOnlyIfRoleMapped(), settings.getDefaultDirectory(), settings.getEnableDefaultGroupsFor(), settings.getOnTheFlyGroupCreation(), settings.getOnTheFlyDoNotRemoveGroups(), settings.getCreateNewGroups(), settings.getOnTheFlyAssignNewGroupsOnly(), settings.getApplicationGroupEnrollment(), settings.getGroupRegexPatternEnabled(), settings.getOnTheFlyFilterIDPGroupsOption(), settings.getOnTheFlyFilterIDPGroupsKey(), settings.getRegexPatternForGroup(), settings.getRegexGroups(), settings.getTestRegex());
            metadataRefreshService.unschedule("miniorange.saml.DEFAULT_IDP_ID");
            MoPluginHandler.toggleSchedulerService(idpID);
        }
    }

    public void stopAllSchedulers() {
        LOGGER.debug("Stopping metadata schedulers ");
        ArrayList<String> idpList = settings.getIdPList();
        for (String idp : idpList) {
            metadataRefreshService.unschedule(idp);
        }
        metadataRefreshService.unschedule("miniorange.saml.DEFAULT_IDP_ID");
    }

    private static Boolean isJSONString(String string) {
        try {
            new JSONObject(string);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(string);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public Customer fetchCustomer(String email, String password) {
        try {
            Customer customer = new Customer(email, password, "", "", "");
            String json = customer.getJSON();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/key", json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (MoPluginHandler.isJSONString(response).booleanValue()) {
                JSONObject jsonObj = new JSONObject(response);
                String statusNode = jsonObj.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success")) {
                    Long customerId = Long.valueOf(jsonObj.getString("id"));
                    customer = new Customer(customerId, email, "", "", "", "");
                    customer.setApiKey(jsonObj.getString("apiKey"));
                    customer.setTokenKey(jsonObj.getString("token"));
                    return customer;
                }
                throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "Couldn't verify your account. Please contact support at support-atlassian@miniorange.atlassian.net", null);
            }
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            LOGGER.error("An account verification error occurred ", e);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Boolean isValidDomainMapping(String[] domains, Boolean useDomainMapping) {
        LOGGER.debug("isValidDomainMapping called ");
        int count = 0;
        if (useDomainMapping != null && useDomainMapping.booleanValue()) {
            if (domains != null && domains.length > 0) {
                for (String domain : domains) {
                    if (StringUtils.isBlank((CharSequence)domain)) {
                        return false;
                    }
                    ++count;
                }
                if (domains.length == count) {
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public Boolean verifyLicense(MoSAMLSettings settings, String key) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", settings.getCustomerID());
            jsonObject.put("code", key);
            jsonObject.put("isActive", false);
            JSONObject baseUrl = new JSONObject();
            baseUrl.put("field1", settings.getSpBaseUrl());
            jsonObject.put("additionalFields", baseUrl);
            String json = jsonObject.toString();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/verify", json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf(settings.getCustomerID()), settings.getCustomerAPIKey()));
            LOGGER.debug("Verify license response: " + response);
            if (MoPluginHandler.isJSONString(response).booleanValue()) {
                JSONObject responseJson = new JSONObject(response);
                String statusNode = responseJson.getString("status");
                LOGGER.debug(" statusNode : " + statusNode);
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success")) {
                    this.getLicencedUsers(settings);
                    settings.setCustomerLicenseKey(key);
                    settings.setLicenseVerified(Boolean.TRUE);
                    return true;
                }
                return false;
            }
            LOGGER.debug("Please contact support. Response String: " + response);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while verifying license key", e);
            return false;
        }
    }

    public void getLicencedUsers(MoSAMLSettings settings) {
        try {
            JSONObject responseJson;
            String statusNode;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerId", settings.getCustomerID());
            jsonObject.put("applicationName", "crowd_saml_sso_premium_plan");
            String json = jsonObject.toString();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/license", json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf(settings.getCustomerID()), settings.getCustomerAPIKey()));
            LOGGER.debug("check customer license response: " + response);
            if (MoPluginHandler.isJSONString(response).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)(statusNode = (responseJson = new JSONObject(response)).getString("status")).toString(), (CharSequence)"success")) {
                if (responseJson.has("licenseType")) {
                    settings.setLicenseType(responseJson.getString("licenseType"));
                }
                if (responseJson.has("licenseExpiry")) {
                    settings.setLicenseExpireDate(responseJson.getString("licenseExpiry"));
                }
                if (responseJson.has("noOfUsers")) {
                    String noOfUsers = responseJson.getString("noOfUsers");
                    Integer licensedUsers = Integer.valueOf(noOfUsers);
                    LOGGER.debug("no of license in user = " + licensedUsers);
                    if (licensedUsers > 0) {
                        settings.setLicencedUsers(licensedUsers);
                        return;
                    }
                }
            }
            LOGGER.error("Please contact support. Response String: " + response);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            LOGGER.error("an error occurred while getting licensed users", e);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Boolean checkLicenseCondition() {
        if (settings.isNoOfUserExceed().booleanValue() && !settings.isTrialLicense().booleanValue()) {
            if (settings.getMailSent().booleanValue()) {
                this.deactivateAndRemoveCustomerAccount();
                return false;
            }
            LOGGER.debug("Sending User limit exceeded email");
            this.sendEmail("You have exceeded license users count for miniOrange Crowd SAML SSO plugin. Please update you license otherwise plugin will stop working after 7 days from now", "Hello,<br><br>You have exceeded allowed users count (" + settings.getLicencedUsers() + " users) on your Crowd Server. <br>Your account will be deactivated after 7 days.Please upgrade your license.Contact us at support-atlassian@miniorange.atlassian.net to get more information and to upgrade your license.<br><br>Thanks,<br>miniOrange");
            settings.setMailSent(true);
        } else {
            settings.setMailSent(false);
        }
        return true;
    }

    public void deactivateAndRemoveCustomerAccount() {
        try {
            if (settings.getLicenseVerified().booleanValue()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("code", settings.getCustomerLicenseKey());
                jsonObject.put("customerKey", settings.getCustomerID());
                JSONObject additionalFields = new JSONObject();
                additionalFields.put("field1", settings.getSpBaseUrl());
                jsonObject.put("additionalFields", additionalFields);
                String json = jsonObject.toString();
                String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/updatestatus", json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf(settings.getCustomerID()), settings.getCustomerAPIKey()));
                LOGGER.debug("Deactivate license response: " + response);
            }
            settings.removeCustomerAccount();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while deactivating the license.", e);
            settings.removeCustomerAccount();
        }
    }

    public void sendEmail(String subject, String content) {
        try {
            LOGGER.debug("Sending email alert");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", settings.getCustomerID());
            jsonObject.put("sendEmail", true);
            JSONObject emailObject = new JSONObject();
            emailObject.put("customerKey", settings.getCustomerID());
            emailObject.put("fromEmail", "info@miniorange.com");
            emailObject.put("bccEmail", "info@miniorange.com");
            emailObject.put("fromName", "miniOrange");
            emailObject.put("toEmail", settings.getCustomerEmail());
            emailObject.put("toName", settings.getCustomerEmail());
            emailObject.put("subject", subject);
            emailObject.put("content", content);
            jsonObject.put("email", emailObject);
            String json = jsonObject.toString();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/notify/send", json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf(settings.getCustomerID()), settings.getCustomerAPIKey()));
            LOGGER.debug("Email alert response: " + response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSettings(MoSAMLSettings settings) {
        MoPluginHandler.settings = settings;
    }

    public void setMetadataRefreshService(MoMetadataRefreshService metadataRefreshService) {
        MoPluginHandler.metadataRefreshService = metadataRefreshService;
    }

    public void fetchMetadata(String idpID, String idpName, String metadataUrl) {
        String metadata = MoHttpUtils.sendGetRequest(metadataUrl);
        try {
            MoPluginHandler.configureFromMetadata(idpID, idpName, metadata, false);
            MoPluginHandler.saveImportMetadata(idpID, metadataUrl, false, "hourly", 60, "minutes");
        }
        catch (Exception e) {
            LOGGER.error(MoPluginException.PluginErrorCode.METADATA_PARSE.getMessage(), e);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "An error occurred while saving your details. Please check logs for more info.", e);
        }
    }

    public static MoIDPConfig constructIdpConfigObject(String idpID) {
        LOGGER.debug("Constructing MoIDPConfig - IDP config object");
        MoIDPConfig idpConfig = null;
        try {
            if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
                LOGGER.debug("constructIdpConfigObject for default IDP");
                JSONObject idpConfigObj = MoPluginHandler.constructIdpConfig(idpID, "IDP", settings.getIdpEntityId(), settings.getSsoBindingType(), settings.getSsoServiceUrl(), settings.getSloBindingType(), settings.getSloServiceUrl(), (List)settings.getAllX509Certificates(), settings.getX509Certificate(), settings.getSignedRequest(), settings.getNameIdFormat(), settings.getInputMetadataUrl(), settings.getRefreshMetadata(), settings.getRefreshInterval(), settings.getCustomRefreshInterval(), settings.getCustomRefreshIntervalUnit());
                LOGGER.debug("constructIdpConfigObject idpConfigObj : " + idpConfigObj.toString());
                if (idpConfigObj != null) {
                    JSONObject importMetadataConfigObj;
                    JSONObject groupMappingConfigObj;
                    idpConfig = new MoIDPConfig();
                    MoPluginHandler.insertIDPConfig(idpConfig, idpConfigObj);
                    JSONObject attributeMappingConfigObj = MoPluginHandler.constructAttributeConfig(settings.getUsernameAttribute(), settings.getEmailAttribute(), settings.getFullNameAttribute(), settings.getFirstNameAttribute(), settings.getLastNameAttribute(), settings.getKeepExistingUserAttributes(), settings.getLoginUserAttribute(), settings.getRegexPatternEnabled(), settings.getRegexPattern(), settings.getCustomAttributeMapping());
                    if (attributeMappingConfigObj != null) {
                        MoPluginHandler.insertAttributeMappingConfig(idpConfig, attributeMappingConfigObj);
                    }
                    if ((groupMappingConfigObj = MoPluginHandler.constructGroupMappingConfigObj(settings.getRoleAttribute(), settings.getCreateUsersIfRoleMapped(), settings.getKeepExistingUserRoles(), settings.getRoleMapping(), settings.getDefaultGroups(), settings.getRestrictUserCreation(), settings.getEnableDefaultGroupsFor(), settings.getDefaultDirectory(), settings.getUpdateUserOnlyIfRoleMapped(), settings.getOnTheFlyGroupCreation(), settings.getOnTheFlyDoNotRemoveGroups(), settings.getOnTheFlyAssignNewGroupsOnly(), settings.getCreateNewGroups(), settings.getApplicationGroupEnrollment(), settings.getGroupRegexPatternEnabled(), settings.getOnTheFlyFilterIDPGroupsOption(), settings.getOnTheFlyFilterIDPGroupsKey(), settings.getRegexPatternForGroup(), settings.getRegexGroups(), settings.getTestRegex())) != null) {
                        MoPluginHandler.insertGroupMappingConfig(idpConfig, groupMappingConfigObj);
                    }
                    if ((importMetadataConfigObj = MoPluginHandler.constructImportMetadataObj(settings.getInputMetadataUrl(), settings.getRefreshMetadata(), settings.getRefreshInterval(), settings.getCustomRefreshInterval(), settings.getCustomRefreshIntervalUnit())) != null) {
                        MoPluginHandler.insertImportMetadataConfig(idpConfig, importMetadataConfigObj);
                    }
                }
            } else {
                LOGGER.debug("[constructIdPConfigObject]IDP ID: " + idpID);
                JSONObject idpConfigObj = settings.getIdpConfig(idpID);
                if (idpConfigObj != null) {
                    JSONObject importMetadataConfigObj;
                    JSONObject groupMappingConfigObj;
                    idpConfig = new MoIDPConfig();
                    MoPluginHandler.insertIDPConfig(idpConfig, idpConfigObj);
                    JSONObject attributeMappingConfigObj = settings.getAttributeMappingConfig(idpID);
                    if (attributeMappingConfigObj != null) {
                        MoPluginHandler.insertAttributeMappingConfig(idpConfig, attributeMappingConfigObj);
                    }
                    if ((groupMappingConfigObj = settings.getGroupMappingConfig(idpID)) != null) {
                        MoPluginHandler.insertGroupMappingConfig(idpConfig, groupMappingConfigObj);
                    }
                    if ((importMetadataConfigObj = settings.getImportMetadataConfig(idpID)) != null) {
                        idpConfig.setMetadataUrl(importMetadataConfigObj.optString("miniorange.saml.INPUT_METADATA_URL", ""));
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.debug("An exception occurred while initializing IDP Configurations " + t.getMessage());
        }
        return idpConfig;
    }

    public static JSONObject constructImportMetadataObj(String inputUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        JSONObject importMetadataObj = new JSONObject();
        try {
            importMetadataObj.put("miniorange.saml.INPUT_METADATA_URL", StringUtils.defaultIfBlank((CharSequence)inputUrl, (CharSequence)""));
            importMetadataObj.put("miniorange.saml.REFRESH_METADATA", BooleanUtils.toBoolean((Boolean)refreshMetadata));
            importMetadataObj.put("miniorange.saml.METADATA_REFRESH_INTERVAL", StringUtils.defaultIfBlank((CharSequence)refreshInterval, (CharSequence)"hourly"));
            importMetadataObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL", customRefreshInterval != null ? customRefreshInterval : 60);
            importMetadataObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", StringUtils.defaultIfBlank((CharSequence)customRefreshIntervalUnit, (CharSequence)"minutes"));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while initializing import metadata configurations", e);
        }
        return importMetadataObj;
    }

    public static void toggleSchedulerService(String idpID) {
        LOGGER.debug("Schedule/unschedule certificate refreshing");
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpID);
        if (BooleanUtils.toBoolean((Boolean)idpConfig.getRefreshMetadata())) {
            int interval = MoSAMLUtils.getMetadataRefreshInterval(idpConfig.getRefreshInterval(), idpConfig.getCustomRefreshInterval(), idpConfig.getCustomRefreshIntervalUnit());
            metadataRefreshService.reschedule(interval, idpConfig);
        } else {
            metadataRefreshService.unschedule(idpConfig.getId());
        }
    }

    private static void insertImportMetadataConfig(MoIDPConfig idpConfig, JSONObject importMetadataConfigObj) {
        if (importMetadataConfigObj != null) {
            idpConfig.setMetadataUrl(importMetadataConfigObj.optString("miniorange.saml.INPUT_METADATA_URL", ""));
            idpConfig.setRefreshMetadata(importMetadataConfigObj.optBoolean("miniorange.saml.REFRESH_METADATA", false));
            idpConfig.setRefreshInterval(importMetadataConfigObj.optString("miniorange.saml.METADATA_REFRESH_INTERVAL", "hourly"));
            idpConfig.setCustomRefreshInterval(importMetadataConfigObj.optInt("miniorange.saml.CUSTOM_REFRESH_INTERVAL", 60));
            idpConfig.setCustomRefreshIntervalUnit(importMetadataConfigObj.optString("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", "minutes"));
        } else {
            idpConfig.setMetadataUrl("");
            idpConfig.setRefreshMetadata(Boolean.FALSE);
            idpConfig.setRefreshInterval("hourly");
            idpConfig.setCustomRefreshInterval(60);
            idpConfig.setCustomRefreshIntervalUnit("minutes");
        }
    }

    private static JSONObject constructIdpConfig(String idpID, String idpName, String idpEntityId, String ssoBinding, String ssoUrl, String sloBinding, String sloUrl, List<String> x509AllCertificates, String x509Certificate, Boolean signedRequest, String nameIdFormat, String inputUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        LOGGER.debug(" constructIdpConfig called ");
        LOGGER.debug(" NameID Format  :  " + nameIdFormat);
        JSONObject idpConfigObj = new JSONObject();
        try {
            idpConfigObj.put("miniorange.saml.IDP_ID", idpID);
            idpConfigObj.put("miniorange.saml.IDP_NAME", StringUtils.trimToEmpty((String)idpName));
            idpConfigObj.put("miniorange.saml.IDP_ENTITY_ID", StringUtils.trimToEmpty((String)idpEntityId));
            idpConfigObj.put("miniorange.saml.SSO_URL", StringUtils.trimToEmpty((String)ssoUrl));
            idpConfigObj.put("miniorange.saml.SLO_URL", StringUtils.trimToEmpty((String)sloUrl));
            idpConfigObj.put("miniorange.saml.SSO_BINDING_TYPE", StringUtils.defaultIfBlank((CharSequence)ssoBinding, (CharSequence)"HttpRedirect"));
            idpConfigObj.put("miniorange.saml.SLO_BINDING_TYPE", StringUtils.defaultIfBlank((CharSequence)sloBinding, (CharSequence)"HttpRedirect"));
            idpConfigObj.putOpt("miniorange.saml.X509_CERTIFICATE", StringUtils.trimToEmpty((String)Objects.toString(MoSAMLUtils.serializePublicCertificate(x509Certificate), "")));
            idpConfigObj.put("miniorange.saml.SIGNED_REQUEST", BooleanUtils.toBooleanDefaultIfNull((Boolean)signedRequest, (boolean)false));
            if (x509AllCertificates != null) {
                for (String certificate : x509AllCertificates) {
                    idpConfigObj.append("miniorange.saml.ALL_X509_CERTIFICATES", StringUtils.trimToEmpty((String)MoSAMLUtils.serializePublicCertificate(certificate)));
                }
            }
            idpConfigObj.put("miniorange.saml.NAME_ID_FORMAT", StringUtils.defaultIfBlank((CharSequence)nameIdFormat, (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
            idpConfigObj.put("miniorange.saml.INPUT_METADATA_URL", StringUtils.defaultIfBlank((CharSequence)inputUrl, (CharSequence)""));
            idpConfigObj.put("miniorange.saml.REFRESH_METADATA", BooleanUtils.toBooleanDefaultIfNull((Boolean)refreshMetadata, (boolean)false));
            idpConfigObj.put("miniorange.saml.METADATA_REFRESH_INTERVAL", StringUtils.defaultIfBlank((CharSequence)refreshInterval, (CharSequence)"hourly"));
            idpConfigObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL", customRefreshInterval != null ? customRefreshInterval : 60);
            idpConfigObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", StringUtils.defaultIfBlank((CharSequence)customRefreshIntervalUnit, (CharSequence)"minutes"));
        }
        catch (JSONException e) {
            LOGGER.debug("constructIdpConfig exception ", e);
        }
        return idpConfigObj;
    }

    private static void insertIDPConfig(MoIDPConfig idpConfig, JSONObject idpConfigObj) {
        try {
            idpConfig.setId(idpConfigObj.optString("miniorange.saml.IDP_ID", ""));
            idpConfig.setIdpName(idpConfigObj.optString("miniorange.saml.IDP_NAME", ""));
            idpConfig.setIdpEntityId(idpConfigObj.optString("miniorange.saml.IDP_ENTITY_ID", ""));
            idpConfig.setSsoUrl(idpConfigObj.optString("miniorange.saml.SSO_URL", ""));
            idpConfig.setSsoBindingType(idpConfigObj.optString("miniorange.saml.SSO_BINDING_TYPE", "HttpRedirect"));
            idpConfig.setSloUrl(idpConfigObj.optString("miniorange.saml.SLO_URL", ""));
            idpConfig.setSloBindingType(idpConfigObj.optString("miniorange.saml.SLO_BINDING_TYPE", "HttpRedirect"));
            idpConfig.setX509Certificate(idpConfigObj.optString("miniorange.saml.X509_CERTIFICATE", ""));
            JSONArray certificates = idpConfigObj.optJSONArray("miniorange.saml.ALL_X509_CERTIFICATES");
            ArrayList<String> x509AllCertificates = new ArrayList<String>();
            if (certificates != null) {
                for (int i = 0; i < certificates.length(); ++i) {
                    x509AllCertificates.add(certificates.getString(i));
                }
            }
            idpConfig.setCertificates(x509AllCertificates);
            idpConfig.setSignedRequest(idpConfigObj.optBoolean("miniorange.saml.SIGNED_REQUEST", true));
            idpConfig.setNameIdFormat(idpConfigObj.optString("miniorange.saml.NAME_ID_FORMAT", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
            idpConfig.setMetadataUrl(idpConfigObj.optString("miniorange.saml.INPUT_METADATA_URL", ""));
            idpConfig.setRefreshMetadata(idpConfigObj.optBoolean("miniorange.saml.REFRESH_METADATA", false));
            idpConfig.setRefreshInterval(idpConfigObj.optString("miniorange.saml.METADATA_REFRESH_INTERVAL", "hourly"));
            idpConfig.setCustomRefreshInterval(idpConfigObj.optInt("miniorange.saml.CUSTOM_REFRESH_INTERVAL", 60));
            idpConfig.setCustomRefreshIntervalUnit(idpConfigObj.optString("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", "minutes"));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while creating IDP configurations", e);
        }
    }

    public static void configureFromMetadata(String idpID, String idpName, String metadata, Boolean isRefreshTask) {
        LOGGER.debug("configureFromMetadata called ");
        metadata = metadata.replaceAll("[^\\x20-\\x7e]", "");
        MoIDPMetadata idpMetadata = new MoIDPMetadata(metadata);
        String idpEntityId = idpMetadata.getEntityId();
        String ssoBinding = "HttpRedirect";
        String ssoUrl = "";
        String sloBinding = "HttpRedirect";
        String sloUrl = "";
        String nameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        Boolean isRequestSigned = Boolean.TRUE;
        String inputUrl = "";
        Boolean refreshMetadata = Boolean.FALSE;
        String refreshInterval = "hourly";
        Integer customRefreshInterval = 60;
        String customRefreshIntervalUnit = "minutes";
        if (!BooleanUtils.toBoolean((Boolean)isRefreshTask)) {
            if (idpMetadata.getSingleSignOnServices().containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                ssoBinding = "HttpRedirect";
                ssoUrl = idpMetadata.getSingleSignOnServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            } else {
                ssoBinding = "HttpPost";
                ssoUrl = idpMetadata.getSingleSignOnServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            }
            if (idpMetadata.getSingleLogoutServices().size() > 0) {
                if (idpMetadata.getSingleLogoutServices().containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                    sloBinding = "HttpRedirect";
                    sloUrl = idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                } else {
                    sloBinding = "HttpPost";
                    sloUrl = idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
                }
            }
        } else {
            MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpID);
            ssoBinding = idpConfig.getSsoBindingType();
            ssoUrl = idpConfig.getSsoUrl();
            sloUrl = idpConfig.getSloUrl();
            sloBinding = idpConfig.getSloBindingType();
            isRequestSigned = idpConfig.getSignedRequest();
            inputUrl = idpConfig.getMetadataUrl();
            refreshMetadata = idpConfig.getRefreshMetadata();
            refreshInterval = idpConfig.getRefreshInterval();
            customRefreshInterval = idpConfig.getCustomRefreshInterval();
            customRefreshIntervalUnit = idpConfig.getCustomRefreshIntervalUnit();
        }
        String x509Certificate = idpMetadata.getSigningCertificates().get(0);
        List<String> x509AllCertificates = idpMetadata.getSigningCertificates();
        MoPluginHandler.saveIdPConfiguration(idpID, idpName, idpEntityId, ssoBinding, ssoUrl, sloBinding, sloUrl, x509AllCertificates, x509Certificate, isRequestSigned, nameIdFormat, inputUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
    }

    private static JSONObject constructAttributeConfig(String usernameAttribute, String emailAttribute, String fullNameAttribute, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String loginUserAttribute, Boolean regexPatternEnabled, String regexPattern, HashMap<String, String> customAttributeMapping) {
        JSONObject attributeMappingConfigObj = new JSONObject();
        try {
            attributeMappingConfigObj.put("miniorange.saml.USERNAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)usernameAttribute, (CharSequence)"NameID"));
            attributeMappingConfigObj.put("miniorange.saml.EMAIL_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)emailAttribute, (CharSequence)"NameID"));
            attributeMappingConfigObj.put("miniorange.saml.FULL_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.FIRST_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)firstNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.LAST_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)lastNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", BooleanUtils.toBooleanDefaultIfNull((Boolean)keepExistingUserAttributes, (boolean)Boolean.FALSE));
            attributeMappingConfigObj.put("miniorange.saml.LOGIN_USER_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)loginUserAttribute, (CharSequence)"username"));
            attributeMappingConfigObj.put("miniorange.saml.ENABLE_REGEX_PATTERN", BooleanUtils.toBooleanDefaultIfNull((Boolean)regexPatternEnabled, (boolean)false));
            attributeMappingConfigObj.put("miniorange.saml.REGEX_PATTERN", StringUtils.defaultIfBlank((CharSequence)regexPattern, (CharSequence)""));
            JSONObject custom_attributeObj = new JSONObject();
            if (customAttributeMapping != null) {
                for (String keySet : customAttributeMapping.keySet()) {
                    custom_attributeObj.putOpt(keySet, customAttributeMapping.get(keySet));
                }
            }
            attributeMappingConfigObj.put("miniorange.saml.CUSTOM_ATTRIBUTE_MAPPING", custom_attributeObj);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while initializing attribute mapping configurations", e);
        }
        return attributeMappingConfigObj;
    }

    private static void insertAttributeMappingConfig(MoIDPConfig idpConfig, JSONObject attributeMappingConfigObj) {
        LOGGER.debug("insertAttributeMappingConfig called");
        idpConfig.setUsernameAttribute(attributeMappingConfigObj.optString("miniorange.saml.USERNAME_ATTRIBUTE", "NameID"));
        idpConfig.setEmailAttribute(attributeMappingConfigObj.optString("miniorange.saml.EMAIL_ATTRIBUTE", "NameID"));
        idpConfig.setFullNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.FULL_NAME_ATTRIBUTE", ""));
        idpConfig.setFirstNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.FIRST_NAME_ATTRIBUTE", ""));
        idpConfig.setLastNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.LAST_NAME_ATTRIBUTE", ""));
        idpConfig.setKeepExistingUserAttributes(attributeMappingConfigObj.optBoolean("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", Boolean.TRUE));
        idpConfig.setLoginUserAttribute(attributeMappingConfigObj.optString("miniorange.saml.LOGIN_USER_ATTRIBUTE", "username"));
        idpConfig.setRegexPatternEnabled(attributeMappingConfigObj.optBoolean("miniorange.saml.ENABLE_REGEX_PATTERN", Boolean.FALSE));
        idpConfig.setRegexPattern(attributeMappingConfigObj.optString("miniorange.saml.REGEX_PATTERN", ""));
        JSONObject customAttributeMapping = attributeMappingConfigObj.optJSONObject("miniorange.saml.CUSTOM_ATTRIBUTE_MAPPING");
        HashMap<String, String> customAttributeMappings = new HashMap<String, String>();
        if (customAttributeMapping != null) {
            Iterator<String> keySet = customAttributeMapping.keys();
            while (keySet.hasNext()) {
                String customAttribute = keySet.next();
                if (!StringUtils.isNotBlank((CharSequence)customAttributeMapping.getString(customAttribute))) continue;
                customAttributeMappings.put(customAttribute, customAttributeMapping.getString(customAttribute));
            }
        }
        idpConfig.setCustomAttributeMapping(customAttributeMappings);
    }

    private static JSONObject constructGroupMappingConfigObj(String roleAttribute, Boolean createUsersIfRoleMapped, Boolean keepExistingUserRoles, HashMap<String, String> roleMapping, List<String> defaultGroups, Boolean restrictUserCreation, String enableDefaultGroupsFor, String defaultDirectory, Boolean updateUserOnlyIfRoleMapped, Boolean onTheFlyGroupCreation, List<String> onTheFlyDoNotRemoveGroups, Boolean createNewGroups, Boolean onTheFlyAssignNewGroupsOnly, Boolean applicationGroupEnrollment, Boolean groupRegexPatternEnabled, String onTheFlyFilterIDPGroupsOption, String onTheFlyFilterIDPGroupsKey, String regexPatternForGroup, String regexGroups, String testRegex) {
        JSONObject groupMappingConfigObj = new JSONObject();
        try {
            groupMappingConfigObj.put("miniorange.saml.ROLE_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)roleAttribute, (CharSequence)""));
            groupMappingConfigObj.put("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED", BooleanUtils.toBooleanDefaultIfNull((Boolean)createUsersIfRoleMapped, (boolean)false));
            groupMappingConfigObj.put("miniorange.saml.KEEP_EXISTING_USER_ROLES", BooleanUtils.toBooleanDefaultIfNull((Boolean)keepExistingUserRoles, (boolean)Boolean.FALSE));
            JSONObject groupMappingObj = new JSONObject();
            if (roleMapping != null) {
                for (String crowdGroup : roleMapping.keySet()) {
                    groupMappingObj.putOpt(crowdGroup, roleMapping.get(crowdGroup));
                }
            }
            groupMappingConfigObj.put("miniorange.saml.ROLE_MAPPING", groupMappingObj);
            groupMappingConfigObj.put("miniorange.saml.RESTRICT_USER_CREATION", BooleanUtils.toBoolean((Boolean)restrictUserCreation));
            groupMappingConfigObj.put("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR", enableDefaultGroupsFor);
            groupMappingConfigObj.put("miniorange.saml.DEFAULT_DIRECTORY", StringUtils.trimToEmpty((String)defaultDirectory));
            groupMappingConfigObj.put("miniorange.saml.UPDATE_USER_ONLY_IF_ROLEMAPPED", BooleanUtils.toBooleanDefaultIfNull((Boolean)updateUserOnlyIfRoleMapped, (boolean)false));
            JSONArray defaultGroupsObj = new JSONArray();
            groupMappingConfigObj.put("miniorange.saml.DEFAULT_GROUP", defaultGroupsObj);
            for (String group : defaultGroups) {
                groupMappingConfigObj.append("miniorange.saml.DEFAULT_GROUP", group);
            }
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_GROUP_MAPPING", BooleanUtils.toBooleanDefaultIfNull((Boolean)onTheFlyGroupCreation, (boolean)false));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY", BooleanUtils.toBooleanDefaultIfNull((Boolean)onTheFlyAssignNewGroupsOnly, (boolean)Boolean.FALSE));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS", BooleanUtils.toBooleanDefaultIfNull((Boolean)createNewGroups, (boolean)Boolean.FALSE));
            groupMappingConfigObj.put("miniorange.saml.APPLICATION_GROUP_ENROLLMENT", BooleanUtils.toBooleanDefaultIfNull((Boolean)applicationGroupEnrollment, (boolean)Boolean.FALSE));
            if (onTheFlyDoNotRemoveGroups != null) {
                for (String group : onTheFlyDoNotRemoveGroups) {
                    groupMappingConfigObj.append("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS", group);
                }
            }
            groupMappingConfigObj.put("miniorange.saml.REGEX_FOR_GROUPS_ENABLED", BooleanUtils.toBooleanDefaultIfNull((Boolean)groupRegexPatternEnabled, (boolean)false));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_OPTION", StringUtils.trimToEmpty((String)onTheFlyFilterIDPGroupsOption));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_KEY", StringUtils.trimToEmpty((String)onTheFlyFilterIDPGroupsKey));
            groupMappingConfigObj.put("miniorange.saml.REGEX_PATTERN_FOR_GROUPS", StringUtils.trimToEmpty((String)regexPatternForGroup));
            groupMappingConfigObj.put("miniorange.saml.REGEX_GROUPS", StringUtils.trimToEmpty((String)regexGroups));
            groupMappingConfigObj.put("miniorange.saml.TEXT_REGEX_FOR_GROUPS", StringUtils.trimToEmpty((String)testRegex));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while initializing group mapping configurations", e);
        }
        return groupMappingConfigObj;
    }

    private static void insertGroupMappingConfig(MoIDPConfig idpConfig, JSONObject groupMappingConfigObj) {
        idpConfig.setDefaultDirectory(groupMappingConfigObj.optString("miniorange.saml.DEFAULT_DIRECTORY", settings.getDefaultDirectory()));
        idpConfig.setRoleAttribute(groupMappingConfigObj.optString("miniorange.saml.ROLE_ATTRIBUTE", ""));
        idpConfig.setCreateUsersIfRoleMapped(groupMappingConfigObj.optBoolean("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED", false));
        idpConfig.setUpdateUserOnlyIfRoleMapped(groupMappingConfigObj.optBoolean("miniorange.saml.UPDATE_USER_ONLY_IF_ROLEMAPPED", false));
        idpConfig.setKeepExistingUserRoles(groupMappingConfigObj.optBoolean("miniorange.saml.KEEP_EXISTING_USER_ROLES", Boolean.TRUE));
        List<Object> defaultGroupsList = new ArrayList();
        try {
            JSONArray defaultGroups = groupMappingConfigObj.optJSONArray("miniorange.saml.DEFAULT_GROUP");
            if (defaultGroups != null) {
                for (int i = 0; i < defaultGroups.length(); ++i) {
                    defaultGroupsList.add(defaultGroups.getString(i));
                }
            }
            idpConfig.setDefaultGroups(defaultGroupsList.isEmpty() ? settings.getDefaultGroups() : defaultGroupsList);
        }
        catch (Exception e) {
            String defaultGroups = groupMappingConfigObj.optString("miniorange.saml.DEFAULT_GROUP");
            defaultGroupsList = Arrays.asList(defaultGroups.split(","));
            idpConfig.setDefaultGroups(defaultGroupsList.isEmpty() ? settings.getDefaultGroups() : defaultGroupsList);
        }
        JSONObject groupMapping = groupMappingConfigObj.optJSONObject("miniorange.saml.ROLE_MAPPING");
        HashMap<String, String> roleMapping = new HashMap<String, String>();
        if (groupMapping != null) {
            Iterator<String> crowdGroups = groupMapping.keys();
            while (crowdGroups.hasNext()) {
                String crowdGroup = crowdGroups.next();
                if (!StringUtils.isNotBlank((CharSequence)groupMapping.getString(crowdGroup))) continue;
                roleMapping.put(crowdGroup, groupMapping.getString(crowdGroup));
            }
        }
        idpConfig.setRoleMapping(roleMapping);
        idpConfig.setRestrictUserCreation(groupMappingConfigObj.optBoolean("miniorange.saml.RESTRICT_USER_CREATION", false));
        idpConfig.setEnableDefaultGroupsFor(groupMappingConfigObj.optString("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR", "newUsers"));
        idpConfig.setOnTheFlyGroupCreation(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_GROUP_MAPPING", false));
        idpConfig.setOnTheFlyAssignNewGroupsOnly(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY", Boolean.TRUE));
        idpConfig.setCreateNewGroups(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS", Boolean.TRUE));
        idpConfig.setApplicationGroupEnrollment(groupMappingConfigObj.optBoolean("miniorange.saml.APPLICATION_GROUP_ENROLLMENT", false));
        JSONArray doNotRemoveGroups = groupMappingConfigObj.optJSONArray("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS");
        ArrayList<String> doNotRemoveGroupsList = new ArrayList<String>();
        if (doNotRemoveGroups != null) {
            for (int i = 0; i < doNotRemoveGroups.length(); ++i) {
                doNotRemoveGroupsList.add(doNotRemoveGroups.getString(i));
            }
        }
        idpConfig.setOnTheFlyDoNotRemoveGroups(doNotRemoveGroupsList);
        idpConfig.setGroupRegexPatternEnabled(groupMappingConfigObj.optBoolean("miniorange.saml.REGEX_FOR_GROUPS_ENABLED", Boolean.FALSE));
        idpConfig.setOnTheFlyFilterIDPGroupsOption(groupMappingConfigObj.optString("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_OPTION", "None"));
        idpConfig.setOnTheFlyFilterIDPGroupsKey(groupMappingConfigObj.optString("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_KEY", ""));
        idpConfig.setRegexPatternForGroup(groupMappingConfigObj.optString("miniorange.saml.REGEX_PATTERN_FOR_GROUPS", ""));
        idpConfig.setRegexGroups(groupMappingConfigObj.optString("miniorange.saml.REGEX_GROUPS", ""));
        idpConfig.setTestRegex(groupMappingConfigObj.optString("miniorange.saml.TEXT_REGEX_FOR_GROUPS", ""));
    }

    public void saveListIDPConfigurations(String[] domains, Boolean useDomainMapping) throws MoPluginException {
        if (useDomainMapping != null && useDomainMapping.booleanValue()) {
            this.saveDomainMapping(domains);
        }
        settings.setUseDomainMapping(useDomainMapping);
    }

    private void saveDomainMapping(String[] domains) throws MoPluginException {
        LOGGER.debug("save domain mapping called ");
        HashMap<String, String> domainMapping = new HashMap<String, String>();
        ArrayList<String> idpList = settings.getIdPList();
        LOGGER.debug("idpList " + idpList.toString());
        LOGGER.debug("domains: " + Arrays.asList(domains).toString());
        for (int i = 0; i < domains.length; ++i) {
            String[] multipleDomains;
            if (!StringUtils.isNotBlank((CharSequence)domains[i])) continue;
            for (String domain : multipleDomains = domains[i].trim().split(";")) {
                if (domainMapping.containsKey(domain) && !StringUtils.equalsIgnoreCase((CharSequence)idpList.get(i), (CharSequence)domainMapping.get(domain))) {
                    throw new MoPluginException(MoPluginException.PluginErrorCode.SAVING_DETAILS, "Domain names must be unique");
                }
                domainMapping.put(StringUtils.trimToEmpty((String)domain), idpList.get(i));
            }
        }
        LOGGER.debug("Domain Mapping: " + domainMapping.toString());
        settings.setDomains(domains);
        settings.setDomainMapping(domainMapping);
    }

    public void saveSPCertificates(String publicCertificate, String privateCertificate) {
        LOGGER.debug("saveSPCertificates Saving certificates " + publicCertificate);
        settings.setPublicSPCertificate(MoSAMLUtils.serializePublicCertificate(publicCertificate));
        settings.setPrivateSPCertificate(MoSAMLUtils.serializePrivateCertificate(privateCertificate));
        settings.setSPCertExpireOn(MoSAMLUtils.getCertificateInfo(publicCertificate).get("Valid To"));
    }

    public void importConfigurations(String pluginConfigurations) {
        LOGGER.debug("Importing app's configuration from config file");
        try {
            LOGGER.debug("importConfigurations :  pluginConfigurations  = " + pluginConfigurations);
            this.stopAllSchedulers();
            settings.clearOldConfiguration();
            settings.clearPluginSettings();
            MoPluginConfigurationsHandler.importPluginConfigurations(pluginConfigurations);
        }
        catch (JSONException e) {
            LOGGER.error(e.getMessage());
            throw new MoPluginException(MoPluginException.PluginErrorCode.SAVING_DETAILS, "Invalid file uploaded");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new MoPluginException(MoPluginException.PluginErrorCode.SAVING_DETAILS, "An error occurred while saving the configuration.");
        }
    }

    public Map<String, String> getIdpGuides() {
        TreeMap<String, String> idp = new TreeMap<String, String>();
        for (MoPluginConstants.idpGuides idpGuide : MoPluginConstants.idpGuides.values()) {
            idp.put(idpGuide.name(), idpGuide.getGuide());
        }
        return idp;
    }

    public void generateTrial() {
        LOGGER.debug("Generating trial");
        Date expiry = DateUtils.addMonths((Date)new Date(), (int)1);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
        settings.setTrialActivated(true);
        settings.setCustomerAPIKey("NA");
        settings.setCustomerEmail("-");
        settings.setCustomerId("NA");
        settings.setCustomerTokenKey("PYBz3WIfBEn3DUHx");
        settings.setLicenseType("TRIAL");
        settings.setLicencedUsers(10);
        settings.setLicenseExpireDate(dateFormatter.format(expiry));
        settings.setLicenseVerified(Boolean.TRUE);
    }
}

