/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.crowd.service.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoSAMLLoginFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoSAMLLoginFilter.class);
    private MoSAMLSettings settings;
    @ComponentImport
    private UserService userService;

    @Autowired
    public MoSAMLLoginFilter(MoSAMLSettings settings, UserService userService) {
        this.settings = settings;
        this.userService = userService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOGGER.debug("SAML Filter called...");
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String url = req.getRequestURL().toString();
        String loggedInUserStr = this.userService.getAuthenticatedUsername(req);
        if (loggedInUserStr != null) {
            LOGGER.debug("SAML Login Filter: user is already logged in...");
            chain.doFilter(request, response);
            return;
        }
        if (!this.settings.isCustomerRegistered().booleanValue()) {
            LOGGER.debug("Customer is not registered");
            chain.doFilter(request, response);
            return;
        }
        if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getLicenseType(), (CharSequence)"TRIAL") && this.settings.isLicenseExpired().booleanValue()) {
            LOGGER.debug("License is not verified");
            chain.doFilter(request, response);
            return;
        }
        this.checkConfigurationAndRedirect(request, response, chain);
    }

    private void checkConfigurationAndRedirect(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Boolean isConfigured = false;
        if ((this.settings.getIdpMap().size() > 0 || StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) && this.settings.getEnableSAMLSSO().booleanValue()) {
            isConfigured = true;
        }
        LOGGER.debug("SAML Filter Is Plugin Configured " + isConfigured);
        if (isConfigured.booleanValue()) {
            LOGGER.debug("SAML Filter IsConfigured is true. Checking the configuration.");
            Boolean defaultLoginDisabled = this.settings.getDefaultLoginDisabled();
            Boolean backdoorEnabled = this.settings.getBackdoorEnabled();
            Boolean restrictBackdoor = this.settings.getRestrictBackdoor();
            if (!(!defaultLoginDisabled.booleanValue() || backdoorEnabled.booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("saml_sso"), (CharSequence)"false") || StringUtils.containsIgnoreCase((CharSequence)req.getRequestURI(), (CharSequence)"/saml/auth"))) {
                if (!this.settings.getIdpMap().isEmpty() && this.settings.getIdpMap().size() <= 1) {
                    LOGGER.debug("Redirecting to SAML IdP for Authentication...");
                    StringBuffer buffer = new StringBuffer(this.settings.getLoginServletUrl());
                    String redirectTo = "";
                    if (StringUtils.isNotBlank((CharSequence)redirectTo)) {
                        buffer.append("?return_to=").append(URLEncoder.encode(redirectTo, "UTF-8"));
                    }
                    LOGGER.debug("SAML Filter Redirecting user to " + buffer.toString());
                    StringBuffer htmlStart = new StringBuffer("<html><head><script>window.location.href=\"" + buffer.toString() + "\"</script></head><body>Please wait...</body></html>");
                    response.setContentType("text/html");
                    response.getOutputStream().write(htmlStart.toString().getBytes("UTF-8"));
                } else if (this.settings.getIdpMap().size() > 1) {
                    String renderIDPButtonsOnly = this.getIDPButtonsTemplate(req);
                    response.setContentType("text/html");
                    response.getOutputStream().write(renderIDPButtonsOnly.getBytes("UTF-8"));
                }
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("show_login_form"), (CharSequence)"true") || StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("error"), (CharSequence)"true") || StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("saml_sso"), (CharSequence)"false") && !restrictBackdoor.booleanValue()) {
                LOGGER.debug("SAML Filter: Show default logging form");
                chain.doFilter(request, response);
            } else if (backdoorEnabled.booleanValue() && restrictBackdoor.booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("saml_sso"), (CharSequence)"false")) {
                if (this.settings.getUserPresent().booleanValue()) {
                    this.settings.setUserPresent(false);
                    chain.doFilter(request, response);
                } else {
                    response.setCharacterEncoding("iso-8859-1");
                    response.setContentType("text/html");
                    response.getOutputStream().write(this.getBackdoorForm().getBytes(StandardCharsets.UTF_8));
                }
            } else {
                response.setCharacterEncoding("iso-8859-1");
                response.setContentType("text/html");
                response.getOutputStream().write(this.settings.getLoginTemplate().getBytes(StandardCharsets.UTF_8));
            }
        } else {
            LOGGER.debug("SAML Filter IsConfigured is false. Continuing the filter chain...");
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private String getIDPButtonsTemplate(HttpServletRequest req) {
        String multipleIdpButtons = this.getMultipleIDPButtons(req);
        String html = "<html><head><title>SAML SSO</title><meta name='decorator' content='atl.general'><style>#main.aui-page-panel {border: 1px solid #ccc; border-radius: 20px; margin: 50px auto 50px auto;min-height: 200px; overflow: auto; max-width:400px !important; } </style></head><body id='com-atlassian-crowd' class='theme-default login aui-layout aui-theme-default'><div id='stp-licenseStatus-banner'></div><div id='page'><div id='full-height-container'><div id='main' class=' aui-page-panel'><table id='custom_login_page' style=' width: 100%;'><tr><td style='width: 49%;vertical-align: initial;;padding: 20px;'><div id='custom-sso-login' style='border-radius: 20px;padding: 20px;border: 1px solid lightgrey;'><h2>Single Sign-On</h2><hr><p>Login with your corporate account</p><br/> &nbsp;&nbsp;" + multipleIdpButtons + "</div></td></tr></table></div></div></div></body></html>";
        return html;
    }

    private String getMultipleIDPButtons(HttpServletRequest req) {
        String returnTo = req.getParameter("next");
        LOGGER.debug("next parmater is :" + returnTo);
        HashMap<String, String> idpMap = this.settings.getIdpMap();
        String multipleLinks = "";
        for (String idpId : idpMap.keySet()) {
            String authUrl = this.settings.getSpBaseUrl() + "/plugins/servlet/saml/auth?idp=" + idpId;
            if (StringUtils.isNotBlank((CharSequence)returnTo)) {
                authUrl = authUrl + "&return_to=" + returnTo;
            }
            multipleLinks = multipleLinks + "<div class='field-group' style='text-align: center'><a class='aui-button aui-button-primary' style='width:250px' href='" + authUrl + "'>" + idpMap.get(idpId) + "</a></div><br>";
        }
        return multipleLinks;
    }

    private String getBackdoorForm() {
        String backdoorForm = "<html><head><title>BackDoor Restriction Form</title><meta name='decorator' content='atl.general'><style>#main.aui-page-panel {border: 1px solid #ccc; border-radius: 20px; margin: 50px auto 50px auto;min-height: 200px; overflow: auto; max-width:400px !important; } </style></head><body id='com-atlassian-crowd' class='theme-default login aui-layout aui-theme-default'><div id='stp-licenseStatus-banner'></div><div id='page'><div id='full-height-container'><div id='main' class=' aui-page-panel'><table id='custom_login_page' style=' width: 100%;'><tr><td style='width: 49%;vertical-align: initial;;padding: 20px;'><div id='backdoor_restriction_note' class='aui-message aui-message-info'>Please submit your username to access login form</div><form id='backdoor-restriction-form' method='post' action='' name='backdoor-restriction-form' class='aui gdt'><div class='field-group'><label accesskey='u' for='login-form-email' id='usernamelabel' style='display: block;'><strong>Username</strong></label><input class='text medium-field' id='login-form-email' name='mo_username' type='text' style='height: initial;'/></div><div class='field-group'><button id='check_backdoor_access' class='aui aui-button aui-button-primary'>Submit</button></div></form><br/> &nbsp;&nbsp;</div></td></tr></table></div></div></div></body></html>";
        return backdoorForm;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

