/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.scheduler;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.crowd.scheduler.UpdateLicenseTaskHandler;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Named
public class UpdateLicenseService
implements LifecycleAware {
    private static Log LOGGER = LogFactory.getLog(UpdateLicenseService.class);
    public static final String KEY = UpdateLicenseTaskHandler.class.getName() + ":instance";
    public static final String SETTINGS_KEY = UpdateLicenseTaskHandler.class.getName() + ":settings";
    public static final String PLUGIN_HANDLER_KEY = UpdateLicenseTaskHandler.class.getName() + ":pluginHandler";
    private static final String JOB_NAME = UpdateLicenseTaskHandler.class.getName() + ":job";
    @ComponentImport
    private final PluginScheduler pluginScheduler;
    private MoPluginHandler pluginHandler;
    private MoSAMLSettings settings;
    private int resetIntervalInHours = 168;

    @Autowired
    public UpdateLicenseService(MoSAMLSettings settings, PluginScheduler pluginScheduler, MoPluginHandler pluginHandler) {
        this.pluginScheduler = pluginScheduler;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public void schedule() {
        LOGGER.debug("Scheduling License service");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, 1);
        long resetIntervalInMiliseconds = Integer.toUnsignedLong(this.resetIntervalInHours * 60 * 60 * 1000);
        this.pluginScheduler.scheduleJob(JOB_NAME, UpdateLicenseTaskHandler.class, (Map)new HashMap<String, Object>(){
            {
                this.put(PLUGIN_HANDLER_KEY, UpdateLicenseService.this.pluginHandler);
                this.put(SETTINGS_KEY, UpdateLicenseService.this.settings);
                this.put(KEY, UpdateLicenseService.this);
            }
        }, cal.getTime(), resetIntervalInMiliseconds);
    }

    public void unschedule() {
        LOGGER.debug("Unscheduling License service");
        try {
            this.pluginScheduler.unscheduleJob(JOB_NAME);
        }
        catch (IllegalArgumentException t) {
            LOGGER.error("No JOB exist. Can't unschedule.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void onStart() {
        LOGGER.debug("License Scheduler on start called");
        try {
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isTrialLicense().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                this.unschedule();
            } else {
                this.schedule();
            }
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while Starting the scheduler service");
        }
    }

    public void onStop() {
        LOGGER.info("Scheduler onStop Called");
        try {
            this.unschedule();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while unscheduling : " + e.getMessage());
        }
    }
}

