/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.crowd.scheduler.UpdateLicenseService;
import com.opensymphony.xwork2.Validateable;
import java.net.URI;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoVerifyLicenseAction
extends BaseAction
implements Validateable {
    private static Log LOGGER = LogFactory.getLog(MoVerifyLicenseAction.class);
    @ComponentImport
    private I18nHelper i18nHelper;
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private UpdateLicenseService updateLicenseService;
    String email;
    private String key;
    private Boolean submitted;
    private Boolean backToRegister;

    @Autowired
    public MoVerifyLicenseAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler, I18nHelper i18nHelper, UpdateLicenseService updateLicenseService) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.updateLicenseService = updateLicenseService;
        this.i18nHelper = i18nHelper;
    }

    public String execute() throws Exception {
        LOGGER.info("verify license action execute called.");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (this.settings.isCustomerRegistered().booleanValue() && this.settings.getLicenseVerified().booleanValue() && !this.settings.isTrialLicense().booleanValue() && !this.settings.isLicenseExpired().booleanValue()) {
            LOGGER.debug("customer is registered with valid license, redirecting to the configuration page");
            return "success";
        }
        if (this.settings.getTrialActivated().booleanValue() && this.settings.isTrialLicense().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
            this.moPluginHandler.deactivateAndRemoveCustomerAccount();
        }
        if (!this.settings.isCustomerRegistered().booleanValue()) {
            LOGGER.debug("customer is not registered.");
            return "register";
        }
        if (BooleanUtils.toBoolean((Boolean)this.backToRegister)) {
            LOGGER.debug("back to login page");
            this.settings.removeCustomerAccount();
            return "register";
        }
        if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
            LOGGER.debug("varify license action submitted");
            if (StringUtils.isBlank((CharSequence)this.key)) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.verify.license.empty"));
                this.initializeSAMLConfig();
                return "input";
            }
            LOGGER.debug("key = " + this.key);
            Boolean valid = this.moPluginHandler.verifyLicense(this.settings, this.key);
            LOGGER.debug("valid = " + valid);
            if (valid.booleanValue()) {
                this.updateLicenseService.schedule();
                return "success";
            }
            this.addActionError(this.i18nHelper.getText("samlsso.error.verify.license.invalid"));
            this.initializeSAMLConfig();
            return "input";
        }
        this.initializeSAMLConfig();
        return "input";
    }

    private void initializeSAMLConfig() {
        this.email = this.settings.getCustomerEmail();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getBackToRegister() {
        return this.backToRegister;
    }

    public void setBackToRegister(Boolean backToRegister) {
        this.backToRegister = backToRegister;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

