/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.io.IOException;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoAdvancedConfigurationsAction
extends BaseAction {
    private static Log LOGGER = LogFactory.getLog(MoAdvancedConfigurationsAction.class);
    private String secretKey;
    private boolean configSubmitted;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private MoSAMLSettings settings;

    @Autowired
    public MoAdvancedConfigurationsAction(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String execute() throws IOException {
        LOGGER.info("Advanced Configuration action execute called");
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            LOGGER.info("Advanced Configure Action execute Submitted. ");
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            if (BooleanUtils.toBoolean((Boolean)this.configSubmitted)) {
                this.generateRandomAlphaNumericKey(16);
                this.addActionMessage("Success");
            }
            this.initializeConfig();
        }
        catch (Exception e) {
            this.addActionError("An error occurred while generating new secret key");
            LOGGER.error("An error occurred while generating new secret key", e);
        }
        return "success";
    }

    private void initializeConfig() {
        LOGGER.debug("Initializing page..");
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.secretKey = this.settings.getSecretKey().isEmpty() ? this.generateRandomAlphaNumericKey(16) : this.settings.getSecretKey();
    }

    public String generateRandomAlphaNumericKey(int bytes) {
        String randomString = RandomStringUtils.random((int)bytes, (boolean)true, (boolean)true);
        this.settings.setSecretKey(randomString);
        return randomString;
    }

    public boolean isConfigSubmitted() {
        return this.configSubmitted;
    }

    public void setConfigSubmitted(boolean configSubmitted) {
        this.configSubmitted = configSubmitted;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean noOfUserExceed) {
        this.isNoOfUserExceed = noOfUserExceed;
    }
}

