/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.xml.security.Init;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactBuilderFactory;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;
import org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLConfigurator;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xml.security.x509.tls.StrictHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoCustomDefaultBootstrap {
    public static final String SYSPROP_HTTPCLIENT_HTTPS_DISABLE_HOSTNAME_VERIFICATION = "org.opensaml.httpclient.https.disableHostnameVerification";
    private static String[] xmlToolingConfigs = new String[]{"/default-config.xml", "/schema-config.xml", "/signature-config.xml", "/signature-validation-config.xml", "/encryption-config.xml", "/encryption-validation-config.xml", "/soap11-config.xml", "/wsfed11-protocol-config.xml", "/saml1-assertion-config.xml", "/saml1-protocol-config.xml", "/saml1-core-validation-config.xml", "/saml2-assertion-config.xml", "/saml2-protocol-config.xml", "/saml2-core-validation-config.xml", "/saml1-metadata-config.xml", "/saml2-metadata-config.xml", "/saml2-metadata-validation-config.xml", "/saml2-metadata-attr-config.xml", "/saml2-metadata-idp-discovery-config.xml", "/saml2-metadata-ui-config.xml", "/saml2-protocol-aslo-config.xml", "/saml2-protocol-thirdparty-config.xml", "/saml2-metadata-query-config.xml", "/saml2-assertion-delegation-restriction-config.xml", "/saml2-ecp-config.xml", "/saml2-channel-binding-config.xml", "/saml-ec-gss-config.xml", "/xacml10-saml2-profile-config.xml", "/xacml11-saml2-profile-config.xml", "/xacml20-context-config.xml", "/xacml20-policy-config.xml", "/xacml2-saml2-profile-config.xml", "/xacml3-saml2-profile-config.xml", "/wsaddressing-config.xml", "/wssecurity-config.xml", "/wstrust-config.xml", "/wspolicy-config.xml"};

    protected MoCustomDefaultBootstrap() {
    }

    public static synchronized void bootstrap() throws ConfigurationException {
        MoCustomDefaultBootstrap.initializeXMLSecurity();
        MoCustomDefaultBootstrap.initializeXMLTooling();
        MoCustomDefaultBootstrap.initializeArtifactBuilderFactories();
        MoCustomDefaultBootstrap.initializeGlobalSecurityConfiguration();
        MoCustomDefaultBootstrap.initializeParserPool();
        MoCustomDefaultBootstrap.initializeHttpClient();
    }

    protected static void initializeHttpClient() {
        if (!Boolean.getBoolean(SYSPROP_HTTPCLIENT_HTTPS_DISABLE_HOSTNAME_VERIFICATION)) {
            TLSProtocolSocketFactory socketFactory = new TLSProtocolSocketFactory(null, null, new StrictHostnameVerifier());
            Protocol.registerProtocol("https", new Protocol("https", (ProtocolSocketFactory)socketFactory, 443));
        }
    }

    protected static void initializeParserPool() throws ConfigurationException {
        StaticBasicParserPool pp = new StaticBasicParserPool();
        pp.setMaxPoolSize(50);
        try {
            pp.initialize();
        }
        catch (XMLParserException e) {
            throw new ConfigurationException("Error initializing parser pool", e);
        }
        Configuration.setParserPool(pp);
    }

    protected static void initializeGlobalSecurityConfiguration() {
        Configuration.setGlobalSecurityConfiguration(DefaultSecurityConfigurationBootstrap.buildDefaultConfig());
    }

    protected static void initializeXMLSecurity() throws ConfigurationException {
        Logger log = MoCustomDefaultBootstrap.getLogger();
        String lineBreakPropName = "org.apache.xml.security.ignoreLineBreaks";
        if (System.getProperty(lineBreakPropName) == null) {
            System.setProperty(lineBreakPropName, "true");
        }
        if (!Init.isInitialized()) {
            log.debug("Initializing Apache XMLSecurity library");
            Init.init();
        }
    }

    protected static void initializeXMLTooling() throws ConfigurationException {
        MoCustomDefaultBootstrap.initializeXMLTooling(xmlToolingConfigs);
    }

    protected static void initializeXMLTooling(String[] providerConfigs) throws ConfigurationException {
        Logger log = MoCustomDefaultBootstrap.getLogger();
        Class<Configuration> clazz = Configuration.class;
        XMLConfigurator configurator = new XMLConfigurator();
        for (String config : providerConfigs) {
            log.debug("Loading XMLTooling configuration {}", (Object)config);
            configurator.load(clazz.getResourceAsStream(config));
        }
    }

    protected static void initializeArtifactBuilderFactories() throws ConfigurationException {
        Logger log = MoCustomDefaultBootstrap.getLogger();
        log.debug("Initializing SAML Artifact builder factories");
        Configuration.setSAML1ArtifactBuilderFactory(new SAML1ArtifactBuilderFactory());
        Configuration.setSAML2ArtifactBuilderFactory(new SAML2ArtifactBuilderFactory());
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(DefaultBootstrap.class);
    }
}

