/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.service.HomeDirectoryService;
import com.atlassian.crowd.service.UserService;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.crowd.MoCrowdUserManager;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoAjaxCallsServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAjaxCallsServlet.class);
    private MoSAMLSettings settings;
    private Boolean userPresent;
    private MoCrowdUserManager crowdUserManager;
    private UserManager userManager;
    @ComponentImport
    private UserService userService;
    @ComponentImport
    private HomeDirectoryService homeDirectoryService;

    @Autowired
    public MoAjaxCallsServlet(MoSAMLSettings samlSettings, UserService userService, HomeDirectoryService homeDirectoryService, MoCrowdUserManager crowdUserManager, UserManager userManager) {
        this.settings = samlSettings;
        this.userService = userService;
        this.homeDirectoryService = homeDirectoryService;
        this.crowdUserManager = crowdUserManager;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("Ajax Servlet doGet Called");
        String action = req.getParameter("action");
        String referer = req.getHeader("referer");
        LOGGER.debug("Referer Header:" + referer);
        String returnTo = req.getParameter("return_to");
        if (StringUtils.contains((CharSequence)returnTo, (CharSequence)"testgroupregex")) {
            this.showTestRegexGroupResult(req, resp);
            return;
        }
        if (StringUtils.isBlank((CharSequence)action)) {
            resp.setContentType("text/html");
            resp.sendError(400, "The requested parameter [action] not found or is empty");
            return;
        }
        UserProfile user = this.userManager.getRemoteUser();
        Boolean isAdmin = Boolean.FALSE;
        if (user != null) {
            isAdmin = this.userManager.isAdmin(user.getUserKey());
        }
        if (isAdmin.booleanValue() || action.equals("checkBackdoorAccess")) {
            switch (action) {
                case "checkBackdoorAccess": {
                    this.checkBackdoorAccess(req, resp);
                    break;
                }
                case "fetchGroups": {
                    this.fetchGroups(req, resp);
                    break;
                }
                case "getIdpList": {
                    this.getIdpList(req, resp);
                    break;
                }
                case "enableDebugLogs": {
                    this.enableDebugLogs(req, resp);
                    break;
                }
                case "downloadCrowdLogs": {
                    this.downloadCrowdLogs(req, resp);
                    break;
                }
                default: {
                    resp.setContentType("text/html");
                    resp.sendError(405, "The requested action is not allowed. Choose valid Action");
                    break;
                }
            }
        } else {
            LOGGER.error("Access Denied. You will need admin privileges to make this API call");
            resp.sendError(403, "Access Denied. You will need admin privileges to make this API call.");
        }
    }

    private void enableDebugLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Boolean enableDebugLogs = BooleanUtils.toBoolean(req.getParameter("enableDebugLogs"));
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("com.miniorange.sso.saml");
        if (enableDebugLogs.booleanValue()) {
            logger.setLevel(Level.DEBUG);
        } else {
            logger.setLevel(Level.INFO);
        }
        this.settings.setEnableDebugLogs(enableDebugLogs);
        this.sendSuccessFullResponse(JSONObject.quote("Changes Successful"), resp);
    }

    public void getIdpList(HttpServletRequest req, HttpServletResponse resp) throws IOException, NullPointerException {
        LOGGER.debug("Ajax Servlet getIdp list");
        ArrayList<String> idpList = this.settings.getIdPList();
        JSONObject result = new JSONObject();
        result.put("idpList", idpList);
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    public void checkBackdoorAccess(HttpServletRequest req, HttpServletResponse resp) throws IOException, NullPointerException {
        LOGGER.debug("Ajax Servlet checkBackdoorAccess Called");
        String username = StringUtils.trim((String)req.getParameter("username"));
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.debug("username empty");
            resp.setContentType("application/json");
            resp.sendError(400, "The username is empty");
            return;
        }
        if (username != null) {
            List<String> groupList = this.settings.getBackdoorGroups();
            JSONObject result = new JSONObject();
            try {
                for (String group : groupList) {
                    if (!this.userService.isUserInGroup(username, group)) continue;
                    this.userPresent = this.userService.isUserInGroup(username, group);
                    this.settings.setUserPresent(this.userPresent);
                    result.put("isUserAllowedBackdoorAccess", this.userPresent);
                    this.sendSuccessFullResponse(result.toString(), resp);
                    return;
                }
            }
            catch (JSONException e) {
                LOGGER.debug("catch");
                e.printStackTrace();
                LOGGER.error("An Error Occurred while checking Backdoor Access for User ", (Throwable)e);
            }
        }
    }

    private void fetchGroups(HttpServletRequest req, HttpServletResponse resp) {
        LOGGER.debug("Ajax Servlet fetchGroup Called");
        try {
            String search = StringUtils.trim((String)req.getParameter("search"));
            if (StringUtils.equalsIgnoreCase((CharSequence)search, (CharSequence)"*")) {
                search = "";
            }
            CrowdService crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)search)).returningAtMost(10);
            LOGGER.debug("query =  " + query);
            Iterable groups = crowdService.search((Query)query);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (Group groupName : groups) {
                HashMap<String, Object> groupResultsMap = new HashMap<String, Object>();
                groupResultsMap.put("id", groupName.getName());
                groupResultsMap.put("text", groupName.getName());
                resultArray.put(groupResultsMap);
            }
            LOGGER.debug("resultArray :" + resultArray.toString());
            data.put("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
    }

    private void downloadCrowdLogs(HttpServletRequest req, HttpServletResponse resp) {
        File dataFolder = new File(this.homeDirectoryService.getLocalHome());
        File logsFolder = null;
        File crowdLogsFile = null;
        try {
            for (File f : dataFolder.listFiles()) {
                if (!f.isDirectory() || !StringUtils.equalsIgnoreCase((CharSequence)f.getName(), (CharSequence)"logs")) continue;
                logsFolder = f;
                break;
            }
            for (File f : logsFolder.listFiles()) {
                if (!f.isFile() || !StringUtils.equalsIgnoreCase((CharSequence)f.getName(), (CharSequence)"atlassian-crowd.log")) continue;
                crowdLogsFile = f;
                break;
            }
            resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-crowd.log\"");
            resp.setHeader("Cache-Control", "max-age=0");
            resp.setHeader("Pragma", "");
            resp.setContentType("text/plain");
            FileUtils.copyFile(crowdLogsFile, (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            LOGGER.error("Error in retrieving the Logs file");
        }
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    public void showTestRegexGroupResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String regexp = request.getParameter("regexp");
        String regexg = request.getParameter("regexg");
        String groupName = request.getParameter("groupName");
        String result = "";
        regexp = StringEscapeUtils.escapeJavaScript(regexp);
        regexg = StringEscapeUtils.escapeJavaScript(regexg);
        groupName = StringEscapeUtils.escapeJavaScript(groupName);
        LOGGER.debug("in show test regex function");
        LOGGER.debug("regexp is" + regexp + " regexq is" + regexg + " group name is =" + groupName);
        if (StringUtils.isNotEmpty((CharSequence)regexg) && StringUtils.isNotEmpty((CharSequence)regexp) && StringUtils.isNotEmpty((CharSequence)groupName)) {
            result = MoCrowdUserManager.getGroupNameFromRegexMethod(regexp, regexg, groupName);
            LOGGER.debug("result of test regex" + result);
        }
        output.append("</div>");
        if (StringUtils.isBlank((CharSequence)regexp) || StringUtils.isBlank((CharSequence)regexg) || StringUtils.isBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            if (StringUtils.isBlank((CharSequence)regexp)) {
                output.append("<li>Regular Expression field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)regexg)) {
                output.append("<li>Replace with field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)groupName)) {
                output.append("<li>Group Name field can't left blank</li><br>");
            }
            output.append("</div>");
        } else if (StringUtils.isNotEmpty((CharSequence)result) && StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Test Regex Result</div>");
            output.append("<table border=\"1\" style=\"width: 100%;\">\n     <tbody><tr>\n        <th>Actual Value</th>\n        <th>Transformed Value</th>\n    </tr>\n    <tr>\n        <td align=\"center\">" + groupName + "</td>\n        <td align=\"center\">" + result + "</td>\n    </tr>    \n    </tbody></table>");
        } else if (StringUtils.isEmpty((CharSequence)result) && StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            output.append("<li>Regex not valid for the group Name.</li><br>");
            output.append("</div>");
        }
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public Boolean getUserPresent() {
        return this.userPresent;
    }

    public void setUserPresent(Boolean userPresent) {
        this.userPresent = userPresent;
    }
}

