/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoAttributeMappingAction
extends BaseAction {
    private static Log LOGGER = LogFactory.getLog(MoAttributeMappingAction.class);
    @ComponentImport
    private I18nHelper i18nHelper;
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private String usernameAttribute;
    private String emailAttribute;
    private String fullNameAttribute;
    private Boolean keepExistingUserAttributes;
    private String firstNameAttribute;
    private String lastNameAttribute;
    private Boolean attributeMappingSubmitted;
    private Boolean reregister;
    private Boolean checklicense;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private String loginUserAttribute;
    private ArrayList userLoginOptions;
    private String idpID;
    private String idpName;
    private Boolean amIdpChanged;
    private String regexPattern;
    private Boolean regexPatternEnabled;
    private HashMap<String, String> idpMap;
    private Map<String, String> customAttributeMapping;
    private String timeDelay;

    @Autowired
    public MoAttributeMappingAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler, I18nHelper i18nHelper) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.i18nHelper = i18nHelper;
    }

    public void validate() {
        LOGGER.info("AttributeMapping Action validate() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.attributeMappingSubmitted)) {
            return;
        }
        if (BooleanUtils.toBoolean((Boolean)this.regexPatternEnabled) && StringUtils.isBlank((CharSequence)this.regexPattern)) {
            this.addActionError(this.i18nHelper.getText("samlsso.error.profile.regex.empty"));
        }
        if (super.hasActionErrors()) {
            this.initializeSAMLConfig();
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.info("AttributeMapping Action execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            HashMap<String, String> customAttributeMapping = new HashMap<String, String>();
            int totalCustomattributes = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("totalCustomattributes"), (CharSequence)"0"));
            for (int i = 0; i < totalCustomattributes; ++i) {
                String key = request.getParameter("attrMappingKey[" + i + "]");
                String value = request.getParameter("attrMappingValue[" + i + "]");
                LOGGER.debug("key : " + key + " Value: " + value);
                if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                customAttributeMapping.put(key.trim(), value.trim());
            }
            if (BooleanUtils.toBoolean((Boolean)this.attributeMappingSubmitted)) {
                this.validate();
                MoPluginHandler.saveAttributeMapping(this.idpID, this.usernameAttribute, this.emailAttribute, this.fullNameAttribute, this.firstNameAttribute, this.lastNameAttribute, this.keepExistingUserAttributes, this.loginUserAttribute, this.regexPatternEnabled, this.regexPattern, customAttributeMapping);
                this.addActionMessage(this.getText("SAML settings updated."));
            }
            if (StringUtils.isBlank((CharSequence)this.idpID)) {
                if (!this.settings.getIdpMap().isEmpty()) {
                    this.idpID = this.settings.getIdPList().get(0);
                } else if (StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                    this.idpID = UUID.randomUUID().toString();
                    this.idpName = "IDP";
                    this.moPluginHandler.replaceOldSettingsWithNew(this.idpID, this.idpName);
                } else {
                    this.initializeNewForm();
                    return "success";
                }
            }
            this.initializeSAMLConfig();
            return "success";
        }
        catch (PluginException e) {
            LOGGER.error("Plugin exceptions occurred while initializing attribute mapping ", e);
            this.addActionError(e.getMessage());
            this.initializeSAMLConfig();
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An error occured while saving your details", e);
            this.addActionError("An error occured while saving your details. Please check logs for more info.");
            this.initializeSAMLConfig();
            return "input";
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeSAMLConfig() {
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.timeDelay = this.settings.getTimeDelay();
        this.usernameAttribute = idpConfig.getUsernameAttribute();
        this.emailAttribute = idpConfig.getEmailAttribute();
        this.fullNameAttribute = idpConfig.getFullNameAttribute();
        this.firstNameAttribute = idpConfig.getFirstNameAttribute();
        this.lastNameAttribute = idpConfig.getLastNameAttribute();
        this.keepExistingUserAttributes = idpConfig.getKeepExistingUserAttributes();
        this.loginUserAttribute = idpConfig.getLoginUserAttribute();
        this.regexPatternEnabled = idpConfig.getRegexPatternEnabled();
        this.regexPattern = idpConfig.getRegexPattern();
        this.customAttributeMapping = new TreeMap<String, String>(idpConfig.getCustomAttributeMapping());
    }

    private void initializeNewForm() {
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.timeDelay = this.settings.getTimeDelay();
        this.usernameAttribute = "NameID";
        this.emailAttribute = "NameID";
        this.fullNameAttribute = "";
        this.firstNameAttribute = "";
        this.lastNameAttribute = "";
        this.keepExistingUserAttributes = true;
        this.loginUserAttribute = this.settings.getLoginUserAttribute();
        this.regexPatternEnabled = this.settings.getRegexPatternEnabled();
        this.regexPattern = this.settings.getRegexPattern();
        this.customAttributeMapping = new HashMap<String, String>(this.settings.getCustomAttributeMapping());
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getPluginHandler() {
        return this.moPluginHandler;
    }

    public void setPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute;
    }

    public Boolean getKeepExistingUserAttributes() {
        return this.keepExistingUserAttributes;
    }

    public void setKeepExistingUserAttributes(Boolean keepExistingUserAttributes) {
        this.keepExistingUserAttributes = keepExistingUserAttributes;
    }

    public String getFirstNameAttribute() {
        return this.firstNameAttribute;
    }

    public void setFirstNameAttribute(String firstNameAttribute) {
        this.firstNameAttribute = firstNameAttribute;
    }

    public String getLastNameAttribute() {
        return this.lastNameAttribute;
    }

    public void setLastNameAttribute(String lastNameAttribute) {
        this.lastNameAttribute = lastNameAttribute;
    }

    public Boolean getAttributeMappingSubmitted() {
        return this.attributeMappingSubmitted;
    }

    public void setAttributeMappingSubmitted(Boolean attributeMappingSubmitted) {
        this.attributeMappingSubmitted = attributeMappingSubmitted;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getChecklicense() {
        return this.checklicense;
    }

    public void setChecklicense(Boolean checklicense) {
        this.checklicense = checklicense;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public String getTimeDelay() {
        return this.timeDelay;
    }

    public void setTimeDelay(String timeDelay) {
        this.timeDelay = timeDelay;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public String getIdpID() {
        return this.idpID;
    }

    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public Boolean getAmIdpChanged() {
        return this.amIdpChanged;
    }

    public void setAmIdpChanged(Boolean amIdpChanged) {
        this.amIdpChanged = amIdpChanged;
    }

    public HashMap<String, String> getIdpMap() {
        this.idpMap = this.settings.getIdpMap();
        return this.idpMap;
    }

    public void setIdpMap(HashMap<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    public String getLoginUserAttribute() {
        return this.loginUserAttribute;
    }

    public void setLoginUserAttribute(String loginUserAttribute) {
        this.loginUserAttribute = loginUserAttribute;
    }

    public ArrayList getUserLoginOptions() {
        this.userLoginOptions = new ArrayList();
        this.userLoginOptions.add("username");
        this.userLoginOptions.add("email");
        return this.userLoginOptions;
    }

    public void setUserLoginOptions(ArrayList userLoginOptions) {
        this.userLoginOptions = userLoginOptions;
    }

    public Boolean getNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setNoOfUserExceed(Boolean noOfUserExceed) {
        this.isNoOfUserExceed = noOfUserExceed;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public Boolean getRegexPatternEnabled() {
        return this.regexPatternEnabled;
    }

    public void setRegexPatternEnabled(Boolean regexPatternEnabled) {
        this.regexPatternEnabled = regexPatternEnabled;
    }

    public Map<String, String> getCustomAttributeMapping() {
        return this.customAttributeMapping;
    }

    public void setCustomAttributeMapping(Map<String, String> customAttributeMapping) {
        this.customAttributeMapping = customAttributeMapping;
    }
}

