/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.MoConfigAjaxAttributes;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoGetConfigurationServlet
extends HttpServlet {
    private MoSAMLSettings settings;
    @ComponentImport
    private CrowdLicenseManager crowdLicenseManager;
    private PropertyManager propertyManager;
    private static Log LOGGER = LogFactory.getLog(MoGetConfigurationServlet.class);

    @Autowired
    public MoGetConfigurationServlet(MoSAMLSettings settings, CrowdLicenseManager crowdLicenseManager, PropertyManager propertyManager) {
        this.settings = settings;
        this.crowdLicenseManager = crowdLicenseManager;
        this.propertyManager = propertyManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("MoGetConfigurationServlet : doGet called.");
        if (this.settings.isCustomerRegistered().booleanValue() && this.settings.getLicenseVerified().booleanValue()) {
            if (this.settings.isTrialLicense().booleanValue() && !this.settings.isLicenseExpired().booleanValue()) {
                LOGGER.debug("Trial license is activated but not expired");
                this.getConfiguration(request, response);
            } else if (!this.settings.isTrialLicense().booleanValue()) {
                LOGGER.debug("Premium license is activated");
                this.getConfiguration(request, response);
            }
        }
    }

    public void getConfiguration(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("MoGetConfigurationServlet : getConfiguration called. ");
        try {
            Integer licencedUsers = this.settings.getLicencedUsers();
            int crowdUserTier = this.propertyManager.getCurrentLicenseResourceTotal();
            LOGGER.debug("licencedUsers " + licencedUsers + " crowdUserTier : " + crowdUserTier);
            Boolean isConfigured = false;
            if (this.settings.isNoOfUserExceed().booleanValue() && !this.settings.isTrialLicense().booleanValue()) {
                LOGGER.error("No of user in Crowd is exceeded. Please upgrade you miniOrange license user tier");
                isConfigured = Boolean.FALSE;
            }
            Boolean canUserSaveDetails = false;
            if (this.settings.getIdpMap().size() > 0 || StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                canUserSaveDetails = true;
                isConfigured = true;
            }
            Boolean sloConfigured = StringUtils.isNotBlank((CharSequence)this.settings.getSloServiceUrl());
            Boolean disableDefaultLogin = this.settings.getDefaultLoginDisabled();
            Boolean autoActivateUser = this.settings.getAutoActivateUser();
            Boolean backdoorEnabled = this.settings.getBackdoorEnabled();
            HashMap<String, String> idpMap = this.settings.getIdpMap();
            ArrayList<String> idpList = this.settings.getIdPList();
            Boolean restrictBackdoor = this.settings.getRestrictBackdoor();
            Boolean useDomainMapping = this.settings.getUseDomainMapping() != false && idpList.size() > 1;
            MoConfigAjaxAttributes attrs = new MoConfigAjaxAttributes(isConfigured, this.settings.getLoginButtonText(), sloConfigured, disableDefaultLogin, backdoorEnabled, canUserSaveDetails, idpMap, idpList, useDomainMapping, autoActivateUser, restrictBackdoor);
            String attrsJSON = attrs.getJSON();
            response.setContentType("application/json");
            response.getOutputStream().write(attrsJSON.getBytes("UTF-8"));
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Error occured while getting plugin's configuration and the error message is: " + e);
        }
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public CrowdLicenseManager getCrowdLicenseManager() {
        return this.crowdLicenseManager;
    }

    public void setCrowdLicenseManager(CrowdLicenseManager crowdLicenseManager) {
        this.crowdLicenseManager = crowdLicenseManager;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }
}

