/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.net.URI;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoImportExportAction
extends BaseAction {
    private static Log LOGGER = LogFactory.getLog(MoImportExportAction.class);
    private MoSAMLSettings settings;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private Boolean importFileSubmitted;

    @Autowired
    public MoImportExportAction(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public Boolean doValidate() {
        LOGGER.debug("MoImportExportAction: doValidate() called");
        return true;
    }

    public String execute() throws Exception {
        LOGGER.debug("MoImportExportAction execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            LOGGER.debug("MoImportExportAction execute submitted: " + this.importFileSubmitted);
            if (MoSAMLSettings.isPluginConfigurationFileUploaded.booleanValue()) {
                MoSAMLSettings.isPluginConfigurationFileUploaded = Boolean.FALSE;
                if (StringUtils.isNotBlank(this.settings.getSpConfigurationStatus())) {
                    if (StringUtils.equalsIgnoreCase(this.settings.getSpConfigurationStatus(), "success")) {
                        this.addActionMessage(this.getText("SAML settings updated"));
                    } else {
                        this.addActionError(this.settings.getSpConfigurationStatus());
                    }
                }
            }
            this.initializeNewForm();
            return "success";
        }
        catch (Exception e) {
            LOGGER.error("An plugin exception occurred while initializing download app settings", e);
            this.addActionError(e);
            this.initializeNewForm();
            return "input";
        }
    }

    private void initializeNewForm() {
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public Boolean getImportFileSubmitted() {
        return this.importFileSubmitted;
    }

    public void setImportFileSubmitted(Boolean importFileSubmitted) {
        this.importFileSubmitted = importFileSubmitted;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }
}

