/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLManager;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoEncryptionUtils;
import java.io.IOException;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoSAMLLogoutServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoSAMLLogoutServlet.class);
    private MoSAMLSettings settings;
    private MoSAMLManager samlManager;
    private MoPluginHandler moPluginHandler;

    @Autowired
    public MoSAMLLogoutServlet(MoSAMLSettings settings, MoSAMLManager samlManager, MoPluginHandler moPluginHandler) {
        this.settings = settings;
        this.samlManager = samlManager;
        this.moPluginHandler = moPluginHandler;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info("SAML Logout :doGet called");
        String redirectURL = request.getParameter("conn_redirect_url");
        if (StringUtils.isNotBlank((CharSequence)redirectURL)) {
            Cookie cookie = new Cookie("redirectURL", redirectURL);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
        this.handleSAMLLogout(request, response, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info("SAML Logout :doPost called");
        Cookie redirectURL = this.getCookie(request, "redirectURL");
        if (redirectURL != null) {
            String sloRedirect = redirectURL.getValue();
            this.clearCookie(request, response, "redirectURL");
            LOGGER.debug("Redirecting to  : " + sloRedirect);
            response.sendRedirect(sloRedirect);
            return;
        }
        this.handleSAMLLogout(request, response, true);
    }

    private void handleSAMLLogout(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest) throws IOException {
        LOGGER.info("SAML Logout : handleSAMLLogout called");
        Cookie logoutcookie = this.getCookie(request, "samlsso_idp.key");
        String idpId = "";
        if (logoutcookie != null) {
            idpId = logoutcookie.getValue();
        }
        LOGGER.debug("IDP ID= " + idpId);
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpId);
        this.clearCookie(request, response, "samlsso_idp.key");
        if (idpConfig != null && this.settings.isCustomerRegistered().booleanValue() && StringUtils.isNotBlank((CharSequence)idpConfig.getSloUrl())) {
            LOGGER.debug("SAML Logout :customer is registered and slo configured");
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("SAMLRequest"))) {
                try {
                    LOGGER.debug("SAML Logout :logout request");
                    this.samlManager.createLogoutResponseAndRedirect(request, response, isPostRequest, idpConfig);
                    return;
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while executing logout request and redirecting", (Throwable)e);
                }
            } else {
                Cookie cookie = this.getCookie(request, "SAMLCOOKIE");
                if (cookie != null) {
                    LOGGER.debug("SAML Cookie found");
                    String decryptedCookie = MoEncryptionUtils.decrypt(this.settings.getCustomerTokenKey(), cookie.getValue());
                    String[] samlValues = StringUtils.split((String)decryptedCookie, (String)"::");
                    String nameId = samlValues[0];
                    String sessionIndex = samlValues[1];
                    this.clearCookie(request, response, "SAMLCOOKIE");
                    this.samlManager.createLogoutRequestAndRedirect(request, response, nameId, sessionIndex, idpConfig);
                    return;
                }
            }
        } else if (idpConfig != null && StringUtils.isBlank((CharSequence)idpConfig.getSloUrl())) {
            LOGGER.debug("SLO url is not configured for IDP");
            this.clearCookie(request, response, "SAMLCOOKIE");
        }
        this.clearCookie(request, response, "SAMLCOOKIE");
        response.sendRedirect(this.settings.getLoginPageUrl());
    }

    public void clearCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = this.getCookie(request, cookieName);
        if (cookie != null) {
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }
}

