/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.crowd.MoPluginConfigurationsHandler;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.xml.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoConfigurePluginServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoConfigurePluginServlet.class);
    private MoSAMLSettings settings;
    private MoPluginConfigurationsHandler pluginConfigurationsHandler;
    private MoPluginHandler pluginHandler;
    @ComponentImport
    private UserManager userManager;

    @Autowired
    public MoConfigurePluginServlet(MoSAMLSettings settings, MoPluginConfigurationsHandler pluginConfigurationsHandler, UserManager userManager, MoPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginConfigurationsHandler = pluginConfigurationsHandler;
        this.userManager = userManager;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block12: {
            LOGGER.info("Configure Plugin servlet called from doGet");
            Enumeration headerNames = request.getHeaderNames();
            String key = "";
            String value = "";
            String username = "";
            String pwd = "";
            Boolean isAdmin = Boolean.FALSE;
            while (headerNames.hasMoreElements()) {
                try {
                    key = (String)headerNames.nextElement();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"Authorization", (CharSequence)key)) continue;
                    value = request.getHeader(key);
                    value = value.split(" ")[1];
                    byte[] valueDecoded = Base64.decode(value);
                    value = new String(valueDecoded);
                    String[] arr = value.split(":");
                    username = arr[0];
                    pwd = arr[1];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOGGER.error("Something went wrong while fetching username and password. " + e);
                }
            }
            UserProfile user = null;
            if (StringUtils.isNotBlank((CharSequence)username) || StringUtils.isNotEmpty((CharSequence)username)) {
                user = this.userManager.getUserProfile(username);
            }
            if (user != null) {
                LOGGER.debug("User exist with username : " + username);
                if (BooleanUtils.toBoolean((Boolean)this.userManager.authenticate(username, pwd))) {
                    isAdmin = this.userManager.isAdmin(user.getUserKey()) || this.userManager.isSystemAdmin(user.getUserKey());
                } else {
                    this.showErrorMessage(response, "Basic Authentication Failed", "Authentication with the provided credentials failed. It may indicate that the user does not exist or the user's account is inactive or the credentials are incorrect");
                    isAdmin = Boolean.FALSE;
                }
            }
            if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
                try {
                    if (this.settings.getLicenseVerified().booleanValue()) {
                        String jsonConfigurations = this.pluginConfigurationsHandler.generateConfigurationsJson();
                        response.setHeader("Cache-Control", "max-age=0");
                        response.setHeader("Pragma", "");
                        response.setContentType("application/json");
                        response.getOutputStream().write(jsonConfigurations.getBytes());
                        break block12;
                    }
                    this.showErrorMessage(response, "Your License has expired", "Please renew the license to use the API Call.");
                }
                catch (JSONException e) {
                    LOGGER.error("An error occurred while fetching the json." + e);
                }
            } else {
                this.showErrorMessage(response, "Access Denied", "App Configurations can be accessed only by administrators.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block26: {
            LOGGER.info("Configure Plugin servlet called from doPost");
            Enumeration headerNames = request.getHeaderNames();
            String key = "";
            String value = "";
            Boolean isAdmin = Boolean.FALSE;
            String username = "";
            String pwd = "";
            while (headerNames.hasMoreElements()) {
                try {
                    key = (String)headerNames.nextElement();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"Authorization", (CharSequence)key)) continue;
                    value = request.getHeader(key);
                    value = value.split(" ")[1];
                    byte[] valueDecoded = Base64.decode(value);
                    value = new String(valueDecoded);
                    String[] arr = value.split(":");
                    username = arr[0];
                    pwd = arr[1];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOGGER.error("Something went wrong while fetching username and password." + e);
                }
            }
            UserProfile user = null;
            if (StringUtils.isNotBlank((CharSequence)username) || StringUtils.isNotEmpty((CharSequence)username)) {
                user = this.userManager.getUserProfile(username);
            }
            if (user != null) {
                LOGGER.debug("User exist with username : " + username);
                if (BooleanUtils.toBoolean((Boolean)this.userManager.authenticate(username, pwd))) {
                    isAdmin = this.userManager.isAdmin(user.getUserKey()) || this.userManager.isSystemAdmin(user.getUserKey());
                } else {
                    this.showErrorMessage(response, "Basic Authentication Failed", "Authentication with the provided credentials failed. It may indicate that the user does not exist or the user's account is inactive or the credentials are incorrect");
                    isAdmin = Boolean.FALSE;
                }
            }
            if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
                StringBuffer sb = new StringBuffer();
                try (BufferedReader bufferedReader = null;){
                    int bytesRead;
                    bufferedReader = request.getReader();
                    char[] charBuffer = new char[128];
                    while ((bytesRead = bufferedReader.read(charBuffer)) != -1) {
                        sb.append(charBuffer, 0, bytesRead);
                    }
                }
                try {
                    if (this.settings.getLicenseVerified().booleanValue()) {
                        this.pluginHandler.stopAllSchedulers();
                        this.settings.clearPluginSettings();
                        MoPluginConfigurationsHandler.importPluginConfigurations(sb.toString());
                        this.showSuccessMessage(response, "SAML settings updated", "SAML App Configured successfully.");
                        break block26;
                    }
                    this.showErrorMessage(response, "Your License has expired", " Please renew the license to use the API Call.");
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while importing the configuration. ", e);
                }
            } else {
                this.showErrorMessage(response, "Access Denied", "App Configurations can be accessed only by administrators.");
            }
        }
    }

    private void showErrorMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "ERROR");
            json.put("Message", message);
            json.put("Description", description);
            response.setStatus(401);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred. ", e);
        }
    }

    private void showSuccessMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "SUCCESS");
            json.put("Message", message);
            json.put("Description", description);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred. ", e);
        }
    }
}

