/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.Customer;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.opensymphony.xwork2.Validateable;
import java.net.URI;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoCustomerLoginAction
extends BaseAction
implements Validateable {
    private static Log LOGGER = LogFactory.getLog(MoCustomerLoginAction.class);
    @ComponentImport
    private I18nHelper i18nHelper;
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private String email;
    private String password;
    private Boolean submitted;

    @Autowired
    public MoCustomerLoginAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler, I18nHelper i18nHelper) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.i18nHelper = i18nHelper;
    }

    public void validate() {
        LOGGER.info("Register Action validate");
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.email)) {
            this.addActionError(this.i18nHelper.getText("samlsso.error.register.email.empty"));
        }
        if (StringUtils.isBlank((CharSequence)this.password)) {
            this.addActionError(this.i18nHelper.getText("samlsso.error.register.password.empty"));
        }
    }

    public String execute() throws Exception {
        LOGGER.info("Login action execute submitted");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (this.settings.isCustomerRegistered().booleanValue()) {
            LOGGER.debug("customer is registered, redirecting to the configure action");
            return "redirect";
        }
        if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
            this.validate();
            try {
                try {
                    Customer customer = this.moPluginHandler.fetchCustomer(this.email, this.password);
                    this.settings.setCustomerId(customer.getCustomerId().toString());
                    this.settings.setCustomerEmail(customer.getEmail());
                    this.settings.setCustomerAPIKey(customer.getApiKey());
                    this.settings.setCustomerTokenKey(customer.getTokenKey());
                    return "verifylicense";
                }
                catch (MoPluginException e) {
                    this.addActionError("Invalid username and password.");
                    return "input";
                }
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while verifying account details", e);
                this.addActionError("An unknown error occured. Please check logs and contact us at support-atlassian@miniorange.atlassian.net.");
                return "error";
            }
        }
        return "input";
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }
}

