/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoCustomCertificatesAction
extends BaseAction {
    private static Log LOGGER = LogFactory.getLog(MoCustomCertificatesAction.class);
    @ComponentImport
    private I18nHelper i18nHelper;
    private MoSAMLSettings settings;
    private MoPluginHandler pluginHandler;
    private String publicSPCertificate;
    private String privateSPCertificate;
    private Boolean certificateSubmitted;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private String emailAdsress;
    private String companyName;
    private String orgUnit;
    private String locationName;
    private String countryCode;
    private String validityDays;

    @Autowired
    public MoCustomCertificatesAction(MoSAMLSettings settings, MoPluginHandler pluginHandler, I18nHelper i18nHelper) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.i18nHelper = i18nHelper;
    }

    public void validate() {
        if (BooleanUtils.toBoolean((Boolean)this.certificateSubmitted)) {
            if (StringUtils.isBlank((CharSequence)this.privateSPCertificate) || StringUtils.isBlank((CharSequence)this.publicSPCertificate)) {
                LOGGER.info("SP Certificate missing. Setting SP Certificate to default");
                this.addActionError(this.i18nHelper.getText("samlsso.error.certificate.public.cert.invalid"));
            }
            if (!StringUtils.isBlank((CharSequence)this.publicSPCertificate) && !MoSAMLUtils.isValidPublicCertificate(this.publicSPCertificate).booleanValue()) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.certificate.public.cert.invalid"));
            }
            if (!StringUtils.isBlank((CharSequence)this.privateSPCertificate) && !MoSAMLUtils.isValidPrivateCertificate(this.privateSPCertificate).booleanValue()) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.certificate.private.cert.invalid"));
            }
        }
        if (super.hasActionErrors()) {
            this.initializeSAMLConfig();
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.info("Custom certificate Action execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            String operation = request.getParameter("operation");
            if ("updated".equalsIgnoreCase(operation)) {
                this.addActionMessage(this.getText("Public and Private Certificate updated"));
            }
            if (BooleanUtils.toBoolean((Boolean)this.certificateSubmitted)) {
                this.validate();
                this.pluginHandler.saveSPCertificates(this.publicSPCertificate, this.privateSPCertificate);
                this.addActionMessage(this.getText("SAML settings updated."));
            }
            this.initializeSAMLConfig();
            return "success";
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving your details", e);
            this.addActionError("An error occurred while saving your details. Please check logs for more info.");
            return "input";
        }
    }

    private void initializeSAMLConfig() {
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.publicSPCertificate = this.settings.getPublicSPCertificate();
        this.privateSPCertificate = this.settings.getPrivateSPCertificate();
        this.emailAdsress = "";
        this.companyName = "";
        this.orgUnit = "";
        this.locationName = "";
        this.countryCode = "";
        this.validityDays = "";
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public String getPublicSPCertificate() {
        return this.publicSPCertificate;
    }

    public void setPublicSPCertificate(String publicSPCertificate) {
        this.publicSPCertificate = publicSPCertificate;
    }

    public String getPrivateSPCertificate() {
        return this.privateSPCertificate;
    }

    public void setPrivateSPCertificate(String privateSPCertificate) {
        this.privateSPCertificate = privateSPCertificate;
    }

    public Boolean getCertificateSubmitted() {
        return this.certificateSubmitted;
    }

    public void setCertificateSubmitted(Boolean certificateSubmitted) {
        this.certificateSubmitted = certificateSubmitted;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public String getEmailAdsress() {
        return this.emailAdsress;
    }

    public void setEmailAdsress(String emailAdsress) {
        this.emailAdsress = emailAdsress;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getValidityDays() {
        return this.validityDays;
    }

    public void setValidityDays(String validityDays) {
        this.validityDays = validityDays;
    }
}

