/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.MoSAMLResponse;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Named
public class MoCrowdSessionManager {
    private static Log LOGGER = LogFactory.getLog(MoCrowdSessionManager.class);
    private MoSAMLSettings settings;
    @ComponentImport
    private ApplicationService applicationService;
    @ComponentImport
    private ApplicationManager applicationManager;
    @ComponentImport
    private PropertyManager propertyManager;
    @ComponentImport
    private TokenAuthenticationManager tokenAuthenticationManager;
    private DirectoryManager directoryManager;
    private long directoryId;

    @Autowired
    public MoCrowdSessionManager(MoSAMLSettings settings, ApplicationService applicationService, ApplicationManager applicationManager, PropertyManager propertyManager, TokenAuthenticationManager tokenAuthenticationManager, DirectoryManager directoryManager) {
        this.settings = settings;
        this.applicationService = applicationService;
        this.applicationManager = applicationManager;
        this.propertyManager = propertyManager;
        this.tokenAuthenticationManager = tokenAuthenticationManager;
        this.directoryManager = directoryManager;
    }

    public void createUserSession(String username, HttpServletRequest request, HttpServletResponse response, MoSAMLResponse samlResponse, Boolean applicationGroupEnrollment) {
        block13: {
            LOGGER.debug("MoCrowdSessionManager: MoCrowdSessionManager called");
            try {
                CookieConfiguration cookieConfiguration = this.propertyManager.getCookieConfiguration();
                String ssoDomain = StringUtils.isNotBlank((CharSequence)cookieConfiguration.getDomain()) ? cookieConfiguration.getDomain() : "";
                String crowdSSOCookieName = this.getSSOCookieName(cookieConfiguration);
                String relayState = samlResponse.getRelayStateURL();
                if (!relayState.startsWith("http") && !relayState.startsWith("/")) {
                    relayState = "/" + relayState;
                }
                if (!relayState.startsWith("http")) {
                    relayState = this.settings.getSpBaseUrl().concat(relayState);
                }
                URL url = new URL(relayState);
                String domain = url.getProtocol() + "://" + url.getAuthority();
                LOGGER.debug("Application Domain Name=" + domain);
                Application app = this.getUserApplicationFromRelayState(username, domain);
                String crowdToken = this.getCrowdSessiontoken(username, request, app);
                Boolean setSecureCookie = cookieConfiguration.isSecure();
                LOGGER.debug("crowdToken = " + crowdToken);
                if (crowdToken != null) {
                    LOGGER.debug("setting crowd token in request and cookies = " + crowdToken);
                    request.setAttribute(crowdSSOCookieName, (Object)crowdToken);
                    Cookie ssoCookie = new Cookie(crowdSSOCookieName, crowdToken);
                    ssoCookie.setPath("/");
                    if (setSecureCookie.booleanValue()) {
                        ssoCookie.setSecure(Boolean.TRUE.booleanValue());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)ssoDomain)) {
                        LOGGER.debug("Setting up crowd token in SSO Domain = " + ssoDomain);
                        ssoCookie.setDomain(ssoDomain);
                    } else {
                        LOGGER.debug("SSO Domain is not configured");
                    }
                    response.addCookie(ssoCookie);
                    String twoFAEncryptedKey = MoCrowdSessionManager.encryptString(username, crowdToken + ":" + this.settings.getSecretKey());
                    if (twoFAEncryptedKey != null) {
                        Cookie twoFACookie = new Cookie("crowd.saml.2fa_token", twoFAEncryptedKey);
                        twoFACookie.setPath("/");
                        if (setSecureCookie.booleanValue()) {
                            twoFACookie.setSecure(Boolean.TRUE.booleanValue());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)ssoDomain)) {
                            LOGGER.debug("Setting 2FA token in SSO Domain = " + ssoDomain);
                            twoFACookie.setDomain(ssoDomain);
                        }
                        response.addCookie(twoFACookie);
                    }
                    if (applicationGroupEnrollment.booleanValue()) {
                        this.fireApplicationBasedGroupEnrollment(username, app);
                    }
                    break block13;
                }
                MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.UNKNOWN;
                MoSAMLException samlException = new MoSAMLException(errorCode.getMessage(), null, errorCode);
                LOGGER.error("An exception occurs while creating the user session");
                throw samlException;
            }
            catch (MoSAMLException e) {
                LOGGER.error(e.getMessage(), e);
                throw e;
            }
            catch (Throwable e) {
                LOGGER.error("An error occurred while creating the user session.", e);
                throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
            }
        }
    }

    public String getCrowdSessiontoken(String username, HttpServletRequest request, Application application) throws URISyntaxException {
        LOGGER.debug("Getting Crowd SESSION Token");
        try {
            Token crowdToken = null;
            UserAuthenticationContext userAuthContext = new UserAuthenticationContext();
            userAuthContext.setApplication(application.getName());
            userAuthContext.setName(username);
            userAuthContext.setCredential(new PasswordCredential("", false));
            if (request.getHeader("X-Forwarded-For") == null) {
                ValidationFactor[] factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr())};
                userAuthContext.setValidationFactors(factors);
            } else {
                ValidationFactor[] factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr()), new ValidationFactor("X-Forwarded-For", request.getHeader("X-Forwarded-For"))};
                userAuthContext.setValidationFactors(factors);
            }
            LOGGER.debug("User Authentication context: " + userAuthContext.toString());
            crowdToken = this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(application, userAuthContext);
            this.directoryId = crowdToken.getDirectoryId();
            LOGGER.debug("Crowd User Token : " + crowdToken.toString());
            return crowdToken.getRandomHash();
        }
        catch (Exception e) {
            LOGGER.debug("An exception occurs while getting session token for the user : " + username);
            LOGGER.error("An error occurs while getting session token", e);
            return null;
        }
    }

    public String getSSOCookieName(CookieConfiguration cookieConfiguration) {
        String ssoCookieName = "";
        ssoCookieName = cookieConfiguration.getName();
        if (StringUtils.isEmpty((CharSequence)ssoCookieName)) {
            LOGGER.debug("Crowd cookies is not configured. using default one.");
            ssoCookieName = "crowd.token_key";
        }
        LOGGER.debug("Crowd SSO cookie name : " + ssoCookieName);
        return ssoCookieName;
    }

    public static String encryptString(String toEncrypt, String twoFAKey) {
        try {
            SecretKeySpec secretKey = MoCrowdSessionManager.getSecretKey(twoFAKey);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(toEncrypt.getBytes("UTF-8")));
        }
        catch (Exception e) {
            LOGGER.debug("Error while encrypting: " + e.toString());
            return null;
        }
    }

    public static SecretKeySpec getSecretKey(String myKey) {
        SecretKeySpec secretKey = null;
        MessageDigest sha = null;
        try {
            byte[] key = myKey.getBytes("UTF-8");
            sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, "AES");
            return secretKey;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void fireApplicationBasedGroupEnrollment(String username, Application app) {
        try {
            LOGGER.debug("Application Domain Name=" + app);
            EventPublisher eventPublisher = (EventPublisher)ComponentLocator.getComponent(EventPublisher.class);
            Directory userDirectory = this.directoryManager.findDirectoryById(this.directoryId);
            User user = this.directoryManager.findUserByName(this.directoryId, username);
            if (app != null) {
                eventPublisher.publish((Object)new UserAuthenticatedEvent(ApplicationService.class, userDirectory, app, user));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while publishing user authenticated event:", e);
        }
    }

    public Application getUserApplicationFromRelayState(String userName, String domain) throws ApplicationNotFoundException {
        try {
            Application defaultApp = this.applicationManager.findByName("crowd");
            String crowdAppUrl = this.settings.getSpBaseUrl();
            LOGGER.debug("DefaultApp is: " + defaultApp.getName());
            LOGGER.debug("crowdAppUrl  is: " + crowdAppUrl);
            if (crowdAppUrl != null && (domain.contains(crowdAppUrl) || crowdAppUrl.contains(domain) || defaultApp.getRemoteAddresses().toString().contains(domain)) && this.applicationService.isUserAuthorised(defaultApp, userName)) {
                if (Boolean.parseBoolean((String)defaultApp.getAttributes().get("insecureAuthenticationEnabled"))) {
                    LOGGER.debug("Authenticating App is: " + defaultApp.getName());
                    LOGGER.debug("App=" + defaultApp.getName() + " is user allowed=" + this.applicationService.isUserAuthorised(defaultApp, userName));
                    return defaultApp;
                }
                LOGGER.debug("Authentication without validating password is disabled for " + defaultApp.getName() + " app.");
            }
            List appList = this.applicationManager.findAll();
            for (Application app : appList) {
                String applicationUrl = (String)app.getAttributes().get("applicationURL");
                LOGGER.debug("Application URL==" + applicationUrl);
                LOGGER.debug("All remote app addresses = " + app.getRemoteAddresses().toString());
                if (applicationUrl == null || !domain.contains(applicationUrl) && !applicationUrl.contains(domain) && !app.getRemoteAddresses().toString().contains(domain) || !this.applicationService.isUserAuthorised(app, userName)) continue;
                if (Boolean.parseBoolean((String)app.getAttributes().get("insecureAuthenticationEnabled"))) {
                    LOGGER.debug("Authenticating App is: " + defaultApp.getName());
                    LOGGER.debug("App=" + app.getName() + " is user allowed=" + this.applicationService.isUserAuthorised(defaultApp, userName));
                    return app;
                }
                LOGGER.debug("Authentication without validating password is disabled for " + app.getName() + " app.");
            }
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while fetching application", e);
        }
        return this.applicationManager.findByName("crowd");
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }
}

