<html>
    <head>
        <meta name="decorator" content="atl.general"/>
        <#if roleMapping.isEmpty()>
            <#assign count = existingGroups.size()>
        <#else>
            <#assign count = roleMapping.keySet().size()>
        </#if>
        <#assign groups = existingGroups>
        <#assign idpCount = idpMap.size()>

        <script>
            AJS.$(document).ready(function() {
	            AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	            AJS.$("#GROUPMAPPINGCONFIG").addClass("aui-nav-selected");
                AJS.$('#defaultDirectory').auiSelect2();
                AJS.$("#defaultGroups").auiSelect2({
                    placeholder: 'Select the Default Crowd Groups',
                        ajax: {
                            url: AJS.contextPath() + '/plugins/servlet/saml/moapi',
                            data: function (params) {
                                var query = {
                                search: params,
                                action: 'fetchGroups'
                                }
                            return query;
                            },
                            results: function (data, page) {
                                return {
                                    results: data.results
                                };
                            },
                        },
                        multiple: true
                });
                var defaultGroups = [];
                <#foreach group in defaultGroupsList >
                var groupName = "${group}";
                defaultGroups.push({
                    "id": groupName,
                    "text": groupName
                });
                </#foreach>
                AJS.$("#defaultGroups").auiSelect2('data', defaultGroups);
                AJS.$("#onTheFlyDoNotRemoveGroups").auiSelect2({
                    placeholder: 'Select Crowd Group',
                        ajax: {
                            url: AJS.contextPath() + '/plugins/servlet/saml/moapi',
                            data: function (params) {
                                var query = {
                                    search: params,
                                    action: 'fetchGroups'
                                }
                                return query;
                                },
                                results: function (data, page) {
                                    return {
                                        results: data.results
                                    };
                                },
                            },
                            multiple: true
                });
                var doNotRemoveGroups = [];
                <#foreach group in onTheFlyDoNotRemoveGroupsList >
                var groupName = "${group}";
                doNotRemoveGroups.push({
                    "id": groupName,
                    "text": groupName
                });
                </#foreach>
                AJS.$("#onTheFlyDoNotRemoveGroups").auiSelect2('data', doNotRemoveGroups);

                var cnt = ${count};
                document.getElementById("idTotalNumberOfRoles").value = cnt;

                for(var i=0;i<cnt;i++){
                    AJS.$('#userGroupKey_'+i).auiSelect2({
                        placeholder: 'Select Crowd Group',
                            ajax: {
                                url: AJS.contextPath() + '/plugins/servlet/saml/moapi',
                                data: function (params) {
                                    var query = {
                                        search: params,
                                        action: 'fetchGroups'
                                    }
                                    return query;
                                },
                                results: function (data, page) {
                                return {
                                    results: data.results
                                };
                            },
                        }
                    });
                    AJS.$("#userGroupKey_" + i).auiSelect2('data', {
                        id: AJS.$("#userGroupKey_" + i).val(),
                        text: AJS.$("#userGroupKey_" + i).val()
                        });
                    }
	            var e = document.getElementById("gmIdpName");
                	            if (e.options[e.selectedIndex] != undefined) {
                                    var idpNm = e.options[e.selectedIndex].text;
                                    var idpCnt = ${idpCount};
                                    if(idpCnt > 1) {
                                        AJS.flag({
                                            title: 'SAML IDP Configuration',
                                            type: 'info',
                                            close: 'auto',
                                            body: '<p>Now viewing ' + idpNm + '\'s settings</p>'
                                        });
                                    }
                                }
                if (AJS.$("#groupRegexPatternEnabled").is(":checked")) {
                    AJS.$("#groupRegexfield").show();
                    AJS.$("#regexPatternForGroup").prop("required", true);
                    AJS.$("#regexGroups").prop("required", true);
                } else {
                    AJS.$("#groupRegexfield").hide();
                    AJS.$("#regexPatternForGroup").prop("required", false);
                    AJS.$("#regexGroups").prop("required", false);
                }

                AJS.$("#groupRegexPatternEnabled").change(function () {
                    if (this.checked) {
                        AJS.$("#groupRegexfield").show();
                        AJS.$("#regexPatternForGroup").prop("required", true);
                        AJS.$("#regexGroups").prop("required", true);
                    } else {
                        AJS.$("#groupRegexfield").hide();
                        AJS.$("#regexPatternForGroup").prop("required", false);
                        AJS.$("#regexGroups").prop("required", false);
                    }
                });
                AJS.$("#test-group-regex").click(function () {
                    var osDestination = "testgroupregex";
                    var value=AJS.$("#testRegex").val();
                    var testUrl = AJS.contextPath() + '/plugins/servlet/saml/moapi';
                    testUrl += "?return_to=" + encodeURIComponent(osDestination) + "&regexp=" +
                    encodeURIComponent(AJS.$("#regexPatternForGroup").val())+"&regexg="+
                    encodeURIComponent(AJS.$("#regexGroups").val())+"&groupName="+
                    encodeURIComponent(AJS.$("#testRegex").val());
                    var testWindow = window.open(testUrl, "", "width=600,height=400");
            });
            check();
        	});

        AJS.$(document).on('click', '#group-mapping-pill', function () {
        AJS.$('#group-mapping-pill').attr("class", "active");
        AJS.$("#on-the-fly-group-mapping-pill").removeClass("active");
        check();
        });

        AJS.$(document).on('click', '#on-the-fly-group-mapping-pill', function () {
        AJS.$('#on-the-fly-group-mapping-pill').attr("class", "active");
        AJS.$("#group-mapping-pill").removeClass("active");
        check();
        });
        AJS.$(document).on('change', '#onTheFlyFilterIDPGroupsOption', function () {
            if(AJS.$("#onTheFlyFilterIDPGroupsOption").val()=="None"){
            AJS.$("#onTheFlyFilterIDPGroupsKey").hide();
            AJS.$("#onTheFlyGroupRegexDescription").hide();
            }else{
            AJS.$("#onTheFlyFilterIDPGroupsKey").show();
            AJS.$("#onTheFlyGroupRegexDescription").show();
            }
        });

        function check() {
            var groupMappingClass = document.getElementById("group-mapping-pill").getAttribute("class");
            
            if (groupMappingClass == "active") {
                document.getElementById("onthefly-group-mapping-instructions-div").style.display = "none";
                document.getElementById("onTheFlyGroupMappingDiv").style.display = "none";
                document.getElementById("onTheFlyAssignNewGroupsOnlyDiv").style.display = "none";
                document.getElementById("onTheFlyCreateNewGroupsDiv").style.display = "none";
                document.getElementById("onTheFlyFilterGroupsDiv").style.display = "none";
                document.getElementById("onTheApplyRegexGroupsDiv").style.display = "none";
                document.getElementById("groupRegexfield").style.display = "none";
                document.getElementById("on-the-fly-group-mapping-main-inst").style.display = "none";
                document.getElementById("groupMappingDiv").style.display = "block";
                document.getElementById("group-mapping-main-inst").style.display = "block";
                document.getElementById("roleAttribute").required = false;
                document.getElementById("onTheFlyGroupCreation").value = "false";


                
            } else {
                document.getElementById("groupMappingDiv").style.display = "none";
                document.getElementById("group-mapping-instructions-div").style.display = "none";
                document.getElementById("group-mapping-main-inst").style.display = "none";
                document.getElementById("onTheFlyGroupMappingDiv").style.display = "block";
                document.getElementById("onTheFlyAssignNewGroupsOnlyDiv").style.display = "block";
                document.getElementById("onTheFlyCreateNewGroupsDiv").style.display = "block";
                document.getElementById("onTheFlyFilterGroupsDiv").style.display = "block";
                document.getElementById("onTheApplyRegexGroupsDiv").style.display = "block";
                document.getElementById("on-the-fly-group-mapping-main-inst").style.display = "block";
                document.getElementById("roleAttribute").required = true;
                document.getElementById("onTheFlyGroupCreation").value = "true";


                var onTheFlyAssignNewGroupsOnly = document.getElementById("onTheFlyAssignNewGroupsOnly").checked;
                    if (onTheFlyAssignNewGroupsOnly == true) {
                        document.getElementById("onTheFlyGroupMappingDiv").style.display = "none";
                    } else {
                        document.getElementById("onTheFlyGroupMappingDiv").style.display = "block";
                 }

                var groupRegexPatternEnabled = document.getElementById("groupRegexPatternEnabled").checked;
                    if (groupRegexPatternEnabled == true) {
                        document.getElementById("groupRegexfield").style.display = "block";
                    } else {
                        document.getElementById("groupRegexfield").style.display = "none";
                    }
            }
        }

            function toggleRecommendations() {
            AJS.$("#group-mapping-recommendation").toggle(400);
            }

            function showMappingInstruction() {
            var value = document.getElementById("group-mapping-instructions-div");
            if (value.style.display === "none") {
                AJS.$('#group-mapping-instructions-div').show("slow");
            } else {
                AJS.$('#group-mapping-instructions-div').hide("slow");
            }
        }

        function showExcludeGroupsText(){
            var onTheFlyAssignNewGroupsOnly = document.getElementById("onTheFlyAssignNewGroupsOnly").checked;
                if (onTheFlyAssignNewGroupsOnly == true) {
                    document.getElementById("onTheFlyGroupMappingDiv").style.display = "none";
                } else {
                    document.getElementById("onTheFlyGroupMappingDiv").style.display = "block";
                 }
            }
        

        var counter = ${count};

        var crowdGroups = "${groups}";
            var crowdGroup =  crowdGroups.substr(1, (crowdGroups.length-2)).split(',');
            var optionElement ="";

            for(var group in crowdGroup) {
                  optionElement=optionElement +'<option value ="'+crowdGroup[group]+'">'+crowdGroup[group]+'</option>'
            }

        function GetDynamicTextBox(value){
                var htmlElement;
                htmlElement = '<br/>'+'<input id = "userGroupKey_'+counter+'"  name = "userGroupKey_'+counter+'" style="width:250px" placeholder="Crowd Group"/>&nbsp&nbsp;'
                                  +'<input id = "userGroupValue_'+counter+'" name = "userGroupValue_'+counter+'"  type="text" class="text" placeholder="Groups from IdP" style="vertical-align:bottom" value = "' + value + '" />' +'&nbsp&nbsp;'
                                  +'<input type="button" value="-" class="aui-button aui-button-primary"  onclick = "RemoveTextBox(this,'+counter+')" style="vertical-align:bottom" />'
                return htmlElement;
            }

        function AddTextBox(value) {
                var newField;
                for (newField = 0; newField < value; newField++) {
                    var div = document.createElement('DIV');
                    div.innerHTML = GetDynamicTextBox("");
                    var roleMappingInnerContainer = document.getElementById("roleMappingInnerContainer");
                    roleMappingInnerContainer.insertBefore(div, roleMappingInnerContainer.childNodes[0]);
                    AJS.$("#userGroupKey_" + counter).auiSelect2({
                        ajax: {
                            url: AJS.contextPath() + '/plugins/servlet/saml/moapi',
                            data: function (params) {
                                var query = {
                                    search: params,
                                    action: 'fetchGroups'
                                }
                                return query;
                            },
                            results: function (data, page) {
                                return {
                                    results: data.results
                                };
                            },
                        }
                    });
                    counter++;
                    document.getElementById("idTotalNumberOfRoles").value = parseInt(document.getElementById("idTotalNumberOfRoles").value) + 1;
                }
            }

        function RemoveTextBox(div, loopCount) {
                document.getElementById("roleMappingInnerContainer").removeChild(div.parentNode);
            }

        function showOnTheFlyMappingInstruction() {
            var value = document.getElementById("onthefly-group-mapping-instructions-div");
            if (value.style.display === "none") {
                AJS.$('#onthefly-group-mapping-instructions-div').show("slow");
            } else {
                AJS.$('#onthefly-group-mapping-instructions-div').hide("slow");
                }
            }

            


        </script>
        <style>
    		.aui-page-panel-content{
				padding: 0px !important;
			}

			.aui-page-panel{
				margin: 0px !important;
			}


			.labelClass {
                width: 275px !important;
                margin-left: -286px !important;
                margin-left: -250px;
                width: 235px;
                padding: 0 0 0 0;
             }

			.field-group{
                 margin: 10px 100px 1px 100px !important;
                 margin-left: 100px !important;
             }

             .pill-nav {
                margin-top: 20px;
            }

            .pill-nav a {
                display: inline-block;
                color: black;
                text-align: center;
                padding: 14px;
                text-decoration: none;
                font-size: 15px;
                border-radius: 5px;
                background: #cec9c9;
            }

            .pill-nav a:hover {
                background-color: #ddd;
                color: black;
            }

            .pill-nav a.active {
                background-color: #0052cc;
                color: white;
            }

            .aui-message-info{
                background-color: #deebff;
            }
    	</style>
    </head>
    <body >
         <#include "*/header.ftl" parse=true>
		<div class="tabs-pane active-pane" id="role-mapping"  role="tabpanel">
        	<p style="font-size:13pt;">Configure User Groups Mapping</p>
            <hr class="header"/>
            <div class="aui-message aui-message-info">
			<p id="configure-user-groups-mapping" class="title">Don't want to map groups? Disable group mapping, save and skip to <a href="${signinsettings}.action">SSO Settings</a></p>
			</div>
            <form id="group-mapping-idp-select-form" class="aui" action="" method="POST">
                <input type="hidden" name="gmIdpChanged" value="true"/>
                <input type="hidden" id="changedIdpName" name="idpID"/>

            </form>

			<form id="role-mapping-form" class="aui" action="" method="POST">
                    <input type="hidden" name="roleMappingSubmitted" value="true"/>
                    <input type="hidden" name="totalNumberOfRoles" id="idTotalNumberOfRoles" />
					<#if idpMap.keySet().size() <= 1>
					<div id="selectIDPGm" class="field-group" style="display:none">
					<#else>
					<div id="selectIDPGm" class="field-group" >
					</#if>
						<label for="gmIdpName">Select IDP : <span style="color: red">*</span></label>
						<select class="select" name="idpID" id="gmIdpName" style="padding: 3px !important;">
						<#assign idpList = idpMap.keySet()>
							<#foreach idp in idpList>
								<#assign idpName = idpMap.get(idp)>
								<option value="${idp}"
								<#if idpID.equals(idp)>
								selected
								</#if>>
								${idpName}</option>
							</#foreach>
						</select>
					</div>
					<div class="field-group">
						<label for="restrictUserCreation" class="labelClass">Disable User Creation:</label>
						<span style="vertical-align:middle;">
							<label class="moswitch" style="vertical-align:middle;">
								<#if restrictUserCreation == true>
									<input class="checkbox" type="checkbox" name="restrictUserCreation" checked="true" value="true" id="restrictUserCreation"/>
									<span class="moslider moround"></span>
								<#else>
									<input class="checkbox" type="checkbox" name="restrictUserCreation" value="true" id="restrictUserCreation" />
									<span class="moslider moround"></span>
								</#if>
							</label>
						<span style="height:16px; width: 16px">New user will not be created only existing users will be able to login through SSO.</span>
						</span>
					</div>
					<div class="field-group">
                        <label for="applicationGroupEnrollment" class="labelClass">Enable built-in group enrollment:</label>
                        <span style="vertical-align:middle;">
                            <label class="moswitch" style="vertical-align:middle;">
                                <input class="checkbox" type="checkbox" name="applicationGroupEnrollment" <#if applicationGroupEnrollment == true> checked="true" </#if> value="true" id="applicationGroupEnrollment"/>
                                <span class="moslider moround"></span>
                            </label>
                        <span style="height:16px; width: 16px"> The directory specific groups configured in the application connected to your atlassian app will be assigned on SSO.
                        <a href="https://confluence.atlassian.com/crowd/automatically-assigning-users-to-groups-194806197.html">Click here</a> to know more.</span>
                        </span>
                    </div>

					<div class="field-group">
		                <label for="defaultDirectory">Default Directory:
		                    <span class="aui-icon icon-required">(required)</span>
		                </label>
		                <select class="select" name="defaultDirectory" id="defaultDirectory" placeholder="Select Default Directory">
		                    <#foreach directory in existingDirectory>
		                        <option value="${directory}"
		                            <#if defaultDirectory.equals(directory)>
		                                selected
		                            </#if>
		                        >${directory}</option>
		                    </#foreach>
		                </select>
		                <div class="description">The user will be created in the first directory with read/write permissions, of the application that initiated SSO. If none of the directories have read/write permission than user will be created in the default directory.</div>
		                <div class="description"><strong>Note:</strong> Please make sure that crowd application is in this directory and it has a permission to authneticate the user.<br/>To change the permission go to the Applications->crowd->directories and allow all to authenticate</div>
		            </div>

					<hr class="header"/>
                <h3>Default Group Configurations</h3>

					<div class="field-group">
                             <label for="defaultGroups" class="labelClass">Default Group:
                               <span class="aui-icon icon-required">(required)</span>
                             </label>
                        
                           <input class="select long-field" name="defaultGroups" id="defaultGroups" style="width: 500px" required />
                        <div class="description" >Select Default Group(s) to assign to <strong>New Users / All users</strong>. Select
                        <b>None</b> to disable default group assignment.<br/>
						</div>
                     </div>
					 <fieldset class="group"  style="margin-left: 90px; ">
                    <legend>
                        <span>Assign Default Groups To:</span>
                    </legend>
                    <#if enableDefaultGroupsFor == "newUsers">
                        <input type="radio" class="radio" id="newUsers"
                               name="enableDefaultGroupsFor" value="newUsers" checked="checked" style="margin-left: 11px;">
                    <#else>
                        <input type="radio" class="radio" id="newUsers"
                               name="enableDefaultGroupsFor" value="newUsers" style="margin-left: 11px;">
                    </#if>
                    <label for="newUsers">New Users</label>
                    <#if enableDefaultGroupsFor == "allUsers">
                        <input type="radio" class="radio" id="allUsers"
                               name="enableDefaultGroupsFor" value="allUsers" checked="checked">
                    <#else>
                        <input type="radio" class="radio" id="allUsers"
                               name="enableDefaultGroupsFor" value="allUsers">
                    </#if>
                    <label for="allUsers">All Users</label>
                    <#if enableDefaultGroupsFor == "doNotAssignDefaultGroup">
                        <input type="radio" class="radio" id="doNotAssignDefaultGroup"
                               name="enableDefaultGroupsFor" value="doNotAssignDefaultGroup" checked="checked">
                    <#else>
                        <input type="radio" class="radio" id="doNotAssignDefaultGroup"
                               name="enableDefaultGroupsFor" value="doNotAssignDefaultGroup">
                    </#if>
                    <label for="doNotAssignDefaultGroup">None</label>
                </fieldset>

					<hr class="header"/>
				<h3>Group Mapping Configurations</h3>
                    <div class="aui-message aui-message-info">
                    Group Mapping can be configured in one of the following two ways.
                    <a id="group-mapping-recommendation-link" onclick="toggleRecommendations()" style="cursor: pointer">Click here</a> to know which group mapping configuration you should use.
                        <div id="group-mapping-recommendation" hidden>
                            <ol>
                                <li>

                                    If the names of groups in Crowd are different than the corresponding groups in IDP, then you should use <strong>Manual group mapping</strong>.
                                </li>
                                <li>
                                    If the names of groups in Crowd and IDP are same, you should use <strong>On-The-Fly group mapping</strong>.
                                </li>
                            </ol>
                        </div>
                    </div>
                    <br>
                    <div class="mapping-nav">
                        <div class="pill-nav">
                            <a id="group-mapping-pill" style="cursor: pointer" <#if onTheFlyGroupCreation == "false" > class="active" </#if> >Manual Group Mapping</a>
                            <a id="on-the-fly-group-mapping-pill" style="cursor: pointer" <#if onTheFlyGroupCreation == "true" > class="active" </#if> >On-The Fly Group Mapping</a>
                        </div>
                    </div>

                    <input type="hidden" name="onTheFlyGroupCreation" id="onTheFlyGroupCreation"
                                   value="${onTheFlyGroupCreation}"/>

                    <div class="aui-message aui-message-info">
                         <p id="group-mapping-main-inst" class="title" style="margin: 0px;">Group Mapping allows you to map your IDP's groups to your Crowd
                             groups. You can follow <a id="group-mapping-instructions" onclick="showMappingInstruction()"
                                          style="cursor:pointer">these steps</a> for Group Mapping.</p>
                        <p id="on-the-fly-group-mapping-main-inst" class="title">Users will be assigned to Groups in Crowd
                        whose group name is same as groups from IDP. If the Group doesn't exists in Crowd then it will
                        be created.
                        <br/>
                        You can follow <a id="onthefly-group-mapping-instructions"
                                          onclick="showOnTheFlyMappingInstruction()" style="cursor:pointer">these steps</a>
                        for On-The-Fly Group Mapping.
                        </p>

                        <div id="group-mapping-instructions-div" style="display:none">
                        <ol>
                            <li>Go to <a href="${listidp}.action">Configure IDP</a> and click on Test Configuration.</li>
                            <li>Copy the <i>Attribute Name</i> against the group value and enter in <i>Group Attribute</i>
                            textbox below.
                            </li>
                            <li>Against the Crowd group given below, enter the name of the group(s) whose users should be added
                                in that Crowd group.
                            </li>
                            <li>
                            Click on '+' button to add a new row and '+10' button to add 10 new rows
                                for mapping groups
                            </li>
                            <li>You can remove a row by clicking on '-' button. All the unmapped groups will be removed
                                automatically on saving the settings
                            </li>
                        </ol>
                        </div>
                        <div id="onthefly-group-mapping-instructions-div" style="display:none">
                        <ol>
                            <li>Go to <a href="${listidp}.action">Configure IDP</a> and click on Test Configuration.</li>
                            <li>Copy the <i>Attribute Name</i> against the group value and enter in <i>Group Attribute</i>
                                textbox
                                below.
                            </li>
                            <li>If the user is part of some group in Crowd and that group is not present in SAML response returned by IDP, then the user will be removed from that group in Crowd.
                            </li>
                            <li>If you don't want On-The-Fly group mapping to affect Crowd groups which are managed locally (for eg. Crowd-administrator), then add those groups in Exclude Groups field</li>
                        </ol>
                    </div>
                    </div>

                   <div class="field-group">
                        <label for="keepExistingUserRoles" class="labelClass">Disable Group Mapping:</label>
                        
                        <input class="checkbox" type="checkbox" name="keepExistingUserRoles" value="true" id="keepExistingUserRoles"
                         <#if keepExistingUserRoles == true > checked="true" </#if> />
                        
                        <span>Do not update groups of existing users.</span>
                        <div class="description aui-message aui-message-info" style="width: 85%;" >
                        <p>If users are managed from the external user directory for e.g. AD/LDAP with the <b>read only</b>
                           permission. It is recommended to enable <b>"Disable Group Mapping for existing users"</b> option.
                        </p>
                    </div>
                    </div>

                     <div class="field-group">
                        <label for="roleAttribute" class="labelClass">Group Attribute:</label>
                        <input type="text" id="roleAttribute" name="roleAttribute" placeholder="Enter the group attribute name."
                               value="${roleAttribute}" class="text long-field"/>
                        <div class="description">Enter the SAML-response Attribute Name that contains groups of the User.</div>
                    </div>

                    <div class="field-group" id="onTheFlyFilterGroupsDiv">
                        <label>Filter Groups:</label>
                            <select class="select" id="onTheFlyFilterIDPGroupsOption" name="onTheFlyFilterIDPGroupsOption" style="width:225px;">
                                <#foreach option in groupFilterOptionsList >
                                    <option value="${option}"
                                        <#if option.equals(onTheFlyFilterIDPGroupsOption) >
                                            selected
                                        </#if>
                                    >${option}</option>
                                </#foreach>
                            </select>&nbsp&nbsp&nbsp&nbsp&nbsp

                            <input type="text" placeholder="Enter filter/regex pattern" class="text" value="${onTheFlyFilterIDPGroupsKey}"
                            name="onTheFlyFilterIDPGroupsKey" id="onTheFlyFilterIDPGroupsKey" <#if onTheFlyFilterIDPGroupsOption.equals("None") > style="display:none;" </#if> />
                            &nbsp&nbsp&nbsp&nbsp&nbsp
                            <div class="description">Select how you want to <b>filter groups</b> received from the OAuth/OIDC provider.</div>
                            <div class="description" id="onTheFlyGroupRegexDescription" <#if !onTheFlyFilterIDPGroupsOption.equals("Regex") >style="display:none" </#if>
                                If you have configured regex pattern as <b>dev.*</b> and you received 3 groups (dev-1, dev-2 and testers) from OAuth/OIDC provider, <br>
                                then only the groups matching the regex pattern will be considered (dev-1 and dev-2).
                            </div>
                    </div>

                <div class="field-group" id="onTheApplyRegexGroupsDiv">
                    <input class="checkbox" type="checkbox" name="groupRegexPatternEnabled" value="true" id="groupRegexPatternEnabled"
                    <#if groupRegexPatternEnabled == true > checked="true" </#if> />
                    <span> Apply regular expression on <strong>Group Name</strong>.</span>
                </div>

                <div class="field-group" id="groupRegexfield">
                    <div>
                        <label for="regexPatternForGroup">Replace</label>
                        <input type="text medium-field" id="regexPatternForGroup" name="regexPatternForGroup" value="${regexPatternForGroup}"
                        placeholder="Regular Expression" class="text long-field" style="width: 150px"/>&nbsp;&nbsp;&nbsp;&nbsp;
                        <label for="regexGroups">With</label>
                        <input  type="text medium-field" id="regexGroups"  name="regexGroups" value="${regexGroups}"
                        placeholder="Replace With" class="text long-field" style="width: 150px"/>
                    </div>
                    <br>
                    <div style = "padding-left: 53px">
                        <input type="text" id="testRegex" name="testRegex" value="${testRegex}" placeholder="Group Name to Test Regex" class="text long-field" style="width:210px;" />&nbsp;&nbsp
                        <input type="button" id="test-group-regex" value="Test Group Regex" class="aui-button" style="width:130px;" />
                    </div>
                    <div class="description">Enter the regular expression here. It will be applied on value for group
                        Name provided in the field.
                        <br>
                        For example, you can use regular expression <b>(.*):group:(.*)#</b> and replacement <b>$2</b> to extract <b> <span style = "text-transform: capitalize;">$platform</span>-users</b> from groupName
                        <b>urn:group:<span style = "text-transform: capitalize;">$platform</span>-users#idp</b>
                    </div>
                    <br>
                </div>

                <div class="field-group" id="onTheFlyCreateNewGroupsDiv">
                    <label for="createNewGroups">Create New Groups:</label>
                    
                        <input class="checkbox" type="checkbox" name="createNewGroups" value="true" id="createNewGroups"
                        <#if createNewGroups == true> checked="true" </#if> />
                    
                    <span>Create new groups coming from IDP if the group does not already exist in Crowd.</span>
                </div>

                <div class="field-group" id="onTheFlyAssignNewGroupsOnlyDiv">
                    <label for="onTheFlyAssignNewGroupsOnly" class="labelClass">Keep Existing Users Groups</label>
                    
                        <input class="checkbox" type="checkbox" name="onTheFlyAssignNewGroupsOnly"  value="true"
                               id="onTheFlyAssignNewGroupsOnly" onclick="showExcludeGroupsText()" 
                               <#if onTheFlyAssignNewGroupsOnly == true> checked="true" </#if> />
                    
                    <span>New groups will be assigned but user's existing groups will be not be affected.</span>
                </div>
                <div id="onTheFlyGroupMappingDiv">
                    <div class="field-group">
                         <label>Exclude Groups:</label>
                             <input class="select long-field" name="onTheFlyDoNotRemoveGroups" id="onTheFlyDoNotRemoveGroups" multiple style="max-width: 500px !important;width: 500px;"/>

                         <div class="description">Do not remove user from these groups after SSO.</div>
                    </div>
                </div>

                <div id="groupMappingDiv">
                     <div class="field-group">
								<label for="createUsersIfRoleMapped" class="labelClass">Restrict User Creation based on Group Mapping:</label>
	                            
		                        <input type="checkbox" id="createUsersIfRoleMapped" value="true" name="createUsersIfRoleMapped"
                                <#if createUsersIfRoleMapped == true> checked="true" </#if> />
		                        
		                    <span>Create users only if their groups are mapped</span>
                    </div>
                    <div class="field-group" id="roleMappingContainer" name="roleMappingContainer">
                        <span style="margin-right: 14px; font-weight: 600;">Add Groups</span>
                        <input type='button' value='+' id='addGroupAttr' class="aui-button aui-button-primary"
                               onclick="AddTextBox(1)">
                        <input type='button' value='+10' id='add10GroupAttr' class="aui-button aui-button-primary"
                               onclick="AddTextBox(10)">
                        <div class="description">
                            By default first 50 groups will shown for mapping and you can add more using <b>"+"</b> or <b>"+10"</b> buttons. All unmapped groups will be removed on saving the configuration.
                        </div>
                        <div id="roleMappingInnerContainer" name="roleMappingInnerContainer">
                            <#assign loopCount = 0>
                            <#if roleMapping.isEmpty()>
                                <#foreach key in existingGroups>
                                    <#if loopCount == 50>
                                        <#break>
                                    </#if>
                                    <div>
                                        <br/>
                                        <input name="userGroupKey_${loopCount}" id="userGroupKey_${loopCount}" placeholder="Crowd Group" class="groupmapping" style="width:250px" value="${key}" />&nbsp&nbsp;
                                        <input type="text" id="userGroupValue_${loopCount}" style="vertical-align:bottom"
                                               name="userGroupValue_${loopCount}" value="" placeholder="Group from IdP"
                                               class="text"/>&nbsp&nbsp;
                                        <input type="button" value="-" style="vertical-align:bottom"
                                               class="aui-button aui-button-primary"
                                               onclick="RemoveTextBox(this, ${loopCount})"/>
                                        <#assign loopCount = loopCount+1>
                                    </div>
                                </#foreach>
                            <#else>
                                <#foreach key in roleMapping.keySet()>
                                <#if loopCount == 50>
                                        <#break>
                                    </#if>
                                    <div>
                                        <br/>
                                        <input name="userGroupKey_${loopCount}" id="userGroupKey_${loopCount}" placeholder="Crowd Group" class="groupmapping" style="width:250px" value="${key}" />&nbsp&nbsp;
                                        <#assign groupName = roleMapping.get(key)>
                                        <input type="text" id="userGroupValue_${loopCount}" name="userGroupValue_${loopCount}" style="vertical-align:bottom" value="${groupName}" placeholder="IdP's Group" class="text"/>&nbsp&nbsp;
                                        <input type="button" value="-" class="aui-button aui-button-primary" style="vertical-align:bottom" onclick = "RemoveTextBox(this, ${loopCount})" />
                                        <#assign loopCount = loopCount+1>
                                    </div>
                                </#foreach>
                            </#if>
                        </div>
                    </div>
                 </div>
                <br/>
                    <div class="field-group">
                        <input type="submit" value="Save" class="aui-button aui-button-primary" style="width:100px;" <#if idpMap.size() == 0 > disabled </#if> />
						&nbsp;&nbsp;
						<a href="${signinsettings}.action"><input type="button" value="Next" class="aui-button aui-button-primary" style="width:100px;"/></a>&nbsp;&nbsp;&nbsp;
						<a href="${listidp}.action" style="width:300px;">Back to configuration</a>
                    </div>
            </form>
        </div>
        </div>
        </section>
        </div>
        </div>
    </body>
</html>
