<html>
<head>
	<meta name="decorator" content="atl.general"/>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<script>
	
		 jQuery(document).ready(function() {
			jQuery(".aui-nav li").removeClass("aui-nav-selected");
			jQuery("#CONFIGURE").addClass("aui-nav-selected");
		});

        AJS.$(function () {
           //Adding search bar to IDP select dropdown
            AJS.$("#idpGuides").auiSelect2();
            AJS.$("#idpGuides").change(function () {
                var linkToGuide = AJS.$("#idpGuides").val();
                AJS.$("#idp-guide-link").attr('href', linkToGuide);
                });
            });

		function copyToClipboard(element, copyButton) {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(element).text()).select();
            document.execCommand("copy");
            $temp.remove();
            $(copyButton).show();
            setTimeout(function() { $(copyButton).hide("slow"); }, 5000);
        }

        function copyCertificate(element,copyButton){
            var $temp = $("<textarea id=\"certificateAsText\" cols=\"64\" rows=\"4\"></textarea>");
            $("body").append($temp);
            document.getElementById('certificateAsText').value += $(element).text();
            document.querySelector("#certificateAsText").select();
            document.execCommand("copy");
            $temp.remove();
            $(copyButton).show();
            setTimeout(function() { $(copyButton).hide("slow"); }, 5000);
        }

        function showCertificateDetails() {
            var x = document.getElementById('certificateInfoDiv');
            if (x.style.display === 'none') {
                x.style.display = 'block';
                document.getElementById('show-certificate-details').innerHTML = "Hide Certificate Details";

            } else {
                x.style.display = 'none';
                document.getElementById('show-certificate-details').innerHTML = "Show Certificate Details";

            }
        }
	
	</script>
	<style>
    	.aui-page-panel-content{
			padding: 0px !important;
		}

		.aui-page-panel{
			margin: 0px !important;
		}
	
        .show-title:after {
            content:attr(title);
            font-weight: bold;
            color: white;
            padding:5px 10px;
            margin-left: 20px;
            border-radius: 2px;
            border:1px solid #2D4D4D;
            background: #2D4D4D;
        }
    </style>
</head>
<body>
    <#include "*/header.ftl" parse=true >
   <div class="tabs-pane active-pane" id="configure-idp"  role="tabpanel">
	<p style="font-size:13pt;">Service Provider Info</p>
	<hr class="header"/>
		<p style="font-size:13pt;">Choose your Identity Provider from the list below to view its setup guide:</p>
                    <div class="field-group" style="padding: 15px 0 4px 145px;">
                        <select class="select" name="idpGuides" id="idpGuides" style="width:200px;">
                            <#foreach guide in idpGuides.keySet()>
                                <option value="${idpGuides.get(guide)}">${guide}</option>
                            </#foreach>
                        </select>
                        <a id="idp-guide-link" class="aui-button aui-button-primary" style="vertical-align: bottom;"
                        href="https://plugins.miniorange.com/crowd-saml-single-sign-on-sso-using-adfs-idp" target="_blank"> View the Guide </a>

                    </div>
                <p>Your IdP is not in the list? Contact us using <b>Support/Feedback</b> widget and we will help you set it up very
                    quickly.
                <p>
        	<hr class="header"/>
		<p>Provide this metadata to your Identity Provider to enable Crowd as a service provider/relying party:<br>
		
		<#assign metadata = spBaseUrl + "/plugins/servlet/saml/metadata">
        <a href="${metadata}" target="_blank" class="aui-button aui-button-link">${metadata}</a>
		
		<form id="set-certificates-form" class="aui" action="" method="POST">
				<input type="hidden" name="certificatesSubmitted" value="true"/>
				
				<div class="field-group">
					<#if signing == true>
						<input type="checkbox" checked="true" id="signing" value="true" name="signing">
						<span>Include Signing Certificate in Metadata</span>
					<#else>
						<input type="checkbox" id="signing" value="true" name="signing">
						<span>Include Signing Certificate in Metadata</span>
					</#if>
					<div class="description">
						<span> Include signing certificate in the SAML Metadata to inform IdP that SP has signed request. To disable signing request, please uncheck this value and also uncheck <b>Send Signed Requests</b> in Configure IDP section.</span>
					</div>
					<#if  settings.getSignedRequest() == false && settings.getSigning() == true>
						<div class="description">
							<div class="aui-message aui-message-warning">
								<span> Warning: Signed Request is disabled in SP configuration.</span>
							</div>
						</div>
					</#if>
				</div>
				
				<div class="field-group">
					<#if encryption == true>
						<input type="checkbox" checked="true" id="encryption" value="true" name="encryption">
						<span>Include Encryption Certificate in Metadata</span>
					<#else>
						<input type="checkbox" id="encryption" value="true" name="encryption">
						<span>Include Encryption Certificate in Metadata</span>
					</#if>
					<div class="description">
						<span> Include encryption certificate in the SAML Metadata. This allows the IdP to encrypt Assertions.</span>
					</div>                    
					<#if isJCEInstalled == false && encryption == true>
						<div class="description">
							<div class="aui-message aui-message-warning">
								<span>Warning: The Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files are not installed on this system. It is likely that decrypting Assertions will fail.
								<br>Download JCE Unlimited Strength Jurisdiction Policy Files for your java version. Extract the jar files from the zip and save them in <b>${java.home}/jre/lib/security/</b>.</span>
							</div>
						</div>   
					</#if>
				</div>
				
				<div class="field-group">
					<input type="submit" value="Save" class="aui-button aui-button-primary" style="width:100px;"/>
				</div>
        </form>
		
		
	
		  <p style="margin-left: 200px;">OR</p>
		  <p>Use these values below to add Crowd as service provider/relying party in your Identity Provider:</p>
		  		
		  	<table class="aui aui-table-interactive">
                    <tbody>
			        	<tr>
                            <td headers="name"  width="30%">
                                <b>SP Entity ID / Issuer</b>
                            </td>
                            <td headers="type"  width="40%">
			        			<p id = "p1">${settings.getSpEntityId()}</p>
                            </td>
                            <td  width="30%">
                            	<button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p1','#c1')"><i class="fa fa-copy"></i> Copy</button>
                                <span id="c1" title="Copied" class="show-title" hidden></span>
                            </td>
                        </tr>
                        <tr>
                            <td headers="name">
                                <b>ACS URL</b>
                            </td>
                            <td headers="type">
                            	<p id = "p2">${settings.getLoginServletUrl()}</p>
                            </td>
                            <td>
                            	<button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p2','#c2')"><i class="fa fa-copy"></i> Copy</button>
                                <span id="c2" title="Copied" class="show-title" hidden></span>
                            </td>
                        </tr>
                        <tr>
                            <td headers="name">
                                <b>Single Logout URL</b>
                            </td>
                            <td headers="type">
                            	<p id = "p3">${settings.getLogoutServletUrl()}</p>
                            </td>
                            <td>
                            	<button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p3','#c3')"><i class="fa fa-copy"></i> Copy</button>
                                <span id="c3" title="Copied" class="show-title" hidden></span>
                            </td>
                        </tr>
                       	<tr>
                            <td headers="name">
                                <b>Audience URI</b>
                            </td>
                            <td headers="type">
                            	<p id = "p4">${settings.getSpEntityId()}</p>
                            </td>
                            <td>
								<button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p4','#c4')"><i class="fa fa-copy"></i> Copy</button>
								<span id="c4" title="Copied" class="show-title" hidden></span>
                            </td>
                        </tr>
                        <tr>
                            <td headers="name">
                                <b>Recipient URL</b>
                            </td>
                            <td headers="type">
                            	<p id = "p5">${settings.getLoginServletUrl()}</p>
                            </td>
                            <td>
                            	<button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p5','#c5')"><i class="fa fa-copy"></i> Copy</button>
                                <span id="c5" title="Copied" class="show-title" hidden></span>
                            </td>
                        </tr>
                        <tr>
                            <td headers="name">
                                <b>Destination URL</b>
                            </td>
                            <td headers="type">
                                <p id = "p6">${settings.getLoginServletUrl()}</p>
                            </td>
                            <td>
                                <button class="mo-copy aui-button" title = "Copy to Clipboard" onclick="copyToClipboard('#p6','#c6')"><i class="fa fa-copy"></i> Copy</button>
                                <span id="c6" title="Copied" class="show-title" hidden></span>
                            </td>
                        </tr>
                        <tr>
                    		<td headers="name">
                        		<b>Certificate</b>
                    		</td>
                    		<td headers="type">
                        		<a href="${downloadcertificate}.action" >
                            		<input  type="button" class="aui-button aui-button-link" value="Download"/>
                        		</a>
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <a id="show-certificate-details"
                                   data-replace-text="Hide Certificate Details"
                                   class="show-certificate-details"
                                   aria-controls="certificateInfoDiv"
                                   onclick="showCertificateDetails()"
                                   style="cursor:pointer">Show Certificate Details
                                </a>
                                <!-- Certificate details div. Hidden by default. -->
                                <div id="certificateInfoDiv" style="display: none;">
                                    <table style="border: 1px solid;">
                                        <#foreach key in certificateInfo.keySet()>
                                            <tr>
                                                <th>${key}:</th>
                                                <td>${certificateInfo.get(key)}</td>
                                            </tr>
                                        </#foreach>
                                    </table>
                                </div>
								<div class="description" style="font-size:12px;">Note: If the IdP requires signed requests, the IdP will need this certificate to validate requests. It is also used to decrypt encrypted SAML Assertions from the IdP.
								</div>
                    		</td>		
                    		<td>
                                <p id="p7"
                                    style="font-family:Courier New;display: none" cols="64" rows="4">${settings.getPublicSPCertificate()}
                                </p>
                                <button class="mo-copy aui-button" title = "Copy to Clipboard" onclick="copyCertificate('#p7','#c7')"><i class="fa fa-copy"></i> Copy</button>
                                <span id="c7" title="Copied" class="show-title" hidden></span>
                    		</td>
                		</tr>
                    </tbody>
                </table>
		<p style="font-size:13pt;">Configure Service Provider URLs (Optional)</p>
		
		<form id="configure-idp-form" class="aui" action="" method="POST">
                    <input type="hidden" name="addIdpSubmitted" value="true"/>
                    <div class="field-group">
                        <label for="spBaseUrl">SP Base URL:
                            <span class="aui-icon icon-required">(required)</span>
                        </label>
                        <input type="url" required="true" id="spBaseUrl" name="spBaseUrl" value="${spBaseUrl}"
                               class="text long-field"/>
                         <div class="description">
                       			<span>If your site is behind a proxy you can modify SP Base URL for Single Sign-On to work. If not provided, Crowd base URL will be used by default.</span>
                		</div>
                    </div>
                    <div class="field-group">
                        <label for="spEntityId">SP Entity ID:
                            <span class="aui-icon icon-required">(required)</span>
                        </label>
                        <input type="text" required="true" id="spEntityId" name="spEntityId" value="${spEntityId}"
                               class="text long-field"/>
                        <div class="description">
                     		<span>Set the Entity ID for the Service Provider. If not provided, Crowd base URL will be used by default.</span>
                		</div>
                    </div>
                    <div class="field-group">
                        <input type="submit" value="Save" class="aui-button aui-button-primary" style="width:100px;"/>
                    </div>
                </form>
		<hr class="header"/>
	
		<p style="font-size:13pt;"> <a href="${listidp}.action">Import IdP Metadata </a> or note down the following information from your IdP and keep it handy. Click the next button below when you are ready.</p>
		<ol>
           <li>IdP Entity ID or Issuer</li>
           <li>Single Sign-On Service URL</li>
           <li>Single Logout URL(optional)</li>
           <li>X.509 Signing Certificate</li>
        </ol>
        <br>
		<div class="field-group"><a href="${listidp}.action"><input type="submit" value="Next" class="aui-button aui-button-primary" style="width:100px;"/></a></div>
	</div>
</div>
</section>
</div>
</div>
</body>
</html>
