/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoSignInSettingsAction
extends BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoSignInSettingsAction.class);
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    @ComponentImport
    private CrowdService crowdService;
    private Boolean enableBackdoor;
    private String timeDelay;
    private String loginButtonText;
    private Boolean disableDefaultLogin;
    private String relayState;
    private Boolean reregister;
    private Boolean checklicense;
    private Boolean signinSettingsSubmitted;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private String loginTemplate;
    private String errorMsgTemplate;
    private Boolean autoActivateUser;
    private Boolean enableSAMLSSO;
    private Boolean enableErrorMsgTemplate;
    private I18nHelper i18nHelper;
    private Boolean restrictBackdoor;
    private String[] backdoorGroups;
    private List<String> backdoorGroupsList;

    @Autowired
    public MoSignInSettingsAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler, I18nHelper i18nHelper, CrowdService crowdService) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.i18nHelper = i18nHelper;
        this.crowdService = crowdService;
    }

    public void validate() {
        LOGGER.info("SignInSettings Action validate called ");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.signinSettingsSubmitted)) {
            return;
        }
        if (StringUtils.isNotBlank(this.relayState)) {
            try {
                new URL(this.relayState);
                if (!StringUtils.contains(this.relayState, this.settings.getSSODomain())) {
                    this.addActionError(this.i18nHelper.getText("samlsso.error.sso.relaystate.domain.invalid"));
                }
            }
            catch (MalformedURLException e) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.sso.relaystate.url.invalid"));
            }
        }
        try {
            if (Integer.parseInt(this.timeDelay) < 0) {
                this.addActionError(this.i18nHelper.getText("samlsso.timedelay.number.invalid"));
            }
        }
        catch (NumberFormatException e) {
            this.addActionError(this.i18nHelper.getText("samlsso.timedelay.number.invalid"));
        }
        if (super.hasActionErrors()) {
            this.initializeSAMLConfig();
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.info("Sign in Settings Action execute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            LOGGER.debug("Sign in Settings Action doExecute Submitted: " + this.signinSettingsSubmitted);
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            this.backdoorGroupsList = new ArrayList<String>();
            if (BooleanUtils.toBoolean((Boolean)this.signinSettingsSubmitted)) {
                this.backdoorGroupsList = this.settings.convertArrayToList(org.apache.commons.lang3.StringUtils.split((String)this.backdoorGroups[0], (String)","));
                if (this.getRestrictBackdoor() == Boolean.TRUE && this.getBackdoorGroupsList().isEmpty()) {
                    LOGGER.info("Backdoor Group/s Empty");
                    this.addActionError(this.i18nHelper.getText("samlsso.error.sso.autoredirect.restrict.groups.invalid"));
                }
                this.validate();
                this.moPluginHandler.saveSigninSettings(this.timeDelay, this.disableDefaultLogin, this.enableBackdoor, this.loginButtonText, this.relayState, this.loginTemplate, this.autoActivateUser, this.enableSAMLSSO, this.restrictBackdoor, this.backdoorGroupsList, this.enableErrorMsgTemplate, this.errorMsgTemplate);
                this.addActionMessage(this.getText("SAML settings updated."));
            }
            this.initializeSAMLConfig();
            return "success";
        }
        catch (PluginException e) {
            LOGGER.error("plugin exception occurred while initializing sign in settings details ", (Throwable)e);
            this.addActionError(e.getMessage());
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An error occured while saving sing in settings details", (Throwable)e);
            this.addActionError("An error occured while saving your details. Please check logs for more info.");
            return "input";
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeSAMLConfig() {
        this.disableDefaultLogin = this.settings.getDefaultLoginDisabled();
        this.enableBackdoor = this.settings.getBackdoorEnabled();
        this.relayState = this.settings.getRelayState();
        this.loginButtonText = this.settings.getLoginButtonText();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.timeDelay = this.settings.getTimeDelay();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.loginTemplate = this.settings.getLoginTemplate();
        this.errorMsgTemplate = this.settings.getErrorMsgTemplate();
        this.autoActivateUser = this.settings.getAutoActivateUser();
        this.enableSAMLSSO = this.settings.getEnableSAMLSSO();
        this.enableErrorMsgTemplate = this.settings.getenableErrorMsgTemplate();
        this.restrictBackdoor = this.settings.getRestrictBackdoor();
        this.backdoorGroupsList = this.settings.getBackdoorGroups();
    }

    public String getTimeDelay() {
        return this.timeDelay;
    }

    public void setTimeDelay(String timeDelay) {
        this.timeDelay = timeDelay;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getPluginHandler() {
        return this.moPluginHandler;
    }

    public void setPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public Boolean getEnableBackdoor() {
        return this.enableBackdoor;
    }

    public void setEnableBackdoor(Boolean enableBackdoor) {
        this.enableBackdoor = enableBackdoor;
    }

    public String getLoginButtonText() {
        return this.loginButtonText;
    }

    public void setLoginButtonText(String loginButtonText) {
        this.loginButtonText = loginButtonText;
    }

    public Boolean getDisableDefaultLogin() {
        return this.disableDefaultLogin;
    }

    public void setDisableDefaultLogin(Boolean disableDefaultLogin) {
        this.disableDefaultLogin = disableDefaultLogin;
    }

    public Boolean getAutoActivateUser() {
        return this.autoActivateUser;
    }

    public void setAutoActivateUser(Boolean autoActivateUser) {
        this.autoActivateUser = autoActivateUser;
    }

    public Boolean getEnableSAMLSSO() {
        return this.enableSAMLSSO;
    }

    public void setEnableSAMLSSO(Boolean enableSAMLSSO) {
        this.enableSAMLSSO = enableSAMLSSO;
    }

    public Boolean getEnableErrorMsgTemplate() {
        return this.enableErrorMsgTemplate;
    }

    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.enableErrorMsgTemplate = enableErrorMsgTemplate;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public Boolean getSigninSettingsSubmitted() {
        return this.signinSettingsSubmitted;
    }

    public void setSigninSettingsSubmitted(Boolean signinSettingsSubmitted) {
        this.signinSettingsSubmitted = signinSettingsSubmitted;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getChecklicense() {
        return this.checklicense;
    }

    public void setChecklicense(Boolean checklicense) {
        this.checklicense = checklicense;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public String getLoginTemplate() {
        return this.loginTemplate;
    }

    public void setLoginTemplate(String loginTemplate) {
        this.loginTemplate = loginTemplate;
    }

    public String getErrorMsgTemplate() {
        return this.errorMsgTemplate;
    }

    public void setErrorMsgTemplate(String errorMsgTemplate) {
        this.errorMsgTemplate = errorMsgTemplate;
    }

    public Boolean getRestrictBackdoor() {
        return this.restrictBackdoor;
    }

    public void setRestrictBackdoor(Boolean restrictBackdoor) {
        this.restrictBackdoor = restrictBackdoor;
    }

    public String[] getBackdoorGroups() {
        return this.backdoorGroups;
    }

    public void setBackdoorGroups(String[] backdoorGroups) {
        this.backdoorGroups = backdoorGroups;
    }

    public List<String> getBackdoorGroupsList() {
        if (this.backdoorGroupsList == null) {
            this.backdoorGroupsList = new ArrayList<String>();
        }
        return this.backdoorGroupsList;
    }

    public void setBackdoorGroupsList(List<String> backdoorGroupsList) {
        this.backdoorGroupsList = backdoorGroupsList;
    }
}

