/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoSPConfigurationAction
extends BaseAction {
    private static Log LOGGER = LogFactory.getLog(MoSPConfigurationAction.class);
    @ComponentImport
    private I18nHelper i18nHelper;
    @ComponentImport
    private DirectoryManager directoryManager;
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private String spBaseUrl;
    private String spEntityId;
    private Boolean signing;
    private Boolean encryption;
    private Boolean isJCEInstalled;
    private Boolean certificatesSubmitted;
    private Boolean addIdpSubmitted;
    private Boolean reregister;
    private Boolean checklicense;
    private String crowdBaseUrl;
    private Map<String, String> idpGuides;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;

    @Autowired
    public MoSPConfigurationAction(DirectoryManager directoryManager, MoSAMLSettings settings, MoPluginHandler moPluginHandler, I18nHelper i18nHelper) {
        this.directoryManager = directoryManager;
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.i18nHelper = i18nHelper;
    }

    public void validate() {
        LOGGER.info("Configuration action  validate called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.addIdpSubmitted)) {
            return;
        }
        if (BooleanUtils.toBoolean((Boolean)this.addIdpSubmitted)) {
            if (StringUtils.isBlank(this.spBaseUrl)) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.spinfo.baseurl.empty"));
            } else {
                try {
                    new URL(this.spBaseUrl);
                }
                catch (MalformedURLException e) {
                    this.addActionError(this.i18nHelper.getText("samlsso.error.spinfo.baseurl.invalid"));
                }
            }
            if (StringUtils.isBlank(this.spEntityId)) {
                this.addActionError(this.i18nHelper.getText("samlsso.error.spinfo.entityid.empty"));
            }
        }
        if (super.hasActionErrors()) {
            this.initializeSAMLConfig();
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.info("Configuration action  execute called called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            LOGGER.info("Configure Action execute Submitted. ");
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            if (StringUtils.isNotBlank(this.settings.getSsoServiceUrl())) {
                String idpID = UUID.randomUUID().toString();
                String idpName = "IDP";
                this.moPluginHandler.replaceOldSettingsWithNew(idpID, idpName);
            }
            String validTo = this.getCertificateInfo().get("Valid To");
            this.settings.setSPCertExpireOn(validTo);
            if (BooleanUtils.toBoolean((Boolean)this.addIdpSubmitted)) {
                this.validate();
                LOGGER.debug("Saving sp configuration.");
                this.moPluginHandler.saveSPConfiguration(this.spBaseUrl, this.spEntityId);
                this.addActionMessage(this.getText("SAML settings updated."));
            } else if (BooleanUtils.toBoolean((Boolean)this.certificatesSubmitted)) {
                LOGGER.debug("Saving sp metadata configuration.");
                this.moPluginHandler.saveSPCertificates(this.signing, this.encryption);
                this.addActionMessage(this.getText("SAML settings updated."));
            }
            LOGGER.debug("Initializing sp configuration.");
            this.initializeSAMLConfig();
            return "success";
        }
        catch (MoPluginException e) {
            LOGGER.error("Plugin exception occurred  while initializing sp configuration", e);
            this.addActionError(e.getMessage());
            this.initializeSAMLConfig();
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while while initializing sp configuration ", e);
            this.initializeSAMLConfig();
            this.addActionError("An error occurred while saving your details. Please check logs for more info.");
            return "input";
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public boolean isJCEEnable() {
        try {
            if (Cipher.getMaxAllowedKeyLength("SHA256") != Integer.MAX_VALUE) {
                LOGGER.debug("JCE Strength=  " + Cipher.getMaxAllowedKeyLength("SHA256"));
                LOGGER.debug("JCE unlimited strength jurisdiction policy files are not installed");
                return false;
            }
            LOGGER.debug("JCE unlimited strength jurisdiction policy files are installed in this server");
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("No Such Algorithm Found" + e);
            return false;
        }
    }

    private void initializeSAMLConfig() {
        this.spBaseUrl = this.settings.getSpBaseUrl();
        this.spEntityId = this.settings.getSpEntityId();
        this.signing = this.settings.getSigning();
        this.encryption = this.settings.getEncryption();
        this.isJCEInstalled = this.isJCEEnable();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getPluginHandler() {
        return this.moPluginHandler;
    }

    public void setPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public String getSpBaseUrl() {
        return this.spBaseUrl;
    }

    public void setSpBaseUrl(String spBaseUrl) {
        this.spBaseUrl = spBaseUrl;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public Boolean getSigning() {
        return this.signing;
    }

    public void setSigning(Boolean signing) {
        this.signing = signing;
    }

    public Boolean getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Boolean encryption) {
        this.encryption = encryption;
    }

    public Boolean getIsJCEInstalled() {
        return this.isJCEInstalled;
    }

    public void setIsJCEInstalled(Boolean isJCEInstalled) {
        this.isJCEInstalled = isJCEInstalled;
    }

    public Boolean getCertificatesSubmitted() {
        return this.certificatesSubmitted;
    }

    public void setCertificatesSubmitted(Boolean certificatesSubmitted) {
        this.certificatesSubmitted = certificatesSubmitted;
    }

    public Boolean getAddIdpSubmitted() {
        return this.addIdpSubmitted;
    }

    public void setAddIdpSubmitted(Boolean addIdpSubmitted) {
        this.addIdpSubmitted = addIdpSubmitted;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getChecklicense() {
        return this.checklicense;
    }

    public void setChecklicense(Boolean checklicense) {
        this.checklicense = checklicense;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public Map<String, String> getCertificateInfo() {
        return MoSAMLUtils.getCertificateInfo(this.settings.getPublicSPCertificate());
    }

    public Map<String, String> getIdpGuides() {
        this.idpGuides = this.moPluginHandler.getIdpGuides();
        return this.idpGuides;
    }

    public void setIdpGuides(Map<String, String> idpGuides2) {
        this.idpGuides = idpGuides2;
    }
}

