/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.crowd.action.MoAddIDPConfigurationAction;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoIdpListAction
extends BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAddIDPConfigurationAction.class);
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private ArrayList<String> idpList;
    private HashMap<String, String> idpMap;
    private Boolean domainsSubmitted;
    private String[] domains;
    private List<String> domainsList;
    private Boolean useDomainMapping;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;

    @Autowired
    public MoIdpListAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
    }

    private Boolean doValidate() {
        LOGGER.info(" MoIDPListAction#doValidate() method called ");
        Boolean error = false;
        return error;
    }

    public String execute() throws Exception {
        LOGGER.info(" MoIDPListAction#execute() method called ");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            this.idpMap = this.settings.getIdpMap();
            this.idpList = this.settings.getIdPList();
            if (this.idpList.isEmpty()) {
                response.sendRedirect(this.settings.getSpBaseUrl() + "/console/secure/plugins/crowd-sso-config/addidp.action");
                return null;
            }
            if (this.idpList.size() == 1) {
                String id = this.idpList.get(0);
                response.sendRedirect(this.settings.getSpBaseUrl() + "/console/secure/plugins/crowd-sso-config/addidp.action?idpid=" + id);
                return null;
            }
            String status = request.getParameter("status");
            String operation = request.getParameter("operation");
            Boolean error = this.doValidate();
            if (BooleanUtils.toBoolean(this.domainsSubmitted) && !error.booleanValue()) {
                try {
                    this.moPluginHandler.saveListIDPConfigurations(this.domains, BooleanUtils.toBoolean(this.useDomainMapping));
                    this.addActionMessage(this.getText("SAML settings updated."));
                }
                catch (MoPluginException e) {
                    this.addActionError("Domain names must be unique.");
                }
            } else if (StringUtils.isNotBlank(operation) && operation.equals("delete")) {
                this.addActionMessage(this.getText("IDP Deleted Successfully."));
            } else if (StringUtils.isNotBlank(operation) && status.equals("success")) {
                this.addActionMessage(this.getText("SAML settings updated."));
            }
        }
        catch (MoPluginException e) {
            LOGGER.error("moPluginexeption occurs...", (Throwable)e);
            this.addActionError(e);
            this.initializeSAMLConfig();
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An exeption occurs while saving the configuration", (Throwable)e);
            this.initializeSAMLConfig();
            this.addActionError("An error occurred while saving your details. Please check logs for more info.");
            return "input";
        }
        this.initializeSAMLConfig();
        return "success";
    }

    private void initializeSAMLConfig() {
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.idpMap = this.settings.getIdpMap();
        this.domainsList = new ArrayList<String>();
        this.useDomainMapping = false;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public ArrayList<String> getIdpList() {
        return this.idpList;
    }

    public void setIdpList(ArrayList<String> idpList) {
        this.idpList = idpList;
    }

    public HashMap<String, String> getIdpMap() {
        return this.idpMap;
    }

    public void setIdpMap(HashMap<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    public Boolean getDomainsSubmitted() {
        return this.domainsSubmitted;
    }

    public void setDomainsSubmitted(Boolean domainsSubmitted) {
        this.domainsSubmitted = domainsSubmitted;
    }

    public String[] getDomains() {
        return this.domains;
    }

    public void setDomains(String[] domains) {
        this.domains = domains;
    }

    public List<String> getDomainsList() {
        return this.domainsList;
    }

    public void setDomainsList(List<String> domainsList) {
        this.domainsList = domainsList;
    }

    public Boolean getUseDomainMapping() {
        return this.useDomainMapping;
    }

    public void setUseDomainMapping(Boolean useDomainMapping) {
        this.useDomainMapping = useDomainMapping;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }
}

