/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.crowd.scheduler.UpdateLicenseService;
import java.net.URI;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoAccountDetailsAction
extends BaseAction {
    public static Logger LOGGER = LoggerFactory.getLogger(MoAccountDetailsAction.class);
    private MoSAMLSettings settings;
    private UpdateLicenseService updateLicenseService;
    private String email;
    private Boolean reregister;
    private Boolean checklicense;
    private MoPluginHandler moPluginHandler;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;

    @Autowired
    public MoAccountDetailsAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler, UpdateLicenseService updateLicenseService) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.updateLicenseService = updateLicenseService;
    }

    public void validate() {
        LOGGER.debug("Account Details Action: validate() called");
    }

    public String execute() throws Exception {
        LOGGER.info("Account Details Action: execute() called");
        try {
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                return "register";
            }
            if (this.reregister != null && BooleanUtils.toBoolean((Boolean)this.reregister)) {
                LOGGER.debug("deactivating customes account");
                this.moPluginHandler.deactivateAndRemoveCustomerAccount();
                this.updateLicenseService.unschedule();
                return "register";
            }
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            if (this.settings.isCustomerRegistered().booleanValue() && BooleanUtils.toBoolean((Boolean)this.checklicense)) {
                LOGGER.debug("License check initated...");
                this.moPluginHandler.getLicencedUsers(this.settings);
                this.addActionMessage(this.getText("License check success"));
            }
            this.initializeSAMLConfig();
            return "success";
        }
        catch (MoPluginException ex) {
            this.moPluginHandler.deactivateAndRemoveCustomerAccount();
            this.addActionMessage(this.getText("License Not Found. Please contact support-atlassian@miniorange.atlassian.net for more details."));
            return "register";
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while while verifying license against registered account ", (Throwable)e);
            this.initializeSAMLConfig();
            this.addActionMessage(this.getText("An error occured please check logs for more information"));
            return "success";
        }
    }

    private void initializeSAMLConfig() {
        this.email = this.settings.getCustomerEmail();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getChecklicense() {
        return this.checklicense;
    }

    public void setChecklicense(Boolean checklicense) {
        this.checklicense = checklicense;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }
}

