/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Logger;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.codecs.Base64;
import org.owasp.esapi.codecs.CSSCodec;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.HTMLEntityCodec;
import org.owasp.esapi.codecs.JSONCodec;
import org.owasp.esapi.codecs.JavaScriptCodec;
import org.owasp.esapi.codecs.PercentCodec;
import org.owasp.esapi.codecs.VBScriptCodec;
import org.owasp.esapi.codecs.XMLEntityCodec;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.IntrusionException;

public class DefaultEncoder
implements Encoder {
    private static volatile Encoder singletonInstance;
    private List codecs = new ArrayList();
    private HTMLEntityCodec htmlCodec = new HTMLEntityCodec();
    private XMLEntityCodec xmlCodec = new XMLEntityCodec();
    private PercentCodec percentCodec = new PercentCodec();
    private JavaScriptCodec javaScriptCodec = new JavaScriptCodec();
    private VBScriptCodec vbScriptCodec = new VBScriptCodec();
    private CSSCodec cssCodec = new CSSCodec();
    private JSONCodec jsonCodec = new JSONCodec();
    private final Logger logger = ESAPI.getLogger("Encoder");
    private static final char[] IMMUNE_HTML;
    private static final char[] IMMUNE_HTMLATTR;
    private static final char[] IMMUNE_CSS;
    private static final char[] IMMUNE_JAVASCRIPT;
    private static final char[] IMMUNE_VBSCRIPT;
    private static final char[] IMMUNE_XML;
    private static final char[] IMMUNE_SQL;
    private static final char[] IMMUNE_OS;
    private static final char[] IMMUNE_XMLATTR;
    private static final char[] IMMUNE_XPATH;
    private static final char[] IMMUNE_JSON;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Encoder getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<DefaultEncoder> clazz = DefaultEncoder.class;
        synchronized (DefaultEncoder.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new DefaultEncoder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    private DefaultEncoder() {
        this(ESAPI.securityConfiguration().getDefaultCanonicalizationCodecs());
    }

    public DefaultEncoder(List<String> codecNames) {
        for (String clazz : codecNames) {
            try {
                if (clazz.indexOf(46) == -1) {
                    clazz = "org.owasp.esapi.codecs." + clazz;
                }
                this.codecs.add(Class.forName(clazz).newInstance());
            }
            catch (Exception e) {
                this.logger.warning(Logger.EVENT_FAILURE, "Codec " + clazz + " listed in ESAPI.properties not on classpath");
            }
        }
    }

    @Override
    public String canonicalize(String input) {
        if (input == null) {
            return null;
        }
        return this.canonicalize(input, !ESAPI.securityConfiguration().getAllowMultipleEncoding(), !ESAPI.securityConfiguration().getAllowMixedEncoding());
    }

    @Override
    public String canonicalize(String input, boolean strict) {
        return this.canonicalize(input, strict, strict);
    }

    @Override
    public String canonicalize(String input, boolean restrictMultiple, boolean restrictMixed) {
        if (input == null) {
            return null;
        }
        String working = input;
        Codec codecFound = null;
        int mixedCount = 1;
        int foundCount = 0;
        boolean clean = false;
        while (!clean) {
            clean = true;
            Iterator i = this.codecs.iterator();
            while (i.hasNext()) {
                String old = working;
                Codec codec = (Codec)i.next();
                if (old.equals(working = codec.decode(working))) continue;
                if (codecFound != null && codecFound != codec) {
                    ++mixedCount;
                }
                codecFound = codec;
                if (clean) {
                    ++foundCount;
                }
                clean = false;
            }
        }
        if (foundCount >= 2 && mixedCount > 1) {
            if (restrictMultiple || restrictMixed) {
                throw new IntrusionException("Input validation failure", "Multiple (" + foundCount + "x) and mixed encoding (" + mixedCount + "x) detected in " + input);
            }
            this.logger.warning(Logger.SECURITY_FAILURE, "Multiple (" + foundCount + "x) and mixed encoding (" + mixedCount + "x) detected in " + input);
        } else if (foundCount >= 2) {
            if (restrictMultiple) {
                throw new IntrusionException("Input validation failure", "Multiple (" + foundCount + "x) encoding detected in " + input);
            }
            this.logger.warning(Logger.SECURITY_FAILURE, "Multiple (" + foundCount + "x) encoding detected in " + input);
        } else if (mixedCount > 1) {
            if (restrictMixed) {
                throw new IntrusionException("Input validation failure", "Mixed encoding (" + mixedCount + "x) detected in " + input);
            }
            this.logger.warning(Logger.SECURITY_FAILURE, "Mixed encoding (" + mixedCount + "x) detected in " + input);
        }
        return working;
    }

    @Override
    public String encodeForHTML(String input) {
        if (input == null) {
            return null;
        }
        return this.htmlCodec.encode(IMMUNE_HTML, input);
    }

    @Override
    public String decodeForHTML(String input) {
        if (input == null) {
            return null;
        }
        return this.htmlCodec.decode(input);
    }

    @Override
    public String encodeForHTMLAttribute(String input) {
        if (input == null) {
            return null;
        }
        return this.htmlCodec.encode(IMMUNE_HTMLATTR, input);
    }

    @Override
    public String encodeForCSS(String input) {
        if (input == null) {
            return null;
        }
        return this.cssCodec.encode(IMMUNE_CSS, input);
    }

    @Override
    public String encodeForJavaScript(String input) {
        if (input == null) {
            return null;
        }
        return this.javaScriptCodec.encode(IMMUNE_JAVASCRIPT, input);
    }

    @Override
    public String encodeForVBScript(String input) {
        if (input == null) {
            return null;
        }
        return this.vbScriptCodec.encode(IMMUNE_VBSCRIPT, input);
    }

    @Override
    public String encodeForSQL(Codec codec, String input) {
        if (input == null) {
            return null;
        }
        return codec.encode(IMMUNE_SQL, input);
    }

    @Override
    public String encodeForOS(Codec codec, String input) {
        if (input == null) {
            return null;
        }
        return codec.encode(IMMUNE_OS, input);
    }

    @Override
    public String encodeForLDAP(String input) {
        return this.encodeForLDAP(input, true);
    }

    @Override
    public String encodeForLDAP(String input, boolean encodeWildcards) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\5c");
                    continue block10;
                }
                case '/': {
                    sb.append("\\2f");
                    continue block10;
                }
                case '*': {
                    if (encodeWildcards) {
                        sb.append("\\2a");
                        continue block10;
                    }
                    sb.append(c);
                    continue block10;
                }
                case '(': {
                    sb.append("\\28");
                    continue block10;
                }
                case ')': {
                    sb.append("\\29");
                    continue block10;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block10;
                }
                default: {
                    if (c >= '\u0080') {
                        try {
                            byte[] u;
                            for (byte b : u = String.valueOf(c).getBytes("UTF-8")) {
                                sb.append(String.format("\\%02x", b));
                            }
                            continue block10;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            continue block10;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String encodeForDN(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (input.length() > 0 && (input.charAt(0) == ' ' || input.charAt(0) == '#')) {
            sb.append('\\');
        }
        block13: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("\\00");
                    continue block13;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block13;
                }
                case '/': {
                    sb.append("\\/");
                    continue block13;
                }
                case ',': {
                    sb.append("\\,");
                    continue block13;
                }
                case '+': {
                    sb.append("\\+");
                    continue block13;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block13;
                }
                case '<': {
                    sb.append("\\<");
                    continue block13;
                }
                case '>': {
                    sb.append("\\>");
                    continue block13;
                }
                case ';': {
                    sb.append("\\;");
                    continue block13;
                }
                default: {
                    if (c >= '\u0080') {
                        try {
                            byte[] u;
                            for (byte b : u = String.valueOf(c).getBytes("UTF-8")) {
                                sb.append(String.format("\\%02x", b));
                            }
                            continue block13;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            continue block13;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        if (input.length() > 1 && input.charAt(input.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    @Override
    public String encodeForXPath(String input) {
        if (input == null) {
            return null;
        }
        return this.htmlCodec.encode(IMMUNE_XPATH, input);
    }

    @Override
    public String encodeForXML(String input) {
        if (input == null) {
            return null;
        }
        return this.xmlCodec.encode(IMMUNE_XML, input);
    }

    @Override
    public String encodeForXMLAttribute(String input) {
        if (input == null) {
            return null;
        }
        return this.xmlCodec.encode(IMMUNE_XMLATTR, input);
    }

    @Override
    public String encodeForURL(String input) throws EncodingException {
        if (input == null) {
            return null;
        }
        try {
            return URLEncoder.encode(input, ESAPI.securityConfiguration().getCharacterEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncodingException("Encoding failure", "Character encoding not supported", ex);
        }
        catch (Exception e) {
            throw new EncodingException("Encoding failure", "Problem URL encoding input", e);
        }
    }

    @Override
    public String decodeFromURL(String input) throws EncodingException {
        if (input == null) {
            return null;
        }
        String canonical = this.canonicalize(input);
        try {
            return URLDecoder.decode(canonical, ESAPI.securityConfiguration().getCharacterEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncodingException("Decoding failed", "Character encoding not supported", ex);
        }
        catch (Exception e) {
            throw new EncodingException("Decoding failed", "Problem URL decoding input", e);
        }
    }

    @Override
    public String encodeForBase64(byte[] input, boolean wrap) {
        if (input == null) {
            return null;
        }
        int options = 0;
        if (!wrap) {
            options |= 8;
        }
        return Base64.encodeBytes(input, options);
    }

    @Override
    public byte[] decodeFromBase64(String input) throws IOException {
        if (input == null) {
            return null;
        }
        return Base64.decode(input);
    }

    @Override
    public String getCanonicalizedURI(URI dirtyUri) throws IntrusionException {
        EnumMap<UriSegment, String> parseMap = new EnumMap<UriSegment, String>(UriSegment.class);
        parseMap.put(UriSegment.SCHEME, dirtyUri.getScheme());
        parseMap.put(UriSegment.AUTHORITY, dirtyUri.getRawAuthority());
        parseMap.put(UriSegment.SCHEMSPECIFICPART, dirtyUri.getRawSchemeSpecificPart());
        parseMap.put(UriSegment.HOST, dirtyUri.getHost());
        Integer port = new Integer(dirtyUri.getPort());
        parseMap.put(UriSegment.PORT, port == -1 ? "" : port.toString());
        parseMap.put(UriSegment.PATH, dirtyUri.getRawPath());
        parseMap.put(UriSegment.QUERY, dirtyUri.getRawQuery());
        parseMap.put(UriSegment.FRAGMENT, dirtyUri.getRawFragment());
        StringBuilder sb = new StringBuilder();
        Set set = parseMap.keySet();
        SecurityConfiguration sg = ESAPI.securityConfiguration();
        boolean allowMixed = sg.getBooleanProp("Encoder.AllowMixedEncoding");
        boolean allowMultiple = sg.getBooleanProp("Encoder.AllowMultipleEncoding");
        for (UriSegment seg : set) {
            String value = this.canonicalize((String)parseMap.get((Object)seg), allowMultiple, allowMixed);
            String string = value = value == null ? "" : value;
            if (seg == UriSegment.QUERY && null != parseMap.get((Object)seg)) {
                StringBuilder qBuilder = new StringBuilder();
                try {
                    Map<String, List<String>> canonicalizedMap = this.splitQuery(dirtyUri);
                    Set<Map.Entry<String, List<String>>> query = canonicalizedMap.entrySet();
                    Iterator<Map.Entry<String, List<String>>> i = query.iterator();
                    while (i.hasNext()) {
                        Map.Entry<String, List<String>> e = i.next();
                        String key = e.getKey();
                        String qVal = "";
                        List<String> list = e.getValue();
                        if (!list.isEmpty()) {
                            qVal = list.get(0);
                        }
                        qBuilder.append(key).append("=").append(qVal);
                        if (!i.hasNext()) continue;
                        qBuilder.append("&");
                    }
                    value = qBuilder.toString();
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.debug(Logger.EVENT_FAILURE, "decoding error when parsing [" + dirtyUri.toString() + "]");
                }
            }
            if (seg == UriSegment.PORT && "-1" == parseMap.get((Object)seg)) {
                value = "";
            }
            parseMap.put(seg, value);
        }
        return this.buildUrl(parseMap);
    }

    protected String buildUrl(Map<UriSegment, String> parseMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(parseMap.get((Object)UriSegment.SCHEME)).append("://").append(parseMap.get((Object)UriSegment.AUTHORITY) == null || parseMap.get((Object)UriSegment.AUTHORITY).equals("") ? "" : parseMap.get((Object)UriSegment.AUTHORITY)).append(parseMap.get((Object)UriSegment.PATH) == null || parseMap.get((Object)UriSegment.PATH).equals("") ? "" : parseMap.get((Object)UriSegment.PATH)).append(parseMap.get((Object)UriSegment.QUERY) == null || parseMap.get((Object)UriSegment.QUERY).equals("") ? "" : "?" + parseMap.get((Object)UriSegment.QUERY)).append(parseMap.get((Object)UriSegment.FRAGMENT) == null || parseMap.get((Object)UriSegment.FRAGMENT).equals("") ? "" : "#" + parseMap.get((Object)UriSegment.FRAGMENT));
        return sb.toString();
    }

    public Map<String, List<String>> splitQuery(URI uri) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = uri.getQuery().split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? this.canonicalize(pair.substring(0, idx)) : pair;
            if (!query_pairs.containsKey(key)) {
                query_pairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)query_pairs.get(key)).add(this.canonicalize(value));
        }
        return query_pairs;
    }

    @Override
    public String encodeForJSON(String input) {
        if (input == null) {
            return null;
        }
        return this.jsonCodec.encode(IMMUNE_JSON, input);
    }

    @Override
    public String decodeFromJSON(String input) {
        if (input == null) {
            return null;
        }
        return this.jsonCodec.decode(input);
    }

    static {
        IMMUNE_HTML = new char[]{',', '.', '-', '_', ' '};
        IMMUNE_HTMLATTR = new char[]{',', '.', '-', '_'};
        IMMUNE_CSS = new char[]{'#'};
        IMMUNE_JAVASCRIPT = new char[]{',', '.', '_'};
        IMMUNE_VBSCRIPT = new char[]{',', '.', '_'};
        IMMUNE_XML = new char[]{',', '.', '-', '_', ' '};
        IMMUNE_SQL = new char[]{' '};
        IMMUNE_OS = new char[]{'-'};
        IMMUNE_XMLATTR = new char[]{',', '.', '-', '_'};
        IMMUNE_XPATH = new char[]{',', '.', '-', '_', ' '};
        IMMUNE_JSON = new char[0];
    }

    public static enum UriSegment {
        AUTHORITY,
        SCHEME,
        SCHEMSPECIFICPART,
        USERINFO,
        HOST,
        PORT,
        PATH,
        QUERY,
        FRAGMENT;

    }
}

