/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.sal.api.user.UserManager;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoEncryptionUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoVerifyLicenseFile
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoVerifyLicenseFile.class);
    private static final String PUBLIC_CERT_PATH = "/certificates/com/miniorange/sso/saml/crowd/publicKey.crt";
    private String configuredKey;
    private UploadedFile licenseFile;
    private Boolean isError = Boolean.FALSE;
    private String errorMessage;
    private final UserManager userManager;
    private final CrowdLicenseManager crowdLicenseManager;
    private final MoSAMLSettings settings;

    public MoVerifyLicenseFile(UserManager userManager, CrowdLicenseManager crowdLicenseManager, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.crowdLicenseManager = crowdLicenseManager;
        this.settings = settings;
    }

    public void doValidate() {
        this.isError = false;
        if (this.licenseFile == null) {
            this.errorMessage = "File not found";
            this.isError = true;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Do Post called:");
        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            if (Boolean.parseBoolean(request.getParameter("submitted"))) {
                String licenseKey = this.handleUpload();
                LOGGER.info("LicenseKey:" + licenseKey);
                if (licenseKey != null && this.isLicenseValid(licenseKey)) {
                    response.sendRedirect(this.settings.getConfigureActionUrl());
                    return;
                }
                LOGGER.debug("Invalid License");
                this.errorMessage = "Invalid_License!";
            }
            response.sendRedirect(this.settings.getLoginActionUrl() + "?errorMessage=" + this.errorMessage);
        } else {
            this.errorMessage = "Admin_Access_required";
            response.sendRedirect(this.settings.getBaseUrl());
        }
    }

    private boolean isLicenseValid(String token) {
        try {
            this.configuredKey = IOUtils.toString(MoVerifyLicenseFile.class.getResourceAsStream(PUBLIC_CERT_PATH), "UTF-8");
            String serverId = this.crowdLicenseManager.getLicense().getServerId();
            LOGGER.info("ServerID:" + serverId);
            URL domainURL = new URL(this.settings.getBaseUrl());
            String domainName = domainURL.getAuthority();
            LOGGER.info("Domain Name:" + domainName);
            token = MoEncryptionUtils.decrypt("u4JpSz2dti6u5kRB", token);
            LOGGER.debug("Token value after enc=" + token);
            RSAPublicKey publicKey = this.getPublicKey();
            Algorithm algorithm = Algorithm.RSA256(publicKey, null);
            JWTVerifier verifier = JWT.require(algorithm).withIssuer("miniOrange").build();
            DecodedJWT jwt = verifier.verify(token);
            LOGGER.debug("License Domain=" + jwt.getClaims().get("domainName").asString());
            if (jwt.getClaims().get("serverID").asString().equals(serverId) || jwt.getClaims().get("domainName").asString().contains(domainName)) {
                return this.saveLicenseDetails(jwt.getClaims());
            }
        }
        catch (Exception exception) {
            LOGGER.debug("An error occurred while verifying license:" + exception);
        }
        return false;
    }

    private boolean saveLicenseDetails(Map<String, Claim> claims) {
        try {
            LOGGER.debug("Saving license details");
            this.settings.setCustomerAPIKey(claims.get("customerKey").asString());
            this.settings.setCustomerEmail(claims.get("customerEmail").asString());
            this.settings.setCustomerId(claims.get("customerId").asString());
            this.settings.setCustomerTokenKey(claims.get("customerToken").asString());
            this.settings.setLicenseVerified(Boolean.TRUE);
            this.settings.setLicenseType(claims.get("licenseType").asString());
            this.settings.setLicencedUsers(Integer.valueOf(claims.get("userTier").asString()));
            this.settings.setLicenseExpireDate(claims.get("ExpiryDate").asString());
            if (!this.settings.getLicenseVerified().booleanValue()) {
                this.errorMessage = "Invalid_Customer_Token_Key";
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Invalid License Details", (Throwable)e);
            this.errorMessage = "Invalid_License";
            return false;
        }
    }

    private RSAPublicKey getPublicKey() {
        String publicKey = this.configuredKey.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        byte[] publicBytes = Base64.decodeBase64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while getting public key", (Throwable)e);
            return null;
        }
    }

    private String handleUpload() throws IOException {
        MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        this.licenseFile = wrapper.getFiles("licenseFile")[0];
        this.doValidate();
        if (!this.isError.booleanValue()) {
            return FileUtils.readFileToString((File)this.licenseFile.getContent());
        }
        return null;
    }
}

