/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.Applications;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.MoSAMLResponse;
import com.miniorange.sso.saml.crowd.MoCrowdSessionManager;
import com.miniorange.sso.saml.crowd.MoCrowdUserManager;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLManager;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoEncryptionUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.xml.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.HtmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

@Named
public class MoSAMLLoginServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoSAMLLoginServlet.class);
    private MoSAMLSettings settings;
    private MoSAMLManager samlManager;
    private MoCrowdUserManager moCrowdUserManager;
    private MoCrowdSessionManager moCrowdSessionManager;
    private MoIDPConfig idpConfig;
    private MoPluginHandler moPluginHandler;
    @ComponentImport
    private ApplicationManager applicationManager;
    @ComponentImport
    private CrowdService crowdService;
    @ComponentImport
    private PropertyManager propertyManager;
    @ComponentImport
    private DirectoryManager directoryManager;
    private final TemplateRenderer renderer;

    @Autowired
    public MoSAMLLoginServlet(MoSAMLSettings settings, MoSAMLManager samlManager, CrowdService crowdService, MoCrowdSessionManager moCrowdSessionManager, MoCrowdUserManager moCrowdUserManager, MoIDPConfig idpConfig, MoPluginHandler moPluginHandler, PropertyManager propertyManager, TemplateRenderer renderer, DirectoryManager directoryManager, ApplicationManager applicationManager) {
        this.settings = settings;
        this.samlManager = samlManager;
        this.crowdService = crowdService;
        this.moCrowdSessionManager = moCrowdSessionManager;
        this.moCrowdUserManager = moCrowdUserManager;
        this.idpConfig = idpConfig;
        this.moPluginHandler = moPluginHandler;
        this.propertyManager = propertyManager;
        this.renderer = renderer;
        this.directoryManager = directoryManager;
        this.applicationManager = applicationManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Boolean isConfigured;
        LOGGER.debug("SAML Authentication Servlet doGet called.");
        String returnTo = request.getParameter("return_to");
        String idpID = request.getParameter("idp");
        if (StringUtils.isBlank((CharSequence)idpID) && !this.settings.getIdPList().isEmpty()) {
            idpID = this.settings.getIdPList().get(0);
        }
        if (StringUtils.isNotBlank((CharSequence)idpID)) {
            this.idpConfig = MoPluginHandler.constructIdpConfigObject(idpID);
        }
        if (this.idpConfig == null || StringUtils.isBlank((CharSequence)this.idpConfig.getId())) {
            try {
                LOGGER.error("Error occurred while generating SAML Request. Error_CODE: IDP_ID_INVALID");
                this.redirectToLoginWithSAMLError(response, null, "Invalid IDP_ID");
                return;
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while generating SAML Request. " + e);
            }
        }
        if ((isConfigured = Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.idpConfig.getSsoUrl()))).booleanValue()) {
            if (StringUtils.isBlank((CharSequence)returnTo)) {
                returnTo = this.settings.getDashboardUrl();
            } else if (StringUtils.contains((CharSequence)returnTo, (CharSequence)"displaysamlrequest")) {
                this.displaySAMLRequest(response);
                return;
            }
            LOGGER.debug("Relay State in SAML Request: " + this.settings.getRelayState());
            if (StringUtils.isBlank((CharSequence)returnTo)) {
                returnTo = this.settings.getSpBaseUrl();
            }
            if (!(StringUtils.isBlank((CharSequence)this.settings.getRelayState()) || returnTo.equals("displaysamlrequest") || returnTo.equals("displaysamlresponse") || returnTo.equals("testidpconfiguration"))) {
                returnTo = this.settings.getRelayState();
            }
            HttpSession relayStateSession = request.getSession();
            relayStateSession.setAttribute("RELAY_STATE", (Object)returnTo);
            this.samlManager.createAuthnRequestAndRedirect(request, response, returnTo, this.idpConfig);
            return;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            LOGGER.debug("SAML Authentication Servlet doPost() called...");
            if (this.settings.getLicenseVerified().booleanValue() && !this.settings.isLicenseExpired().booleanValue()) {
                if (this.settings.isNoOfUserExceed().booleanValue() && !this.settings.isTrialLicense().booleanValue()) {
                    LOGGER.debug("License Error:User count exceeded ");
                    this.redirectToLoginWithSAMLError(response, null, "license_user_count_exceeded");
                    return;
                }
            } else {
                LOGGER.debug("License Error:Expired");
                this.redirectToLoginWithSAMLError(response, null, "invalid_license");
                return;
            }
            MoSAMLResponse samlResponse = null;
            User ssoUser = null;
            UserTemplate userTemplate = null;
            String relayState = request.getParameter("RelayState");
            relayState = MoSAMLUtils.sanitizeText(relayState);
            String idpid = request.getParameter("idp");
            if (StringUtils.isNotBlank((CharSequence)idpid) && !this.settings.getIdPList().contains(idpid)) {
                LOGGER.error("No IDP Configuration found for IDP ID : " + idpid + ". Redirecting to login page");
                this.redirectToLoginWithSAMLError(response, null, "Invalid IDP_ID");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)idpid) && this.idpConfig == null) {
                if (this.settings.getIdPList().size() >= 1) {
                    idpid = this.settings.getIdPList().get(0);
                } else if (StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                    idpid = "miniorange.saml.DEFAULT_IDP_ID";
                } else {
                    this.redirectToLoginWithSAMLError(response, null, "Invalid IDP_ID");
                    return;
                }
                LOGGER.debug("Constructed idpConfig obj for default IDP ");
                this.idpConfig = MoPluginHandler.constructIdpConfigObject(idpid);
            }
            if (StringUtils.isNotEmpty((CharSequence)idpid) && this.idpConfig == null) {
                LOGGER.debug("Constructed idpConfig obj for  IDP ID :  " + idpid);
                this.idpConfig = MoPluginHandler.constructIdpConfigObject(idpid);
            }
            LOGGER.debug("IDP Config : " + this.idpConfig.toString());
            try {
                samlResponse = this.samlManager.readSAMLResponse(request, response, this.idpConfig);
            }
            catch (MoSAMLException e) {
                if (StringUtils.contains((CharSequence)relayState, (CharSequence)"testidpconfiguration")) {
                    this.showTestConfigurationResult(null, response, e);
                    return;
                }
                this.redirectToLoginWithSAMLError(response, null, "cant_signin_check_configuration");
                return;
            }
            if (StringUtils.contains((CharSequence)samlResponse.getRelayStateURL(), (CharSequence)"testidpconfiguration")) {
                this.showTestConfigurationResult(samlResponse, response, null);
                return;
            }
            if (StringUtils.contains((CharSequence)samlResponse.getRelayStateURL(), (CharSequence)"displaysamlresponse")) {
                this.displaySAMLResponse(samlResponse, request, response, null);
                return;
            }
            String username = "";
            String email = "";
            if (samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute()).length == 1) {
                username = samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute())[0];
            }
            if (samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute()).length == 1) {
                email = samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute())[0];
            }
            LOGGER.debug("Username received: " + username + ", Email received: " + email);
            if (StringUtils.isNotBlank((CharSequence)username)) {
                Cookie cookie;
                try {
                    if (this.idpConfig.getRegexPatternEnabled().booleanValue()) {
                        try {
                            Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)this.idpConfig.getRegexPattern()));
                            Matcher matcher = pattern.matcher(username);
                            LOGGER.debug(matcher);
                            if (matcher.find()) {
                                username = "";
                                if (matcher.groupCount() > 0) {
                                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                                        username = username + matcher.group(i);
                                    }
                                } else {
                                    username = matcher.group();
                                }
                                LOGGER.debug("Username after appling regex: " + username);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Can't signin regex pattern exception occured", e);
                            this.redirectToLoginWithSAMLError(response, e, "cant_signin_check_configuration");
                        }
                    }
                    LOGGER.debug("Login user account by : " + this.idpConfig.getLoginUserAttribute());
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.idpConfig.getLoginUserAttribute(), (CharSequence)"email")) {
                        LOGGER.debug("searching for existing user with email  : " + email);
                        int size = 1;
                        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)email)).returningAtMost(10);
                        LOGGER.debug("user by email search query =  " + query);
                        Iterable usersByEmail = this.crowdService.search((Query)query);
                        LOGGER.debug("usersByEmail =  " + usersByEmail.toString());
                        if (usersByEmail instanceof Collection) {
                            size = ((Collection)usersByEmail).size();
                            LOGGER.debug("Number of users found : " + size);
                            if (size >= 2) {
                                LOGGER.error(" Multiple users found with email : " + email + " Unable to identify the right SSO user. Please check and delete/update duplicate users and try again.");
                                this.redirectToLoginWithSAMLError(response, null, "Multiple users found with the same email");
                                return;
                            }
                        }
                        for (User user : usersByEmail) {
                            LOGGER.debug("user : " + user.getName());
                            ssoUser = user;
                        }
                    } else {
                        LOGGER.debug("searching for existing user with username : " + username);
                        ssoUser = this.findApplicationSpecificUser(samlResponse.getRelayStateURL(), username);
                    }
                    if (ssoUser != null) {
                        LOGGER.debug("SSO User found " + ssoUser.getName());
                    }
                }
                catch (Exception e) {
                    ssoUser = null;
                    LOGGER.debug("User not found");
                }
                if (ssoUser == null) {
                    if (this.idpConfig.getRestrictUserCreation().booleanValue()) {
                        LOGGER.debug("New user creation is restricted. Redirecting to Login page");
                        this.redirectToLoginWithSAMLError(response, null, "User doesn't exist");
                        return;
                    }
                    userTemplate = this.moCrowdUserManager.createNewUser(username, email, samlResponse, this.idpConfig);
                    LOGGER.debug("Creating session for user " + username);
                    this.moCrowdSessionManager.createUserSession(username, request, response, samlResponse, this.idpConfig.getApplicationGroupEnrollment());
                    String cookieValue = samlResponse.getNameId() + "::" + samlResponse.getSessionIndex();
                    cookie = new Cookie("SAMLCOOKIE", MoEncryptionUtils.encrypt(this.settings.getCustomerTokenKey(), cookieValue));
                    cookie.setPath("/");
                    response.addCookie(cookie);
                    Cookie samlIDPCookie = new Cookie("samlsso_idp.key", MoEncryptionUtils.encrypt(this.settings.getCustomerAPIKey(), this.idpConfig.getId()));
                    samlIDPCookie.setPath("/");
                    response.addCookie(samlIDPCookie);
                    this.redirectToSuccessfulAuthLandingPage(request, response, relayState);
                    return;
                }
                if (ssoUser != null) {
                    LOGGER.debug("Updating existing User");
                    Boolean isDeactivated = ssoUser.isActive();
                    if (!isDeactivated.booleanValue()) {
                        if (!this.settings.getAutoActivateUser().booleanValue()) {
                            LOGGER.debug("User is deactivated. Can't create user session, redirecting to the login page");
                            this.redirectToLoginWithSAMLError(response, null, "Can't sign-in user is inactive");
                            return;
                        }
                        this.moCrowdUserManager.reactivateUser(ssoUser);
                    }
                    userTemplate = this.moCrowdUserManager.updateUser(ssoUser, email, samlResponse, this.idpConfig);
                }
                if (ssoUser != null && userTemplate != null) {
                    LOGGER.debug("Athenticating user");
                    this.moCrowdSessionManager.createUserSession(ssoUser.getName(), request, response, samlResponse, this.idpConfig.getApplicationGroupEnrollment());
                    String cookieValue = samlResponse.getNameId() + "::" + samlResponse.getSessionIndex();
                    cookie = new Cookie("SAMLCOOKIE", MoEncryptionUtils.encrypt(this.settings.getCustomerTokenKey(), cookieValue));
                    cookie.setPath("/");
                    response.addCookie(cookie);
                    String ssoDomain = this.settings.getSSODomain();
                    Cookie samlIDPCookie = new Cookie("samlsso_idp.key", this.idpConfig.getId());
                    samlIDPCookie.setPath("/");
                    samlIDPCookie.setDomain(ssoDomain);
                    response.addCookie(samlIDPCookie);
                    this.redirectToSuccessfulAuthLandingPage(request, response, samlResponse.getRelayStateURL());
                    return;
                }
            }
            LOGGER.error("Username not received in the SAML Response. Please check your configuration.");
        }
        catch (Exception e) {
            LOGGER.error("An error occured while verifying the SAML Response.", e);
        }
        LOGGER.error("An error occured login the user. Redirecting to the login page ");
        this.redirectToLoginWithSAMLError(response, null, "Check user profile mapping");
    }

    protected void redirectToSuccessfulAuthLandingPage(HttpServletRequest request, HttpServletResponse response, String relayState) throws IOException, InterruptedException {
        URL redirectUrl;
        LOGGER.debug("Relay state URL : " + relayState);
        if (StringUtils.isBlank((CharSequence)relayState) || StringUtils.isEmpty((CharSequence)relayState)) {
            relayState = this.settings.getDashboardUrl();
        }
        relayState = relayState.replace("\"", "");
        if (!(relayState = MoSAMLUtils.sanitizeText(relayState)).startsWith("http") && !relayState.startsWith("/")) {
            relayState = "/" + relayState;
        }
        if (!relayState.startsWith("http")) {
            relayState = this.settings.getSpBaseUrl().concat(relayState);
        }
        if (!StringUtils.contains((CharSequence)(redirectUrl = new URL(relayState)).getHost(), (CharSequence)this.settings.getSSODomain())) {
            LOGGER.debug("Relay state URL is from outside Crowd SSO domain.");
            HttpSession relayStateSession = request.getSession();
            relayState = "";
            if (relayStateSession.getAttribute("RELAY_STATE") != null) {
                LOGGER.debug("Relay state in session : " + relayState);
                relayState = relayStateSession.getAttribute("RELAY_STATE").toString();
            }
            if (StringUtils.isEmpty((CharSequence)relayState)) {
                relayState = this.settings.getSpBaseUrl();
            }
        }
        MoSAMLManager.httpRedirect(response, relayState);
    }

    protected void redirectToLoginWithSAMLError(HttpServletResponse response, Exception exception, String string) throws ServletException {
        LOGGER.debug("Redirecting to login with SAML Error");
        try {
            if (exception != null) {
                LOGGER.error("SAML Plugin error: " + exception.getMessage(), exception);
            }
            if (BooleanUtils.toBoolean((Boolean)this.settings.getenableErrorMsgTemplate()) || this.settings.getDefaultLoginDisabled().booleanValue() && this.settings.getIdPList().size() == 1) {
                String baseURL = this.settings.getLoginPageUrl();
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("baseUrl", baseURL);
                response.setContentType("text/html;charset=utf-8");
                String result = this.renderer.renderFragment(this.settings.getErrorMsgTemplate(), context);
                response.getWriter().write(result);
            } else {
                String redirectUrl = this.settings.getLoginPageUrl() + "?samlerror=" + string;
                MoSAMLManager.httpRedirect(response, redirectUrl);
            }
        }
        catch (IOException ioException) {
            LOGGER.error("An exception occured while redirecting the user to login page with SAML Error");
            throw new ServletException();
        }
    }

    private void displaySAMLResponse(MoSAMLResponse samlResponse, HttpServletRequest request, HttpServletResponse response, MoSAMLException e) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String encodedSAMLResponse = request.getParameter("SAMLResponse");
        String xml = new String(Base64.decode(encodedSAMLResponse), "UTF-8");
        xml = this.XmlFormatter(xml);
        output.append(xml);
        xml = HtmlUtils.htmlEscape((String)xml);
        output.append("</div>");
        output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>SAML Response</div>");
        output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:1062px; margin:0px; height:350px;' id ='reqmessage' readonly>" + xml + "</textarea> ");
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
        output.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#reqmessage\").select();document.execCommand('copy');};</script>");
        response.setCharacterEncoding("iso-8859-1");
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    public String XmlFormatter(String xml) {
        try {
            InputSource src = new InputSource(new StringReader(xml));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            Boolean keepDeclaration = xml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            return writer.writeToString(document);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void displaySAMLRequest(HttpServletResponse response) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String message = this.idpConfig.getSignedRequest() != false ? this.samlManager.getSignedTestAuthnRequest(this.idpConfig) : this.samlManager.getUnSignedTestAuthnRequest(this.idpConfig);
        message = this.XmlFormatter(message);
        message = HtmlUtils.htmlEscape((String)message);
        output.append(message);
        output.append("</div>");
        output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Authentication(SAML) Request</div>");
        output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:1062px; margin:0px; height:350px;' id ='reqmessage' readonly>" + message + "</textarea> ");
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
        output.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#reqmessage\").select();document.execCommand('copy');};</script>");
        response.setCharacterEncoding("iso-8859-1");
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    private void showTestConfigurationResult(MoSAMLResponse samlResponse, HttpServletResponse response, MoSAMLException e) throws IOException {
        LOGGER.debug("showTestConfigurationResult called");
        if (e == null) {
            String username = "";
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            String[] usernameArray = samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute());
            if (usernameArray != null && usernameArray.length == 1) {
                username = usernameArray[0];
            }
            htmlStart = StringUtils.isBlank((CharSequence)username) ? htmlStart.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">WARNING: Username attribute not found in the response. Users will not be able to login.</div>") : htmlStart.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">TEST SUCCESSFUL</div>");
            htmlStart = htmlStart.append("<span style=\"font-size:14pt;\"><b>Hello</b>, " + username + "</span><br/><p style=\"font-weight:bold;font-size:14pt;margin-left:1%;\">ATTRIBUTES RECEIVED:</p><table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%; font-size:14pt;background-color:#EDEDED;\"><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
            for (String key : samlResponse.getAttributes().keySet()) {
                htmlStart = htmlStart.append("<tr><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + key + "</td><td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
                String[] values = samlResponse.getAttributes().get(key);
                for (int i = 0; i < values.length; ++i) {
                    htmlStart = i == values.length - 1 ? htmlStart.append(StringUtils.join((Object[])new String[]{values[i], "<br/>"})) : htmlStart.append(StringUtils.join((Object[])new String[]{values[i], "<hr/>"}));
                }
                htmlStart = htmlStart.append("</td></tr>");
            }
            htmlStart = htmlStart.append("</table></div>");
            htmlStart = htmlStart.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            response.getOutputStream().write(htmlStart.toString().getBytes("UTF-8"));
        } else {
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            htmlStart = htmlStart.append("<div style=\"color:#a94442;background-color:#f2dede;padding:15px;margin-bottom:20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div>");
            htmlStart = htmlStart.append("<table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%;font-size:14pt;\"><tr style=\"padding-top:10px;padding-bottom:10px;\"><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Code</td><td style=\"word-wrap:break-word;\">" + (Object)((Object)e.getErrorCode()) + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Message</td><td style=\"word-wrap:break-word;\">" + e.getMessage() + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Resolution</td><td style=\"word-wrap:break-word;\">" + e.getResolution() + "</tr></table></div>");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            response.getOutputStream().write(htmlStart.toString().getBytes("UTF-8"));
        }
    }

    public User findApplicationSpecificUser(String relayState, String username) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException {
        List appList = this.applicationManager.findAll();
        LOGGER.debug("Application relay state = " + relayState);
        for (Application app : appList) {
            String applicationUrl = (String)app.getAttributes().get("applicationURL");
            if (applicationUrl == null || !relayState.contains(applicationUrl) && !applicationUrl.contains(relayState) && !app.getRemoteAddresses().toString().contains(relayState)) continue;
            List dirList = Applications.getActiveDirectories((Application)app);
            for (Directory dir2 : dirList) {
                com.atlassian.crowd.model.user.User user = null;
                try {
                    user = this.directoryManager.findUserByName(dir2.getId().longValue(), username);
                }
                catch (Exception e) {
                    LOGGER.debug("User not found in directory = " + dir2.getName());
                }
                if (user == null) continue;
                return user;
            }
            LOGGER.debug("User not found in the application directories = " + app.getName());
        }
        return this.crowdService.getUser(username);
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public void setSamlManager(MoSAMLManager samlManager) {
        this.samlManager = samlManager;
    }

    public MoCrowdUserManager getMoCrowdUserManager() {
        return this.moCrowdUserManager;
    }

    public void setMoCrowdUserManager(MoCrowdUserManager moCrowdUserManager) {
        this.moCrowdUserManager = moCrowdUserManager;
    }

    public MoCrowdSessionManager getMoCrowdSessionManager() {
        return this.moCrowdSessionManager;
    }

    public void setMoCrowdSessionManager(MoCrowdSessionManager moCrowdSessionManager) {
        this.moCrowdSessionManager = moCrowdSessionManager;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public MoSAMLManager getSamlManager() {
        return this.samlManager;
    }
}

