/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoDownloadCertificateAction
extends BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoDownloadCertificateAction.class);
    private MoSAMLSettings settings;

    @Autowired
    public MoDownloadCertificateAction(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String execute() throws Exception {
        LOGGER.info("Download Certificate action execute() called");
        try {
            HttpServletRequest request = ServletActionContext.getRequest();
            HttpServletResponse response = ServletActionContext.getResponse();
            if (this.settings.isCustomerRegistered().booleanValue() && this.settings.getLicenseVerified().booleanValue()) {
                String certificate = this.settings.getPublicSPCertificate();
                response.setHeader("Content-Disposition", "attachment; filename=\"sp-certificate.crt\"");
                response.setHeader("Cache-Control", "max-age=0");
                response.setHeader("Pragma", "");
                response.setContentType("application/octet-stream");
                response.getOutputStream().write(certificate.getBytes());
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occured while downloading the certificate.", (Throwable)e);
        }
        return "input";
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }
}

