/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.scheduler;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.crowd.scheduler.MoMetadataRefreshTask;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Named
public class MoMetadataRefreshService
implements LifecycleAware {
    private static Log LOGGER = LogFactory.getLog(MoMetadataRefreshService.class);
    public static final String KEY = MoMetadataRefreshTask.class.getName() + ":instance";
    private static final String JOB_NAME = MoMetadataRefreshService.class.getName() + ":job";
    public static final String IDP_KEY = MoMetadataRefreshService.class.getName() + ":idp";
    private final MoSAMLSettings settings;
    @ComponentImport
    private final PluginScheduler pluginScheduler;
    private long refreshIntervalInMinutes = 60L;

    @Autowired
    public MoMetadataRefreshService(MoSAMLSettings settings, PluginScheduler pluginScheduler) {
        this.settings = settings;
        this.pluginScheduler = pluginScheduler;
    }

    public void saveSettings(String idpID, String idpName, String metadata) {
        LOGGER.debug("Metadata refresh saveSettings called");
        MoPluginHandler.configureFromMetadata(idpID, idpName, metadata, true);
    }

    public void reschedule(int refreshIntervalInMinutes, final MoIDPConfig idpConfig) {
        LOGGER.info("Rescheduling the refresh metadada");
        String jobName = JOB_NAME;
        if (!idpConfig.getId().equals("miniorange.saml.DEFAULT_IDP_ID")) {
            jobName = jobName + ":" + idpConfig.getId();
        }
        this.refreshIntervalInMinutes = refreshIntervalInMinutes;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, 1);
        long refreshIntervalInMiliseconds = Integer.toUnsignedLong(refreshIntervalInMinutes * 60 * 1000);
        this.pluginScheduler.scheduleJob(jobName, MoMetadataRefreshTask.class, (Map)new HashMap<String, Object>(){
            {
                this.put(KEY, MoMetadataRefreshService.this);
                this.put(IDP_KEY, idpConfig);
            }
        }, cal.getTime(), refreshIntervalInMiliseconds);
    }

    public void unschedule(String idpID) {
        LOGGER.info("Unscheduling the refresh metadada");
        String jobName = JOB_NAME;
        if (!StringUtils.equalsIgnoreCase((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            jobName = jobName + ":" + idpID;
        }
        this.refreshIntervalInMinutes = 60L;
        try {
            this.pluginScheduler.unscheduleJob(jobName);
        }
        catch (IllegalArgumentException t) {
            LOGGER.error("No JOB exist. Can't unschedule.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getMetadataURL(MoIDPConfig idpConfig) {
        if (idpConfig == null) {
            LOGGER.debug("IDP is null");
            return this.settings.getInputMetadataUrl();
        }
        LOGGER.debug("IDP not null");
        return idpConfig.getMetadataUrl();
    }

    private void createARescheduler() {
        LOGGER.info("create Rescheduler the refresh metadada");
        String jobName = JOB_NAME;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, 60);
        long refreshIntervalInMiliseconds = Integer.toUnsignedLong(3600000);
        this.pluginScheduler.scheduleJob(jobName, MoMetadataRefreshTask.class, (Map)new HashMap<String, Object>(){
            {
                this.put(KEY, null);
                this.put(IDP_KEY, null);
            }
        }, cal.getTime(), refreshIntervalInMiliseconds);
    }

    public void onStart() {
        LOGGER.info("MoMetadataRefreshService onStart Called");
        try {
            int interval;
            MoIDPConfig idpConfig = null;
            if (this.settings != null && StringUtils.isNotBlank((CharSequence)this.settings.getInputMetadataUrl()) && BooleanUtils.toBoolean((Boolean)this.settings.getRefreshMetadata())) {
                interval = MoSAMLUtils.getMetadataRefreshInterval(this.settings.getRefreshInterval(), this.settings.getCustomRefreshInterval(), this.settings.getCustomRefreshIntervalUnit());
                idpConfig = MoPluginHandler.constructIdpConfigObject("miniorange.saml.DEFAULT_IDP_ID");
                this.reschedule(interval, idpConfig);
            } else {
                LOGGER.debug("onStart-scheduling and unscheduling Refresh Metadata Task");
                this.createARescheduler();
                this.unschedule("miniorange.saml.DEFAULT_IDP_ID");
            }
            HashMap<String, String> idpMap = this.settings.getIdpMap();
            for (String idpID : idpMap.keySet()) {
                idpConfig = MoPluginHandler.constructIdpConfigObject(idpID);
                if (idpConfig == null || !StringUtils.isNotBlank((CharSequence)idpConfig.getMetadataUrl()) || !BooleanUtils.toBoolean((Boolean)idpConfig.getRefreshMetadata())) continue;
                interval = MoSAMLUtils.getMetadataRefreshInterval(idpConfig.getRefreshInterval(), idpConfig.getCustomRefreshInterval(), idpConfig.getCustomRefreshIntervalUnit());
                this.reschedule(interval, idpConfig);
            }
        }
        catch (NullPointerException e) {
            LOGGER.error("An error occurred while rescheduling Refresh From Metadata Cycle: ", e);
        }
    }

    public void onStop() {
        LOGGER.info("MoMetadataRefreshService onStop Called");
        try {
            MoIDPConfig idpConfig = null;
            if (this.settings != null && StringUtils.isNotBlank((CharSequence)this.settings.getInputMetadataUrl()) && BooleanUtils.toBoolean((Boolean)this.settings.getRefreshMetadata())) {
                this.unschedule("miniorange.saml.DEFAULT_IDP_ID");
            }
            HashMap<String, String> idpMap = this.settings.getIdpMap();
            for (String idpID : idpMap.keySet()) {
                idpConfig = MoPluginHandler.constructIdpConfigObject(idpID);
                if (idpConfig == null || !StringUtils.isNotBlank((CharSequence)idpConfig.getMetadataUrl()) || !BooleanUtils.toBoolean((Boolean)idpConfig.getRefreshMetadata())) continue;
                this.unschedule(idpID);
            }
        }
        catch (NullPointerException e) {
            LOGGER.error("An error occurred while rescheduling Refresh From Metadata Cycle: ", e);
        }
    }

    public long getRefreshIntervalInMinutes() {
        return this.refreshIntervalInMinutes;
    }
}

