/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoGroupMappingAction
extends BaseAction {
    private static Log LOGGER = LogFactory.getLog(MoGroupMappingAction.class);
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    @ComponentImport
    private DirectoryManager directoryManager;
    @ComponentImport
    private CrowdService crowdService;
    private String roleAttribute;
    private String defaultGroups;
    private List<String> defaultGroupsList;
    private HashMap<String, String> roleMapping;
    private Boolean createUsersIfRoleMapped;
    private Boolean keepExistingUserRoles;
    private ArrayList<String> existingGroups;
    private Boolean roleMappingSubmitted;
    private Boolean restrictUserCreation;
    private Boolean updateUserOnlyIfRoleMapped;
    private Boolean applicationGroupEnrollment;
    private String onTheFlyGroupCreation;
    private String[] onTheFlyDoNotRemoveGroups;
    private List<String> onTheFlyDoNotRemoveGroupsList;
    private Boolean createNewGroups;
    private Boolean onTheFlyAssignNewGroupsOnly;
    private Boolean reregister;
    private Boolean checklicense;
    private ArrayList<String> existingDirectory;
    private String defaultDirectory;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private String enableDefaultGroupsFor;
    private HashMap<String, String> idpMap;
    private String idpID;
    private String idpName;
    private Boolean gmIdpChanged;
    private Boolean groupRegexPatternEnabled;
    private String onTheFlyFilterIDPGroupsOption;
    private String onTheFlyFilterIDPGroupsKey;
    private String regexPatternForGroup;
    private String testRegex;
    private String regexGroups;
    private List<String> groupFilterOptionsList;

    @Autowired
    public MoGroupMappingAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler, DirectoryManager directoryManager, CrowdService crowdService) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.directoryManager = directoryManager;
        this.crowdService = crowdService;
    }

    public void validate() {
        LOGGER.info("GroupMapping Action execute");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.roleMappingSubmitted)) {
            return;
        }
        if (super.hasActionErrors()) {
            this.initializeSAMLConfig();
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.info("GroupMapping action execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            LOGGER.debug("GroupMapping Action execute Submitted: " + this.roleMappingSubmitted);
            if (!this.settings.isCustomerRegistered().booleanValue()) {
                return "register";
            }
            LOGGER.debug("registered cutomer");
            if (!this.settings.getLicenseVerified().booleanValue() || this.settings.getLicenseVerified().booleanValue() && this.settings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            LOGGER.debug("verified customer");
            this.gmIdpChanged = Boolean.parseBoolean(request.getParameter("gmIdpChanged"));
            if (BooleanUtils.toBoolean((Boolean)this.roleMappingSubmitted)) {
                this.validate();
                HashMap<String, String> roleMapping = new HashMap<String, String>();
                ArrayList<String> existingGroup = this.getExistingGroups();
                List<Object> defaultGroupList = new ArrayList();
                if (this.defaultGroups != null) {
                    LOGGER.debug("multiple default groups -" + this.defaultGroups);
                    this.defaultGroups = this.defaultGroups.replaceAll("\\s", "");
                    String[] defaultGrp = this.defaultGroups.split(",");
                    defaultGroupList = Arrays.asList(defaultGrp);
                    defaultGroupList.removeAll(Arrays.asList(null, ""));
                }
                int totalNumberOfRoles = Integer.parseInt(request.getParameter("totalNumberOfRoles"));
                for (int i = 0; i < totalNumberOfRoles; ++i) {
                    String key = StringUtils.trimToEmpty((String)request.getParameter("userGroupKey_" + i));
                    String value = StringUtils.trimToEmpty((String)request.getParameter("userGroupValue_" + i));
                    if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value) || StringUtils.equalsIgnoreCase((CharSequence)"select-group-to-map", (CharSequence)key) || BooleanUtils.toBoolean((Boolean)roleMapping.containsKey(key))) continue;
                    roleMapping.put(key.trim(), value.trim());
                }
                LOGGER.debug("IS ON THE FLY ENABLED:" + this.onTheFlyGroupCreation);
                if (this.onTheFlyDoNotRemoveGroups != null) {
                    LOGGER.debug("Excluded groups from on-the-fly group mapping-" + this.onTheFlyDoNotRemoveGroups.length);
                    this.onTheFlyDoNotRemoveGroupsList = Arrays.asList(StringUtils.split((String)this.onTheFlyDoNotRemoveGroups[0], (String)","));
                    this.onTheFlyDoNotRemoveGroupsList.removeAll(Arrays.asList(null, ""));
                }
                MoPluginHandler.saveRoleMapping(this.idpID, this.roleAttribute, this.createUsersIfRoleMapped, this.keepExistingUserRoles, roleMapping, defaultGroupList, BooleanUtils.toBoolean((Boolean)this.restrictUserCreation), BooleanUtils.toBoolean((Boolean)this.updateUserOnlyIfRoleMapped), this.defaultDirectory, this.enableDefaultGroupsFor, Boolean.parseBoolean(this.onTheFlyGroupCreation), this.onTheFlyDoNotRemoveGroupsList, this.createNewGroups, this.onTheFlyAssignNewGroupsOnly, BooleanUtils.toBoolean((Boolean)this.applicationGroupEnrollment), this.groupRegexPatternEnabled, this.onTheFlyFilterIDPGroupsOption, this.onTheFlyFilterIDPGroupsKey, this.regexPatternForGroup, this.regexGroups, this.testRegex);
                this.addActionMessage(this.getText("SAML settings updated."));
            }
            if (StringUtils.isBlank((CharSequence)this.idpID)) {
                if (!this.settings.getIdpMap().isEmpty()) {
                    this.idpID = this.settings.getIdPList().get(0);
                } else {
                    this.idpID = UUID.randomUUID().toString();
                    if (StringUtils.isNotBlank((CharSequence)this.settings.getSsoServiceUrl())) {
                        this.idpName = "IDP";
                        this.moPluginHandler.replaceOldSettingsWithNew(this.idpID, this.idpName);
                    } else {
                        this.initializeNewForm();
                        return "success";
                    }
                }
            }
            this.initializeSAMLConfig();
            return "success";
        }
        catch (MoPluginException e) {
            LOGGER.error("An plugin exception occurred while initializing groups mapping configuration", e);
            this.addActionError(e);
            this.initializeSAMLConfig();
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while initializing group mapping configuration", e);
            this.addActionError("Error while saving rolemapping.");
            this.initializeSAMLConfig();
            return "input";
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeSAMLConfig() {
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(this.idpID);
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.createUsersIfRoleMapped = idpConfig.getCreateUsersIfRoleMapped();
        this.keepExistingUserRoles = idpConfig.getKeepExistingUserRoles();
        this.defaultGroupsList = idpConfig.getDefaultGroups();
        this.roleMapping = idpConfig.getRoleMapping();
        this.roleAttribute = idpConfig.getRoleAttribute();
        this.defaultDirectory = idpConfig.getDefaultDirectory();
        this.existingDirectory = this.getExistingDirectory();
        this.existingGroups = this.getExistingGroups();
        this.restrictUserCreation = idpConfig.getRestrictUserCreation();
        this.updateUserOnlyIfRoleMapped = idpConfig.getUpdateUserOnlyIfRoleMapped();
        this.enableDefaultGroupsFor = idpConfig.getEnableDefaultGroupsFor();
        this.onTheFlyGroupCreation = idpConfig.getOnTheFlyGroupCreation() != false ? "true" : "false";
        this.onTheFlyDoNotRemoveGroupsList = idpConfig.getOnTheFlyDoNotRemoveGroups();
        this.createNewGroups = idpConfig.getCreateNewGroups();
        this.onTheFlyAssignNewGroupsOnly = idpConfig.getOnTheFlyAssignNewGroupsOnly();
        this.applicationGroupEnrollment = idpConfig.getApplicationGroupEnrollment();
        this.groupRegexPatternEnabled = idpConfig.getGroupRegexPatternEnabled();
        this.onTheFlyFilterIDPGroupsOption = idpConfig.getOnTheFlyFilterIDPGroupsOption();
        this.onTheFlyFilterIDPGroupsKey = idpConfig.getOnTheFlyFilterIDPGroupsKey();
        this.regexPatternForGroup = idpConfig.getRegexPatternForGroup();
        this.testRegex = idpConfig.getTestRegex();
        this.regexGroups = idpConfig.getRegexGroups();
    }

    private void initializeNewForm() {
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.createUsersIfRoleMapped = this.settings.getCreateUsersIfRoleMapped();
        this.keepExistingUserRoles = this.settings.getKeepExistingUserRoles();
        this.defaultGroupsList = this.settings.getDefaultGroups();
        this.roleMapping = this.settings.getRoleMapping();
        this.roleAttribute = this.settings.getRoleAttribute();
        this.defaultDirectory = this.settings.getDefaultDirectory();
        this.existingDirectory = this.getExistingDirectory();
        this.existingGroups = this.getExistingGroups();
        this.restrictUserCreation = this.settings.getRestrictUserCreation();
        this.updateUserOnlyIfRoleMapped = this.settings.getUpdateUserOnlyIfRoleMapped();
        this.enableDefaultGroupsFor = this.settings.getEnableDefaultGroupsFor();
        this.onTheFlyGroupCreation = this.settings.getOnTheFlyGroupCreation() != false ? "true" : "false";
        this.onTheFlyDoNotRemoveGroupsList = this.settings.getOnTheFlyDoNotRemoveGroups();
        this.createNewGroups = this.settings.getCreateNewGroups();
        this.onTheFlyAssignNewGroupsOnly = this.settings.getOnTheFlyAssignNewGroupsOnly();
        this.applicationGroupEnrollment = this.settings.getApplicationGroupEnrollment();
        this.groupRegexPatternEnabled = this.settings.getGroupRegexPatternEnabled();
        this.onTheFlyFilterIDPGroupsOption = this.settings.getOnTheFlyFilterIDPGroupsOption();
        this.onTheFlyFilterIDPGroupsKey = this.settings.getOnTheFlyFilterIDPGroupsKey();
        this.regexPatternForGroup = this.settings.getRegexPatternForGroup();
        this.testRegex = this.settings.getTestRegex();
        this.regexGroups = this.settings.getRegexGroups();
    }

    public ArrayList<String> getExistingDirectory() {
        List directoryObjects = this.directoryManager.findAllDirectories();
        this.existingDirectory = new ArrayList();
        for (Directory directory : directoryObjects) {
            this.existingDirectory.add(directory.getName());
        }
        return this.existingDirectory;
    }

    public ArrayList<String> getExistingGroups() {
        try {
            this.existingGroups = this.getAllGroups();
            return this.existingGroups;
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while getting list of groups from Crowd Server", e);
            return null;
        }
    }

    protected ArrayList<String> getAllGroups() {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(50);
        LOGGER.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        LOGGER.debug("groups =  " + groups);
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public void setExistingGroups(ArrayList<String> existingGroup) {
        this.existingGroups = existingGroup;
    }

    public MoPluginHandler getPluginHandler() {
        return this.moPluginHandler;
    }

    public void setPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public String getDefaultGroups() {
        return this.defaultGroups;
    }

    public void setDefaultGroups(String defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    public List<String> getDefaultGroupsList() {
        return this.defaultGroupsList;
    }

    public void setDefaultGroupsList(List<String> defaultGroupsList) {
        this.defaultGroupsList = defaultGroupsList;
    }

    public HashMap<String, String> getRoleMapping() {
        return this.roleMapping;
    }

    public void setRoleMapping(HashMap<String, String> roleMapping) {
        this.roleMapping = roleMapping;
    }

    public Boolean getRestrictUserCreation() {
        return this.restrictUserCreation;
    }

    public void setRestrictUserCreation(Boolean restrictUserCreation) {
        this.restrictUserCreation = restrictUserCreation;
    }

    public Boolean getUpdateUserOnlyIfRoleMapped() {
        return this.updateUserOnlyIfRoleMapped;
    }

    public void setUpdateUserOnlyIfRoleMapped(Boolean updateUserOnlyIfRoleMapped) {
        this.updateUserOnlyIfRoleMapped = updateUserOnlyIfRoleMapped;
    }

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public void setRoleAttribute(String roleAttribute) {
        this.roleAttribute = roleAttribute;
    }

    public Boolean getCreateUsersIfRoleMapped() {
        return this.createUsersIfRoleMapped;
    }

    public void setCreateUsersIfRoleMapped(Boolean createUsersIfRoleMapped) {
        this.createUsersIfRoleMapped = createUsersIfRoleMapped;
    }

    public Boolean getKeepExistingUserRoles() {
        return this.keepExistingUserRoles;
    }

    public void setKeepExistingUserRoles(Boolean keepExistingUserRoles) {
        this.keepExistingUserRoles = keepExistingUserRoles;
    }

    public Boolean getRoleMappingSubmitted() {
        return this.roleMappingSubmitted;
    }

    public void setRoleMappingSubmitted(Boolean roleMappingSubmitted) {
        this.roleMappingSubmitted = roleMappingSubmitted;
    }

    public String getOnTheFlyGroupCreation() {
        return this.onTheFlyGroupCreation;
    }

    public void setOnTheFlyGroupCreation(String onTheFlyGroupCreation) {
        this.onTheFlyGroupCreation = onTheFlyGroupCreation;
    }

    public String[] getOnTheFlyDoNotRemoveGroups() {
        return this.onTheFlyDoNotRemoveGroups;
    }

    public void setOnTheFlyDoNotRemoveGroups(String[] onTheFlyDoNotRemoveGroups) {
        this.onTheFlyDoNotRemoveGroups = onTheFlyDoNotRemoveGroups;
    }

    public List<String> getOnTheFlyDoNotRemoveGroupsList() {
        return this.onTheFlyDoNotRemoveGroupsList;
    }

    public void setOnTheFlyDoNotRemoveGroupsList(List<String> onTheFlyDoNotRemoveGroupsList) {
        this.onTheFlyDoNotRemoveGroupsList = onTheFlyDoNotRemoveGroupsList;
    }

    public Boolean getCreateNewGroups() {
        return this.createNewGroups;
    }

    public void setCreateNewGroups(Boolean createNewGroups) {
        this.createNewGroups = createNewGroups;
    }

    public Boolean getOnTheFlyAssignNewGroupsOnly() {
        return this.onTheFlyAssignNewGroupsOnly;
    }

    public void setOnTheFlyAssignNewGroupsOnly(Boolean onTheFlyAssignNewGroupsOnly) {
        this.onTheFlyAssignNewGroupsOnly = onTheFlyAssignNewGroupsOnly;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getChecklicense() {
        return this.checklicense;
    }

    public void setChecklicense(Boolean checklicense) {
        this.checklicense = checklicense;
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void setDefaultDirectory(String defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
    }

    public void setExistingDirectory(ArrayList existingDirectory) {
        this.existingDirectory = existingDirectory;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public String getEnableDefaultGroupsFor() {
        return this.enableDefaultGroupsFor;
    }

    public void setEnableDefaultGroupsFor(String enableDefaultGroupsFor) {
        this.enableDefaultGroupsFor = enableDefaultGroupsFor;
    }

    public String getIdpID() {
        return this.idpID;
    }

    public void setIdpID(String idpID) {
        this.idpID = idpID;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public Boolean getGmIdpChanged() {
        return this.gmIdpChanged;
    }

    public void setGmIdpChanged(Boolean gmIdpChanged) {
        this.gmIdpChanged = gmIdpChanged;
    }

    public HashMap<String, String> getIdpMap() {
        this.idpMap = this.settings.getIdpMap();
        return this.idpMap;
    }

    public void setIdpMap(HashMap<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    public Boolean getApplicationGroupEnrollment() {
        return this.applicationGroupEnrollment;
    }

    public void setApplicationGroupEnrollment(Boolean applicationGroupEnrollment) {
        this.applicationGroupEnrollment = applicationGroupEnrollment;
    }

    public Boolean getGroupRegexPatternEnabled() {
        return this.groupRegexPatternEnabled;
    }

    public void setGroupRegexPatternEnabled(Boolean groupRegexPatternEnabled) {
        this.groupRegexPatternEnabled = groupRegexPatternEnabled;
    }

    public String getOnTheFlyFilterIDPGroupsOption() {
        return this.onTheFlyFilterIDPGroupsOption;
    }

    public void setOnTheFlyFilterIDPGroupsOption(String onTheFlyFilterIDPGroupsOption) {
        this.onTheFlyFilterIDPGroupsOption = onTheFlyFilterIDPGroupsOption;
    }

    public String getOnTheFlyFilterIDPGroupsKey() {
        return this.onTheFlyFilterIDPGroupsKey;
    }

    public void setOnTheFlyFilterIDPGroupsKey(String onTheFlyFilterIDPGroupsKey) {
        this.onTheFlyFilterIDPGroupsKey = onTheFlyFilterIDPGroupsKey;
    }

    public String getRegexPatternForGroup() {
        return this.regexPatternForGroup;
    }

    public void setRegexPatternForGroup(String regexPatternForGroup) {
        this.regexPatternForGroup = regexPatternForGroup;
    }

    public String getTestRegex() {
        return this.testRegex;
    }

    public void setTestRegex(String testRegex) {
        this.testRegex = testRegex;
    }

    public void setGroupFilterOptionsList(List<String> groupFilterOptionsList) {
        this.groupFilterOptionsList = groupFilterOptionsList;
    }

    public List<String> getGroupFilterOptionsList() {
        ArrayList<String> filterOption = new ArrayList<String>();
        filterOption.add("None");
        filterOption.add("Starts with");
        filterOption.add("Contains");
        filterOption.add("Regex");
        this.groupFilterOptionsList = filterOption;
        return this.groupFilterOptionsList;
    }

    public String getRegexGroups() {
        return this.regexGroups;
    }

    public void setRegexGroups(String regexGroups) {
        this.regexGroups = regexGroups;
    }
}

