/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Named
public class PluginInstallEvent
implements InitializingBean,
DisposableBean {
    private MoSAMLSettings settings;
    private MoPluginHandler pluginHandler;
    private static Log LOGGER = LogFactory.getLog(PluginInstallEvent.class);

    @Autowired
    public PluginInstallEvent(MoSAMLSettings settings, MoPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public void afterPropertiesSet() {
        LOGGER.debug("Initiating plugin = " + this.settings.getTrialActivated());
        boolean trialActivated = this.settings.getTrialActivated();
        if (!trialActivated) {
            this.pluginHandler.generateTrial();
            LOGGER.debug("First install.......initiating trial");
        }
    }

    public void destroy() {
    }
}

