/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.velocity.one.six.VelocityTemplateRenderer;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.MoSAMLResponse;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@Scanned
@Named
public class MoSAMLManager {
    private static Log LOGGER = LogFactory.getLog(MoSAMLManager.class);
    private MoSAMLSettings settings;
    @ComponentImport
    private VelocityTemplateRenderer renderer;

    @Autowired
    public MoSAMLManager(MoSAMLSettings settings, VelocityTemplateRenderer renderer) {
        this.settings = settings;
        this.renderer = renderer;
    }

    public void createAuthnRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String relayState, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating Signed AuthnRequest...");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(this.settings.getSpEntityId(), this.settings.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getSsoBindingType(), idpConfig.getNameIdFormat());
            if (StringUtils.equals((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SSO");
                if (idpConfig.getSignedRequest().booleanValue()) {
                    authnRequest = (AuthnRequest)MoSAMLUtils.signHttpPostRequest(authnRequest, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
                }
                String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest(authnRequest, true);
                String form = this.createHttpPostRequestForm(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState);
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes("UTF-8"));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SSO");
            String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest(authnRequest, false);
            LOGGER.debug("encoded request = " + encodedAuthnRequest);
            String urlForSignature = this.createRequestQueryParamsForSignature(encodedAuthnRequest, relayState);
            String signature = MoSAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            String redirectUrl = "";
            redirectUrl = idpConfig.getSignedRequest() != false ? this.createRedirectURL(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, false) : this.createUnSignedRedirectURL(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState, false);
            MoSAMLManager.httpRedirect(response, redirectUrl);
            return;
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the AuthnRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public String getSignedTestAuthnRequest(MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating AuthRequest");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(this.settings.getSpBaseUrl(), this.settings.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getSsoBindingType(), idpConfig.getNameIdFormat());
            if (idpConfig.getSignedRequest().booleanValue() && StringUtils.equals((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpPost")) {
                authnRequest = (AuthnRequest)MoSAMLUtils.signHttpPostRequest(authnRequest, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            }
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authnRequest);
            Element authDOM = marshaller.marshall(authnRequest);
            Document doc = authDOM.getOwnerDocument();
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            LOGGER.debug(((Object)out).toString());
            String requestMessage = ((Object)out).toString();
            return requestMessage;
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while creating the AuthnRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public String getUnSignedTestAuthnRequest(MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating AuthRequest");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(this.settings.getSpBaseUrl(), this.settings.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getSsoBindingType(), idpConfig.getNameIdFormat());
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authnRequest);
            Element authDOM = marshaller.marshall(authnRequest);
            Document doc = authDOM.getOwnerDocument();
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            LOGGER.debug(((Object)out).toString());
            String requestMessage = ((Object)out).toString();
            return requestMessage;
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while creating the AuthnRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public MoSAMLResponse readSAMLResponse(HttpServletRequest request, HttpServletResponse response, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Verifying SAML Response...");
            MoSAMLUtils.doBootstrap();
            String encodedSAMLResponse = request.getParameter("SAMLResponse");
            String relayState = request.getParameter("RelayState");
            Response samlResponse = MoSAMLUtils.decodeResponse(encodedSAMLResponse);
            if (!StringUtils.equals((CharSequence)samlResponse.getStatus().getStatusCode().getValue(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
                LOGGER.error("Invalid SAML response. SAML Status Code received: " + samlResponse.getStatus().getStatusCode().getValue());
                String message = "";
                if (samlResponse.getStatus().getStatusMessage() != null) {
                    LOGGER.error("Saml Status Message received: " + samlResponse.getStatus().getStatusMessage().getMessage());
                    message = samlResponse.getStatus().getStatusMessage().getMessage() + ". Status Code received in SAML response: " + samlResponse.getStatus().getStatusCode().getValue().split(":")[7];
                } else {
                    message = "Invalid status code \"" + samlResponse.getStatus().getStatusCode().getValue().split(":")[7] + "\" received in SAML response";
                }
                throw new MoSAMLException(MoSAMLException.SAMLErrorCode.INVALID_SAML_STATUS);
            }
            Assertion assertion = samlResponse.getAssertions() != null && samlResponse.getAssertions().size() > 0 ? samlResponse.getAssertions().get(0) : MoSAMLUtils.decryptAssertion(samlResponse.getEncryptedAssertions().get(0), this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            this.verifyConditions(assertion, this.settings.getSpEntityId());
            this.verifyIssuer(samlResponse, assertion, idpConfig.getIdpEntityId());
            this.verifyDestination(samlResponse, this.settings.getLoginServletUrl(), idpConfig.getId());
            this.verifyRecipient(assertion, this.settings.getLoginServletUrl(), idpConfig.getId());
            MoSAMLException samlException = null;
            Boolean verified = Boolean.FALSE;
            try {
                List<String> certificates = idpConfig.getCertificates();
                LOGGER.debug("no of certificates are:" + certificates.size());
                LOGGER.debug("certificates are :" + certificates);
                if (certificates != null) {
                    for (int index = 0; index < certificates.size(); ++index) {
                        try {
                            LOGGER.debug("verifying licence no: " + index);
                            verified = this.verifyCertificate(samlResponse, assertion, certificates.get(index));
                        }
                        catch (MoSAMLException e) {
                            samlException = e;
                        }
                        if (verified.booleanValue()) break;
                    }
                }
                if (certificates.size() == 0) {
                    LOGGER.debug("Certificates count is 0.");
                    try {
                        LOGGER.debug("Verifying licence.");
                        verified = this.verifyCertificate(samlResponse, assertion, idpConfig.getX509Certificate());
                    }
                    catch (MoSAMLException e) {
                        samlException = e;
                    }
                }
            }
            catch (MoSAMLException e) {
                samlException = e;
            }
            catch (NullPointerException e) {
                LOGGER.error(e.getMessage(), e);
            }
            if (!verified.booleanValue()) {
                LOGGER.error(samlException.getMessage(), samlException);
                throw samlException;
            }
            Map<String, String[]> attributes = this.getAttributes(assertion);
            NameID nameId = assertion.getSubject().getNameID();
            String nameIdValue = "";
            String sessionIndex = assertion.getAuthnStatements().get(0).getSessionIndex();
            if (nameId != null) {
                nameIdValue = nameId.getValue();
            }
            attributes.put("NameID", new String[]{nameIdValue});
            MoSAMLResponse samlResponseObj = new MoSAMLResponse(attributes, nameIdValue, sessionIndex, relayState);
            return samlResponseObj;
        }
        catch (MoSAMLException e) {
            LOGGER.error(e.getMessage(), e);
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while verifying the SAML Response.", e);
            throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private void verifyIssuer(Response response, Assertion assertion, String idpEntityId) {
        LOGGER.debug("Verifying Issuer in Response and Assertion...");
        String issuerInResponse = response.getIssuer().getValue();
        String issuerInAssertion = assertion.getIssuer().getValue();
        LOGGER.debug("Issuer In Assertion : " + issuerInAssertion);
        LOGGER.debug("Issuer In Response : " + issuerInResponse);
        LOGGER.debug("Issuer configured : " + idpEntityId);
        if (!StringUtils.equals((CharSequence)issuerInResponse, (CharSequence)idpEntityId)) {
            LOGGER.error("Invalid Issuer in the SAML Response");
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_ISSUER;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInResponse), errorCode);
            throw e;
        }
        if (!StringUtils.equals((CharSequence)issuerInAssertion, (CharSequence)idpEntityId)) {
            LOGGER.error("Invalid Issuer in the SAML Assertion");
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_ISSUER;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInAssertion), errorCode);
            throw e;
        }
    }

    private void verifyDestination(Response response, String acsUrl, String idpID) {
        LOGGER.debug("Verifying Destination if present...");
        String destInResponse = response.getDestination();
        LOGGER.debug("Issuer In destination : " + destInResponse);
        LOGGER.debug("Destination URL of the app(default) : " + acsUrl);
        String updatedAcsURL = acsUrl;
        if (StringUtils.isNotEmpty((CharSequence)idpID)) {
            updatedAcsURL = acsUrl + "?idp=" + idpID;
            LOGGER.debug("Updated Destination URL for the app : " + updatedAcsURL);
        }
        if (!(StringUtils.isBlank((CharSequence)destInResponse) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)acsUrl) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)updatedAcsURL))) {
            LOGGER.error("Invalid destination in the SAML Response");
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_DESTINATION;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, destInResponse), errorCode);
            throw e;
        }
    }

    private void verifyRecipient(Assertion assertion, String acsUrl, String idpID) {
        LOGGER.debug("Verifying Recipient if present...");
        String recipientInResponse = assertion.getSubject().getSubjectConfirmations().get(0).getSubjectConfirmationData().getRecipient();
        LOGGER.debug("Issuer In Recipient : " + recipientInResponse);
        LOGGER.debug("Recipient URL for the app : " + acsUrl);
        String updatedAcsURL = acsUrl;
        if (StringUtils.isNotEmpty((CharSequence)idpID)) {
            updatedAcsURL = acsUrl + "?idp=" + idpID;
            LOGGER.debug("Updated Recipient URL for the app : " + updatedAcsURL);
        }
        if (!(StringUtils.isBlank((CharSequence)recipientInResponse) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)acsUrl) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)updatedAcsURL))) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_RECIPIENT;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, recipientInResponse), errorCode);
            LOGGER.error("Invalid ACS URL in the SAML Response");
            throw e;
        }
    }

    private String TimeDiff(MoSAMLException.SAMLErrorCode error, long temp, String replacement) {
        StringBuffer errorMsg = new StringBuffer(error.getResolution());
        errorMsg.append(" Set your Server clock " + replacement + " by ");
        errorMsg.append(temp);
        errorMsg.append(" minutes  Or you can Increase ");
        errorMsg.append(temp);
        errorMsg.append(" minutes in  validate Saml Response in Advanced SSO Options tab.");
        return errorMsg.toString();
    }

    public long timeInMiliseconds() {
        String time = this.settings.getTimeDelay();
        LOGGER.debug("Time is: " + time);
        long timeDelay = Long.valueOf(time);
        timeDelay = timeDelay * 60L * 1000L;
        return timeDelay;
    }

    private void verifyConditions(Assertion assertion, String audienceExpected) {
        LOGGER.debug("Verifying Conditions...");
        String replacement = " ";
        MoSAMLException samlException = null;
        Date now = new DateTime().toDate();
        Date notBefore = null;
        Date notOnOrAfter = null;
        long timeDifferenceInBefore = 0L;
        long timeDifferenceInAfter = 0L;
        if (assertion.getConditions().getNotBefore() != null) {
            notBefore = assertion.getConditions().getNotBefore().toDate();
            if (now.before(notBefore)) {
                timeDifferenceInBefore = Math.abs(notBefore.getTime() - now.getTime());
            }
            LOGGER.debug("timeDifferenceInBefore = " + timeDifferenceInBefore);
        }
        if (assertion.getConditions().getNotOnOrAfter() != null) {
            notOnOrAfter = assertion.getConditions().getNotOnOrAfter().toDate();
            if (now.after(notOnOrAfter)) {
                timeDifferenceInAfter = Math.abs(now.getTime() - notOnOrAfter.getTime());
            }
            LOGGER.debug("timeDifferenceInAfter = " + timeDifferenceInAfter);
        }
        long userAddedDelay = this.timeInMiliseconds();
        long timeDiff = 0L;
        if (notBefore != null && now.before(notBefore) && userAddedDelay - timeDifferenceInBefore < 0L) {
            timeDiff = -(userAddedDelay - timeDifferenceInBefore);
            replacement = "Forward";
        } else if (notOnOrAfter != null && (now.after(notOnOrAfter) || now.equals(notOnOrAfter)) && userAddedDelay - timeDifferenceInAfter < 0L) {
            timeDiff = timeDifferenceInAfter - userAddedDelay;
            replacement = "Back";
        }
        long valueInMinutes = timeDiff / 60000L % 60L;
        long finalValueInMinutes = Math.incrementExact(valueInMinutes);
        if (notBefore != null && now.before(notBefore) && userAddedDelay - timeDifferenceInBefore < 0L) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CONDITIONS;
            samlException = new MoSAMLException(errorCode.getMessage(), this.TimeDiff(errorCode, finalValueInMinutes, replacement), errorCode);
            LOGGER.error(samlException.getMessage(), samlException);
            throw samlException;
        }
        if (notOnOrAfter != null && (now.after(notOnOrAfter) || now.equals(notOnOrAfter)) && userAddedDelay - timeDifferenceInAfter < 0L) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CONDITIONS;
            samlException = new MoSAMLException(errorCode.getMessage(), this.TimeDiff(errorCode, finalValueInMinutes, replacement), errorCode);
            LOGGER.error(samlException.getMessage(), samlException);
            throw samlException;
        }
        List<Audience> audiencesInAssertion = assertion.getConditions().getAudienceRestrictions().get(0).getAudiences();
        for (Audience audience : audiencesInAssertion) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)audience.getAudienceURI(), (CharSequence)audienceExpected)) continue;
            return;
        }
        samlException = new MoSAMLException(MoSAMLException.SAMLErrorCode.INVALID_AUDIENCE);
        LOGGER.error(MoSAMLException.SAMLErrorCode.INVALID_AUDIENCE.getMessage(), samlException);
        throw samlException;
    }

    private Boolean verifyCertificate(Response response, Assertion assertion, String x509Certificate) {
        LOGGER.debug("Verifying Certificate...");
        MoSAMLException samlException = null;
        if (x509Certificate != null) {
            try {
                if (!response.isSigned() && !assertion.isSigned()) {
                    MoSAMLException e = new MoSAMLException(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
                    LOGGER.error(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED.getMessage(), e);
                    throw e;
                }
                if (response.isSigned()) {
                    return MoSAMLUtils.verifyCertificate(response, x509Certificate);
                }
                if (assertion.isSigned()) {
                    return MoSAMLUtils.verifyCertificate(assertion, x509Certificate);
                }
                LOGGER.error("Error occurred while verifying the certificate");
            }
            catch (NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
                MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CERTIFICATE;
                samlException = new MoSAMLException(errorCode.getMessage(), this.buildResolutionForCertificate(errorCode, assertion, response), errorCode);
                throw samlException;
            }
            catch (ValidationException e) {
                MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_SIGNATURE;
                samlException = new MoSAMLException(errorCode.getMessage(), this.buildResolutionForCertificate(errorCode, assertion, response), errorCode);
                throw samlException;
            }
        }
        return false;
    }

    private String buildResolutionForCertificate(MoSAMLException.SAMLErrorCode error, Assertion assertion, Response response) {
        String certificateExpected = " ";
        try {
            List<X509Data> x509Datas;
            if (assertion.isSigned()) {
                x509Datas = assertion.getSignature().getKeyInfo().getX509Datas();
                for (X509Data x509Data : x509Datas) {
                    List<X509Certificate> certificates = x509Data.getX509Certificates();
                    for (X509Certificate certificate : certificates) {
                        certificateExpected = certificate.getValue();
                    }
                }
            } else if (response.isSigned()) {
                x509Datas = response.getSignature().getKeyInfo().getX509Datas();
                for (X509Data x509Data : x509Datas) {
                    List<X509Certificate> certificates = x509Data.getX509Certificates();
                    for (X509Certificate certificate : certificates) {
                        certificateExpected = certificate.getValue();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
        StringBuffer errorMsg = new StringBuffer(error.getResolution());
        errorMsg.append(" Expected certificate : ");
        errorMsg.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:580px; margin:0px; height:290px;' id ='errormsg' readonly>-----BEGIN CERTIFICATE-----" + certificateExpected + "-----END CERTIFICATE-----</textarea> ");
        errorMsg.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
        errorMsg.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#errormsg\").select();document.execCommand('copy');};</script>");
        return errorMsg.toString();
    }

    private Map<String, String[]> getAttributes(Assertion assertion) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        if (assertion.getAttributeStatements().size() > 0) {
            for (Attribute attr : assertion.getAttributeStatements().get(0).getAttributes()) {
                if (attr.getAttributeValues().size() <= 0) continue;
                String[] values = new String[attr.getAttributeValues().size()];
                for (int i = 0; i < attr.getAttributeValues().size(); ++i) {
                    values[i] = attr.getAttributeValues().get(i).getDOM().getTextContent();
                }
                attributes.put(attr.getName(), values);
            }
        }
        return attributes;
    }

    public void createLogoutRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String nameId, String sessionIndex, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating LogoutRequest...");
            MoSAMLUtils.doBootstrap();
            LogoutRequest logoutRequest = MoSAMLUtils.buildLogoutRequest(this.settings.getSpEntityId(), idpConfig.getSloUrl(), nameId, sessionIndex);
            if (StringUtils.equals((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SLO");
                logoutRequest = (LogoutRequest)MoSAMLUtils.signHttpPostRequest(logoutRequest, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
                String encodedLogoutRequest = MoSAMLUtils.base64EncodeRequest(logoutRequest, true);
                String form = this.createHttpPostRequestForm(idpConfig.getSloUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl());
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes("UTF-8"));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SLO");
            String encodedLogoutRequest = MoSAMLUtils.base64EncodeRequest(logoutRequest, false);
            String urlForSignature = this.createRequestQueryParamsForSignature(encodedLogoutRequest, this.settings.getLoginPageUrl());
            String signature = MoSAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            String redirectUrl = "";
            redirectUrl = idpConfig.getSignedRequest() != false ? this.createRedirectURL(idpConfig.getSloUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, false) : this.createUnSignedRedirectURL(idpConfig.getSloUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl(), false);
            response.sendRedirect(redirectUrl);
            return;
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the LogoutRequest.", t);
            t.printStackTrace();
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createUnSignedLogoutRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String nameId, String sessionIndex) {
        try {
            LOGGER.debug("Creating LogoutRequest...");
            MoSAMLUtils.doBootstrap();
            LogoutRequest logoutRequest = MoSAMLUtils.buildLogoutRequest(this.settings.getSpEntityId(), this.settings.getSloServiceUrl(), nameId, sessionIndex);
            if (StringUtils.equals((CharSequence)this.settings.getSloBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SLO");
                String encodedLogoutRequest = MoSAMLUtils.base64EncodeRequest(logoutRequest, true);
                String form = this.createHttpPostRequestForm(this.settings.getSloServiceUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl());
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes("UTF-8"));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SLO");
            String encodedLogoutRequest = MoSAMLUtils.base64EncodeRequest(logoutRequest, false);
            String redirectUrl = this.createUnSignedRedirectURL(this.settings.getSloServiceUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl(), false);
            response.sendRedirect(redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the LogoutRequest.", t);
            t.printStackTrace();
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createLogoutResponseAndRedirect(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating LogoutResponse...");
            MoSAMLUtils.doBootstrap();
            String logoutRequestStr = request.getParameter("SAMLRequest");
            LogoutRequest logoutRequest = MoSAMLUtils.readLogoutRequest(logoutRequestStr, isPostRequest);
            LogoutResponse logoutResponse = MoSAMLUtils.buildLogoutResponse(this.settings.getSpEntityId(), idpConfig.getSloUrl(), logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success");
            if (StringUtils.equals((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SLO");
                logoutResponse = (LogoutResponse)MoSAMLUtils.signHttpPostRequest(logoutResponse, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
                String encodedLogoutResponse = MoSAMLUtils.base64EncodeRequest(logoutResponse, true);
                String form = this.createHttpPostResponseForm(idpConfig.getSloUrl(), encodedLogoutResponse, request.getParameter("RelayState"));
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes("UTF-8"));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SLO");
            String encodedLogoutResponse = MoSAMLUtils.base64EncodeRequest(logoutResponse, false);
            String urlForSignature = this.createResponseQueryParamsForSignature(encodedLogoutResponse, request.getParameter("RelayState"));
            String signature = MoSAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            String redirectUrl = this.createRedirectURL(idpConfig.getSloUrl(), encodedLogoutResponse, request.getParameter("RelayState"), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, true);
            response.sendRedirect(redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the LogoutRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createUnSignedLogoutResponseAndRedirect(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest) {
        try {
            LOGGER.debug("Creating LogoutResponse...");
            MoSAMLUtils.doBootstrap();
            String logoutRequestStr = request.getParameter("SAMLRequest");
            LogoutRequest logoutRequest = MoSAMLUtils.readLogoutRequest(logoutRequestStr, isPostRequest);
            LogoutResponse logoutResponse = MoSAMLUtils.buildLogoutResponse(this.settings.getSpEntityId(), this.settings.getSloServiceUrl(), logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success");
            if (StringUtils.equals((CharSequence)this.settings.getSloBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SLO");
                String encodedLogoutResponse = MoSAMLUtils.base64EncodeRequest(logoutResponse, true);
                String form = this.createHttpPostResponseForm(this.settings.getSloServiceUrl(), encodedLogoutResponse, request.getParameter("RelayState"));
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes("UTF-8"));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SLO");
            String encodedLogoutResponse = MoSAMLUtils.base64EncodeRequest(logoutResponse, false);
            String redirectUrl = this.createUnSignedRedirectURL(this.settings.getSloServiceUrl(), encodedLogoutResponse, request.getParameter("RelayState"), true);
            response.sendRedirect(redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the LogoutRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private String buildResolutionMessage(MoSAMLException.SAMLErrorCode error, String expected, String found) {
        StringBuffer errorMsg = new StringBuffer(error.getResolution());
        errorMsg.append(" Add-on was expecting ");
        errorMsg.append(found);
        errorMsg.append(" but found: ");
        errorMsg.append(expected);
        return errorMsg.toString();
    }

    private String createRedirectURL(String url, String samlRequestOrResponse, String relayState, String sigAlgo, String signature, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        builder.append("&").append("SigAlg").append("=").append(URLEncoder.encode(sigAlgo, "UTF-8")).append("&").append("Signature").append("=").append(URLEncoder.encode(signature, "UTF-8"));
        return builder.toString();
    }

    private String createUnSignedRedirectURL(String url, String samlRequestOrResponse, String relayState, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        return builder.toString();
    }

    private String createRequestQueryParamsForSignature(String httpRedirectRequest, String relayState) throws UnsupportedEncodingException {
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLRequest").append("=").append(URLEncoder.encode(httpRedirectRequest, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String createResponseQueryParamsForSignature(String httpRedirectResponse, String relayState) throws UnsupportedEncodingException {
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLResponse").append("=").append(URLEncoder.encode(httpRedirectResponse, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String createHttpPostRequestForm(String ssoUrl, String encodedRequest, String relayState) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("ssoUrl", ssoUrl);
        context.put("encodedRequest", MoSAMLUtils.htmlEncode(encodedRequest));
        context.put("relayState", MoSAMLUtils.htmlEncode(relayState));
        String form = this.renderer.renderFragment(this.settings.getSAMLPostRequest(), context);
        LOGGER.debug("result = " + form);
        return form;
    }

    private String createHttpPostResponseForm(String ssoUrl, String encodedResponse, String relayState) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("ssoUrl", ssoUrl);
        context.put("encodedResponse", MoSAMLUtils.htmlEncode(encodedResponse));
        context.put("relayState", MoSAMLUtils.htmlEncode(relayState));
        String form = this.renderer.renderFragment(this.settings.getSAMLPostResponse(), context);
        LOGGER.debug("result = " + form);
        return form;
    }

    public static void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        LOGGER.debug("Redirecting user to " + redirectUrl);
        response.sendRedirect(redirectUrl);
    }

    public String formatXML(String xml) {
        String responseMessage = xml;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            responseMessage = ((Object)out).toString();
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while parsing the response.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
        return responseMessage;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }
}

