/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Named
public class MoPluginConfigurationsHandler {
    private static Log LOGGER = LogFactory.getLog(MoPluginConfigurationsHandler.class);
    private static MoSAMLSettings settings;
    private static MoPluginHandler pluginHandler;

    @Autowired
    public MoPluginConfigurationsHandler(MoSAMLSettings settings, MoPluginHandler pluginHandler) {
        MoPluginConfigurationsHandler.settings = settings;
        MoPluginConfigurationsHandler.pluginHandler = pluginHandler;
    }

    public String generateConfigurationsJson() throws JSONException {
        LOGGER.debug("Generating configurations JSON string ");
        JSONObject config = new JSONObject();
        HashMap<String, String> idpMap = settings.getIdpMap();
        for (String idpID : idpMap.keySet()) {
            JSONObject idpConfig = new JSONObject();
            MoIDPConfig idpConfigObj = MoPluginHandler.constructIdpConfigObject(idpID);
            idpConfig.put("ID", idpID);
            idpConfig.put("Name", idpMap.get(idpID));
            this.insertConfigSP(idpConfig, idpConfigObj);
            this.insertAttributeMapping(idpConfig, idpConfigObj);
            this.insertGroupMapping(idpConfig, idpConfigObj);
            this.insertImportMetadata(idpConfig, idpConfigObj);
            config.append("Identity Providers", idpConfig);
        }
        this.insertConfigIdP(config);
        this.insertSignOnSettings(config);
        this.insertCertificates(config);
        this.insertTroubleShootSettings(config);
        return config.toString(2);
    }

    private void insertConfigIdP(JSONObject config) {
        LOGGER.debug("Inserting SP in JSON Object.");
        JSONObject configIdp = new JSONObject();
        try {
            configIdp.putOpt("SP Entity ID", settings.getSpEntityId());
            configIdp.putOpt("SP Base URL", settings.getSpBaseUrl());
            configIdp.putOpt("Include Signing Certificate in Metadata", settings.getSigning());
            configIdp.putOpt("Include Encryption Certificate in Metadata", settings.getEncryption());
            config.putOpt("SP Info", configIdp);
        }
        catch (JSONException e) {
            LOGGER.error("Error occurred while inserting SP configuration in JSON Object " + e.getMessage() + " Cause: " + e.getCause());
            e.printStackTrace();
        }
    }

    private static void importConfigureIdPConfigurations(JSONObject configureIdPObj) throws JSONException {
        LOGGER.debug("importConfigureIdPConfigurations called ");
        String spEntityId = configureIdPObj.optString("SP Entity ID", "");
        String spBaseUrl = configureIdPObj.optString("SP Base URL", "");
        Boolean signing = configureIdPObj.optBoolean("Include Signing Certificate in Metadata", Boolean.TRUE);
        Boolean encryption = configureIdPObj.optBoolean("Include Encryption Certificate in Metadata", Boolean.FALSE);
        pluginHandler.saveSPConfiguration(spBaseUrl, spEntityId);
        pluginHandler.saveSPCertificates(signing, encryption);
    }

    private void insertConfigSP(JSONObject config, MoIDPConfig idpConfigObj) {
        LOGGER.debug("Inserting IdP configuration in JSON Object.");
        JSONObject configSP = new JSONObject();
        try {
            configSP.putOpt("IDP Entity ID / Issuer", idpConfigObj.getIdpEntityId());
            configSP.putOpt("Send Signed Requests", idpConfigObj.getSignedRequest());
            configSP.putOpt("SSO Binding Type", idpConfigObj.getSsoBindingType());
            configSP.putOpt("Single Sign On URL", idpConfigObj.getSsoUrl());
            configSP.putOpt("SLO Binding Type", idpConfigObj.getSloBindingType());
            configSP.putOpt("Single Logout URL", idpConfigObj.getSloUrl());
            configSP.putOpt("NameID Format", idpConfigObj.getNameIdFormat());
            configSP.putOpt("Metadata Url", idpConfigObj.getMetadataUrl());
            configSP.putOpt("Refresh Metadata", idpConfigObj.getRefreshMetadata());
            configSP.putOpt("Refresh Interval", idpConfigObj.getRefreshInterval());
            configSP.putOpt("Custom Refresh Interval", idpConfigObj.getCustomRefreshInterval());
            configSP.putOpt("Custom Refresh Interval Unit", idpConfigObj.getCustomRefreshIntervalUnit());
            if (idpConfigObj.getCertificates() != null) {
                List<String> certificates = idpConfigObj.getCertificates();
                for (String certificate : certificates) {
                    configSP.append("IdP Signing Certificates", certificate);
                }
            } else {
                configSP.append("IdP Signing Certificates", "");
            }
            config.putOpt("Configure SP", configSP);
        }
        catch (JSONException e) {
            LOGGER.debug("Error occurred while inserting IdP Configuration in JSON " + e.getMessage() + " Cause: " + e.getCause());
            e.printStackTrace();
        }
    }

    public static void importConfigSPConfigurations(JSONObject configSP, String idpName, String idpID) throws JSONException {
        LOGGER.debug("importConfigSPConfigurations called ");
        String idpEntityId = configSP.optString("IDP Entity ID / Issuer", "");
        String ssoBinding = configSP.optString("SSO Binding Type", "");
        String ssoUrl = configSP.optString("Single Sign On URL", "");
        String sloBinding = configSP.optString("SLO Binding Type", "");
        String sloUrl = configSP.optString("Single Logout URL", "");
        String nameIdFormat = configSP.optString("NameID Format", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Boolean signedRequest = configSP.optBoolean("Send Signed Requests", Boolean.TRUE);
        JSONArray signingCertificates = configSP.optJSONArray("IdP Signing Certificates");
        String metadataUrl = configSP.optString("Metadata Url", "");
        Boolean refreshMetadata = configSP.optBoolean("Refresh Metadata", Boolean.FALSE);
        String refreshInterval = configSP.optString("Refresh Interval", "");
        Integer customRefreshInterval = configSP.optInt("Custom Refresh Interval", 60);
        String customRefreshIntervalUnit = configSP.optString("Custom Refresh Interval Unit", "");
        ArrayList<String> x509AllCertificates = new ArrayList<String>();
        String x509Certificate = "";
        if (signingCertificates != null) {
            x509Certificate = signingCertificates.optString(0, "");
            for (int i = 0; i < signingCertificates.length(); ++i) {
                x509AllCertificates.add(signingCertificates.optString(i, ""));
            }
        }
        MoPluginHandler.saveIdPConfiguration(idpID, idpName, idpEntityId, ssoBinding, ssoUrl, sloBinding, sloUrl, x509AllCertificates, x509Certificate, signedRequest, nameIdFormat, metadataUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
    }

    private void insertImportMetadata(JSONObject config, MoIDPConfig idpConfigObj) {
        LOGGER.debug("Inserting refresh metadata in JSON Object.   ");
        JSONObject importMetadata = new JSONObject();
        try {
            importMetadata.putOpt("Metadata Url/Domain", idpConfigObj.getMetadataUrl());
            importMetadata.putOpt("Refresh Metadata", idpConfigObj.getRefreshMetadata());
            importMetadata.putOpt("Refresh Interval", idpConfigObj.getRefreshInterval());
            importMetadata.putOpt("Custom Refresh Interval", idpConfigObj.getCustomRefreshInterval());
            importMetadata.putOpt("Custom Refresh Interval Unit", idpConfigObj.getCustomRefreshIntervalUnit());
            config.put("Import Metadata", importMetadata);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while inserting refresh metadata configuration in JSON " + e.getMessage() + " Cause: " + e.getCause());
        }
    }

    private static void importImportMetadataConfigurations(JSONObject importMetadataObj, String idpName, String idpID) throws Exception {
        LOGGER.debug("importImportMetadataConfigurations called ");
        String metadataUrl = importMetadataObj.optString("Metadata Url/Domain", "");
        Boolean refreshMetadata = importMetadataObj.optBoolean("Refresh Metadata", Boolean.FALSE);
        String refreshInterval = importMetadataObj.optString("Refresh Interval", "hourly");
        Integer customRefreshInterval = importMetadataObj.optInt("Custom Refresh Interval", 60);
        String customRefreshIntervalUnit = importMetadataObj.optString("Custom Refresh Interval Unit", "minutes");
        MoPluginHandler.saveImportMetadata(idpID, metadataUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
        MoPluginHandler.toggleSchedulerService(idpID);
    }

    private void insertAttributeMapping(JSONObject config, MoIDPConfig idpConfigObj) {
        LOGGER.debug("Inserting Attribute Mapping configuration in JSON Object. ");
        JSONObject attributeMapping = new JSONObject();
        try {
            attributeMapping.putOpt("Disable Attribute Mapping", idpConfigObj.getKeepExistingUserAttributes());
            attributeMapping.putOpt("Create/Login Crowd user account by", idpConfigObj.getLoginUserAttribute());
            attributeMapping.putOpt("Username", idpConfigObj.getUsernameAttribute());
            attributeMapping.putOpt("Regex Enabled", idpConfigObj.getRegexPatternEnabled());
            if (idpConfigObj.getRegexPatternEnabled().booleanValue()) {
                attributeMapping.putOpt("Regex Pattern", idpConfigObj.getRegexPattern());
            }
            attributeMapping.putOpt("Email", idpConfigObj.getEmailAttribute());
            attributeMapping.putOpt("First Name", idpConfigObj.getFirstNameAttribute());
            attributeMapping.putOpt("Last Name", idpConfigObj.getLastNameAttribute());
            attributeMapping.putOpt("Display Name", idpConfigObj.getFullNameAttribute());
            JSONObject mapping = new JSONObject();
            if (idpConfigObj.getCustomAttributeMapping() != null) {
                for (String attribute : idpConfigObj.getCustomAttributeMapping().keySet()) {
                    mapping.putOpt(attribute, idpConfigObj.getCustomAttributeMapping().get(attribute));
                }
            }
            attributeMapping.putOpt("Custom Attribute Mapping", mapping);
            config.putOpt("Attribute Mapping", attributeMapping);
        }
        catch (JSONException e) {
            LOGGER.error("Error occurred while inserting Attribute Mapping configuration in JSON " + e.getMessage() + " Cause: " + e.getCause());
            e.printStackTrace();
        }
    }

    private static void importAttributeMappingConfigurations(JSONObject attributeMappingObj, String idpName, String idpID) throws JSONException {
        LOGGER.debug("importAttributeMappingConfigurations called ");
        Boolean keepExistingUserAttributes = attributeMappingObj.optBoolean("Disable Attribute Mapping", Boolean.FALSE);
        String loginUserAttribute = attributeMappingObj.optString("Create/Login Crowd user account by", "");
        String usernameAttr = attributeMappingObj.optString("Username", "NameID");
        Boolean regexPatternEnabled = attributeMappingObj.optBoolean("Regex Enabled", Boolean.FALSE);
        String regexPattern = attributeMappingObj.optString("Regex Pattern", "");
        String emailAttr = attributeMappingObj.optString("Email", "NameID");
        String firstNameAttribute = attributeMappingObj.optString("First Name", "");
        String lastNameAttribute = attributeMappingObj.optString("Last Name", "");
        String fullNameAttr = attributeMappingObj.optString("Display Name", "");
        JSONObject customAttributeMappingObject = attributeMappingObj.optJSONObject("Custom Attribute Mapping");
        HashMap<String, String> customAttributeMapping = new HashMap<String, String>();
        Iterator<String> customAttributeMappingIterator = customAttributeMappingObject.keys();
        while (customAttributeMappingIterator.hasNext()) {
            String attributeKey = customAttributeMappingIterator.next();
            customAttributeMapping.put(attributeKey, customAttributeMappingObject.getString(attributeKey));
        }
        MoPluginHandler.saveAttributeMapping(idpID, usernameAttr, emailAttr, fullNameAttr, firstNameAttribute, lastNameAttribute, keepExistingUserAttributes, loginUserAttribute, regexPatternEnabled, regexPattern, customAttributeMapping);
    }

    private void insertGroupMapping(JSONObject config, MoIDPConfig idpConfigObj) {
        LOGGER.debug("Inserting Group Mapping configuration in JSON Object. ");
        JSONObject groupMapping = new JSONObject();
        try {
            groupMapping.putOpt("Restrict User Creation", idpConfigObj.getRestrictUserCreation());
            groupMapping.putOpt("Default Directory", idpConfigObj.getDefaultDirectory());
            List<String> defaultGroups = idpConfigObj.getDefaultGroups();
            for (String string : defaultGroups) {
                groupMapping.append("Default Groups", string);
            }
            groupMapping.putOpt("Enable Default Group For", idpConfigObj.getEnableDefaultGroupsFor());
            groupMapping.putOpt("Disable Group Mapping", idpConfigObj.getKeepExistingUserRoles());
            groupMapping.putOpt("Group Attribute", idpConfigObj.getRoleAttribute());
            groupMapping.putOpt("Restrict User Creation based on Group Mapping", idpConfigObj.getCreateUsersIfRoleMapped());
            groupMapping.putOpt("Update User Groups Only If Roles Are Mapped", idpConfigObj.getUpdateUserOnlyIfRoleMapped());
            JSONObject mapping = new JSONObject();
            if (idpConfigObj.getRoleMapping() != null) {
                for (String crowdGroup : idpConfigObj.getRoleMapping().keySet()) {
                    mapping.putOpt(crowdGroup, idpConfigObj.getRoleMapping().get(crowdGroup));
                }
            }
            groupMapping.putOpt("Mapping", mapping);
            groupMapping.putOpt("On The Fly Group Mapping", idpConfigObj.getOnTheFlyGroupCreation());
            groupMapping.putOpt("Create New Groups", idpConfigObj.getCreateNewGroups());
            groupMapping.putOpt("Keep users in existing groups", idpConfigObj.getOnTheFlyAssignNewGroupsOnly());
            groupMapping.putOpt("Application group enrollment", idpConfigObj.getApplicationGroupEnrollment());
            List<String> list = idpConfigObj.getOnTheFlyDoNotRemoveGroups();
            for (String defaultGroup : list) {
                groupMapping.append("Do Not Remove User From These Groups", defaultGroup);
            }
            config.putOpt("Group Mapping", groupMapping);
        }
        catch (JSONException e) {
            LOGGER.error("Error occurred while inserting Group Mapping configuration in JSON " + e.getMessage() + " Cause: " + e.getCause());
            e.printStackTrace();
        }
    }

    private static void importGroupMappingConfigurations(JSONObject groupMappingObj, String idpName, String idpID) throws JSONException {
        LOGGER.debug("importGroupMappingConfigurations called ");
        Boolean restrictUserCreation = groupMappingObj.optBoolean("Restrict User Creation", Boolean.FALSE);
        String defaultDirectory = groupMappingObj.optString("Default Directory", "");
        ArrayList<String> defaultGroups = new ArrayList<String>();
        JSONArray defaultGroupsArray = groupMappingObj.optJSONArray("Default Groups");
        if (defaultGroupsArray != null) {
            for (int i = 0; i < defaultGroupsArray.length(); ++i) {
                defaultGroups.add(defaultGroupsArray.getString(i));
            }
        }
        String enableDefaultGroupsFor = groupMappingObj.optString("Enable Default Group For", "newUsers");
        Boolean keepExistingUserRoles = groupMappingObj.optBoolean("Disable Group Mapping", Boolean.FALSE);
        String roleAttribute = groupMappingObj.optString("Group Attribute", "");
        Boolean createUsersIfRoleMapped = groupMappingObj.optBoolean("Restrict User Creation based on Group Mapping", Boolean.FALSE);
        Boolean updateUserOnlyIfRoleMapped = groupMappingObj.optBoolean("Update User Groups Only If Roles Are Mapped", Boolean.FALSE);
        JSONObject mapping = groupMappingObj.optJSONObject("Mapping");
        HashMap<String, String> roleMapping = new HashMap<String, String>();
        Iterator<String> roleMappingIterator = mapping.keys();
        while (roleMappingIterator.hasNext()) {
            String crowdGroup = roleMappingIterator.next();
            roleMapping.put(crowdGroup, mapping.getString(crowdGroup));
        }
        Boolean onTheFlyGroupCreation = groupMappingObj.optBoolean("On The Fly Group Mapping", Boolean.FALSE);
        Boolean canCreateNewGroups = groupMappingObj.optBoolean("Create New Groups", Boolean.FALSE);
        Boolean onTheFlyAssignNewGroupsOnly = groupMappingObj.optBoolean("Keep users in existing groups", Boolean.TRUE);
        Boolean applicationGroupEnrollment = groupMappingObj.optBoolean("Application group enrollment", Boolean.FALSE);
        ArrayList<String> onTheFlyDoNotRemoveGroups = new ArrayList<String>();
        JSONArray groupsArray = groupMappingObj.optJSONArray("Do Not Remove User From These Groups");
        if (groupsArray != null) {
            for (int i = 0; i < groupsArray.length(); ++i) {
                onTheFlyDoNotRemoveGroups.add(groupsArray.getString(i));
            }
        }
        Boolean groupRegexPatternEnabled = groupMappingObj.optBoolean("Apply regex on incoming groups", Boolean.FALSE);
        String onTheFlyFilterIDPGroupsOption = groupMappingObj.optString("Do not apply any condition on incoming groups", "None");
        String onTheFlyFilterIDPGroupsKey = groupMappingObj.optString("groups key for IDP groups ", "");
        String regexPatternForGroup = groupMappingObj.optString(" regex pattern for group", "");
        String regexGroups = groupMappingObj.optString("regex for group name", "");
        String testRegex = groupMappingObj.optString("group name for testing", "");
        MoPluginHandler.saveRoleMapping(idpID, roleAttribute, createUsersIfRoleMapped, keepExistingUserRoles, roleMapping, defaultGroups, restrictUserCreation, updateUserOnlyIfRoleMapped, defaultDirectory, enableDefaultGroupsFor, onTheFlyGroupCreation, onTheFlyDoNotRemoveGroups, canCreateNewGroups, onTheFlyAssignNewGroupsOnly, applicationGroupEnrollment, groupRegexPatternEnabled, onTheFlyFilterIDPGroupsOption, onTheFlyFilterIDPGroupsKey, regexPatternForGroup, regexGroups, testRegex);
    }

    private void insertSignOnSettings(JSONObject config) {
        LOGGER.debug("Inserting Sign in settings configuration.");
        JSONObject signInSettings = new JSONObject();
        try {
            signInSettings.putOpt("Login Template", settings.getLoginTemplate());
            signInSettings.putOpt("Auto Redirect to IdP", settings.getDefaultLoginDisabled());
            signInSettings.putOpt("Enable backdoor login", settings.getBackdoorEnabled());
            signInSettings.putOpt("Relay State URL", settings.getRelayState());
            signInSettings.putOpt("Auto Activate User On SSO", settings.getAutoActivateUser());
            signInSettings.putOpt("Enable SSO For Crowd", settings.getEnableSAMLSSO());
            signInSettings.putOpt("Login Button Text", settings.getLoginButtonText());
            signInSettings.putOpt("Restrict Backdoor Access", settings.getRestrictBackdoor());
            for (String backdoorGroup : settings.getBackdoorGroups()) {
                signInSettings.append("Restrict Backdoor Access For", backdoorGroup);
            }
            config.putOpt("Sign In Settings", signInSettings);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOGGER.error("Error occurred while inserting Sign in settings configuration in JSON " + e.getMessage() + " Cause: " + e.getCause());
        }
    }

    private static void importSignOnSettingsConfigurations(JSONObject signInSettingsObj) throws JSONException {
        LOGGER.debug("importSignOnSettingsConfigurations called ");
        Boolean disableDefaultLogin = signInSettingsObj.optBoolean("Auto Redirect to IdP", Boolean.FALSE);
        Boolean enableBackdoor = signInSettingsObj.optBoolean("Enable backdoor login", Boolean.FALSE);
        String relayState = signInSettingsObj.optString("Relay State URL", "");
        String loginTemplate = signInSettingsObj.optString("Login Template", "");
        Boolean autoActivateUserOnSso = signInSettingsObj.optBoolean("Auto Activate User On SSO", Boolean.FALSE);
        Boolean enableSAMLSSO = signInSettingsObj.optBoolean("Enable SSO For Crowd", Boolean.TRUE);
        String loginButtonText = signInSettingsObj.optString("Login Button Text", "Login with IdP");
        Boolean restrictBackdoor = signInSettingsObj.optBoolean("Restrict Backdoor Access", Boolean.FALSE);
        JSONArray backdoorGroupsArray = signInSettingsObj.optJSONArray("Restrict Backdoor Access For");
        List<String> backdoorGroupsList = settings.convertJasonArrayToList(backdoorGroupsArray);
        Boolean enableerrormsgtemplate = signInSettingsObj.optBoolean("Enable Error Message Template", Boolean.FALSE);
        String errormsgtemplate = signInSettingsObj.optString("Error Message Template", "");
        String timeDelay = signInSettingsObj.optString("Time delay", settings.getTimeDelay());
        pluginHandler.saveSigninSettings(timeDelay, disableDefaultLogin, enableBackdoor, loginButtonText, relayState, loginTemplate, autoActivateUserOnSso, enableSAMLSSO, restrictBackdoor, backdoorGroupsList, enableerrormsgtemplate, errormsgtemplate);
    }

    private void insertCertificates(JSONObject config) {
        LOGGER.debug("Inserting custom certificates configuration in JSON Object.");
        JSONObject spCertificates = new JSONObject();
        try {
            spCertificates.putOpt("Public SP Certificate", settings.getPublicSPCertificate());
            spCertificates.putOpt("Private SP Certificate", settings.getPrivateSPCertificate());
            config.putOpt("Certificates", spCertificates);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOGGER.error("Error occurred while inserting custom certificate sp configuration in JSON " + e.getMessage() + " Cause: " + e.getCause());
        }
    }

    private static void importCertificatesConfigurations(JSONObject certificatesConfigObj) throws JSONException {
        LOGGER.debug("importCertificatesConfigurations called ");
        String publicCertificate = certificatesConfigObj.optString("Public SP Certificate", "");
        String privateCertificate = certificatesConfigObj.optString("Private SP Certificate", "");
        pluginHandler.saveSPCertificates(publicCertificate, privateCertificate);
    }

    private void insertDomainMapping(JSONObject config) {
        LOGGER.info("Inserting domain mapping configuration in plugin configurations file");
        try {
            JSONObject domainMappingObject = new JSONObject();
            domainMappingObject.putOpt("Use Domain Mapping", settings.getUseDomainMapping());
            for (String domain : settings.getDomains()) {
                domainMappingObject.append("Domains", domain);
            }
            JSONObject domainMapping = new JSONObject();
            HashMap<String, String> mapping = settings.getDomainMapping();
            for (String domain : mapping.keySet()) {
                domainMapping.putOpt(domain, mapping.get(domain));
            }
            domainMappingObject.putOpt("Domain Mapping", domainMapping);
            config.putOpt("Domain Mapping Configurations", domainMappingObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error occurred while inserting custom template configuration in JSON " + e.getMessage() + " Cause: " + e.getCause());
        }
    }

    private static void importDomainMappingConfigurations(JSONObject domainMappingConfigObject) throws JSONException {
        LOGGER.info("importing Domain Mapping Configurations");
        try {
            Boolean useDomainMapping = domainMappingConfigObject.optBoolean("Use Domain Mapping");
            ArrayList<String> domainsList = new ArrayList<String>();
            JSONArray domainsListObject = domainMappingConfigObject.optJSONArray("Domains");
            if (domainsListObject != null) {
                for (int i = 0; i < domainsListObject.length(); ++i) {
                    domainsList.add(domainsListObject.optString(i));
                }
            }
            JSONObject domainMappingObject = domainMappingConfigObject.optJSONObject("Domain Mapping");
            HashMap<String, String> domainMappingMap = new HashMap<String, String>();
            Iterator<String> domains = domainMappingObject.keys();
            while (domains.hasNext()) {
                String domain = domains.next();
                String idpId = domainMappingObject.optString(domain);
                domainMappingMap.put(domain, idpId);
            }
            settings.setUseDomainMapping(useDomainMapping);
            settings.setDomains(domainsList.toArray(new String[0]));
            settings.setDomainMapping(domainMappingMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error occurred while inserting custom template configuration in JSON " + e.getMessage() + " Cause: " + e.getCause());
        }
    }

    public static void importPluginConfigurations(String pluginConfigurationsJson) throws Exception {
        LOGGER.debug("Importing Plugin Configurations in JSON Object : " + pluginConfigurationsJson);
        try {
            JSONObject troubleshootSettingsObj;
            JSONObject certificatesConfigObj;
            JSONObject signInSettingsObj;
            JSONObject pluginConfigObj = new JSONObject(pluginConfigurationsJson);
            JSONArray identityProviders = pluginConfigObj.optJSONArray("Identity Providers");
            if (identityProviders == null) {
                throw new MoPluginException(MoPluginException.PluginErrorCode.EMPTY_CONFIGURATIONS, MoPluginException.PluginErrorCode.EMPTY_CONFIGURATIONS.getMessage());
            }
            LOGGER.debug("identityProviders = " + identityProviders.length());
            for (int i = 0; i < identityProviders.length(); ++i) {
                JSONObject importMetadataObj;
                JSONObject groupMappingObj;
                JSONObject attributeMapping;
                JSONObject idpConfig = identityProviders.getJSONObject(i);
                String idpID = idpConfig.optString("ID");
                String idpName = idpConfig.optString("Name");
                JSONObject configSP = idpConfig.optJSONObject("Configure SP");
                if (configSP != null) {
                    MoPluginConfigurationsHandler.importConfigSPConfigurations(configSP, idpName, idpID);
                }
                if ((attributeMapping = idpConfig.optJSONObject("Attribute Mapping")) != null) {
                    MoPluginConfigurationsHandler.importAttributeMappingConfigurations(attributeMapping, idpName, idpID);
                }
                if ((groupMappingObj = idpConfig.optJSONObject("Group Mapping")) != null) {
                    MoPluginConfigurationsHandler.importGroupMappingConfigurations(groupMappingObj, idpName, idpID);
                }
                if ((importMetadataObj = idpConfig.optJSONObject("Import Metadata")) == null) continue;
                MoPluginConfigurationsHandler.importImportMetadataConfigurations(importMetadataObj, idpName, idpID);
            }
            JSONObject configureIdPObj = pluginConfigObj.optJSONObject("SP Info");
            if (configureIdPObj != null) {
                MoPluginConfigurationsHandler.importConfigureIdPConfigurations(configureIdPObj);
            }
            if ((signInSettingsObj = pluginConfigObj.optJSONObject("Sign In Settings")) != null) {
                MoPluginConfigurationsHandler.importSignOnSettingsConfigurations(signInSettingsObj);
            }
            if ((certificatesConfigObj = pluginConfigObj.optJSONObject("Certificates")) != null) {
                MoPluginConfigurationsHandler.importCertificatesConfigurations(certificatesConfigObj);
            }
            if ((troubleshootSettingsObj = pluginConfigObj.optJSONObject("TroubleShoot Settings")) != null) {
                MoPluginConfigurationsHandler.importTroubleshootConfiguration(troubleshootSettingsObj);
            }
        }
        catch (JSONException e) {
            LOGGER.error("An error occurred while importing plugin Configurations " + e.getMessage() + " with Cause: " + e.getCause());
        }
    }

    public void insertTroubleShootSettings(JSONObject config) {
        LOGGER.debug("Inserting Troubleshoot settings in JSON object");
        JSONObject troubleshootSettings = new JSONObject();
        try {
            troubleshootSettings.putOpt("Enable Debug Logs", settings.getEnableDebugLogs());
            config.putOpt("TroubleShoot Settings", troubleshootSettings);
        }
        catch (JSONException e) {
            LOGGER.error("Error occured while inserting troubleshooting settings in JSON");
        }
    }

    private static void importTroubleshootConfiguration(JSONObject importTroublshootObj) {
        try {
            LOGGER.debug("importTroubleshootConfiguration called");
            Boolean enableDebugLogs = importTroublshootObj.optBoolean("Enable Debug Logs", Boolean.FALSE);
            settings.setEnableDebugLogs(enableDebugLogs);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while importing troubleshoot settings ", e);
        }
    }

    public MoSAMLSettings getSettings() {
        return settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        MoPluginConfigurationsHandler.settings = settings;
    }
}

