/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.utils;

import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.MoPluginException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public class MoHttpUtils {
    private static Log LOGGER = LogFactory.getLog(MoHttpUtils.class);
    public static final String CONTENT_TYPE_JSON = "application/json";

    public static String sendPostRequest(String url, String data, String contentType, HashMap headers) {
        try {
            LOGGER.debug("MoHttpUtils sendPostRequest Sending POST request to " + url + " with payload " + data);
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            StringEntity input = new StringEntity(data);
            input.setContentType(contentType);
            postRequest.setEntity((HttpEntity)input);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                LOGGER.debug("Response Entity found. Reading Response payload.");
                String status = IOUtils.toString(new InputStreamReader(response.getEntity().getContent()));
                LOGGER.debug("Response payload: " + status);
                httpClient.close();
                return status;
            }
            LOGGER.error("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.error("An exception occured while sending post request :" + e.getMessage());
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, e.getMessage(), e);
        }
    }

    public static String sendPostRequestToGetToken(String url, JSONObject data, String contentType, HashMap headers) {
        try {
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            StringEntity entity = new StringEntity(data.toString());
            entity.setContentType(contentType);
            postRequest.setEntity((HttpEntity)entity);
            return MoHttpUtils.executePostRequest(httpClient, postRequest);
        }
        catch (Exception e) {
            return "Failed";
        }
    }

    public static String executePostRequest(CloseableHttpClient httpClient, HttpPost postRequest) {
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug("Response Code : " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                httpClient.close();
                return status;
            }
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Exception occurs while posting request for token", e);
            return "Failed";
        }
    }

    public static String sendGetRequest(String url) {
        try {
            LOGGER.debug("MoHttpUtils sendGetRequest Sending GET request to " + url);
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            HttpGet getRequest = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 200 && response.getEntity() != null) {
                LOGGER.debug("Response Entity found. Reading Response payload.");
                String data = IOUtils.toString(new InputStreamReader(response.getEntity().getContent()));
                LOGGER.debug("Response payload: " + data);
                httpClient.close();
                return data;
            }
            LOGGER.debug("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.error("An exception occured while sending get request :" + e.getMessage());
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, e.getMessage(), e);
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)ccm).build();
        return httpclient;
    }
}

