/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.sso.saml.crowd.MoPluginHandler;
import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import java.io.File;
import java.io.IOException;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoUploadPluginConfigurationServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoUploadPluginConfigurationServlet.class);
    private static final long serialVersionUID = 1L;
    private MoSAMLSettings settings;
    private MoPluginHandler pluginHandler;
    @ComponentImport
    private UserManager userManager;

    @Autowired
    public MoUploadPluginConfigurationServlet(MoSAMLSettings settings, UserManager userManager, MoPluginHandler pluginHandler) {
        this.settings = settings;
        this.userManager = userManager;
        this.pluginHandler = pluginHandler;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("UploadPluginConfigurationServlet: doPost called");
        MoSAMLSettings.isPluginConfigurationFileUploaded = Boolean.TRUE;
        try {
            this.handleUploadConfigurations(response);
            response.sendRedirect(this.settings.getImportExportPageUrl());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving your details." + e);
            this.settings.setSpConfigurationStatus("An error occurred while saving your details.Please check logs for more info.");
            response.sendRedirect(this.settings.getImportExportPageUrl());
        }
    }

    private void handleUploadConfigurations(HttpServletResponse response) throws IOException {
        LOGGER.debug("handleUploadConfigurations called");
        String fileContents = "";
        MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        UploadedFile[] files = wrapper.getFiles("configFile");
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                UploadedFile file = files[i];
                if (!file.isFile()) continue;
                try {
                    fileContents = FileUtils.readFileToString((File)file.getContent());
                    if (StringUtils.isEmpty(fileContents)) {
                        this.settings.setSpConfigurationStatus("Uploaded app configuration file is empty.");
                        return;
                    }
                    this.pluginHandler.importConfigurations(fileContents);
                    this.settings.setSpConfigurationStatus("success");
                    return;
                }
                catch (Exception e) {
                    LOGGER.debug("exception message = " + e.getMessage());
                    LOGGER.debug("Invalid file is  provided. Could not parse app configuration file. " + e);
                    this.settings.setSpConfigurationStatus("Invalid file is  provided. Could not parse app configuration file.");
                    return;
                }
            }
        }
        LOGGER.debug("An error occurred while uploading the app configuring file.");
        this.settings.setSpConfigurationStatus("An error occurred while uploading the app configuring file.");
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

