/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.servlet;

import com.miniorange.sso.saml.crowd.MoSAMLSettings;
import com.miniorange.sso.saml.crowd.scheduler.MoMetadataRefreshService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoDeleteIdpServlet
extends HttpServlet {
    private MoSAMLSettings settings;
    private static Log LOGGER = LogFactory.getLog(MoDeleteIdpServlet.class);
    private ArrayList<String> idpList;
    private HashMap<String, String> idpMap;
    private Boolean useDomainMapping;
    private List<String> domainsList;
    private MoMetadataRefreshService moMetadataRefreshService;

    @Autowired
    MoDeleteIdpServlet(MoSAMLSettings settings, MoMetadataRefreshService moMetadataRefreshService) {
        this.settings = settings;
        this.moMetadataRefreshService = moMetadataRefreshService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoDeleteIdpServlet : execute called");
        try {
            String idpID = request.getParameter("idpID");
            String status = "";
            if (StringUtils.isNotBlank(idpID)) {
                HashMap<String, String> idpMap = this.settings.getIdpMap();
                if (idpMap == null || !idpMap.containsKey(idpID)) {
                    status = "missing";
                } else {
                    this.settings.removeIdp(idpID);
                    this.moMetadataRefreshService.unschedule(idpID);
                    status = "success";
                }
            } else {
                status = "empty";
            }
            if (this.settings.getIdPList().size() == 1) {
                this.settings.setUseDomainMapping(Boolean.FALSE);
            }
            response.sendRedirect(this.settings.getSpBaseUrl() + "/console/secure/plugins/crowd-sso-listidpconfig/listidp.action?operation=delete&status=" + status);
            return;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while deleting IDP configuration", e);
            return;
        }
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public void setMoMetadataRefreshService(MoMetadataRefreshService moMetadataRefreshService) {
        this.moMetadataRefreshService = moMetadataRefreshService;
    }

    public MoMetadataRefreshService getMoMetadataRefreshService() {
        return this.moMetadataRefreshService;
    }

    public ArrayList<String> getIdpList() {
        return this.idpList;
    }

    public void setIdpList(ArrayList<String> idpList) {
        this.idpList = idpList;
    }

    public HashMap<String, String> getIdpMap() {
        return this.idpMap;
    }

    public void setIdpMap(HashMap<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    public Boolean getUseDomainMapping() {
        return this.useDomainMapping;
    }

    public void setUseDomainMapping(Boolean useDomainMapping) {
        this.useDomainMapping = useDomainMapping;
    }

    public List<String> getDomainsList() {
        return this.domainsList;
    }

    public void setDomainsList(List<String> domainsList) {
        this.domainsList = domainsList;
    }
}

