/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.crowd.scheduler;

import com.atlassian.sal.api.scheduling.PluginJob;
import com.miniorange.sso.saml.crowd.scheduler.MoMetadataRefreshService;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoMetadataRefreshTask
implements PluginJob {
    private static Log LOGGER = LogFactory.getLog(MoMetadataRefreshTask.class);

    public void execute(Map<String, Object> jobDataMap) {
        LOGGER.info("Refreshing Metadata.");
        try {
            String metadataUrl;
            String metadata;
            MoMetadataRefreshService service = (MoMetadataRefreshService)jobDataMap.get(MoMetadataRefreshService.KEY);
            MoIDPConfig idpConfig = (MoIDPConfig)jobDataMap.get(MoMetadataRefreshService.IDP_KEY);
            if (service != null && idpConfig != null && StringUtils.isNotBlank((CharSequence)(metadata = MoHttpUtils.sendGetRequest(metadataUrl = service.getMetadataURL(idpConfig))))) {
                if (idpConfig != null) {
                    LOGGER.debug("IDP config not null ID" + idpConfig.getId() + " name " + idpConfig.getIdpName());
                    service.saveSettings(idpConfig.getId(), idpConfig.getIdpName(), metadata);
                } else {
                    LOGGER.debug("IDP config null");
                    service.saveSettings("miniorange.saml.DEFAULT_IDP_ID", "IDP", metadata);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.error("An error occurred while updating the metadata.", t);
        }
    }
}

