<html>
    <head>
        <title>SAML SSO Configuration</title>
        <meta name="decorator" content="atl.admin"/>
        <script type="text/javascript">

        <#if ssoUrl =="">
        AJS.$(function(){
            AJS.dialog2("#preconfig-dialog").show();

            AJS.$("#proceed-config").on('click',function(){
                AJS.dialog2("#preconfig-dialog").hide();
            });
        });
       </#if>

        AJS.$(function(){
            showLogsDownload();
            showImportFromMetadata();
            AJS.$("#metadataOption").change(function () {
                showImportFromMetadata();
            });
             AJS.$("#enableDebugLogs").change(function()
            {
                var enableDebugLogs = document.getElementById("enableDebugLogs").checked;
                    var message;
                    if(enableDebugLogs)
                    {
                        message = "Debug Logs enabled successfully"
                    }else
                    {
                        message = "Debug Logs disabled successfully"
                    }

                    AJS.$.ajax({
                            url: AJS.contextPath() + "/plugins/servlet/saml/troubleshooting",
                            data: {
                                "action" : "enableDebugLogs",
                                "enableDebugLogs" : enableDebugLogs,
                            },
                            error: function (response) {
                            },
                            success: function(response)
                            {
                                AJS.flag({
                                    title: 'Success',
                                    type: 'success',
                                    close: 'auto',
                                    body: message,
                                })
                            },

                        });
                        showLogsDownload();
                    });
                showLogsDownload();
        });

        var fromFile = {
            label: "Upload IDP Metadata File:",
            description: "This file is used to fetch your IDP settings. Reach out to us using Support if you need any help"
        }
        var fromUrl = {
            label: "Enter IDP Metadata URL:",
            description: "This URL is used to fetch your IDP settings. Please make sure that URL is accessible. Reach out to us using Support if you need any help"
        };

        /**
         * map is used to store the idp objects with the option value. This map is used in changeFieldValues() and changeFileFieldValues() functions
         */
        var map = {};
        map['fromUrl'] = fromUrl;
        map['fromFile'] = fromFile;

        function showFileForm() {
            AJS.$("#importByFile").show();
            AJS.$("#importByUrl").hide();
            AJS.$("#importButtons").show();
            AJS.$("#inputUrl").prop("required", false);
            AJS.$("#xmlFile").prop("required", true);
            AJS.$("#fileSubmitted").val("true");
            AJS.$("#urlSubmitted").val("false");
        }
        function showUrlForm() {
            AJS.$("#importByUrl").show();
            AJS.$("#importByFile").hide();
            AJS.$("#importButtons").show();
            AJS.$("#inputUrl").prop("required", true);
            AJS.$("#xmlFile").prop("required", false);
            AJS.$("#fileSubmitted").val("false");
            AJS.$("#urlSubmitted").val("true");
        }

        function changeFieldValues(idp, type) {
            var idpObj = map[idp];

            document.getElementById("metadata_url_label").innerHTML = idpObj.label;
            document.getElementById("metadata_url_description").innerHTML = idpObj.description;

            var inputUrl = document.getElementById("inputUrl");

            var hostname = document.createElement('input');
            hostname.id = inputUrl.id;
            hostname.name = inputUrl.name;
            hostname.style = inputUrl.style;
            hostname.className = "text long-field";
            hostname.placeholder = idpObj.label;
            hostname.type = type;
            hostname.value = inputUrl.value;
            inputUrl.parentNode.replaceChild(hostname, inputUrl);
        }

        function changeFileFieldValues(idp) {
            var idpObj = map[idp];

            document.getElementById("metadata_file_label").innerHTML = idpObj.label;
            document.getElementById("metadata_file_description").innerHTML = idpObj.description;
        }

        function showImportFromMetadata() {
            var value = AJS.$("#metadataOption").val();
            if (value != null) {
                switch (value) {
                    case "fromUrl":
                        changeFieldValues('fromUrl', 'url');
                        showUrlForm();
                        break;
                    case "fromFile":
                        changeFileFieldValues('fromFile')
                        showFileForm();
                        break;
                }
            }
        }

        function downloadLogs(e){
            e.preventDefault();
            document.location.href = AJS.contextPath() + "/plugins/servlet/saml/troubleshooting?action=downloadCrowdLogs";
       }

        function showTestConfiguration(){
        	var next = "testidpconfiguration"
        	var samlAuthUrl = AJS.contextPath() + '/plugins/servlet/saml/auth';
        	samlAuthUrl += "?return_to=" + next;
        	var myWindow = window.open(samlAuthUrl, "TEST SAML IDP", "scrollbars=1 width=800, height=600");
		}
		function copyToClipboard(element, copyButton) {
                var $temp = $("<input>");
                $("body").append($temp);
                $temp.val($(element).text()).select();
                document.execCommand("copy");
                $temp.remove();
                $(copyButton).show();
                setTimeout(function () {
                    $(copyButton).hide("slow");
                }, 2500);
            }

            function openTab(evt, tabName) {
                  var i, tabcontent, tablinks;

                  tabcontent = document.getElementsByClassName("tabcontent");
                  for (i = 0; i < tabcontent.length; i++) {
                      tabcontent[i].style.display = "none";
                  }
                  tablinks = document.getElementsByClassName("tablinks");
                  for (i = 0; i < tablinks.length; i++) {
                      tablinks[i].parentElement.className = tablinks[i].parentElement.className.replace("aui-nav-selected", "");
                  }
                  document.getElementById(tabName).style.display = "block";
                  evt.currentTarget.parentElement.className += "aui-nav-selected";
            }

             function showLogsDownload()
            {
                if(document.getElementById('enableDebugLogs') && document.getElementById('enableDebugLogs').checked)
                {
                    AJS.$("#logsMessageDiv").slideDown();
                    AJS.$("#logsDownloadDiv").slideDown();
                }else
                {
                    AJS.$("#logsMessageDiv").hide();
                    AJS.$("#logsDownloadDiv").hide();
                }
            }



    </script>
    <style>
        <#include "/css/config.css">
    </style>
    </head>
    <body>
    <#include "/templates/com/miniorange/sso/saml/crowd/preconfigurations.ftl" parse=true>
    	<header class="aui-page-header">
            <div>
                <div class="aui-page-header-image">
                    <img src="${settings.getBaseUrl()}/rest/plugins/1.0/com.miniorange.saml.sso.crowd-sso-key/media/plugin-logo" alt="miniorange logo">
                </div>
                <div class="aui-page-header-main">
                    <h1>miniOrange SAML Single Sign-On Configuration</h1>
                    <div class="aui-buttons">
                        <a href="https://forum.miniorange.com/forum/single-sign-on/" target="_blank" class="aui-button aui-button-subtle" style="color:blue"><span class="aui-icon aui-icon-small aui-iconfont-vid-raised-hand" style="color: blue;vertical-align: middle"></span><span style="vertical-align:middle">Ask Us On Forum</span></a>
                        <a href="https://faq.miniorange.com/kb/atlassian/" target="_blank" class="aui-button aui-button-subtle" style="color: blue"><span class="aui-icon aui-icon-small aui-iconfont-question-circle" style="color:blue;vertical-align: middle"></span><span style="vertical-align:middle">&nbsp;Frequently Asked Questions</span></a>
                        <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2" target="_blank" class="aui-button aui-button-subtle" style="color: blue"><span class="aui-icon aui-icon-small aui-iconfont-video-circle" style="color:blue;vertical-align: middle"></span><span style="vertical-align:middle">&nbsp;Book a meeting</span></a>
                    </div>
                </div>
            </div>
            <div style="display: flex;gap: 1vw;">
                <div class="contact-us" id="contact-us" aria-controls="support_div_dialog">
                    <div class="contact-us-heading"><h3> Contact us:</h3>
                        <div>
                            <ul style="list-style-type:none; padding-left: 0;">
                                <li>
                                    <span class="aui-icon aui-icon-small aui-iconfont-email">Contact-us email</span>
                                    <span><a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a></span>
                                </li>
                                <li>
                                    <span class="aui-icon aui-icon-small aui-iconfont-vid-hang-up">Contact-us phone</span>
                                    <span>+1 978 658 9387</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="contact-us" id="contact-us" aria-controls="support_div_dialog">
                        <div class="contact-us-heading"style="text-align: center;"><h3>Request</h3>
                            <ul style="list-style-type:none; padding-left: 0;margin-top: 10px;">
                                <li>
                                <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6/create/15" target="_blank">
                                    <button class="aui-button aui-button-primary" style="width: 90px;display:inline" >Free Trial</button></a>
                                <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6/create/16" target="_blank">
                                        <button class="aui-button aui-button-primary" style="width: 90px;display:inline">Quotation</button></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
		</header>
        <#if action.hasActionMessages() >
			<div class="aui-message aui-message-success success closeable shadowed info">
				<#foreach actionMessage in action.actionMessages >
					<p>${actionMessage} </p>
				</#foreach>
			</div>
		</#if>
		
		<#if  action.hasActionErrors()>
			<div class="aui-message aui-message-error closeable error config_form_error">
				<#foreach actionError in action.actionErrors >
					<p>${actionError}</p>
				</#foreach>
			</div>
		</#if>
		
		<#--<#if !action.isHTTPSURL>-->
			<#--<div class="aui-message aui-message-warning warning closeable shadowed">-->
                   <#--<p class="title">-->
                       <#--<strong>Warning!</strong>-->
                   <#--</p>-->
                   <#--<p>SSO might not work as Crowd server instance is not running on HTTPS. Please click <a href="https://confluence.atlassian.com/crowd/configuring-crowd-to-work-with-ssl-151520306.html" target="_blank">here</a> to know how to configure your instance to run on HTTPS.</p>-->
                   
            <#--</div>-->
        <#--</#if>-->
		
		 <div class="aui-tabs horizontal-tabs" id="tabs-example1" role="application">
            <ul class="tabs-menu" role="tablist">
             <li class="menu-item" role="presentation">
                                <a href="#support" id="aui-uid-2" role="tab" aria-selected="true">
                                    <strong>Pre-configurations</strong>
                                </a>
                            </li>
              <li class="menu-item" role="presentation">
                  <a href="#spMetadata" id="aui-uid-2" role="tab" aria-selected="true">
                       <strong>SP Metadata</strong>
                   </a>
              </li>
                <li class="menu-item active-tab" role="presentation">
                    <a href="#configure" id="aui-uid-0" role="tab" aria-selected="true">
                        <strong>SSO Configuration</strong>
                    </a>
                </li>
                <li class="menu-item" role="presentation">
                    <a href="#licensing-plans" id="aui-uid-1" role="tab" aria-selected="true">
                        <strong>Premium Features</strong>
                    </a>
                </li>
                <li class="menu-item" role="presentation">
                                    <a href="#troubleshooting" id="aui-uid-2" role="tab" aria-selected="true">
                                        <strong>Troubleshooting</strong>
                                    </a>
                                </li>
            </ul>

             <div class="aui-message aui-message-info" style="background: #ff7272 !important">
                 <p class="title"><strong>Important Notice!</strong><br><br>We have an important announcement regarding the plugin you are currently using. In the second week of August, we will be launching a premium version (v 2.0.0) of the plugin. All future security updates and maintenance fixes will be exclusive to the premium version only. We are pleased to inform you that the premium version will come with a 2-month trial period, allowing you to experience its full capabilities before making a decision. Please note that the current free version you are using will no longer receive any updates or fixes going forward. It will remain available on the marketplace until July 1st, 2024, after which it will be discontinued.</p>
             </div>
			<div class="tabs-pane active-pane" id="configure" aria-labelledby="aui-uid-0" role="tabpanel"
                 aria-hidden="false" >
                <div style="margin-top:15px;">
                    <p style="font-size:13pt;">Configure Add-on</p>
                </div>
                <hr class="header"/>
                <p>Need help with the configuration? You can reach out to us at <a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a>.</p>
                <br>

                <nav class="aui-navgroup aui-navgroup-horizontal" id="min_topmenu">
                    <div class="aui-navgroup-inner">
                       <div id="navbar" class="aui-navgroup-primary">
                          <span style="float:right;margin-right:25px;margin-top:-10px;">
                             <div class="tab idp-config">
                                <ul class="aui-nav">
                                   <li class="aui-nav-selected">
                                      <a class="tablinks" onclick="openTab(event, 'config')" id="defaultOpen">Manual Configuration</a>
                                   </li>
                                   <li>
                                      <a id= "importFromMetadataButton" class="tablinks " onclick="openTab(event, 'browse')">Import From Metadata</a>
                                   </li>
                                </ul>
                             </div>
                          </span>
                       </div>
                    </div>
                 </nav>
                 <br>
                 <!-- Import From Metadata Starts Here -->

                 	<div id="browse"  class="tabcontent" style="display: none;" style="margin-top:15px;">
                 	<#assign uploadMetadata = baseURL+"/plugins/servlet/saml/uploadmetadata">
                 		<form id="metadata_url" name="metadata_url" method="POST" action="${uploadMetadata}" class="aui" enctype="multipart/form-data">
                 		    <input type="hidden" name="metadataImported" value="true">
                            <input type="hidden" id="urlSubmitted" name="urlSubmitted" value="true" />
                            <input type="hidden" id="idpID" name="idpID" value="${idpID}"/>
                             <table style="width:100%;">
                                 <tr>
                                      <td width="20%">
                                         IDP Name:
                                         <span style="color: red">*</span>
                                      </td>
                                      <td>
                                          <input type="text" required="true" id="idpNameImport" name="idpName" value="${idpName}" placeholder="Enter the name for your IDP"
                                                               style="width:30%; padding: 5px;" class="text long-field" />
                                      <div class="description">This IDP Name will be shown in the login widget to users.</div>
                                      </td>
                                 </tr>
                                 <tr><td>&nbsp;</td></tr>

                                 <tr>
                                     <td width="20%">Select Import Option: </td>
                                     <td>
                                         <div id="importMetaDataOptions">
                                             <select class="select" id="metadataOption" name="metadataOption" style="width:200px">
                                                 <option value="fromUrl" selected #end> Import From Metadata URL </option>
                                                 <option value="fromFile" #end> Import From Metadata File </option>
                                             </select>
                                         </div>
                                     </td>
                                 </tr>

                             </table>
                             <tr><td>&nbsp;</td></tr>
                             <tr><td>&nbsp;</td></tr>
                             <div id="importByUrl">
                                 <!-- <form name="saml_form_url" id="saml_form_url" method="post" action="" class="aui long-label" > -->
                                 <table style="width:100%;">
                                     <tr>
                                         <td id="metadata_url_label" width="20%"></td>
                                         <td>
                                             <input type="hidden" id="urlSubmitted" name="urlSubmitted" value="true" />
                                             <input type="url" id="inputUrl" name="inputUrl" required value="${inputUrl}" placeholder="Enter metadata URL of your IdP" style="width:70%; padding: 5px;"
                                                 class="text long-field" />
                                             <div id="metadata_url_description" class="description"></div>
                                         </td>
                                     </tr>
                                 </table>
                             </div>
                             <tr><td>&nbsp;</td></tr>

                             <div id="importByFile" style="display: none;">
                                 <table style="width:100%;">
                                     <tr>
                                         <td id="metadata_file_label" width="20%"></td>

                                         <td>
                                             <input type="hidden" id="fileSubmitted" name="fileSubmitted" value="true" />
                                             <input type="file" id="xmlFile" name="xmlFile" class="ignore-inline-attach" accept=".xml" required />
                                             <div id="metadata_file_description" class="description"></div>
                                         </td>

                                     </tr>
                                 </table>
                             </div>

                             <tr><td>&nbsp;</td></tr>
                             <div id="importButtons" style="display: none;">
                                 <table style="width: 100%">
                                     <tr>
                                         <td style="width: 20%">&nbsp;</td>
                                         <td>
                                             <input type="submit" class="aui-button aui-button-primary" value="Import" />&nbsp;&nbsp;&nbsp;
                                         </td>
                                     </tr>
                                 </table>
                             </div>
                 		</form>
                         </div>
                 		<!-- Import From Metadata Ends Here -->

		<div id="config" class="tabcontent" style="display: block;">
        <form id="admin" class="aui" action="" method="POST">
            <input type="hidden" name="submitted" value="true"/>

            <input type="hidden" id="idpID" name="idpID" value="${idpID}"/>

            <div class="field-group">
                <label for="idpName">IDP Name:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
                <input type="text" required="true" id="idpNameImport" name="idpName" value="${idpName}" placeholder="Enter the name for your IDP"
                       class="text long-field" />
                <div class="description">This IDP Name will be shown in the login widget to users.</div>
            </div>

            <div class="field-group">
                <label for="idpEntityId">IDP Entity ID:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
				<#if action.idpEntityId == "">
					<input type="text" required="true" id="idpEntityId" name="idpEntityId" value=""
                       class="text long-field"/>
				<#else>
					<input type="text" required="true" id="idpEntityId" name="idpEntityId" value="${action.idpEntityId}"
                       class="text long-field"/>
				</#if>
                <div class="description">
                    Enter the IDP Entity ID of your Identity Provider.
                </div>
            </div>
            <div class="field-group">
                <label for="ssoUrl">Single Sign On URL:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
				<#if action.ssoUrl == "">
                	<input type="url" required="true" id="ssoUrl" name="ssoUrl" value="" class="text long-field"/>
				<#else>
					<input type="url" required="true" id="ssoUrl" name="ssoUrl" value="${action.ssoUrl}" class="text long-field"/>
				</#if>
                <div class="description">
                    Enter the Single Sign-on Service endpoint of your Identity Provider.
                </div>
            </div>
            <div class="field-group">
                <label for="x509Certificate">X.509 Certificate:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
                <textarea id="x509Certificate" required="true" name="x509Certificate" class="textarea long-field"
                          style="font-family:Courier New;" cols="64" rows="4">${action.x509Certificate}
                </textarea>
                <div class="description">
                    Enter the X.509 Certificate provided by your IDP. If your IDP provided you the certificate file, open it
                    in Notepad and copy/paste the content here.
                </div>
            </div>
	
            <div class="field-group">
                <label for="defaultDirectory">Default Directory:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
                <select class="select" name="defaultDirectory" id="defaultDirectory">
                    <#foreach directory in existingDirectory>
                        <option value="${directory}"
                            <#if defaultDirectory.equals(directory)>
                                selected
                            </#if>
                        >${directory}</option>
                    </#foreach>
                </select>
                <div class="description">Select Directory to assign to new Users.</div>
                <div class="description"><strong>Note:</strong> Please make sure that crowd application is in this directory and it has a permission to authenticate the user.<br/>To change the permission go to the Applications->crowd->directories and allow all to authenticate</div>
            </div>
            
            <div class="field-group">
                <label for="usernameAttribute">Username Attribute:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
                <input type="text" style="color: black;" required="true" id="usernameAttribute" name="usernameAttribute"
                       value="NameID" readonly class="text long-field" disabled/>
              <div class="tooltip"><span class="aui-icon aui-icon-small aui-iconfont-info-circle" style="color: #6493dc;"></span>
                <span class="tooltiptext">This is configurable in the premium version of the Add-on.</span>
              </div>

            </div>
            
            <div class="field-group">
                  <label for="emailAttribute">Email Attribute:
                         <span class="aui-icon icon-required">(required)</span>
                  </label>
                  <input type="text" style="color: black;" required="true" id="emailAttribute" name="emailAttribute"
                       value="NameID" readonly class="text long-field" disabled/>
                   <div class="tooltip"><span class="aui-icon aui-icon-small aui-iconfont-info-circle" style="color: #6493dc;"></span>
                                  <span class="tooltiptext">This is configurable in the premium version of the Add-on.</span>
                                </div>
              </div>
            
    
            <#-- <div class="field-group">
                <label for="loginButtonText">Login Button Text:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
				<#if action.loginButtonText == "">
                <input type="text" required="true" id="loginButtonText" name="loginButtonText"
                       value="" class="text long-field"/>
				<#else>
					 <input type="text" required="true" id="loginButtonText" name="loginButtonText"
                       value="${loginButtonText}" class="text long-field"/>
				</#if>
				</div>  -->
            <br/>
            <div class="field-group">
                <input type="submit" value="Save" class="aui-button aui-button-primary" style="width:100px;"/>
                &nbsp;&nbsp;&nbsp;
                <#if (action.idpEntityId??) && (action.idpEntityId != "")>
                      <input type="button" id="test-saml-configuration" value="Test Configuration" class="aui-button"  onclick="showTestConfiguration()"/>
                <#else>
                    <button class="aui-button" aria-disabled="true" disabled>Test Configuration</button>
                </#if>
            </div>
        </form>
        <br/>
        <p>To authenticate with your IDP, use this URL:
            <b>
                <em>${settings.getLoginServletUrl()}</em>
            </b>
        </p>

        <div class="aui-message aui-message-info">
            <h3>
                Authenticate users to multiple applications with restricted access to Crowd&nbsp;
                <span class="aui-lozenge aui-lozenge-new">Premium</span>
            </h3>
            <hr class="header"/>
            <p>Check out the Premium version of Crowd SAML SSO to authenticate users to multiple applications without granting them full access to Crowd.</p>
        </div>


        <div class="aui-message aui-message-info">
            <h3>
                Enable SAML SSO for connected atlassian applications&nbsp;
                <span class="aui-lozenge aui-lozenge-new">Extend SSO capabilities</span>
            </h3>
            <hr class="header"/>
            <div>
                <ol>
                  <li>Connect Atlassian Application(for eg. JIRA) to Crowd with Crowd SSO </li>
                  <li>Install and configure <a href="https://marketplace.atlassian.com/search?query=miniOrange%20Crowd%20Connector" target="_blank">Crowd SSO Connector add-on</a> in the Atlassian application</li>
                </ol>
            </div>
        </div>

		</div>
      <#-- <h2>miniOrange Account</h2>
        <table class="aui">
            <tbody>
                <tr>
                    <td headers="name"><b>Registered Email</b></td>
                    <td headers="type">${settings.getCustomerEmail()}</td>
                </tr>
                <tr>
                    <td headers="name"><b>Customer ID</b></td>
                    <td headers="type">${settings.getCustomerID()}</td>
                </tr>
            </tbody>
        </table>
        <form id="admin" class="aui" action="" method="POST">
            <input type="hidden" name="reregister" value="true" />
            <input type="submit" value="Remove Account" class="button"/>
        </form>
		<form class="aui" target="_blank" action="${settings.getMiniorangeUrl()}/login" id="upgrade-form"
                      method="POST">
                    <input type="hidden" name="requestOrigin" value="crowd_saml_sso_basic_plan"/>
                    <input type="hidden" name="redirectUrl" value="${settings.getMiniorangeUrl()}/initializepayment"/>
                    <input type="hidden" name="username" value="${settings.getCustomerEmail()}"/>
        </form>-->
		</div>
            <div class="tabs-pane active-pane" id="licensing-plans" aria-labelledby="aui-uid-1" role="tabpanel" aria-hidden="false">
                <br>
                <div class="container wrapper" style="display: flex;justify-content: center;gap: 2vw;margin-bottom: 3%;">
                    <div class="columns wp-sso bl-brdr" style="width: 35%;">
                        <div class="header premium">
                            <div class="cd-price">
                                <h2>Free Plan</h2>
                                <div class="trial">Free</div>
                                <hr>
                                <br>
                            </div>
                        </div>
                        <ul class="price">
                            <li>Unlimited Authentications via IDP</li>
                            <li>Default Directory Assignment</li>
                            <li>Basic Attribute Mapping</li>
                            <li>Login button on login page</li>
                            <li class="pricing-list-crowd"><br>&nbsp;</li>
                            <li class="pricing-list-crowd"><br>&nbsp;</li>
                            <li class="pricing-list-crowd"><br>&nbsp;</li>
                            <li class="pricing-list-crowd"><br>&nbsp;</li>
                            <li class="pricing-list-crowd"><br></li>
                            <li class="pricing-list-crowd"><br></li>
                            <li class="pricing-list-crowd"><br>&nbsp;</li>
                            <li>&nbsp;<b>Support</b><br>Email and video conferencing support for plugin setup and
                                queries<br>
                                <p class="contactus-margin"><a
                                        href="https://miniorange.atlassian.net/servicedesk/customer/portal/2"
                                        target="_blank" class="contactus-link">Contact Us</a></p>
                            </li>
                        </ul>
                    </div>
                    <div class="columns wp-sso bl-brdr" style="width: 35%;">
                        <div class="header premium">
                            <div class="cd-price">
                                <h2>Premium Plan</h2>
                                <div class="trial">
                                    <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6/create/16"
                                        target="_blank" style="width: 114px;margin-top: 6%;">Request a Quote
                                    </a>
                                </div>
                                <hr>
                                <br>
                            </div>
                        </div>
                        <ul class="price">
                            <li>Unlimited Authentications Supported</li>
                            <li>Advanced Directory Mapping</li>
                            <li>Advanced Group Mapping</li>
                            <li>Advanced Attribute Mapping</li>
                            <li>Login button on login page</li>
                            <li>Auto-Redirect to IDP</li>
                            <li>SAML Single Logout</li>
                            <li>SP Metadata XML</li>
                            <li>Support for Encrypted Assertion</li>
                            <li>Support for Reverse proxy</li>
                            <li>Configurable SP certificates</li>
                            <li>Step-by-step guide for IDP setup</li>
                            <li>End to End Identity Provider Configuration</li>
                            <li>&nbsp;<b>Support</b><br>Email and video conferencing support for plugin setup and queries<br>
                                <p class="contactus-margin"><a
                                        href="https://miniorange.atlassian.net/servicedesk/customer/portal/2" target="_blank"
                                        class="contactus-link">Contact Us</a></p>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="container license-plan-box-crowd">
                    <h3>Steps to Get the Premium Plugin Trial -</h3>
                    <p>1. Go to our <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2"
                            target="_blank">miniOrange helpdesk portal </a>.
                    </p>
                    <p>2. Please raise a query stating request to get trial Crowd SAML SSO premium plugin.
                    </p>
                    <p>3. We will provide you the further details and trial plugin.
                    </p>

                    <p>We will setup a Conference Call / GoTo meeting and do end to end configuration for you for IDP as well as
                        plugin. We provide services to do the configuration on your behalf.
                    </p>
                    <h3>10 Days Return Policy -</h3>
                    At miniOrange, we want to ensure you are 100% happy with your purchase. If the premium plugin you purchased is
                    not working as advertised and you've attempted to resolve any issues with our support team, which couldn't get
                    resolved. We will refund the whole amount within 10 days of the purchase.Please email us at <b><a
                            href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a></b>
                    for any queries regarding the return policy.
                </div>
            </div>
            <div class="tabs-pane" id="support" aria-labelledby="aui-uid-2" role="tabpanel"
                 aria-hidden="false" >
                <div style="margin-top:15px;display: flex">
                    <p style="font-size:13pt;">Pre Configuration </p>
               &nbsp;<div class="tooltip"style="margin-top: 4px;"><span class="aui-icon aui-icon-small aui-iconfont-info-circle" style="color: #6493dc;"></span>
                               <span class="tooltiptext"style=" top: -35px;">Please make the following configurations to enable SSO on your Crowd instance. These configuration will help you to enable SAML SSO with connected Atlassian apps.</span>
                             </div>

                </div>
                <hr class="header"/>
                <div>
               		<div class="aui-message aui-message-info">
	               		<p class="title">Before you begin. Please check the following configuration in Crowd</p>
				        	<br/>
								  <li>Navigate to <b>Applications->Crowd->Directory and Group</b> and make sure user is allowed to authenticate. (This is <b>not required in the Premium Plugin</b>.)</li>
								  <li>Navigate to <b>Application->Crowd->Remote address</b> and make sure Crowd server's IP Address is configured here.</li>
								  <li>If you are using Crowd Server/Datacenter version 4.3.0 and above, please navigate to <b>Applications->Crowd->Options</b>. Select <b>Allow to generate user tokens</b> option and <b>Save</b> it.</li>

                    </div>
				 	<div class="aui-message aui-message-info">
	                	<p class="title">Extend SAML SSO functionality to CROWD connected applications using our Connector add-ons.</p>
				        	<br/>
                               <li>For Jira- Install the <a href="https://marketplace.atlassian.com/apps/1220053/mo-sso-connector-for-crowd-and-jira?hosting=datacenter&tab=overview" target="_blank">Jira Crowd Connector</a></li>
                               <li>For Confluence- Install the <a href="https://marketplace.atlassian.com/apps/1220055/mo-sso-connector-for-crowd-and-confluence?hosting=datacenter&tab=overview" target="_blank">Confluence Crowd Connector</a></li>
                               <li>For Bitbucket- Install the <a href="https://marketplace.atlassian.com/apps/1220057/mo-sso-connector-for-crowd-and-bitbucket?hosting=datacenter&tab=overview" target="_blank">Bitbucket Crowd Connector</a></li>
                               <li>For Bamboo- Install the <a href="https://marketplace.atlassian.com/apps/1220056/mo-sso-connector-for-crowd-and-bamboo?hosting=server&tab=overview" target="_blank">Bamboo Crowd Connector</a></li>
                               <li>For Fisheye- Install the <a href="https://marketplace.atlassian.com/apps/1222983/mo-sso-connector-for-crowd-and-fisheye?hosting=server&tab=overview" target="_blank">Fisheye Crowd Connector</a></li>
					</div>
				</div>
                <p>Need help with the plugin configuration or have any query, please reach out to us at <a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a>.</p>
            </div>

            <div class="tabs-pane" id="spMetadata" aria-labelledby="aui-uid-2" role="tabpanel"
                             aria-hidden="false" >
                            <div style="margin-top:15px;">
                                <p style="font-size:13pt;">Configuring your Identity Provider</p>
                            </div>
                            <hr class="header"/>
         <div>
        <p>Provide this metadata to your Identity Provider to enable Crowd as a service provider/relying party:<br>
       	<#assign metadata = settings.getBaseUrl() + "/plugins/servlet/saml/metadata">
        <a href="${metadata}" target="_blank" class="aui-button aui-button-link">${metadata}</a>
        <p style="margin-left: 14%;">OR</p>
        <p>If your IDP supports importing metadata using a File then,
            <#assign downloadMetadataEndpoint = settings.getBaseUrl() + "/plugins/servlet/saml/downloadmetadata">
                 <a href="${downloadMetadataEndpoint}" target="_blank">
                 <input type="button" class="aui-button" value="Download Metadata" id="download_metadata">
                 </a>
            and provide that file to your IDP <br>
        </p>
        <p style="margin-left: 14%;">OR</p>
        <p>Use these values to configure your Identity Provider:</p>
        <table class="aui"style="width: 85%;">
            <tbody>
                <tr>
                    <td headers="name"style="width: 28%;"><b>SP Entity ID</b></td>
                    <td headers="type" id="p1">${settings.getBaseUrl()}</td>
                    <td width="20%"><button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p1','#c1')">
                    <i class="fa fa-copy"></i> Copy </button>
                     <span id="c1" title="Copied" class="show-title" style="display:none">Copied</span>
                     </td>
                </tr>
                <tr>
                    <td headers="name"><b>ACS URL</b></td>
                    <td headers="type" id="p2">${settings.getLoginServletUrl()}</td>
                    <td width="20%"><button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p2','#c2')">
                                        <i class="fa fa-copy"></i> Copy </button>
                                         <span id="c2" title="Copied" class="show-title" style="display:none">Copied</span>
                                         </td>
                </tr>
                <tr>
                    <td headers="name"> <b>Audience URI</b></td>
                    <td headers="type" id="p3">${settings.getBaseUrl()}</td>
                    <td width="20%"><button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p3','#c3')">
                     <i class="fa fa-copy"></i> Copy </button>
                     <span id="c3" title="Copied" class="show-title" style="display:none">Copied</span>
                      </td>
                </tr>
                <tr>
                    <td headers="name"><b>Recipient URL</b></td>
                    <td headers="type" id="p4">${settings.getLoginServletUrl()}</td>
                    <td width="20%"><button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p4','#c4')">
                     <i class="fa fa-copy"></i>Copy</button>
                     <span id="c4" title="Copied" class="show-title" style="display:none">Copied</span>
                     </td>
                </tr>
                <tr>
                    <td headers="name"><b>Destination URL</b></td>
                    <td headers="type" id="p5">${settings.getLoginServletUrl()}</td>
                    <td width="20%">
                    <button class="mo-copy aui-button" title="Copy to clipboard" onclick="copyToClipboard('#p5','#c5')">
                     <i class="fa fa-copy"></i> Copy </button>
                     <span id="c5" title="Copied" class="show-title" style="display:none">Copied</span>
                     </td>
                </tr>
            </tbody>
        </table>
</div></div>
            <div class="tabs-pane" id="troubleshooting" aria-labelledby="aui-uid-3" role="tabpanel"
                             aria-hidden="false" >
                            <div style="margin-top:15px;">
                                <p style="font-size:13pt;">Troubleshooting</p>
                            </div>
                            <hr class="header"/>
                            <div>
                           		<p>For troubleshooting use,</p>

                                        <ul>
                                           <li><b>Log File</b> : Any errors or issues  related to the plugin's functionality can be tracked using debug logs.
                                                <br>
                                                   <form id="troubleshoot-form" class="aui" action="" method="POST">
                                                       <div class="field-group">
                                                           <label for="enableDebugLogs" class="labelClass"><strong>Enable Debug Logs: </strong> </label>
                                                           <span style="vertical-align:middle;">
                                                           <label class="moswitch" style="vertical-align:middle;">
                                                               <#if enableDebugLogs == true>
                                                                   <input type="checkbox" id="enableDebugLogs" value="true" name="enableDebugLogs"
                                                                           checked="true">
                                                                   <span class="moslider moround"></span> <#else>
                                                                           <input type="checkbox" id="enableDebugLogs" value="true" name="enableDebugLogs">
                                                                   <span class="moslider moround"></span></#if>
                                                           </label>
                                                           <div id= "logsMessageDiv" class="aui-message aui-message-info" style="width:68%;">
                                                               <span>
                                                                   Debug Logs are now enabled , please reproduce the issue in incognito and then click on Download button.
                                                               </span>
                                                           </div>
                                                       </div>
                                                        <br>
                                                           <div id= "logsDownloadDiv" class="field-group">
                                                               <label for="serverLogs" class="labelClass"><strong>Server Logs: </strong> </label>
                                                                                           <span style="vertical-align:middle;">
                                                               <input type="button" value="Download" id="downloadButton" class="aui-button aui-button-primary" style="width:100px;" onclick="return downloadLogs(event)"/>
                                                               &nbsp;&nbsp;&nbsp;
                                                               <div class="description" id= "debugLogInfoTag" style= "margin-top:10px ; width:40%">
                                                                   <span>Clicking on download will download a copy of the Crowd Server logs file.</span>
                                                               </div>
                                                           </div>
                                                   </form>
                                            </li>
                                           <br>

                                            <li><b>Tracer Log File</b> : <a href="https://faq.miniorange.com/knowledgebase/capture-saml-tracer-logs/" target="_blank">Click here</a>
                                            	to get steps to capture Tracer logs.
                                			</li>
                                			<br><li><b>Facing an issue with core functionality after installing the SSO add-on?</b><br>  (For staging instance, not to be done in production)<br>
                                                                While we do our best to test our plugin, sometimes compatibility issues arise with other add-ons installed in your instance. If login test is successful but you are getting issues during login,
                                                                try disabling all your add-ons and enabling them one by one to figure out which plugin is causing an issue. Report to us by raising a ticket <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2" target="_blank">here</a>.
                                             </li>

                                       </ul>
                                       <br>

                                       <p>Send us a message, query or feedback attaching above log file on our <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6/create/15" target="_blank">Support Portal</a> and we will get back to you. Have a lot to say? You can also reach us at <a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a>.</p>
            				</div>
                        </div>
		
    </body>
</html>