<html>
    <head>
        <title>Register</title>
        <meta name="decorator" content="atl.admin"/>
    </head>
    <body>
    	<#assign login = settings.getBaseUrl() + "/console/secure/plugins/crowd-sso-login/dologin.action">
        <h2>Register with miniOrange</h2>
		<#if  action.hasActionMessages() >
			<div class="aui-message closeable shadowed info" style="width: 50%;">
				<#foreach  actionMessage in action.actionMessages > 
					<p>${actionMessage} </p>
				</#foreach>
			</div>
		</#if>
		<#if  action.hasActionErrors() >
			<div class="aui-message closeable aui-message-error" style="width: 50%;">
				<#foreach  actionError in action.actionErrors >
					<p>${actionError} </p>
				</#foreach>
			</div>
		</#if>
		
        <form id="admin" class="aui" action="" method="POST">
		
            <input type="hidden" name="submitted" value="true"/>
            <div class="field-group">
                <label for="email">Email:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
                <#if email?? && email != "">
                    <input type="text" required="true" id="email" name="email" value="${email}"
                                           class="text long-field"/>
                <#else>
                    <input type="text" required="true" id="email" name="email" value=""
                                           class="text long-field"/>
                </#if>
                <div class="description">
                    Enter a valid Email ID. You will need to verify the OTP sent to this ID.
                </div>
            </div>
            <div class="field-group">
                <label for="fname">Name:</label>
                <#if (firstName??) && (firstName != "")>
                <input type="text" id="firstName" name="firstName" value="${firstName}"
                       placeholder="First Name" class="text"/>
                <#else>
                <input type="text" id="firstName" name="firstName" value="" placeholder="First Name"
                       class="text"/>
                </#if>
                <#if (lastName??) && (lastName != "")>
                <input type="text" id="lastName" name="lastName" value="${lastName}"
                       placeholder="Last Name" class="text"/>
                <#else>
                <input type="text" id="lastName" name="lastName" value="" placeholder="Last Name"
                       class="text"/>
                </#if>
                <div class="description">
                    Enter your First Name and Last Name here.
                </div>
            </div>
            <div class="field-group">
                <label for="phone">Phone:</label>
                <#if (phone??) && (phone != "")>
                <input type="text" id="phone" name="phone" value="${phone}" pattern="[\+]?[0-9]{1,4}\s?[0-9]{8,12}"
                       class="text long-field"/>
                <#else>
                <input type="text" id="phone" name="phone" value=""
                       pattern="[\+]?[0-9]{1,4}\s?[0-9]{8,12}" class="text long-field"/>
                </#if>
                <div class="description">
                    Enter you phone number with country code. We will call you only when you need assistance.
                </div>
            </div>
            <div class="field-group">
                <label for="password">Password:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
                <input type="password" required="true" id="password" name="password" value="" class="text long-field"/>
            </div>
            <div class="field-group">
                <label for="confirmPassword">Confirm Password:
                    <span class="aui-icon icon-required">(required)</span>
                </label>
                <input type="password" required="true" id="confirmPassword" name="confirmPassword" value=""
                       class="text long-field"/>
            </div>

            <br/>
            <div class="field-group">
                <input type="submit" value="Register" class="aui-button aui-button-primary" style="width:100px;"/>
                &nbsp;&nbsp;&nbsp;
                <a href="${login}" class="aui-link-button">Already have an account?</a>
            </div>
        </form>
    </body>
</html>