UPM.define('VendorFeedbackDialog',
    [
        'UpmDialog',
        'VendorFeedbackDialogTemplate'
    ],
    function(UpmDialog,
             VendorFeedbackDialogTemplate) {

    // Dialog for submitting vendor feedback.  The model for the dialog is the add-on model.
    // You must also set the option "action" to AddonActions.DISABLE or AddonActions.UNINSTALL.

    return UpmDialog.extend({
        template: VendorFeedbackDialogTemplate,

        events: {
            'keyup .textarea': '_updateRemainingCharCount'
        },

        _getData: function() {
            return {
                plugin: this.model.toJSON(),
                action: this.options.action.key
            };
        },

        _getReturnValue: function() {
            return {
                shareUserInfo: this.$el.find('#upm-feedback-share').is(':checked'),
                reason: this.$el.find('#option-reason').val(),
                textReason: this.$el.find('#text-reason').val()
            };
        },

        _onConfirm: function() {
            this.$el.find('#reason-error').addClass('hidden');
            this.$el.find('#comment-error').addClass('hidden');
            if (this.$el.find('#option-reason').val() === 'upm.feedback.select.reason') {
                this.$el.find('#reason-error').removeClass('hidden');
            } else if (this.$el.find('#text-reason').val().length > 10000) {
                this.$el.find('#comment-error').removeClass('hidden');
            } else {
                UpmDialog.prototype._onConfirm.apply(this);
            }
        }
    });
});
